/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.surface;

import java.util.LinkedList;
import main.ImageStack;
import main.Message;
import main.seggen.dm.surface.SurfaceAndMetadata;
import misc.messages.YObservable;
import misc.messages.YObserver;

public class SurfaceStorage
extends YObservable
implements YObserver {
    public static final int M_ADD_SURFACE = Message.register_message("DMSurface added");
    public static final int M_DEL_SURFACE = Message.register_message("DMSurface deleted");
    public static final int M_EDIT_SURFACE = Message.register_message("DMSurface edited");
    public static final int M_TRANSFORMED_SURFACE = Message.register_message("DMSurface transformed");
    public static final int M_RESET_SURFACE = Message.register_message("DMSurface resetted");
    private static SurfaceStorage _instance;
    private LinkedList<SurfaceAndMetadata> surfaces = new LinkedList();

    private SurfaceStorage() {
    }

    public static SurfaceStorage getInstance() {
        if (_instance == null) {
            _instance = new SurfaceStorage();
        }
        return _instance;
    }

    public void addSurface(SurfaceAndMetadata samd) {
        this.surfaces.add(samd);
        this.setChanged();
        this.notifyObservers(new Message(M_ADD_SURFACE, samd));
    }

    public void removeSurface(SurfaceAndMetadata samd) {
        if (this.surfaces.contains(samd)) {
            this.surfaces.remove(samd);
            this.setChanged();
            this.notifyObservers(new Message(M_DEL_SURFACE, samd));
        }
    }

    public void transformedSurface(SurfaceAndMetadata samd) {
        if (this.surfaces.contains(samd)) {
            this.setChanged();
            this.notifyObservers(new Message(M_TRANSFORMED_SURFACE, samd));
        }
    }

    public LinkedList<SurfaceAndMetadata> getSurfacesAndMetadata() {
        return this.surfaces;
    }

    @Override
    public void update(YObservable sender, Message m) {
        if (m._type == ImageStack.M_CLEAR || m._type == ImageStack.M_LOADING_START) {
            this.surfaces.clear();
        }
    }

    public void resetSurface(SurfaceAndMetadata samd) {
        if (this.surfaces.contains(samd)) {
            this.setChanged();
            this.notifyObservers(new Message(M_RESET_SURFACE, samd));
        }
    }
}

