/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.surface;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import misc.Voxel;
import misc.linkedsurface.LinkedTriaSurface;

public class Voxelize {
    public static ArrayList<Voxel> setLine(Point3i p1, Point3i p2) {
        ArrayList<Voxel> ret = new ArrayList<Voxel>();
        if (Math.abs(p2.x - p1.x) >= Math.abs(p2.y - p1.y) && Math.abs(p2.x - p1.x) >= Math.abs(p2.z - p1.z)) {
            if (p1.x > p2.x) {
                return Voxelize.setLine(p2, p1);
            }
            int x = p1.x;
            int deltax = p2.x - p1.x;
            int y = p1.y;
            int deltay = Math.abs(p2.y - p1.y);
            int ysign = 1;
            if (p2.y - p1.y < 0) {
                ysign = -1;
            }
            int dy = 2 * deltay - deltax;
            int yinc1 = 2 * deltay;
            int yinc2 = 2 * (deltay - deltax);
            int z = p1.z;
            int deltaz = Math.abs(p2.z - p1.z);
            int zsign = 1;
            if (p2.z - p1.z < 0) {
                zsign = -1;
            }
            int dz = 2 * deltaz - deltax;
            int zinc1 = 2 * deltaz;
            int zinc2 = 2 * (deltaz - deltax);
            ret.add(new Voxel(x, y, z));
            while (x < p2.x) {
                ++x;
                if (dy < 0) {
                    dy += yinc1;
                } else {
                    dy += yinc2;
                    y += ysign;
                }
                if (dz < 0) {
                    dz += zinc1;
                } else {
                    dz += zinc2;
                    z += zsign;
                }
                ret.add(new Voxel(x, y, z));
            }
        } else if (Math.abs(p2.y - p1.y) >= Math.abs(p2.x - p1.x) && Math.abs(p2.y - p1.y) >= Math.abs(p2.z - p1.z)) {
            if (p1.y > p2.y) {
                return Voxelize.setLine(p2, p1);
            }
            int y = p1.y;
            int deltay = p2.y - p1.y;
            int x = p1.x;
            int deltax = Math.abs(p2.x - p1.x);
            int xsign = 1;
            if (p2.x - p1.x < 0) {
                xsign = -1;
            }
            int dx = 2 * deltax - deltay;
            int xinc1 = 2 * deltax;
            int xinc2 = 2 * (deltax - deltay);
            int z = p1.z;
            int deltaz = Math.abs(p2.z - p1.z);
            int zsign = 1;
            if (p2.z - p1.z < 0) {
                zsign = -1;
            }
            int dz = 2 * deltaz - deltay;
            int zinc1 = 2 * deltaz;
            int zinc2 = 2 * (deltaz - deltay);
            ret.add(new Voxel(x, y, z));
            while (y < p2.y) {
                ++y;
                if (dx < 0) {
                    dx += xinc1;
                } else {
                    dx += xinc2;
                    x += xsign;
                }
                if (dz < 0) {
                    dz += zinc1;
                } else {
                    dz += zinc2;
                    z += zsign;
                }
                ret.add(new Voxel(x, y, z));
            }
        } else {
            if (p1.z > p2.z) {
                return Voxelize.setLine(p2, p1);
            }
            int z = p1.z;
            int deltaz = p2.z - p1.z;
            int x = p1.x;
            int deltax = Math.abs(p2.x - p1.x);
            int xsign = 1;
            if (p2.x - p1.x < 0) {
                xsign = -1;
            }
            int dx = 2 * deltax - deltaz;
            int xinc1 = 2 * deltax;
            int xinc2 = 2 * (deltax - deltaz);
            int y = p1.y;
            int deltay = Math.abs(p2.y - p1.y);
            int ysign = 1;
            if (p2.y - p1.y < 0) {
                ysign = -1;
            }
            int dy = 2 * deltay - deltaz;
            int yinc1 = 2 * deltay;
            int yinc2 = 2 * (deltay - deltaz);
            ret.add(new Voxel(x, y, z));
            while (z < p2.z) {
                ++z;
                if (dx < 0) {
                    dx += xinc1;
                } else {
                    dx += xinc2;
                    x += xsign;
                }
                if (dy < 0) {
                    dy += yinc1;
                } else {
                    dy += yinc2;
                    y += ysign;
                }
                ret.add(new Voxel(x, y, z));
            }
        }
        return ret;
    }

    public static ArrayList<Voxel> setTria(LinkedTriaSurface.LinkedTria lt, boolean filled) {
        return Voxelize.setTria(lt._a._p, lt._b._p, lt._c._p, filled);
    }

    public static ArrayList<Voxel> setTria(Point3d p1, Point3d p2, Point3d p3, boolean filled) {
        Point3i p1i = new Point3i((int)p1.x, (int)p1.y, (int)p1.z);
        Point3i p2i = new Point3i((int)p2.x, (int)p2.y, (int)p2.z);
        Point3i p3i = new Point3i((int)p3.x, (int)p3.y, (int)p3.z);
        return Voxelize.setTria(p1i, p2i, p3i, filled);
    }

    public static ArrayList<Voxel> setTria(Point3i p1, Point3i p2, Point3i p3, boolean filled) {
        ArrayList<Voxel> ret = new ArrayList<Voxel>();
        ret.addAll(Voxelize.setLine(p1, p2));
        ret.addAll(Voxelize.setLine(p2, p3));
        ret.addAll(Voxelize.setLine(p3, p1));
        if (filled) {
            int min_x = Integer.MAX_VALUE;
            int min_y = Integer.MAX_VALUE;
            int min_z = Integer.MAX_VALUE;
            int max_x = Integer.MIN_VALUE;
            int max_y = Integer.MIN_VALUE;
            int max_z = Integer.MIN_VALUE;
            ArrayList<Point3i> plist = new ArrayList<Point3i>();
            plist.add(p1);
            plist.add(p2);
            plist.add(p3);
            for (Point3i p : plist) {
                if (p.x < min_x) {
                    min_x = p.x;
                }
                if (p.x > max_x) {
                    max_x = p.x;
                }
                if (p.y < min_y) {
                    min_y = p.y;
                }
                if (p.y > max_y) {
                    max_y = p.y;
                }
                if (p.z < min_z) {
                    min_z = p.z;
                }
                if (p.z <= max_z) continue;
                max_z = p.z;
            }
            Vector3f v0 = new Vector3f((float)p3.x, (float)p3.y, (float)p3.z);
            v0.sub((Tuple3f)new Vector3f((float)p1.x, (float)p1.y, (float)p1.z));
            Vector3f v1 = new Vector3f((float)p2.x, (float)p2.y, (float)p2.z);
            v1.sub((Tuple3f)new Vector3f((float)p1.x, (float)p1.y, (float)p1.z));
            Vector3f v2 = new Vector3f();
            float dot00 = v0.dot(v0);
            float dot01 = v0.dot(v1);
            float dot11 = v1.dot(v1);
            float invDenom = 1.0f / (dot00 * dot11 - dot01 * dot01);
            int x = min_x;
            while (x <= max_x) {
                int y = min_y;
                while (y <= max_y) {
                    int z = min_z;
                    while (z <= max_z) {
                        v2.x = x;
                        v2.y = y;
                        v2.z = z;
                        v2.sub((Tuple3f)new Vector3f((float)p1.x, (float)p1.y, (float)p1.z));
                        float dot02 = v0.dot(v2);
                        float dot12 = v1.dot(v2);
                        float u = (dot11 * dot02 - dot01 * dot12) * invDenom;
                        float v = (dot00 * dot12 - dot01 * dot02) * invDenom;
                        if (u >= 0.0f && v >= 0.0f && 1.0f - u - v >= 0.0f && u <= 1.0f && v <= 1.0f && 1.0f - u - v <= 1.0f && Math.abs(u * v0.z + v * v1.z - v2.z) <= 0.5f && Math.abs(u * v0.y + v * v1.y - v2.y) <= 0.5f && Math.abs(u * v0.x + v * v1.x - v2.x) <= 0.5f) {
                            ret.add(new Voxel(x, y, z));
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
        return ret;
    }

    public static List<Voxel> setCircle(Voxel center, Vector3d normal, double radius) {
        LinkedList<Voxel> ret = new LinkedList<Voxel>();
        Point3d p_center = new Point3d((double)center._x, (double)center._y, (double)center._z);
        int i_radius = (int)Math.floor(radius) + 1;
        int z = center._z - i_radius;
        while (z < center._z + i_radius) {
            int y = center._y - i_radius;
            while (y < center._y + i_radius) {
                int x = center._x - i_radius;
                while (x < center._x + i_radius) {
                    Point3d test = new Point3d((double)x, (double)y, (double)z);
                    if (Voxelize.pointInPlane(test, p_center, normal) && !(Math.abs(test.distance(p_center)) > radius)) {
                        ret.add(new Voxel(x, y, z));
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        return ret;
    }

    public static boolean pointInPlane(Point3d test, Point3d point_on_plane, Vector3d plane_normal) {
        return Voxelize.pointInPlane(test, point_on_plane, plane_normal, 0.5);
    }

    public static boolean pointInPlane(Point3d test, Point3d point_on_plane, Vector3d plane_normal, double accuracy) {
        Vector3d p = new Vector3d((Tuple3d)point_on_plane);
        p.sub((Tuple3d)test);
        double d = p.dot(plane_normal) / plane_normal.dot(plane_normal);
        return Math.abs(d) <= accuracy;
    }

    public static double distancePointPlane(Point3d test, Point3d point_on_plane, Vector3d plane_normal) {
        Vector3d p = new Vector3d((Tuple3d)((Point3d)point_on_plane.clone()));
        p.sub((Tuple3d)test);
        double d = p.dot((Vector3d)plane_normal.clone()) / plane_normal.dot(plane_normal);
        return d * -1.0;
    }

    public static double maxDistanceTriaFromPlane(LinkedTriaSurface.LinkedTria tria, Point3d point_on_plane, Vector3d plane_normal) {
        double ret = 0.0;
        if (Voxelize.distancePointPlane(tria._a._p, point_on_plane, plane_normal) > ret) {
            ret = Voxelize.distancePointPlane(tria._a._p, point_on_plane, plane_normal);
        }
        if (Voxelize.distancePointPlane(tria._b._p, point_on_plane, plane_normal) > ret) {
            ret = Voxelize.distancePointPlane(tria._b._p, point_on_plane, plane_normal);
        }
        if (Voxelize.distancePointPlane(tria._c._p, point_on_plane, plane_normal) > ret) {
            ret = Voxelize.distancePointPlane(tria._c._p, point_on_plane, plane_normal);
        }
        return ret;
    }

    public static double minDistanceTriaFromPlane(LinkedTriaSurface.LinkedTria tria, Point3d point_on_plane, Vector3d plane_normal) {
        double ret = 0.0;
        if (Voxelize.distancePointPlane(tria._a._p, point_on_plane, plane_normal) < ret) {
            ret = Voxelize.distancePointPlane(tria._a._p, point_on_plane, plane_normal);
        }
        if (Voxelize.distancePointPlane(tria._b._p, point_on_plane, plane_normal) < ret) {
            ret = Voxelize.distancePointPlane(tria._b._p, point_on_plane, plane_normal);
        }
        if (Voxelize.distancePointPlane(tria._c._p, point_on_plane, plane_normal) < ret) {
            ret = Voxelize.distancePointPlane(tria._c._p, point_on_plane, plane_normal);
        }
        return ret;
    }

    public static void add_scaled_vector_to_point(Vector3d v, double scale_factor, Point3d store) {
        store.x += scale_factor * v.x;
        store.y += scale_factor * v.y;
        store.z += scale_factor * v.z;
    }

    public static Point3d hit_point_line_triangle(LinkedTriaSurface.LinkedTria tria, Vector3d normal, Point3d p, Vector3d v) {
        Vector3d tnormal = normal;
        v = new Vector3d(v);
        v.normalize();
        tnormal = new Vector3d(tnormal);
        tnormal.normalize();
        Vector3d tmp = new Vector3d((Tuple3d)p);
        tmp.sub((Tuple3d)tria._a._p);
        if (v.dot(tnormal) == 0.0) {
            return null;
        }
        double t = -1.0 * new Vector3d(tmp).dot(tnormal) / v.dot(tnormal);
        if (t < 0.0) {
            return null;
        }
        Point3d x = new Point3d((Tuple3d)v);
        x.scale(t);
        x.add((Tuple3d)p);
        Vector3d ba = new Vector3d((Tuple3d)tria._b._p);
        ba.sub((Tuple3d)tria._a._p);
        Vector3d cb = new Vector3d((Tuple3d)tria._c._p);
        cb.sub((Tuple3d)tria._b._p);
        Vector3d ac = new Vector3d((Tuple3d)tria._a._p);
        ac.sub((Tuple3d)tria._c._p);
        Vector3d xa = new Vector3d((Tuple3d)x);
        xa.sub((Tuple3d)tria._a._p);
        Vector3d xb = new Vector3d((Tuple3d)x);
        xb.sub((Tuple3d)tria._b._p);
        Vector3d xc = new Vector3d((Tuple3d)x);
        xc.sub((Tuple3d)tria._c._p);
        ba.cross(ba, xa);
        cb.cross(cb, xb);
        ac.cross(ac, xc);
        if (ba.dot(tnormal) >= 0.0 && cb.dot(tnormal) >= 0.0 && ac.dot(tnormal) >= 0.0) {
            return x;
        }
        return null;
    }

    public static Point3d hit_point_line_plane(Point3d line_p, Vector3d line_norm, Point3d plane_p, Vector3d plane_norm) {
        line_norm = new Vector3d(line_norm);
        line_norm.normalize();
        plane_norm = new Vector3d(plane_norm);
        plane_norm.normalize();
        Vector3d tmp = new Vector3d((Tuple3d)line_p);
        tmp.sub((Tuple3d)plane_p);
        if (line_norm.dot(plane_norm) == 0.0) {
            return null;
        }
        double t = -1.0 * new Vector3d(tmp).dot(plane_norm) / line_norm.dot(plane_norm);
        Point3d x = new Point3d((Tuple3d)line_norm);
        x.scale(t);
        x.add((Tuple3d)line_p);
        return x;
    }

    public static Vector3d orthoProjectionVectorOnPlane(Vector3d v, Vector3d plane_normal) {
        return new Vector3d((Tuple3d)Voxelize.hit_point_line_plane(new Point3d((Tuple3d)v), plane_normal, new Point3d(0.0, 0.0, 0.0), plane_normal));
    }

    public static Vector3d rotateVectorAroundAxis(Vector3d v, Vector3d axis, double angle) {
        v = new Vector3d(v);
        v.normalize();
        axis = new Vector3d(axis);
        axis.normalize();
        double r11 = Math.cos(angle) + axis.x * axis.x * (1.0 - Math.cos(angle));
        double r12 = axis.x * axis.y * (1.0 - Math.cos(angle)) - axis.z * Math.sin(angle);
        double r13 = axis.x * axis.z * (1.0 - Math.cos(angle)) + axis.y * Math.sin(angle);
        double r21 = axis.y * axis.x * (1.0 - Math.cos(angle)) + axis.z * Math.sin(angle);
        double r22 = Math.cos(angle) + axis.y * axis.y * (1.0 - Math.cos(angle));
        double r23 = axis.y * axis.z * (1.0 - Math.cos(angle)) - axis.x * Math.sin(angle);
        double r31 = axis.z * axis.x * (1.0 - Math.cos(angle)) - axis.y * Math.sin(angle);
        double r32 = axis.z * axis.y * (1.0 - Math.cos(angle)) + axis.x * Math.sin(angle);
        double r33 = Math.cos(angle) + axis.z * axis.z * (1.0 - Math.cos(angle));
        Matrix3d rot = new Matrix3d(r11, r12, r13, r21, r22, r23, r31, r32, r33);
        rot.transform((Tuple3d)v);
        return v;
    }

    public static Matrix4d rotationMatrixAroundAxis(Vector3d axis, double angle) {
        axis = new Vector3d(axis);
        axis.normalize();
        double r11 = Math.cos(angle) + axis.x * axis.x * (1.0 - Math.cos(angle));
        double r12 = axis.x * axis.y * (1.0 - Math.cos(angle)) - axis.z * Math.sin(angle);
        double r13 = axis.x * axis.z * (1.0 - Math.cos(angle)) + axis.y * Math.sin(angle);
        double r21 = axis.y * axis.x * (1.0 - Math.cos(angle)) + axis.z * Math.sin(angle);
        double r22 = Math.cos(angle) + axis.y * axis.y * (1.0 - Math.cos(angle));
        double r23 = axis.y * axis.z * (1.0 - Math.cos(angle)) - axis.x * Math.sin(angle);
        double r31 = axis.z * axis.x * (1.0 - Math.cos(angle)) - axis.y * Math.sin(angle);
        double r32 = axis.z * axis.y * (1.0 - Math.cos(angle)) + axis.x * Math.sin(angle);
        double r33 = Math.cos(angle) + axis.z * axis.z * (1.0 - Math.cos(angle));
        return new Matrix4d(r11, r12, r13, 0.0, r21, r22, r23, 0.0, r31, r32, r33, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static double distance_point_edge(LinkedTriaSurface.LinkedEdge le, Point3d p) {
        return Math.sqrt(Voxelize.squared_distance_point_edge(le, p));
    }

    public static double squared_distance_point_edge(LinkedTriaSurface.LinkedEdge le, Point3d p) {
        Vector3d v = new Vector3d((Tuple3d)le._b._p);
        v.sub((Tuple3d)le._a._p);
        Vector3d w = new Vector3d((Tuple3d)p);
        w.sub((Tuple3d)le._a._p);
        double c1 = w.dot(v);
        if (c1 <= 0.0) {
            Vector3d ret = new Vector3d((Tuple3d)p);
            ret.sub((Tuple3d)le._a._p);
            return ret.lengthSquared();
        }
        double c2 = v.dot(v);
        if (c2 <= c1) {
            Vector3d ret = new Vector3d((Tuple3d)p);
            ret.sub((Tuple3d)le._b._p);
            return ret.lengthSquared();
        }
        double b = c1 / c2;
        Point3d pb = new Point3d((Tuple3d)v);
        pb.scale(b);
        pb.add((Tuple3d)le._a._p);
        Vector3d ret = new Vector3d((Tuple3d)p);
        ret.sub((Tuple3d)pb);
        return ret.lengthSquared();
    }
}

