/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.surface.loader;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.vecmath.Point3d;
import main.seggen.dm.surface.DMSurface;
import main.seggen.dm.surface.Label;
import main.seggen.dm.surface.loader.DMReader;
import main.seggen.dm.surface.loader.XMLHelper;
import misc.linkedsurface.LinkedTriaSurface;

public class DMLoader {
    private DMSurface _cs;

    public DMSurface load(InputStream is) {
        return this.load(is, false);
    }

    public DMSurface load(InputStream is, boolean verbose) {
        this._cs = new DMSurface();
        this._cs._name = "";
        this._cs._type = "";
        try {
            DMReader dmr = new DMReader(is);
            dmr.skipWhiteSpace();
            String tag = dmr.readTag();
            if (!"model".equals(XMLHelper.getElementName(tag).toLowerCase())) {
                System.err.println("DM-Files must always start with <model ...>");
            }
            if (verbose) {
                System.out.println(tag);
            }
            HashMap<String, String> hm = XMLHelper.getAttributes(tag);
            for (String key : hm.keySet()) {
                if (!verbose) continue;
                System.out.println(String.valueOf(key) + ": " + hm.get(key));
            }
            if (hm.get("type") != null) {
                this._cs._type = hm.get("type");
            }
            if (hm.get("name") != null) {
                this._cs._name = hm.get("name");
            }
            dmr.skipWhiteSpace();
            tag = dmr.readTag();
            do {
                if ("geometry".equals(XMLHelper.getElementName(tag).toLowerCase())) {
                    if (verbose) {
                        System.out.println("now handles geometry");
                    }
                    this.parseGeometry(dmr, verbose);
                } else if ("labels".equals(XMLHelper.getElementName(tag).toLowerCase())) {
                    if (verbose) {
                        System.out.println("now handles labels");
                    }
                    this.parseLabels(dmr, verbose);
                } else if (!XMLHelper.isClosed(tag)) {
                    if (verbose) {
                        System.out.println("skipping unknown tag: " + XMLHelper.getElementName(tag));
                    }
                    dmr.skipUntilClosingTag(XMLHelper.getElementName(tag));
                    dmr.readTag();
                }
                dmr.skipWhiteSpace();
            } while (!"model".equals(XMLHelper.getElementName(tag = dmr.readTag()).toLowerCase()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this._cs;
    }

    public void printHMValues(HashMap<String, String> hm) {
        for (String name : hm.keySet()) {
            System.out.println(String.valueOf(name) + " = " + hm.get(name));
        }
    }

    private void parseGeometry(DMReader dmr, boolean verbose) throws IOException {
        dmr.skipWhiteSpace();
        String tag = dmr.readTag();
        do {
            if ("vertices".equals(XMLHelper.getElementName(tag).toLowerCase())) {
                if (verbose) {
                    System.out.println("now handles vertices");
                }
                this.readVertices(dmr, verbose);
                dmr.readTag();
            } else if ("itriangles".equals(XMLHelper.getElementName(tag).toLowerCase())) {
                if (verbose) {
                    System.out.println("now handles itriangles");
                }
                this.readTrias(dmr, verbose);
                dmr.readTag();
            } else {
                if ("geometry".equals(XMLHelper.getElementName(tag).toLowerCase())) break;
                if (!XMLHelper.isClosed(tag)) {
                    if (verbose) {
                        System.out.println("skipping unknown tag: " + XMLHelper.getElementName(tag));
                    }
                    dmr.skipUntilClosingTag(XMLHelper.getElementName(tag));
                    dmr.readTag();
                }
            }
            dmr.skipWhiteSpace();
        } while (!"geometry".equals(XMLHelper.getElementName(tag = dmr.readTag()).toLowerCase()));
    }

    private void readVertices(DMReader dmr, boolean verbose) throws IOException {
        int count = 0;
        while (true) {
            dmr.skipWhiteSpace();
            Point3d p = this.readPoint(dmr);
            this._cs.add_vert(p);
            ++count;
            dmr.skipWhiteSpace();
            if (!";".equals(dmr.lookAhead(1))) break;
            dmr.readNextCharacter();
        }
        dmr.skipWhiteSpace();
        if (verbose) {
            System.out.println(String.valueOf(count) + " vertices read.");
        }
    }

    private Point3d readPoint(DMReader dmr) throws IOException {
        Point3d p = new Point3d();
        dmr.skipWhiteSpace();
        if (!"(".equals(dmr.readNextCharacter())) {
            return null;
        }
        dmr.skipWhiteSpace();
        p.x = dmr.readDouble();
        dmr.skipWhiteSpace();
        dmr.readNextCharacter();
        dmr.skipWhiteSpace();
        p.y = dmr.readDouble();
        dmr.skipWhiteSpace();
        dmr.readNextCharacter();
        dmr.skipWhiteSpace();
        p.z = dmr.readDouble();
        dmr.skipWhiteSpace();
        if (!")".equals(dmr.readNextCharacter())) {
            return null;
        }
        dmr.skipWhiteSpace();
        return p;
    }

    private void readTrias(DMReader dmr, boolean verbose) throws IOException {
        int count = 0;
        while (true) {
            dmr.skipWhiteSpace();
            int[] tria = this.readITria(dmr);
            this._cs.add_face((LinkedTriaSurface.LinkedVert)this._cs._vlist.get(tria[0]), (LinkedTriaSurface.LinkedVert)this._cs._vlist.get(tria[1]), (LinkedTriaSurface.LinkedVert)this._cs._vlist.get(tria[2]));
            ++count;
            dmr.skipWhiteSpace();
            if (!";".equals(dmr.lookAhead(1))) break;
            dmr.readNextCharacter();
        }
        dmr.skipWhiteSpace();
        if (verbose) {
            System.out.println(String.valueOf(count) + " iTrias read.");
        }
    }

    private int[] readITria(DMReader dmr) throws IOException {
        int[] ret = new int[3];
        dmr.skipWhiteSpace();
        if (!"(".equals(dmr.readNextCharacter())) {
            return null;
        }
        dmr.skipWhiteSpace();
        ret[0] = dmr.readInt();
        dmr.skipWhiteSpace();
        dmr.readNextCharacter();
        dmr.skipWhiteSpace();
        ret[1] = dmr.readInt();
        dmr.skipWhiteSpace();
        dmr.readNextCharacter();
        dmr.skipWhiteSpace();
        ret[2] = dmr.readInt();
        dmr.skipWhiteSpace();
        if (!")".equals(dmr.readNextCharacter())) {
            return null;
        }
        dmr.skipWhiteSpace();
        return ret;
    }

    private void parseLabels(DMReader dmr, boolean verbose) throws IOException {
        dmr.skipWhiteSpace();
        String tag = dmr.readTag();
        while (true) {
            if ("elabels".equals(XMLHelper.getElementName(tag).toLowerCase())) {
                this.parseELabels(dmr, verbose);
            } else if ("tlabels".equals(XMLHelper.getElementName(tag).toLowerCase())) {
                this.parseTLabels(dmr, verbose);
            } else if ("vlabels".equals(XMLHelper.getElementName(tag).toLowerCase())) {
                this.parseVLabels(dmr, verbose);
            } else {
                if ("labels".equals(XMLHelper.getElementName(tag).toLowerCase())) break;
                if (!XMLHelper.isClosed(tag)) {
                    if (verbose) {
                        System.out.println("skipping unknown tag: " + XMLHelper.getElementName(tag));
                    }
                    dmr.skipUntilClosingTag(XMLHelper.getElementName(tag));
                    dmr.readTag();
                }
            }
            dmr.skipWhiteSpace();
            tag = dmr.readTag();
            if ("labels".equals(XMLHelper.getElementName(tag).toLowerCase())) break;
            dmr.skipWhiteSpace();
        }
    }

    private void parseTLabels(DMReader dmr, boolean verbose) throws IOException {
        dmr.skipWhiteSpace();
        String tag = dmr.readTag();
        while (true) {
            if ("tlabel".equals(XMLHelper.getElementName(tag).toLowerCase())) {
                Label<LinkedTriaSurface.LinkedTria> label = new Label<LinkedTriaSurface.LinkedTria>();
                label.attributes = XMLHelper.getAttributes(tag);
                label.id = label.attributes.get("id");
                label.color = label.attributes.get("color");
                this._cs._tria_labels.put(label.id, label);
                this.readTLabelAssigments(dmr, label);
            } else if (!XMLHelper.isClosed(tag)) {
                if (verbose) {
                    System.out.println("skipping unknown tag: " + XMLHelper.getElementName(tag));
                }
                dmr.skipUntilClosingTag(XMLHelper.getElementName(tag));
                dmr.readTag();
            }
            dmr.skipWhiteSpace();
            tag = dmr.readTag();
            dmr.skipWhiteSpace();
            if ("tlabels".equals(XMLHelper.getElementName(tag).toLowerCase())) break;
            dmr.skipWhiteSpace();
        }
        dmr.skipWhiteSpace();
    }

    private void readTLabelAssigments(DMReader dmr, Label<LinkedTriaSurface.LinkedTria> label) throws IOException {
        dmr.skipWhiteSpace();
        if (!dmr.lookAhead(1).equalsIgnoreCase("<")) {
            while (true) {
                int i = dmr.readInt();
                label.add_element((LinkedTriaSurface.LinkedTria)this._cs._flist.get(i));
                dmr.skipWhiteSpace();
                if (!dmr.isNext(";")) break;
                dmr.readNextCharacter();
                dmr.skipWhiteSpace();
            }
        }
        dmr.skipWhiteSpace();
        dmr.readTag();
        dmr.skipWhiteSpace();
    }

    private void parseVLabels(DMReader dmr, boolean verbose) throws IOException {
        dmr.skipWhiteSpace();
        String tag = dmr.readTag();
        do {
            if ("vlabel".equals(XMLHelper.getElementName(tag).toLowerCase())) {
                Label<LinkedTriaSurface.LinkedVert> label = new Label<LinkedTriaSurface.LinkedVert>();
                label.attributes = XMLHelper.getAttributes(tag);
                label.id = label.attributes.get("id");
                label.color = label.attributes.get("color");
                this._cs._vert_labels.put(label.id, label);
                this.readVLabelAssigments(dmr, label);
            } else if (!XMLHelper.isClosed(tag)) {
                if (verbose) {
                    System.out.println("skipping unknown tag: " + XMLHelper.getElementName(tag));
                }
                dmr.skipUntilClosingTag(XMLHelper.getElementName(tag));
                dmr.readTag();
            }
            dmr.skipWhiteSpace();
        } while (!"vlabels".equals(XMLHelper.getElementName(tag = dmr.readTag()).toLowerCase()));
    }

    private void readVLabelAssigments(DMReader dmr, Label<LinkedTriaSurface.LinkedVert> label) throws IOException {
        dmr.skipWhiteSpace();
        if (!dmr.lookAhead(1).equalsIgnoreCase("<")) {
            while (true) {
                int i = dmr.readInt();
                label.add_element((LinkedTriaSurface.LinkedVert)this._cs._vlist.get(i));
                dmr.skipWhiteSpace();
                if (!dmr.isNext(";")) break;
                dmr.readNextCharacter();
                dmr.skipWhiteSpace();
            }
        }
        dmr.skipWhiteSpace();
        dmr.readTag();
        dmr.skipWhiteSpace();
    }

    private void parseELabels(DMReader dmr, boolean verbose) throws IOException {
        dmr.skipWhiteSpace();
        String tag = dmr.readTag();
        do {
            if ("elabel".equals(XMLHelper.getElementName(tag).toLowerCase())) {
                Label<LinkedTriaSurface.LinkedEdge> label = new Label<LinkedTriaSurface.LinkedEdge>();
                label.attributes = XMLHelper.getAttributes(tag);
                label.id = label.attributes.get("id");
                label.color = label.attributes.get("color");
                this._cs._edge_labels.put(label.id, label);
                this.readELabelAssigments(dmr, label);
            } else if (!XMLHelper.isClosed(tag)) {
                if (verbose) {
                    System.out.println("skipping unknown tag: " + XMLHelper.getElementName(tag));
                }
                dmr.skipUntilClosingTag(XMLHelper.getElementName(tag));
                dmr.readTag();
            }
            dmr.skipWhiteSpace();
        } while (!"elabels".equals(XMLHelper.getElementName(tag = dmr.readTag()).toLowerCase()));
    }

    private void readELabelAssigments(DMReader dmr, Label<LinkedTriaSurface.LinkedEdge> label) throws IOException {
        dmr.skipWhiteSpace();
        if (!dmr.lookAhead(1).equalsIgnoreCase("<")) {
            while (true) {
                int[] edge = this.readEdge(dmr);
                LinkedTriaSurface.LinkedVert a = (LinkedTriaSurface.LinkedVert)this._cs._vlist.get(edge[0]);
                LinkedTriaSurface.LinkedVert b = (LinkedTriaSurface.LinkedVert)this._cs._vlist.get(edge[1]);
                for (LinkedTriaSurface.LinkedEdge le : a._ep) {
                    if (!le.equals(a, b)) continue;
                    label.add_element(le);
                }
                dmr.skipWhiteSpace();
                if (!dmr.isNext(";")) break;
                dmr.readNextCharacter();
                dmr.skipWhiteSpace();
            }
        }
        dmr.skipWhiteSpace();
        dmr.readTag();
        dmr.skipWhiteSpace();
    }

    private int[] readEdge(DMReader dmr) throws IOException {
        int[] ret = new int[2];
        dmr.skipWhiteSpace();
        if (!"(".equals(dmr.readNextCharacter())) {
            return null;
        }
        dmr.skipWhiteSpace();
        ret[0] = dmr.readInt();
        dmr.skipWhiteSpace();
        if (!",".equals(dmr.readNextCharacter())) {
            return null;
        }
        dmr.skipWhiteSpace();
        ret[1] = dmr.readInt();
        dmr.skipWhiteSpace();
        if (!")".equals(dmr.readNextCharacter())) {
            return null;
        }
        dmr.skipWhiteSpace();
        return ret;
    }
}

