/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.surface.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class DMReader {
    private BufferedReader br;
    private int lineNumber = 0;
    private String[] whitespace_comma_bracket_separator;
    private String currLine;

    public DMReader(InputStream is) {
        this.br = new BufferedReader(new InputStreamReader(is));
        this.whitespace_comma_bracket_separator = new String[]{" ", ",", ")", "<"};
    }

    private String getNextLine() throws IOException {
        ++this.lineNumber;
        return this.br.readLine();
    }

    public String readNextCharacter() throws IOException {
        if (this.currLine == null || this.currLine.length() == 0) {
            this.currLine = this.getNextLine();
        }
        String ret = this.currLine.substring(0, 1);
        this.currLine = this.currLine.substring(1);
        return ret;
    }

    public String readNextCharacter(int amount) throws IOException {
        if (this.currLine == null || this.currLine.length() == 0) {
            this.currLine = this.getNextLine();
        }
        while (this.currLine.length() < amount) {
            this.currLine = String.valueOf(this.currLine) + this.getNextLine();
        }
        String ret = this.currLine.substring(0, amount);
        this.currLine = this.currLine.substring(amount);
        return ret;
    }

    public void skipWhiteSpace() throws IOException {
        do {
            if (this.currLine == null || this.currLine.length() == 0) {
                this.currLine = this.getNextLine();
            }
            this.currLine = this.currLine.replaceAll("^\\s+", "");
        } while (this.currLine.length() < 1);
    }

    public String readUntilString(String[] stopStrings, int maxSize) throws IOException {
        String stop;
        int n;
        int n2;
        String[] stringArray;
        int index = -1;
        do {
            stringArray = stopStrings;
            n2 = stopStrings.length;
            n = 0;
            while (n < n2) {
                stop = stringArray[n];
                int tempidx = this.currLine.indexOf(stop);
                if (tempidx >= 0) {
                    if (index < 0) {
                        index = tempidx;
                    } else if (tempidx < index) {
                        index = tempidx;
                    }
                }
                ++n;
            }
            if (index != -1 || this.currLine.length() >= maxSize) continue;
            this.currLine = String.valueOf(this.currLine) + this.getNextLine();
        } while (index == -1 && this.currLine.length() < maxSize);
        if (index == -1) {
            stringArray = stopStrings;
            n2 = stopStrings.length;
            n = 0;
            while (n < n2) {
                stop = stringArray[n];
                System.err.println(String.valueOf(stop) + " ");
                ++n;
            }
            System.err.println("Not found in line: " + this.lineNumber);
            return null;
        }
        String ret = this.currLine.substring(0, index);
        this.currLine = this.currLine.substring(index);
        return ret;
    }

    public int readInt() throws IOException {
        String intString = this.readUntilString(this.whitespace_comma_bracket_separator, 100);
        return Integer.parseInt(intString);
    }

    public float readFloat() throws IOException {
        String floatString = this.readUntilString(this.whitespace_comma_bracket_separator, 100);
        return (float)Double.parseDouble(floatString);
    }

    public double readDouble() throws IOException {
        String floatString = this.readUntilString(this.whitespace_comma_bracket_separator, 100);
        return Double.parseDouble(floatString);
    }

    public String readTag() throws IOException {
        String tag = this.readUntilString(new String[]{">"}, Integer.MAX_VALUE);
        tag = String.valueOf(tag) + this.readNextCharacter();
        return tag;
    }

    public boolean isNext(String compare) throws IOException {
        if (this.currLine == null) {
            this.currLine = this.getNextLine();
        }
        while (this.currLine.length() < compare.length()) {
            this.currLine = String.valueOf(this.currLine) + this.getNextLine();
        }
        return this.currLine.startsWith(compare);
    }

    public void skip(int amount) throws IOException {
        if (this.currLine == null) {
            this.currLine = this.getNextLine();
        }
        while (this.currLine.length() < amount) {
            this.currLine = String.valueOf(this.currLine) + this.getNextLine();
        }
        this.currLine = this.currLine.substring(amount);
    }

    public void skipUntilClosingTag(String elementName) throws IOException {
        if (this.currLine == null) {
            this.currLine = this.getNextLine();
        }
        int index = Integer.MAX_VALUE;
        do {
            if ((index = this.currLine.indexOf("</")) != -1) continue;
            this.currLine = this.currLine.endsWith("<") ? String.valueOf(this.currLine) + this.getNextLine() : this.getNextLine();
        } while (index == -1);
        if (index == -1) {
            System.err.println("Closing " + elementName + " tag not found until line: " + this.lineNumber);
        }
        this.currLine = this.currLine.substring(index);
    }

    public String lookAhead(int numberOfCharacters) throws IOException {
        if (this.currLine == null) {
            this.currLine = this.getNextLine();
        }
        while (this.currLine.length() < numberOfCharacters) {
            this.currLine = String.valueOf(this.currLine) + this.getNextLine();
        }
        return this.currLine.substring(0, numberOfCharacters);
    }
}

