/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.surface.loader;

import java.io.InputStream;
import java.util.ArrayList;
import javax.media.j3d.IndexedTriangleArray;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import main.seggen.dm.surface.DMSurface;
import misc.GeometryImport;
import misc.linkedsurface.LinkedTriaSurface;

public class JanusLoader {
    public static DMSurface loadInputStream(InputStream is, Point3d center, Vector3d scale, Matrix3d trans) {
        DMSurface ret = new DMSurface();
        IndexedTriangleArray ita = GeometryImport.read_indexed_tria_from_janus_input_stream(is);
        if (ita == null) {
            System.err.println("Cannot load intial shape");
            return null;
        }
        JanusLoader.set(ret, ita, new Point3d(0.0, 0.0, 0.0), scale, trans);
        return ret;
    }

    public static DMSurface loadInputStream(InputStream is, Point3d center, Vector3d scale) {
        Matrix3d trans = new Matrix3d();
        trans.setIdentity();
        return JanusLoader.loadInputStream(is, center, scale, trans);
    }

    public static DMSurface loadInputStream(InputStream is, Point3d center) {
        Matrix3d trans = new Matrix3d();
        trans.setIdentity();
        return JanusLoader.loadInputStream(is, center, new Vector3d(1.0, 1.0, 1.0), trans);
    }

    public static DMSurface loadInputStream(InputStream is, Vector3d scale) {
        Matrix3d trans = new Matrix3d();
        trans.setIdentity();
        return JanusLoader.loadInputStream(is, new Point3d(0.0, 0.0, 0.0), scale, trans);
    }

    public static DMSurface loadInputStream(InputStream is) {
        Matrix3d trans = new Matrix3d();
        trans.setIdentity();
        return JanusLoader.loadInputStream(is, new Point3d(0.0, 0.0, 0.0), new Vector3d(1.0, 1.0, 1.0), trans);
    }

    private static void set(DMSurface cs, IndexedTriangleArray _shape, Point3d center, Vector3d scale, Matrix3d transform) {
        Point3d[] vertices = new Point3d[_shape.getVertexCount()];
        int[] indices = new int[_shape.getIndexCount()];
        int c = 0;
        while (c < _shape.getVertexCount()) {
            vertices[c] = new Point3d();
            ++c;
        }
        _shape.getCoordinates(0, vertices);
        _shape.getCoordinateIndices(0, indices);
        Point3d[] point3dArray = vertices;
        int n = vertices.length;
        int n2 = 0;
        while (n2 < n) {
            Point3d p = point3dArray[n2];
            transform.transform((Tuple3d)p);
            p.x *= scale.x;
            p.y *= scale.y;
            p.z *= scale.z;
            ++n2;
        }
        JanusLoader.set_lts(cs, vertices, indices, center);
    }

    private static void set_lts(DMSurface cs, Point3d[] _vertices, int[] _trias, Point3d center) {
        DMSurface lts = cs;
        ArrayList<LinkedTriaSurface.LinkedVert> lvertices = new ArrayList<LinkedTriaSurface.LinkedVert>();
        int i = 0;
        while (i < _vertices.length) {
            Point3d pd = _vertices[i];
            pd.add((Tuple3d)center);
            LinkedTriaSurface.LinkedVert lv = cs.add_vert(pd);
            lvertices.add(lv);
            ++i;
        }
        i = 0;
        while (i < _trias.length / 3) {
            cs.add_face((LinkedTriaSurface.LinkedVert)lvertices.get(_trias[i * 3 + 0]), (LinkedTriaSurface.LinkedVert)lvertices.get(_trias[i * 3 + 1]), (LinkedTriaSurface.LinkedVert)lvertices.get(_trias[i * 3 + 2]));
            ++i;
        }
        cs.calc_normals();
        System.out.println("Verts: " + lts._vlist.size() + "\n" + "Edges: " + lts._elist.size() + "\n" + "Trias: " + lts._flist.size());
        System.out.println("EPC:   " + lts.calculate_epc());
    }
}

