/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.surface.loader;

import com.sun.j3d.utils.geometry.Sphere;
import javax.media.j3d.Geometry;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import main.seggen.dm.surface.DMSHelper;
import main.seggen.dm.surface.DMSurface;
import misc.linkedsurface.LinkedTriaSurface;

public class SphereLoader {
    public static DMSurface loadSphere(double radius, Point3d center) {
        DMSurface ret = new DMSurface();
        double sx = 1.0;
        double sy = 1.0;
        double sz = 1.0;
        double max = Math.max(sx, sy);
        max = Math.max(max, sz);
        Sphere sph = new Sphere((float)radius, 16, (int)(radius * 5.0 * max), null);
        Geometry g = sph.getShape().getGeometry();
        System.out.println(g.getClass().toString());
        if (g.getClass() == TriangleStripArray.class) {
            TriangleStripArray tsa = (TriangleStripArray)g;
            int[] vertexCounts = new int[tsa.getNumStrips()];
            tsa.getStripVertexCounts(vertexCounts);
            int init_ind = tsa.getInitialVertexIndex();
            int s = 0;
            while (s < tsa.getNumStrips()) {
                Point3d p1 = new Point3d();
                Point3d p2 = new Point3d();
                Point3d p3 = new Point3d();
                tsa.getCoordinate(init_ind, p1);
                tsa.getCoordinate(init_ind + 1, p2);
                LinkedTriaSurface.LinkedVert lv1 = DMSHelper.lvAddFuzzy(ret, p1);
                LinkedTriaSurface.LinkedVert lv2 = DMSHelper.lvAddFuzzy(ret, p2);
                int c = 2;
                while (c < vertexCounts[s]) {
                    tsa.getCoordinate(init_ind + c, p3);
                    LinkedTriaSurface.LinkedVert lv3 = DMSHelper.lvAddFuzzy(ret, p3);
                    if (c % 2 == 0) {
                        ret.add_face(lv1, lv2, lv3);
                    } else {
                        ret.add_face(lv3, lv2, lv1);
                    }
                    p1 = p2;
                    p2 = p3;
                    lv1 = lv2;
                    lv2 = lv3;
                    ++c;
                }
                init_ind += vertexCounts[s];
                ++s;
            }
            for (LinkedTriaSurface.LinkedVert lv : ret._vlist) {
                lv.scale(sx, sy, sz);
                lv.add((Tuple3d)center);
            }
            System.out.println("Verts: " + ret._vlist.size() + "\n" + "Edges: " + ret._elist.size() + "\n" + "Trias: " + ret._flist.size());
            System.out.println("EPC:   " + ret.calculate_epc());
        } else {
            System.err.println(g.getClass() + " unsupported for inital sphere");
        }
        return ret;
    }
}

