/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.surface.placement;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jgridmaker.GMPanel;
import main.CoordinateConverter;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.SegChangeInfo;
import main.Segment;
import main.YDialogs;
import main.seggen.dm.gui.SurfaceList;
import main.seggen.dm.surface.DMSurface;
import main.seggen.dm.surface.ExtendedBitcube;
import main.seggen.dm.surface.SurfaceAndMetadata;
import main.seggen.dm.surface.SurfaceStorage;
import main.seggen.dm.surface.placement.PlacementInteractionListener;
import main.seggen.dm.surface.placement.PreviewRenderer3d;
import main.view2d.Viewport2d;
import main.view2d.Viewport2dModel;
import misc.grid.BitCube;
import misc.linkedsurface.LinkedTriaSurface;
import misc.messages.YObservable;
import misc.messages.YObserverWantsAWTThread;
import renderer.SegRenderer2d;

public class PlacementController
extends YObservable
implements YObserverWantsAWTThread {
    public static final int M_DMPLACEMENT_START = Message.register_message("DMS Placement started");
    public static final int M_DMPLACEMENT_END = Message.register_message("DMS Placement ended");
    private boolean active = false;
    private PlacementInteractionListener ml;
    private SegRenderer2d renderer2d;
    private PreviewRenderer3d renderer3d;
    private Viewport2d v2d;
    public DMSurface dms;
    private SurfaceAndMetadata samd;
    private Segment seg;
    private GMPanel gui;
    private GMPanel gmp_startstop;
    private GMPanel gmp_translate;
    private GMPanel gmp_rotate;
    private GMPanel gmp_resize;
    private JTextField jtf_angle;
    private JTextField jtf_stepsize;
    private JTextField jtf_resize;
    private JButton jb_start;
    private JButton jb_stop;
    private Matrix4d trans;

    public void start() {
        if (SurfaceList.getInstance().getSelection() == null) {
            YDialogs.notify_user("Select a model first");
            return;
        }
        this.samd = SurfaceList.getInstance().getSelection();
        this.dms = this.samd.surface;
        this.v2d = MasterControl.get_v2d();
        ImageStack is = MasterControl.get_is();
        this.seg = new Segment("", is.get_dim_x(), is.get_dim_y(), is.get_dim_z());
        this.dms.voxelize(this.seg.get_bc());
        this.v2d.get_model().addObserver(this, "PlacementController() v2dmodel");
        this.seg.addObserver(this, "PlacementController() segment");
        this.ml = new PlacementInteractionListener(this.v2d, this.seg, this);
        this.renderer2d = new SegRenderer2d(this.seg, " dms placement preview2d renderer");
        this.v2d.add_renderer(this.renderer2d, Integer.MAX_VALUE);
        this.renderer3d = new PreviewRenderer3d(MasterControl.get_v3d(), 1, this.dms, this.seg);
        MasterControl.get_v3d().add_renderer(this.renderer3d);
        this.v2d.setInteractionListener(this.ml);
        this.trans = new Matrix4d();
        this.trans.setIdentity();
        this.gmp_translate.setEnabled(true);
        this.gmp_rotate.setEnabled(true);
        this.gmp_resize.setEnabled(true);
        this.jb_start.setEnabled(false);
        this.jb_stop.setEnabled(true);
        this.setChanged();
        this.notifyObservers(new Message(M_DMPLACEMENT_START));
    }

    public void stop() {
        if (this.active) {
            this.active = false;
            this.v2d.removeInteractionListener(this.ml);
            this.shutdown();
            Matrix4d samdtrans = new Matrix4d(this.trans);
            samdtrans.mul(this.samd.transform);
            this.samd.transform = samdtrans;
            CoordinateConverter cc = CoordinateConverter.get_converter(MasterControl.get_is());
            for (LinkedTriaSurface.LinkedVert lv : this.dms._vlist) {
                Point3d p = cc.world_to_grid_p3d(lv._p);
                this.trans.transform(p);
                lv.set_point(cc.grid_to_world_p3d(p));
            }
            this.setChanged();
            this.notifyObservers(new Message(M_DMPLACEMENT_END));
            this.gmp_translate.setEnabled(false);
            this.gmp_rotate.setEnabled(false);
            this.gmp_resize.setEnabled(false);
            this.v2d.get_model().deleteObserver(this, "PlacementController() v2dmodel");
            this.seg.deleteObserver(this, "PlacementController() segment");
            SurfaceStorage.getInstance().transformedSurface(this.samd);
            this.jb_start.setEnabled(true);
            this.jb_stop.setEnabled(false);
        }
    }

    public GMPanel getGUI() {
        if (this.gui != null) {
            return this.gui;
        }
        this.jb_start = new JButton("Start");
        this.jb_start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PlacementController.this.start();
            }
        });
        this.jb_stop = new JButton("Stop");
        this.jb_stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PlacementController.this.stop();
            }
        });
        this.gmp_startstop = new GMPanel();
        this.gmp_startstop.add("jb_start", (JComponent)this.jb_start);
        this.gmp_startstop.add("jb_stop", (JComponent)this.jb_stop);
        this.gmp_startstop.set_layout("<table><tr><td>::jb_start::</td><td>::jb_stop::</td></tr></table>");
        this.jtf_stepsize = new JTextField(2);
        this.jtf_stepsize.setText("1");
        this.gmp_translate = new GMPanel();
        this.gmp_translate.add("jtf_stepsize", (JComponent)this.jtf_stepsize);
        this.gmp_translate.add("jb_down", (JComponent)this.getTranslateButton(Direction.DOWN));
        this.gmp_translate.add("jb_downleft", (JComponent)this.getTranslateButton(Direction.DOWNLEFT));
        this.gmp_translate.add("jb_downright", (JComponent)this.getTranslateButton(Direction.DOWNRIGHT));
        this.gmp_translate.add("jb_up", (JComponent)this.getTranslateButton(Direction.UP));
        this.gmp_translate.add("jb_upleft", (JComponent)this.getTranslateButton(Direction.UPLEFT));
        this.gmp_translate.add("jb_upright", (JComponent)this.getTranslateButton(Direction.UPRIGHT));
        this.gmp_translate.add("jb_left", (JComponent)this.getTranslateButton(Direction.LEFT));
        this.gmp_translate.add("jb_right", (JComponent)this.getTranslateButton(Direction.RIGHT));
        this.gmp_translate.set_layout("<table margin='0'><tr margin='0'><td width='48%'></td><td>::jb_upleft::</td><td>::jb_up::</td><td>::jb_upright::</td><td width='49%'></td></tr><tr><td width='48%'></td><td>::jb_left::</td><td></td><td>::jb_right::</td><td width='49%'></td></tr><tr><td width='48%'></td><td>::jb_downleft::</td><td>::jb_down::</td><td>::jb_downright::</td><td width='49%'></td></tr><tr><td width='48%'></td><td colspan='2' align='left'>step size: </td><td align='center'>::jtf_stepsize::</td><td width='49%'></td></tr></table>");
        this.gmp_translate.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Translate", 2, 2));
        JButton jb_larger = new JButton(new ImageIcon("resources/gfx/arrow_resize_larger.png"));
        jb_larger.setText(null);
        jb_larger.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlacementController.this.resize(1);
            }
        });
        JButton jb_smaller = new JButton(new ImageIcon("resources/gfx/arrow_resize_smaller.png"));
        jb_smaller.setText(null);
        jb_smaller.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlacementController.this.resize(0);
            }
        });
        this.jtf_resize = new JTextField(3);
        this.jtf_resize.setText("10.0");
        this.gmp_resize = new GMPanel();
        this.gmp_resize.add("jb_larger", (JComponent)jb_larger);
        this.gmp_resize.add("jb_smaller", (JComponent)jb_smaller);
        this.gmp_resize.add("jtf_resize", (JComponent)this.jtf_resize);
        this.gmp_resize.set_layout("<table>  <tr>    <td>::jb_smaller::</td>    <td>::jb_larger::</td>  </tr><tr>    <td>percent:</td>    <td>::jtf_resize::</td>  </tr></table>");
        this.gmp_resize.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Resize", 2, 2));
        JButton jb_clockwise = new JButton(new ImageIcon("resources/gfx/arrow_rotate_clockwise.png"));
        jb_clockwise.setText(null);
        jb_clockwise.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlacementController.this.rotate(1);
            }
        });
        JButton jb_counterclockwise = new JButton(new ImageIcon("resources/gfx/arrow_rotate_counterclockwise.png"));
        jb_counterclockwise.setText(null);
        jb_counterclockwise.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlacementController.this.rotate(0);
            }
        });
        this.jtf_angle = new JTextField(3);
        this.jtf_angle.setText("10.0");
        this.gmp_rotate = new GMPanel();
        this.gmp_rotate.add("jtf_angle", (JComponent)this.jtf_angle);
        this.gmp_rotate.add("jb_clockwise", (JComponent)jb_clockwise);
        this.gmp_rotate.add("jb_counterclockwise", (JComponent)jb_counterclockwise);
        this.gmp_rotate.set_layout("<table>  <tr>    <td>::jb_counterclockwise::</td>    <td>::jb_clockwise::</td>  </tr><tr>    <td>angle:</td>    <td>::jtf_angle::</td>  </tr></table>");
        this.gmp_rotate.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Rotate", 2, 2));
        this.gui = new GMPanel();
        this.gui.add("gmp_startstop", (JComponent)this.gmp_startstop);
        this.gui.add("gmp_translate", (JComponent)this.gmp_translate);
        this.gui.add("gmp_rotate", (JComponent)this.gmp_rotate);
        this.gui.add("gmp_resize", (JComponent)this.gmp_resize);
        this.gui.set_layout("<table width='100%'>  <tr>    <td fill='both'>::gmp_translate::</td>    <td fill='both'>::gmp_rotate::</td>    <td fill='both'>::gmp_resize::</td>  </tr><tr>    <td colspan='3' anchor='center'>::gmp_startstop::</td>  </tr></table>");
        this.gmp_translate.setEnabled(false);
        this.gmp_rotate.setEnabled(false);
        this.gmp_resize.setEnabled(false);
        this.jb_stop.setEnabled(false);
        this.jb_start.setEnabled(true);
        return this.gui;
    }

    @Override
    public void update(YObservable sender, Message m) {
        if (sender == this.v2d.get_model()) {
            if (m._type == Viewport2dModel.M_V2D_INTERACTIONLISTENER_CHANGED) {
                if (m._obj == this.ml) {
                    this.active = true;
                } else if (this.active) {
                    this.stop();
                }
            }
        } else if (sender == this.seg && m._type == Segment.M_SEG_CHANGED && m._obj != null) {
            SegChangeInfo sci = (SegChangeInfo)m._obj;
            if (sci._change_type == SegChangeInfo.TRANSLATION) {
                int[] translation = (int[])sci._data;
                Matrix4d translation_matrix = new Matrix4d();
                translation_matrix.setIdentity();
                translation_matrix.setTranslation(new Vector3d((double)translation[0], (double)translation[1], (double)translation[2]));
                this.trans.mul(translation_matrix, this.trans);
            }
        }
    }

    private void shutdown() {
        this.active = false;
        MasterControl.get_v2d().del_renderer(this.renderer2d);
        MasterControl.get_v3d().rem_renderer(this.renderer3d);
    }

    public void resize(int dir) {
        double factor = 10.0;
        if (this.seg == null) {
            return;
        }
        if (this.jtf_resize != null) {
            try {
                factor = Double.parseDouble(this.jtf_resize.getText());
            }
            catch (NumberFormatException e) {
                this.jtf_resize.setText(Double.toString(10.0));
            }
        }
        this.resize(dir, factor);
    }

    public void resize(int dir, double factor) {
        ImageStack is = MasterControl.get_is();
        double scale_factor = 100.0;
        scale_factor = dir == 0 ? (scale_factor -= factor) : (scale_factor += factor);
        Matrix4d scale = new Matrix4d();
        scale.setIdentity();
        scale.setScale(scale_factor *= 0.01);
        Matrix4d inv_scale = new Matrix4d();
        inv_scale.setIdentity();
        inv_scale.setScale(1.0 / scale_factor);
        Vector3d com = new Vector3d((Tuple3d)this.CenterOfMassOfVertices());
        Vector3d negcom = new Vector3d(com);
        negcom.scale(-1.0);
        Matrix4d andback = new Matrix4d();
        andback.setIdentity();
        andback.setTranslation(com);
        Matrix4d move_com_to_origin = new Matrix4d();
        move_com_to_origin.setIdentity();
        move_com_to_origin.setTranslation(negcom);
        Matrix4d grid_to_world = new Matrix4d();
        grid_to_world.setIdentity();
        grid_to_world.setM00(is.get_x_spacing());
        grid_to_world.setM11(is.get_y_spacing());
        grid_to_world.setM22(is.get_z_spacing());
        Matrix4d world_to_grid = new Matrix4d();
        world_to_grid.setIdentity();
        world_to_grid.setM00(1.0 / is.get_x_spacing());
        world_to_grid.setM11(1.0 / is.get_y_spacing());
        world_to_grid.setM22(1.0 / is.get_z_spacing());
        Matrix4d combined = new Matrix4d();
        combined.setIdentity();
        Matrix4d inv_combined = new Matrix4d();
        inv_combined.setIdentity();
        combined.mul(andback);
        combined.mul(world_to_grid);
        combined.mul(scale);
        combined.mul(grid_to_world);
        combined.mul(move_com_to_origin);
        inv_combined.mul(andback);
        inv_combined.mul(world_to_grid);
        inv_combined.mul(inv_scale);
        inv_combined.mul(grid_to_world);
        inv_combined.mul(move_com_to_origin);
        this.trans.mul(combined, this.trans);
        if (!this.still_inside()) {
            this.trans.mul(inv_combined, this.trans);
            return;
        }
        this.seg.get_bc().clear();
        this.voxelize(this.seg.get_bc());
        this.renderer3d.apply_transform(combined);
        this.seg.new_data(true);
    }

    public void rotate(int dir) {
        double angle = 10.0;
        if (this.seg == null) {
            return;
        }
        if (this.jtf_angle != null) {
            try {
                angle = Double.parseDouble(this.jtf_angle.getText());
            }
            catch (NumberFormatException e) {
                this.jtf_angle.setText(Double.toString(10.0));
            }
        }
        this.rotate(dir, angle);
    }

    public void rotate(int dir, double angle) {
        Matrix4d inv;
        Matrix4d rot;
        if (this.seg == null) {
            return;
        }
        ImageStack is = MasterControl.get_is();
        if (dir == 0) {
            angle *= -1.0;
        }
        angle *= Math.PI;
        angle /= 180.0;
        if (MasterControl.get_v2d().get_model().get_view_mode() == 0) {
            rot = new Matrix4d();
            rot.setIdentity();
            rot.rotZ(angle);
            inv = new Matrix4d();
            inv.setIdentity();
            inv.rotZ(-1.0 * angle);
        } else if (MasterControl.get_v2d().get_model().get_view_mode() == 1) {
            rot = new Matrix4d();
            rot.setIdentity();
            rot.rotX(angle);
            inv = new Matrix4d();
            inv.setIdentity();
            inv.rotX(-1.0 * angle);
        } else {
            rot = new Matrix4d();
            rot.setIdentity();
            rot.rotY(angle);
            inv = new Matrix4d();
            inv.setIdentity();
            inv.rotY(-1.0 * angle);
        }
        Matrix4d rotf = new Matrix4d();
        rotf.setIdentity();
        Matrix4d invf = new Matrix4d();
        invf.setIdentity();
        Matrix4d grid_to_world = new Matrix4d();
        grid_to_world.setIdentity();
        grid_to_world.setM00(is.get_x_spacing());
        grid_to_world.setM11(is.get_y_spacing());
        grid_to_world.setM22(is.get_z_spacing());
        Matrix4d world_to_grid = new Matrix4d();
        world_to_grid.setIdentity();
        world_to_grid.setM00(1.0 / is.get_x_spacing());
        world_to_grid.setM11(1.0 / is.get_y_spacing());
        world_to_grid.setM22(1.0 / is.get_z_spacing());
        Vector3d com = new Vector3d((Tuple3d)this.CenterOfMassOfVertices());
        Vector3d negcom = new Vector3d(com);
        negcom.scale(-1.0);
        Matrix4d andback = new Matrix4d();
        andback.setIdentity();
        andback.setTranslation(com);
        Matrix4d move_com_to_origin = new Matrix4d();
        move_com_to_origin.setIdentity();
        move_com_to_origin.setTranslation(negcom);
        rotf.mul(andback);
        rotf.mul(world_to_grid);
        rotf.mul(rot);
        rotf.mul(grid_to_world);
        rotf.mul(move_com_to_origin);
        invf.mul(andback);
        invf.mul(world_to_grid);
        invf.mul(inv);
        invf.mul(grid_to_world);
        invf.mul(move_com_to_origin);
        this.trans.mul(rotf, this.trans);
        if (!this.still_inside()) {
            this.trans.mul(invf, this.trans);
            return;
        }
        this.seg.get_bc().clear();
        this.voxelize(this.seg.get_bc());
        this.renderer3d.apply_transform(rotf);
        this.seg.new_data(true);
    }

    public void translate(Direction dir) {
        int stepsize = 1;
        if (this.seg == null) {
            return;
        }
        if (this.jtf_stepsize != null) {
            try {
                stepsize = Integer.parseInt(this.jtf_stepsize.getText());
            }
            catch (NumberFormatException e) {
                this.jtf_stepsize.setText(Integer.toString(1));
            }
        }
        this.translate(dir, stepsize);
    }

    public void translate(Direction dir, int stepsize) {
        if (this.seg == null) {
            return;
        }
        if (MasterControl.get_v2d().get_model().get_view_mode() == 0) {
            switch (dir) {
                case DOWN: {
                    this.seg.translate(0, 1 * stepsize, 0);
                    break;
                }
                case DOWNLEFT: {
                    this.seg.translate(-1 * stepsize, 1 * stepsize, 0);
                    break;
                }
                case DOWNRIGHT: {
                    this.seg.translate(1 * stepsize, 1 * stepsize, 0);
                    break;
                }
                case UP: {
                    this.seg.translate(0, -1 * stepsize, 0);
                    break;
                }
                case UPLEFT: {
                    this.seg.translate(-1 * stepsize, -1 * stepsize, 0);
                    break;
                }
                case UPRIGHT: {
                    this.seg.translate(1 * stepsize, -1 * stepsize, 0);
                    break;
                }
                case RIGHT: {
                    this.seg.translate(1 * stepsize, 0, 0);
                    break;
                }
                case LEFT: {
                    this.seg.translate(-1 * stepsize, 0, 0);
                }
            }
        } else if (MasterControl.get_v2d().get_model().get_view_mode() == 2) {
            switch (dir) {
                case DOWN: {
                    this.seg.translate(0, 0, 1 * stepsize);
                    break;
                }
                case DOWNLEFT: {
                    this.seg.translate(-1 * stepsize, 0, 1 * stepsize);
                    break;
                }
                case DOWNRIGHT: {
                    this.seg.translate(1 * stepsize, 0, 1 * stepsize);
                    break;
                }
                case UP: {
                    this.seg.translate(0, 0, -1 * stepsize);
                    break;
                }
                case UPLEFT: {
                    this.seg.translate(-1 * stepsize, 0, -1 * stepsize);
                    break;
                }
                case UPRIGHT: {
                    this.seg.translate(1 * stepsize, 0, -1 * stepsize);
                    break;
                }
                case RIGHT: {
                    this.seg.translate(1 * stepsize, 0, 0);
                    break;
                }
                case LEFT: {
                    this.seg.translate(-1 * stepsize, 0, 0);
                }
            }
        } else if (MasterControl.get_v2d().get_model().get_view_mode() == 1) {
            switch (dir) {
                case DOWN: {
                    this.seg.translate(0, 0, 1 * stepsize);
                    break;
                }
                case DOWNLEFT: {
                    this.seg.translate(0, -1 * stepsize, 1 * stepsize);
                    break;
                }
                case DOWNRIGHT: {
                    this.seg.translate(0, 1 * stepsize, 1 * stepsize);
                    break;
                }
                case UP: {
                    this.seg.translate(0, 0, -1 * stepsize);
                    break;
                }
                case UPLEFT: {
                    this.seg.translate(0, -1 * stepsize, -1 * stepsize);
                    break;
                }
                case UPRIGHT: {
                    this.seg.translate(0, 1 * stepsize, -1 * stepsize);
                    break;
                }
                case RIGHT: {
                    this.seg.translate(0, 1 * stepsize, 0);
                    break;
                }
                case LEFT: {
                    this.seg.translate(0, -1 * stepsize, 0);
                }
            }
        }
    }

    private JButton getTranslateButton(final Direction dir) {
        ImageIcon i;
        switch (dir) {
            case DOWN: {
                i = new ImageIcon("resources/gfx/arrow_down.png");
                break;
            }
            case DOWNLEFT: {
                i = new ImageIcon("resources/gfx/arrow_downleft.png");
                break;
            }
            case DOWNRIGHT: {
                i = new ImageIcon("resources/gfx/arrow_downright.png");
                break;
            }
            case UP: {
                i = new ImageIcon("resources/gfx/arrow_up.png");
                break;
            }
            case UPLEFT: {
                i = new ImageIcon("resources/gfx/arrow_upleft.png");
                break;
            }
            case UPRIGHT: {
                i = new ImageIcon("resources/gfx/arrow_upright.png");
                break;
            }
            case RIGHT: {
                i = new ImageIcon("resources/gfx/arrow_right.png");
                break;
            }
            case LEFT: {
                i = new ImageIcon("resources/gfx/arrow_left.png");
                break;
            }
            default: {
                i = new ImageIcon("resources/gfx/arrow_down.png");
            }
        }
        JButton ret = new JButton(i);
        ret.setText(null);
        ret.setPreferredSize(new Dimension(25, 25));
        ret.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlacementController.this.translate(dir);
            }
        });
        return ret;
    }

    private void voxelize(BitCube bc) {
        CoordinateConverter cc_conv = CoordinateConverter.get_converter(MasterControl.get_is());
        ExtendedBitcube ebc = new ExtendedBitcube(bc);
        for (LinkedTriaSurface.LinkedTria lt : this.dms._flist) {
            Point3d p1 = cc_conv.world_to_grid_p3d(lt._a._p);
            Point3d p2 = cc_conv.world_to_grid_p3d(lt._b._p);
            Point3d p3 = cc_conv.world_to_grid_p3d(lt._c._p);
            this.trans.transform(p1);
            this.trans.transform(p2);
            this.trans.transform(p3);
            ebc.setTria(p1, p2, p3, true);
        }
        Point3d _myCube_center = this.CenterOfMassOfVertices();
        ebc.floodFill(new Point3f(_myCube_center));
        bc.copy_data_from(ebc);
    }

    Vector3d[] bounding_box() {
        CoordinateConverter cc = CoordinateConverter.get_converter(MasterControl.get_is());
        Vector3d min = new Vector3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        Vector3d max = new Vector3d(Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE);
        for (LinkedTriaSurface.LinkedVert lv : this.dms._vlist) {
            Point3d p = cc.world_to_grid_p3d(lv._p);
            this.trans.transform(p);
            if (p.x < min.x) {
                min.x = p.x;
            }
            if (p.y < min.y) {
                min.y = p.y;
            }
            if (p.z < min.z) {
                min.z = p.z;
            }
            if (p.x > max.x) {
                max.x = p.x;
            }
            if (p.y > max.y) {
                max.y = p.y;
            }
            if (!(p.z > max.z)) continue;
            max.z = p.z;
        }
        Vector3d[] ret = new Vector3d[]{min, max};
        return ret;
    }

    private boolean still_inside() {
        ImageStack is = MasterControl.get_is();
        Vector3d[] minmax = this.bounding_box();
        Vector3d min = minmax[0];
        Vector3d max = minmax[1];
        return min.x > 0.0 && min.y > 0.0 && min.z > 0.0 && max.x < (double)is.get_dim_x() && max.y < (double)is.get_dim_y() && max.z < (double)is.get_dim_z();
    }

    private Point3d CenterOfMassOfVertices() {
        CoordinateConverter cc = CoordinateConverter.get_converter(MasterControl.get_is());
        Point3d center = new Point3d();
        for (LinkedTriaSurface.LinkedVert lv : this.dms._vlist) {
            Point3d p = cc.world_to_grid_p3d(lv._p);
            this.trans.transform(p);
            center.add((Tuple3d)p);
        }
        center.scale(1.0 / (double)this.dms._vlist.size());
        return center;
    }

    public static enum Direction {
        DOWN,
        LEFT,
        UP,
        RIGHT,
        DOWNLEFT,
        DOWNRIGHT,
        UPLEFT,
        UPRIGHT;

    }
}

