/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.surface.placement;

import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import main.Segment;
import main.seggen.dm.surface.placement.PlacementController;
import main.view2d.InteractionListener;
import main.view2d.Viewport2d;
import misc.Voxel;

public class PlacementInteractionListener
extends InteractionListener {
    private Viewport2d v2d;
    private int _last_x;
    private int _last_y;
    private int _last_z;
    private long _last_time = 0L;
    private Segment seg;
    private PlacementController pc;

    public PlacementInteractionListener(Viewport2d v2d, Segment seg, PlacementController pc) {
        this.v2d = v2d;
        this.seg = seg;
        this.pc = pc;
    }

    @Override
    public void mousePressed(MouseEvent me) {
        int modifiers = me.getModifiersEx();
        if ((modifiers & 0x400) != 0) {
            Voxel v = new Voxel();
            this.v2d.convert_panel_pos_to_voxel(me.getX(), me.getY(), v);
            this._last_x = v._x;
            this._last_y = v._y;
            this._last_z = v._z;
        }
        this.v2d.update_magnifier_position();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        int modifiers = me.getModifiersEx();
        if ((modifiers & 0x400) != 0) {
            Voxel v = new Voxel();
            this.v2d.convert_panel_pos_to_voxel(me.getX(), me.getY(), v);
            if (System.currentTimeMillis() - this._last_time > 10L) {
                this._last_time = System.currentTimeMillis();
                this.seg.translate(v._x - this._last_x, v._y - this._last_y, v._z - this._last_z);
                this._last_x = v._x;
                this._last_y = v._y;
                this._last_z = v._z;
            }
        }
        this.v2d.update_magnifier_position();
        this.v2d.repaint();
    }

    @Override
    public void willBegin() {
        this.v2d.updateCursor(this, Cursor.getPredefinedCursor(1), null, 0, 0);
    }

    @Override
    public void didEnd() {
        this.v2d.updateCursor(this, Cursor.getPredefinedCursor(1), null, 0, 0);
    }

    @Override
    public boolean needsKeyboard() {
        return true;
    }

    @Override
    public boolean needsMouse() {
        return true;
    }

    @Override
    public boolean needsMouseMotion() {
        return true;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 87: {
                if (e.isShiftDown()) {
                    this.pc.translate(PlacementController.Direction.UP, 1);
                    break;
                }
                this.pc.translate(PlacementController.Direction.UP);
                break;
            }
            case 65: {
                if (e.isShiftDown()) {
                    this.pc.translate(PlacementController.Direction.LEFT, 1);
                    break;
                }
                this.pc.translate(PlacementController.Direction.LEFT);
                break;
            }
            case 83: {
                if (e.isShiftDown()) {
                    this.pc.translate(PlacementController.Direction.DOWN, 1);
                    break;
                }
                this.pc.translate(PlacementController.Direction.DOWN);
                break;
            }
            case 68: {
                if (e.isShiftDown()) {
                    this.pc.translate(PlacementController.Direction.RIGHT, 1);
                    break;
                }
                this.pc.translate(PlacementController.Direction.RIGHT);
                break;
            }
            case 81: {
                if (e.isShiftDown()) {
                    this.pc.rotate(0, 1.0);
                    break;
                }
                this.pc.rotate(0);
                break;
            }
            case 69: {
                if (e.isShiftDown()) {
                    this.pc.rotate(1, 1.0);
                    break;
                }
                this.pc.rotate(1);
                break;
            }
            case 82: {
                if (e.isShiftDown()) {
                    this.pc.resize(1, 1.0);
                    break;
                }
                this.pc.resize(1);
                break;
            }
            case 70: {
                if (e.isShiftDown()) {
                    this.pc.resize(0, 1.0);
                    break;
                }
                this.pc.resize(0);
            }
        }
    }
}

