/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.surface.userdata;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import main.ImageStack;
import main.MasterControl;
import main.seggen.dm.surface.DMSurface;
import main.seggen.dm.surface.IUserDataHandler;
import main.seggen.dm.surface.Label;
import main.seggen.dm.surface.userdata.FixedData;
import main.seggen.dm.surface.userdata.FixedParameter;
import misc.linkedsurface.LinkedTriaSurface;

public class FixedDataHandler
implements IUserDataHandler {
    public static final String FixedDataLabelName = "internal.fixed";
    private double min_movement;
    private int min_movement_steps;
    private int min_movement_start_after_step;
    private boolean fix_outside;
    private Label<LinkedTriaSurface.LinkedVert> vert_label;
    private Label<LinkedTriaSurface.LinkedEdge> edge_label;
    private Label<LinkedTriaSurface.LinkedTria> tria_label;
    private double dim_x_scaled;
    private double dim_y_scaled;
    private double dim_z_scaled;

    public FixedDataHandler(FixedParameter fp) {
        this.min_movement = fp.min_movement;
        this.min_movement_steps = fp.min_movement_steps;
        this.min_movement_start_after_step = fp.min_movement_start_after_step;
        this.fix_outside = fp.fix_outside;
    }

    public FixedDataHandler(double min_movement, int min_movement_steps, int min_movement_start_after_step) {
        this.min_movement = min_movement;
        this.min_movement_steps = min_movement_steps;
        this.min_movement_start_after_step = min_movement_start_after_step;
        this.fix_outside = false;
    }

    public FixedDataHandler(double min_movement, int min_movement_steps, int min_movement_start_after_step, boolean fix_outside) {
        this.min_movement = min_movement;
        this.min_movement_steps = min_movement_steps;
        this.min_movement_start_after_step = min_movement_start_after_step;
        this.fix_outside = fix_outside;
    }

    @Override
    public void didInit(DMSurface cs) {
        ImageStack is = MasterControl.get_is();
        int dim_x = Math.max(is.get_dim_x() - 1, 0);
        int dim_y = Math.max(is.get_dim_y() - 1, 0);
        int dim_z = Math.max(is.get_dim_z() - 1, 0);
        double scale_x = is.get_x_spacing();
        double scale_y = is.get_y_spacing();
        double scale_z = is.get_z_spacing();
        this.dim_x_scaled = (double)dim_x * scale_x;
        this.dim_y_scaled = (double)dim_y * scale_y;
        this.dim_z_scaled = (double)dim_z * scale_z;
        if (cs._vert_labels.get(FixedDataLabelName) == null) {
            this.vert_label = new Label(FixedDataLabelName, "#ff0000");
            cs._vert_labels.put(FixedDataLabelName, this.vert_label);
        } else {
            this.vert_label = cs._vert_labels.get(FixedDataLabelName);
        }
        if (cs._edge_labels.get(FixedDataLabelName) == null) {
            this.edge_label = new Label(FixedDataLabelName, "#ff0000");
            cs._edge_labels.put(FixedDataLabelName, this.edge_label);
        } else {
            this.edge_label = cs._edge_labels.get(FixedDataLabelName);
        }
        if (cs._tria_labels.get(FixedDataLabelName) == null) {
            this.tria_label = new Label(FixedDataLabelName, "#ff0000");
            cs._tria_labels.put(FixedDataLabelName, this.tria_label);
        } else {
            this.tria_label = cs._tria_labels.get(FixedDataLabelName);
        }
        for (LinkedTriaSurface.LinkedVert lv : cs._vlist) {
            lv.set_user_data(FixedData._DATA_ID, new FixedData(this.min_movement_steps));
        }
    }

    @Override
    public void willBeginTransformation(DMSurface cs, String adjuster, Object data) {
    }

    @Override
    public void didEndTransformation(DMSurface cs, String adjuster, Object data) {
    }

    @Override
    public void willDeleteVert(DMSurface cs, LinkedTriaSurface.LinkedVert lv) {
        if (cs._vert_labels.get(FixedDataLabelName).contains(lv)) {
            cs._vert_labels.get(FixedDataLabelName).del_element(lv);
        }
    }

    @Override
    public void willDeleteEdge(DMSurface cs, LinkedTriaSurface.LinkedEdge le) {
        if (cs._edge_labels.get(FixedDataLabelName).contains(le)) {
            cs._edge_labels.get(FixedDataLabelName).del_element(le);
        }
    }

    @Override
    public void willDeleteTria(DMSurface cs, LinkedTriaSurface.LinkedTria lt) {
        if (cs._tria_labels.get(FixedDataLabelName).contains(lt)) {
            cs._tria_labels.get(FixedDataLabelName).del_element(lt);
        }
    }

    @Override
    public void didAddVert(DMSurface cs, LinkedTriaSurface.LinkedVert lv) {
        lv.set_user_data(FixedData._DATA_ID, new FixedData(this.min_movement_steps));
    }

    @Override
    public void didAddEdge(DMSurface cs, LinkedTriaSurface.LinkedEdge le) {
    }

    @Override
    public void didAddTria(DMSurface cs, LinkedTriaSurface.LinkedTria lt) {
    }

    @Override
    public void didChangeVert(int step, DMSurface cs, LinkedTriaSurface.LinkedVert lv, Vector3d force) {
        ((FixedData)lv.get_user_data(FixedData._DATA_ID)).addForce(lv._p);
        boolean fixed = false;
        if (step > this.min_movement_start_after_step) {
            fixed = ((FixedData)lv.get_user_data(FixedData._DATA_ID)).evaluateHistory(this.min_movement);
        }
        if (this.fix_outside && !fixed && this.correct_outside(lv)) {
            fixed = true;
        }
        if (fixed) {
            cs._vert_labels.get(FixedDataLabelName).add_element(lv);
            for (LinkedTriaSurface.LinkedEdge le : lv._ep) {
                if (!cs._vert_labels.get(FixedDataLabelName).contains(le._a) || !cs._vert_labels.get(FixedDataLabelName).contains(le._b)) continue;
                cs._edge_labels.get(FixedDataLabelName).add_element(le);
            }
            for (LinkedTriaSurface.LinkedTria lt : lv._fp) {
                if (!cs._vert_labels.get(FixedDataLabelName).contains(lt._a) || !cs._vert_labels.get(FixedDataLabelName).contains(lt._b) || !cs._vert_labels.get(FixedDataLabelName).contains(lt._c)) continue;
                cs._tria_labels.get(FixedDataLabelName).add_element(lt);
            }
        }
    }

    private boolean correct_outside(LinkedTriaSurface.LinkedVert lv) {
        boolean outside = false;
        Point3d p = new Point3d(lv._p.x, lv._p.y, lv._p.z);
        if (p.x < 0.0) {
            outside = true;
            p.x = 0.0;
        }
        if (p.y < 0.0) {
            outside = true;
            p.y = 0.0;
        }
        if (p.z < 0.0) {
            outside = true;
            p.z = 0.0;
        }
        if (p.x > this.dim_x_scaled) {
            outside = true;
            p.x = this.dim_x_scaled;
        }
        if (p.y > this.dim_y_scaled) {
            outside = true;
            p.y = this.dim_y_scaled;
        }
        if (p.z > this.dim_z_scaled) {
            outside = true;
            p.z = this.dim_z_scaled;
        }
        if (outside) {
            lv.set_point(p);
        }
        return outside;
    }

    public void fixVert(DMSurface cs, LinkedTriaSurface.LinkedVert lv) {
        if (cs._vert_labels.get(FixedDataLabelName).contains(lv)) {
            return;
        }
        cs._vert_labels.get(FixedDataLabelName).add_element(lv);
        for (LinkedTriaSurface.LinkedEdge le : lv._ep) {
            if (!cs._vert_labels.get(FixedDataLabelName).contains(le._a) || !cs._vert_labels.get(FixedDataLabelName).contains(le._b)) continue;
            cs._edge_labels.get(FixedDataLabelName).add_element(le);
        }
        for (LinkedTriaSurface.LinkedTria lt : lv._fp) {
            if (!cs._vert_labels.get(FixedDataLabelName).contains(lt._a) || !cs._vert_labels.get(FixedDataLabelName).contains(lt._b) || !cs._vert_labels.get(FixedDataLabelName).contains(lt._c)) continue;
            cs._tria_labels.get(FixedDataLabelName).add_element(lt);
        }
    }
}

