/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.surface.userdata;

import java.util.HashMap;
import java.util.LinkedList;
import javax.vecmath.Vector3d;
import main.seggen.dm.surface.DMSurface;
import main.seggen.dm.surface.IUserDataHandler;
import misc.linkedsurface.IndexData;
import misc.linkedsurface.LinkedTriaSurface;

public class IndexDataHandler
implements IUserDataHandler {
    private HashMap<DMSurface, LinkedList<Integer>> free_indices = new HashMap();
    private HashMap<DMSurface, Integer> max_index = new HashMap();
    private static IndexDataHandler _instance;

    public static IndexDataHandler getInstance() {
        if (_instance == null) {
            _instance = new IndexDataHandler();
        }
        return _instance;
    }

    private IndexDataHandler() {
    }

    @Override
    public void didInit(DMSurface cs) {
        if (this.free_indices.containsKey(cs)) {
            this.free_indices.remove(cs);
        }
        if (this.max_index.containsKey(cs)) {
            this.max_index.remove(cs);
        }
        this.free_indices.put(cs, new LinkedList());
        int i = 0;
        while (i < cs._vlist.size()) {
            LinkedTriaSurface.LinkedVert lv = (LinkedTriaSurface.LinkedVert)cs._vlist.get(i);
            lv.set_user_data(IndexData._DATA_ID, new IndexData(i));
            ++i;
        }
        this.max_index.put(cs, cs._vlist.size() - 1);
    }

    @Override
    public void willBeginTransformation(DMSurface cs, String adjuster, Object data) {
    }

    @Override
    public void didEndTransformation(DMSurface cs, String adjuster, Object data) {
    }

    @Override
    public void willDeleteVert(DMSurface cs, LinkedTriaSurface.LinkedVert lv) {
        if (this.free_indices.containsKey(cs)) {
            if (((IndexData)lv.get_user_data((int)IndexData._DATA_ID))._i == this.max_index.get(cs)) {
                this.max_index.put(cs, ((IndexData)lv.get_user_data((int)IndexData._DATA_ID))._i - 1);
            } else {
                this.free_indices.get(cs).add(((IndexData)lv.get_user_data((int)IndexData._DATA_ID))._i);
            }
        } else {
            System.err.println("unkown surface in indexhandler");
        }
    }

    @Override
    public void willDeleteEdge(DMSurface cs, LinkedTriaSurface.LinkedEdge le) {
    }

    @Override
    public void willDeleteTria(DMSurface cs, LinkedTriaSurface.LinkedTria lt) {
    }

    @Override
    public void didAddVert(DMSurface cs, LinkedTriaSurface.LinkedVert lv) {
        if (this.max_index.containsKey(cs)) {
            if (this.free_indices.get(cs).size() > 0) {
                int idx = this.free_indices.get(cs).removeFirst();
                lv.set_user_data(IndexData._DATA_ID, new IndexData(idx));
            } else {
                int max_idx = this.max_index.get(cs);
                lv.set_user_data(IndexData._DATA_ID, new IndexData(max_idx + 1));
                this.max_index.put(cs, max_idx + 1);
            }
        } else {
            System.err.println("unkown surface in indexhandler");
        }
    }

    @Override
    public void didAddEdge(DMSurface cs, LinkedTriaSurface.LinkedEdge le) {
    }

    @Override
    public void didAddTria(DMSurface cs, LinkedTriaSurface.LinkedTria lt) {
    }

    @Override
    public void didChangeVert(int step, DMSurface cs, LinkedTriaSurface.LinkedVert lv, Vector3d force) {
    }

    public int getMaxIndex(DMSurface cs) {
        if (this.max_index.containsKey(cs)) {
            return this.max_index.get(cs);
        }
        return 0;
    }
}

