/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.surface.userdata;

import java.util.LinkedList;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import main.seggen.dm.surface.DMSurface;
import main.seggen.dm.surface.IUserDataHandler;
import main.seggen.dm.surface.userdata.NormalData;
import misc.linkedsurface.LinkedTriaSurface;

public class NormalDataHandler
implements IUserDataHandler {
    private LinkedList<LinkedTriaSurface.LinkedTria> added_trias = new LinkedList();
    private LinkedList<LinkedTriaSurface.LinkedVert> added_verts;
    private LinkedList<LinkedTriaSurface.LinkedEdge> added_edges = new LinkedList();

    public NormalDataHandler() {
        this.added_verts = new LinkedList();
    }

    @Override
    public void didInit(DMSurface cs) {
        for (LinkedTriaSurface.LinkedVert lv : cs._vlist) {
            lv.set_user_data(NormalData._DATA_ID, new NormalData());
        }
        for (LinkedTriaSurface.LinkedTria lt : cs._flist) {
            lt.set_user_data(NormalData._DATA_ID, new NormalData());
        }
        for (LinkedTriaSurface.LinkedEdge le : cs._elist) {
            le.set_user_data(NormalData._DATA_ID, new NormalData());
        }
        cs.calc_normals();
    }

    @Override
    public void willDeleteVert(DMSurface cs, LinkedTriaSurface.LinkedVert lv) {
    }

    @Override
    public void willDeleteEdge(DMSurface cs, LinkedTriaSurface.LinkedEdge le) {
    }

    @Override
    public void willDeleteTria(DMSurface cs, LinkedTriaSurface.LinkedTria lt) {
    }

    @Override
    public void didAddVert(DMSurface cs, LinkedTriaSurface.LinkedVert lv) {
        lv.set_user_data(NormalData._DATA_ID, new NormalData());
        this.added_verts.add(lv);
    }

    @Override
    public void didAddEdge(DMSurface cs, LinkedTriaSurface.LinkedEdge le) {
        le.set_user_data(NormalData._DATA_ID, new NormalData());
        this.added_edges.add(le);
    }

    @Override
    public void didAddTria(DMSurface cs, LinkedTriaSurface.LinkedTria lt) {
        lt.set_user_data(NormalData._DATA_ID, new NormalData());
        this.added_trias.add(lt);
    }

    @Override
    public void didChangeVert(int step, DMSurface cs, LinkedTriaSurface.LinkedVert lv, Vector3d force) {
    }

    @Override
    public void willBeginTransformation(DMSurface cs, String adjuster, Object data) {
        this.added_verts.clear();
        this.added_edges.clear();
        this.added_trias.clear();
    }

    @Override
    public void didEndTransformation(DMSurface cs, String adjuster, Object data) {
        for (LinkedTriaSurface.LinkedTria lt : this.added_trias) {
            ((NormalData)lt.get_user_data((int)NormalData._DATA_ID)).normal.set((Tuple3d)lt.calc_normal());
            this.added_verts.add(lt._a);
            this.added_verts.add(lt._b);
            this.added_verts.add(lt._c);
        }
        for (LinkedTriaSurface.LinkedVert lv : this.added_verts) {
            ((NormalData)lv.get_user_data((int)NormalData._DATA_ID)).normal = new Vector3d();
            for (LinkedTriaSurface.LinkedTria lt : lv._fp) {
                ((NormalData)lv.get_user_data((int)NormalData._DATA_ID)).normal.add((Tuple3d)((NormalData)lt.get_user_data((int)NormalData._DATA_ID)).normal);
            }
            this.added_edges.addAll(lv._ep);
            ((NormalData)lv.get_user_data((int)NormalData._DATA_ID)).normal.normalize();
        }
        for (LinkedTriaSurface.LinkedEdge le : this.added_edges) {
            ((NormalData)le.get_user_data((int)NormalData._DATA_ID)).normal = new Vector3d();
            ((NormalData)le.get_user_data((int)NormalData._DATA_ID)).normal.add((Tuple3d)((NormalData)le._a.get_user_data((int)NormalData._DATA_ID)).normal);
            ((NormalData)le.get_user_data((int)NormalData._DATA_ID)).normal.add((Tuple3d)((NormalData)le._b.get_user_data((int)NormalData._DATA_ID)).normal);
            ((NormalData)le.get_user_data((int)NormalData._DATA_ID)).normal.normalize();
        }
    }
}

