/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.dm.surface.userdata;

public class RingBuffer<E> {
    private E[] a;
    private int N = 0;
    private int first = 0;
    private int last = 0;

    public RingBuffer(int capacity) {
        this.a = new Object[capacity];
    }

    public boolean isEmpty() {
        return this.N == 0;
    }

    public int size() {
        return this.N;
    }

    public void enqueue(E item) {
        this.a[this.last] = item;
        this.last = (this.last + 1) % this.a.length;
        ++this.N;
        if (this.N > this.a.length) {
            this.N = this.a.length;
            this.first = (this.first + 1) % this.a.length;
        }
    }

    public E getFirst() {
        if (this.a.length == 0) {
            return null;
        }
        return this.a[this.first];
    }

    public E getLast() {
        if (this.a.length <= 1) {
            return null;
        }
        int lastIdx = this.last - 1;
        while (lastIdx < 0) {
            lastIdx += this.a.length;
        }
        return this.a[lastIdx %= this.a.length];
    }
}

