/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.levelset;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import misc.Voxel;
import misc.VoxelQueue;
import misc.grid.BitCube;
import misc.grid.BitMask;

public final class DistanceFunction {
    private double[] _phi;
    private double[] _speed;
    private int _x_size;
    private int _y_size;
    private int _z_size;
    private int _dx;
    private int _dy;
    private int _dz;
    private double _x_spacing;
    private double _y_spacing;
    private double _z_spacing;
    private boolean _is_3d = false;
    private int[] _bb_min;
    private int[] _bb_max;
    private int _index_2d;

    private void init_bb_arrays(int[] bb_min, int[] bb_max) {
        this._bb_min = new int[3];
        this._bb_max = new int[3];
        int i = 0;
        while (i < 3) {
            this._bb_min[i] = bb_min[i];
            this._bb_max[i] = bb_max[i];
            ++i;
        }
    }

    private void init(LinkedList<Voxel> seeds, int radius, int x_size, int y_size, int z_size, double x_spacing, double y_spacing, double z_spacing, int[] bb_min, int[] bb_max, boolean is_3d) {
        this._is_3d = is_3d;
        this._x_size = x_size;
        this._y_size = y_size;
        this._z_size = z_size;
        if (!is_3d) {
            this._index_2d = seeds.getFirst()._z;
        }
        this._dx = 1;
        this._dy = this._x_size;
        this._dz = this._x_size * this._y_size;
        this._phi = new double[this._dz * this._z_size];
        this._speed = new double[this._dz * this._z_size];
        this._is_3d = is_3d;
        this._x_spacing = x_spacing;
        this._y_spacing = y_spacing;
        this._z_spacing = z_spacing;
        this.init_bb_arrays(bb_min, bb_max);
        this.generate_distances(seeds, radius);
    }

    private void init(BitCube bc, int image_number, int x_size, int y_size, int z_size, double x_spacing, double y_spacing, double z_spacing, int[] bb_min, int[] bb_max, boolean is_3d) {
        this._is_3d = is_3d;
        this._x_size = x_size;
        this._y_size = y_size;
        this._z_size = z_size;
        this._dx = 1;
        this._dy = this._x_size;
        this._dz = this._x_size * this._y_size;
        this._phi = new double[this._dz * this._z_size];
        this._speed = new double[this._dz * this._z_size];
        this._x_spacing = x_spacing;
        this._y_spacing = y_spacing;
        this._z_spacing = z_spacing;
        this.init_bb_arrays(bb_min, bb_max);
        if (is_3d) {
            int x;
            int y;
            int z = this._bb_min[2];
            while (z <= this._bb_max[2]) {
                y = this._bb_min[1];
                while (y <= this._bb_max[1]) {
                    x = this._bb_min[0];
                    while (x <= this._bb_max[0]) {
                        if (bc.getXYZ(x, y, z)) {
                            this.set_dist(x, y, z, -1.0);
                        } else {
                            this.set_dist(x, y, z, 1.0);
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            z = this._bb_min[2];
            while (z <= this._bb_max[2]) {
                y = this._bb_min[1];
                while (y <= this._bb_max[1]) {
                    x = this._bb_min[0];
                    while (x <= this._bb_max[0]) {
                        if (this.is_front3d(x, y, z)) {
                            this.set_dist(x, y, z, 0.0);
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        } else {
            int x;
            this._index_2d = image_number;
            int y = this._bb_min[1];
            while (y <= this._bb_max[1]) {
                x = this._bb_min[0];
                while (x <= this._bb_max[0]) {
                    if (bc.getXYZ(x, y, image_number)) {
                        this.set_dist(x, y, 0, -1.0);
                    } else {
                        this.set_dist(x, y, 0, 1.0);
                    }
                    ++x;
                }
                ++y;
            }
            y = this._bb_min[1];
            while (y <= this._bb_max[1]) {
                x = this._bb_min[0];
                while (x <= this._bb_max[0]) {
                    if (this.is_front2d(x, y)) {
                        this.set_dist(x, y, 0, 0.0);
                    }
                    ++x;
                }
                ++y;
            }
        }
    }

    public DistanceFunction(LinkedList<Voxel> seeds, int radius, int x_size, int y_size, int z_size, double x_spacing, double y_spacing, double z_spacing, int[] bb_min, int[] bb_max, boolean is_3d) {
        this.init(seeds, radius, x_size, y_size, z_size, x_spacing, y_spacing, z_spacing, bb_min, bb_max, is_3d);
    }

    public DistanceFunction(BitCube bc, int image_number, int x_size, int y_size, int z_size, double x_spacing, double y_spacing, double z_spacing, int[] bb_min, int[] bb_max, boolean is_3d) {
        this.init(bc, image_number, x_size, y_size, z_size, x_spacing, y_spacing, z_spacing, bb_min, bb_max, is_3d);
    }

    public void reinitialize_distance_function(LinkedList<Voxel> seeds, int radius, int x_size, int y_size, int z_size, double x_spacing, double y_spacing, double z_spacing, int[] bb_min, int[] bb_max, boolean is_3d) {
        this.init(seeds, radius, x_size, y_size, z_size, x_spacing, y_spacing, z_spacing, bb_min, bb_max, is_3d);
    }

    public void reinitialize_distance_function(BitCube bc, int image_number, int x_size, int y_size, int z_size, double x_spacing, double y_spacing, double z_spacing, int[] bb_min, int[] bb_max, boolean is_3d) {
        this.init(bc, image_number, x_size, y_size, z_size, x_spacing, y_spacing, z_spacing, bb_min, bb_max, is_3d);
    }

    public void generate_distances(LinkedList<Voxel> seeds, int radius) {
        double dist = 2.147483647E9;
        if (this.is_3d()) {
            int z = this._bb_min[2];
            while (z <= this._bb_max[2]) {
                int y = this._bb_min[1];
                while (y <= this._bb_max[1]) {
                    int x = this._bb_min[0];
                    while (x <= this._bb_max[0]) {
                        this.set_dist(x, y, z, dist);
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            for (Voxel seed : seeds) {
                int z2 = this._bb_min[2];
                while (z2 <= this._bb_max[2]) {
                    double zz = (double)((z2 - seed._z) * (z2 - seed._z)) * (this._z_spacing * this._z_spacing);
                    int y = this._bb_min[1];
                    while (y <= this._bb_max[1]) {
                        double yy = (double)((y - seed._y) * (y - seed._y)) * (this._y_spacing * this._y_spacing);
                        int x = this._bb_min[0];
                        while (x <= this._bb_max[0]) {
                            double xx = (double)((x - seed._x) * (x - seed._x)) * (this._x_spacing * this._x_spacing);
                            if (this.get_dist(x, y, z2) > Math.sqrt(xx + yy + zz) - (double)radius) {
                                dist = Math.sqrt(xx + yy + zz) - (double)radius;
                                this.set_dist(x, y, z2, dist);
                            }
                            ++x;
                        }
                        ++y;
                    }
                    ++z2;
                }
            }
        } else {
            int y = this._bb_min[1];
            while (y <= this._bb_max[1]) {
                int x = this._bb_min[0];
                while (x <= this._bb_max[0]) {
                    this.set_dist(x, y, 0, dist);
                    ++x;
                }
                ++y;
            }
            for (Voxel seed : seeds) {
                int y2 = this._bb_min[1];
                while (y2 <= this._bb_max[1]) {
                    double yy = (double)((y2 - seed._y) * (y2 - seed._y)) * (this._y_spacing * this._y_spacing);
                    int x = this._bb_min[0];
                    while (x <= this._bb_max[0]) {
                        double xx = (double)((x - seed._x) * (x - seed._x)) * (this._x_spacing * this._x_spacing);
                        if (this.get_dist(x, y2, 0) > Math.sqrt(xx + yy) - (double)radius) {
                            dist = Math.sqrt(xx + yy) - (double)radius;
                            this.set_dist(x, y2, 0, dist);
                        }
                        ++x;
                    }
                    ++y2;
                }
            }
        }
    }

    public boolean is_front3d(int x, int y, int z) {
        int pos = x + y * this._dy + z * this._dz;
        return this._phi[pos] == 0.0 || this._phi[pos] < 0.0 && (x == this._bb_min[0] || y == this._bb_min[1] || z == this._bb_min[2] || x == this._bb_max[0] || y == this._bb_max[1] || z == this._bb_max[2]) || this._phi[pos] < 0.0 && (this._phi[pos + this._dx] > 0.0 || this._phi[pos + this._dy] > 0.0 || this._phi[pos + this._dz] > 0.0 || this._phi[pos - this._dx] > 0.0 || this._phi[pos - this._dy] > 0.0 || this._phi[pos - this._dz] > 0.0 || this._phi[pos + this._dx + this._dy] > 0.0 || this._phi[pos + this._dx - this._dy] > 0.0 || this._phi[pos + this._dx + this._dz] > 0.0 || this._phi[pos + this._dx - this._dz] > 0.0 || this._phi[pos - this._dx + this._dy] > 0.0 || this._phi[pos - this._dx - this._dy] > 0.0 || this._phi[pos - this._dx + this._dz] > 0.0 || this._phi[pos - this._dx - this._dz] > 0.0 || this._phi[pos + this._dy + this._dz] > 0.0 || this._phi[pos - this._dy + this._dz] > 0.0 || this._phi[pos + this._dy - this._dz] > 0.0 || this._phi[pos - this._dy - this._dz] > 0.0 || this._phi[pos + this._dx + this._dy + this._dz] > 0.0 || this._phi[pos + this._dx + this._dy - this._dz] > 0.0 || this._phi[pos + this._dx - this._dy + this._dz] > 0.0 || this._phi[pos + this._dx - this._dy - this._dz] > 0.0 || this._phi[pos - this._dx + this._dy + this._dz] > 0.0 || this._phi[pos - this._dx + this._dy - this._dz] > 0.0 || this._phi[pos - this._dx - this._dy + this._dz] > 0.0 || this._phi[pos - this._dx - this._dy - this._dz] > 0.0);
    }

    public boolean is_front2d(int x, int y) {
        int pos = x + y * this._dy;
        return this._phi[pos] == 0.0 || this._phi[pos] < 0.0 && (x == this._bb_min[0] || y == this._bb_min[1] || x == this._bb_max[0] || y == this._bb_max[1]) || this._phi[pos] < 0.0 && (this._phi[pos + this._dx] > 0.0 || this._phi[pos + this._dy] > 0.0 || this._phi[pos - this._dx] > 0.0 || this._phi[pos - this._dy] > 0.0 || this._phi[pos + this._dx + this._dy] > 0.0 || this._phi[pos + this._dx - this._dy] > 0.0 || this._phi[pos - this._dx + this._dy] > 0.0 || this._phi[pos - this._dx - this._dy] > 0.0);
    }

    public double get_dist(int x, int y, int z) {
        return this._phi[this._dz * z + y * this._dy + x];
    }

    public void set_dist(int x, int y, int z, double value) {
        this._phi[this._dz * z + y * this._dy + x] = value;
    }

    public double[] get_dist() {
        return this._phi;
    }

    public double get_speed(int x, int y, int z) {
        return this._speed[this._dz * z + y * this._dy + x];
    }

    public void set_speed(int x, int y, int z, double value) {
        this._speed[this._dz * z + y * this._dy + x] = value;
    }

    public double[] get_speed() {
        return this._speed;
    }

    public double compute_curvature3d(int x, int y, int z) {
        if (x + 2 <= this._bb_max[0] && y + 2 <= this._bb_max[1] && z + 2 <= this._bb_max[2] & x > this._bb_min[0] + 1 && y > this._bb_min[0] + 1 && z > this._bb_min[0] + 1) {
            int pos = x + y * this._dy + z * this._dz;
            double phi_x = (this._phi[pos + this._dx] - this._phi[pos - this._dx]) * 0.5;
            double phi_y = (this._phi[pos + this._dy] - this._phi[pos - this._dy]) * 0.5;
            double phi_z = (this._phi[pos + this._dz] - this._phi[pos - this._dz]) * 0.5;
            double phi_xx = (this._phi[pos + this._dx + this._dx] - this._phi[pos - this._dx - this._dx] - 2.0 * this._phi[pos]) * 0.25;
            double phi_yy = (this._phi[pos + this._dy + this._dy] - this._phi[pos - this._dy - this._dy] - 2.0 * this._phi[pos]) * 0.25;
            double phi_zz = (this._phi[pos + this._dz + this._dz] - this._phi[pos - this._dz - this._dz] - 2.0 * this._phi[pos]) * 0.25;
            double phi_xy = (this._phi[pos + this._dx + this._dy] - this._phi[pos + this._dx - this._dy] - this._phi[pos - this._dx + this._dy] + this._phi[pos - this._dx - this._dy]) * 0.25;
            double phi_xz = (this._phi[pos + this._dx + this._dz] - this._phi[pos + this._dx - this._dz] - this._phi[pos - this._dx + this._dz] + this._phi[pos - this._dx - this._dz]) * 0.25;
            double phi_yz = (this._phi[pos + this._dy + this._dz] - this._phi[pos + this._dy - this._dz] - this._phi[pos - this._dy + this._dz] + this._phi[pos - this._dy - this._dz]) * 0.25;
            double k_top = phi_xx * (phi_y * phi_y + phi_z * phi_z) + phi_yy * (phi_x * phi_x + phi_z * phi_z) + phi_zz * (phi_x * phi_x + phi_y * phi_y) - 2.0 * (phi_x * phi_y * phi_xy + phi_x * phi_z * phi_xz + phi_y * phi_z * phi_yz);
            double k_bot = Math.sqrt((phi_x * phi_x + phi_y * phi_y + phi_z * phi_z) * (phi_x * phi_x + phi_y * phi_y + phi_z * phi_z) * (phi_x * phi_x + phi_y * phi_y + phi_z * phi_z));
            return k_bot == 0.0 ? 0.0 : k_top / k_bot;
        }
        return 0.0;
    }

    public double compute_curvature2d(int x, int y) {
        if (x + 2 <= this._bb_max[0] && y + 2 <= this._bb_max[1] && x > this._bb_min[0] + 1 && y > this._bb_min[0] + 1) {
            int pos = x + y * this._dy;
            double phi_x = (this._phi[pos + this._dx] - this._phi[pos - this._dx]) * 0.5;
            double phi_y = (this._phi[pos + this._dy] - this._phi[pos - this._dy]) * 0.5;
            double phi_xx = (this._phi[pos + this._dx + this._dx] - this._phi[pos - this._dx - this._dx] - 2.0 * this._phi[pos]) * 0.25;
            double phi_yy = (this._phi[pos + this._dy + this._dy] - this._phi[pos - this._dy - this._dy] - 2.0 * this._phi[pos]) * 0.25;
            double phi_xy = (this._phi[pos + this._dx + this._dy] - this._phi[pos + this._dx - this._dy] - this._phi[pos - this._dx + this._dy] + this._phi[pos - this._dx - this._dy]) * 0.25;
            double k_top = phi_xx * phi_y * phi_y + phi_yy * phi_x * phi_x - 2.0 * (phi_x * phi_y * phi_xy);
            double k_bot_tmp = (phi_x * phi_x + phi_y * phi_y) * (phi_x * phi_x + phi_y * phi_y) * (phi_x * phi_x + phi_y * phi_y);
            double k_bot = Math.sqrt(k_bot_tmp);
            return k_bot == 0.0 ? 0.0 : k_top / k_bot;
        }
        return 0.0;
    }

    public double compute_speed3d(int x, int y, int z, double eps, double edgestop) {
        int pos = x + y * this._dy + z * this._dz;
        if (x + 1 <= this._bb_max[0] && y + 1 <= this._bb_max[1] && z + 1 <= this._bb_max[2] && x > this._bb_min[0] && y > this._bb_min[1] && z > this._bb_min[2]) {
            double mx_max = Math.max(this._phi[pos] - this._phi[pos - this._dx], 0.0);
            double mx_min = Math.min(this._phi[pos + this._dx] - this._phi[pos], 0.0);
            double my_max = Math.max(this._phi[pos] - this._phi[pos - this._dy], 0.0);
            double my_min = Math.min(this._phi[pos + this._dy] - this._phi[pos], 0.0);
            double mz_max = Math.max(this._phi[pos] - this._phi[pos - this._dz], 0.0);
            double mz_min = Math.min(this._phi[pos + this._dz] - this._phi[pos], 0.0);
            double mx = this._phi[pos + this._dx] - this._phi[pos - this._dx];
            double my = this._phi[pos + this._dy] - this._phi[pos - this._dy];
            double mz = this._phi[pos + this._dz] - this._phi[pos - this._dz];
            double F_a = Math.sqrt(mx_max * mx_max + mx_min * mx_min + my_max * my_max + my_min * my_min + mz_max * mz_max + mz_min * mz_min);
            double F_g = -eps * this.compute_curvature3d(x, y, z) * Math.sqrt((mx * mx + my * my + mz * mz) * 0.5);
            return edgestop * (F_a + F_g);
        }
        return 0.0;
    }

    public double compute_speed2d(int x, int y, double eps, double edgestop) {
        int pos = x + y * this._dy;
        if (x + 1 <= this._bb_max[0] && y + 1 <= this._bb_max[1] && x > this._bb_min[0] && y > this._bb_min[1]) {
            double mx_max = Math.max(this._phi[pos] - this._phi[pos - this._dx], 0.0);
            double mx_min = Math.min(this._phi[pos + this._dx] - this._phi[pos], 0.0);
            double my_max = Math.max(this._phi[pos] - this._phi[pos - this._dy], 0.0);
            double my_min = Math.min(this._phi[pos + this._dy] - this._phi[pos], 0.0);
            double mx = this._phi[pos + this._dx] - this._phi[pos - this._dx];
            double my = this._phi[pos + this._dy] - this._phi[pos - this._dy];
            double F_a = Math.sqrt(mx_max * mx_max + mx_min * mx_min + my_max * my_max + my_min * my_min);
            double F_g = -eps * this.compute_curvature2d(x, y) * Math.sqrt((mx * mx + my * my) * 0.5);
            return edgestop * (F_a + F_g);
        }
        return 0.0;
    }

    public boolean is_3d() {
        return this._is_3d;
    }

    public double[] compute_min_max_dist() {
        double[] dist = new double[2];
        double max_dist = -2.147483648E9;
        double min_dist = 2.147483647E9;
        if (this._is_3d) {
            int z = this._bb_min[2];
            while (z <= this._bb_max[2]) {
                int y = this._bb_min[1];
                while (y <= this._bb_max[1]) {
                    int pos = z * this._dz + y * this._dy + this._bb_min[0];
                    int x = this._bb_min[0];
                    while (x <= this._bb_max[0]) {
                        if (this._phi[pos] > max_dist) {
                            max_dist = this._phi[pos];
                        }
                        if (this._phi[pos] < min_dist) {
                            min_dist = this._phi[pos];
                        }
                        ++pos;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        } else {
            int y = this._bb_min[1];
            while (y <= this._bb_max[1]) {
                int pos = y * this._dy + this._bb_min[0];
                int x = this._bb_min[0];
                while (x <= this._bb_max[0]) {
                    if (this._phi[pos] > max_dist) {
                        max_dist = this._phi[pos];
                    }
                    if (this._phi[pos] < min_dist) {
                        min_dist = this._phi[pos];
                    }
                    ++pos;
                    ++x;
                }
                ++y;
            }
        }
        dist[0] = min_dist;
        dist[1] = max_dist;
        return dist;
    }

    public int[] get_min() {
        return this._bb_min;
    }

    public int[] get_max() {
        return this._bb_max;
    }

    public double[] compute_min_max_speed() {
        double[] dist = new double[2];
        double max_dist = -2.147483648E9;
        double min_dist = 2.147483647E9;
        int i = 0;
        while (i < this._speed.length) {
            if (this._speed[i] > max_dist) {
                max_dist = this._speed[i];
            }
            if (this._speed[i] < min_dist) {
                min_dist = this._speed[i];
            }
            ++i;
        }
        dist[0] = min_dist;
        dist[1] = max_dist;
        return dist;
    }

    public double[] compute_min_max_speed(ArrayList<Voxel> narrow_band) {
        double[] dist = new double[2];
        double max_dist = -2.147483648E9;
        double min_dist = 2.147483647E9;
        if (this.is_3d()) {
            int i = 0;
            while (i < narrow_band.size()) {
                Voxel v = narrow_band.get(i);
                if (this.get_speed(v._x, v._y, v._z) > max_dist) {
                    max_dist = this.get_speed(v._x, v._y, v._z);
                }
                if (this.get_speed(v._x, v._y, v._z) < min_dist) {
                    min_dist = this.get_speed(v._x, v._y, v._z);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < narrow_band.size()) {
                Voxel v = narrow_band.get(i);
                if (this.get_speed(v._x, v._y, 0) > max_dist) {
                    max_dist = this.get_speed(v._x, v._y, 0);
                }
                if (this.get_speed(v._x, v._y, 0) < min_dist) {
                    min_dist = this.get_speed(v._x, v._y, 0);
                }
                ++i;
            }
        }
        dist[0] = min_dist;
        dist[1] = max_dist;
        return dist;
    }

    public int get_2d_index() {
        return this._index_2d;
    }

    public void reinitialize_distances2d(ArrayList<Voxel> front, boolean use_fast_reinit) {
        if (use_fast_reinit) {
            LinkedList<Voxel> todo = new LinkedList<Voxel>();
            BitMask _gotcha = new BitMask(this._x_size, this._y_size);
            int f = 0;
            while (f < front.size()) {
                Voxel v = front.get(f);
                todo.add(v);
                _gotcha.setXY(v._x, v._y, true);
                this.set_dist(v._x, v._y, v._z, 0.0);
                ++f;
            }
            while (!todo.isEmpty()) {
                Voxel next = (Voxel)todo.poll();
                if (next._x < this._bb_max[0] && !_gotcha.getXY(next._x + 1, next._y)) {
                    if (this.get_dist(next._x + 1, next._y, 0) >= 0.0) {
                        this.set_dist(next._x + 1, next._y, 0, this.get_dist(next._x, next._y, 0) + 1.0 * this._x_spacing);
                    } else {
                        this.set_dist(next._x + 1, next._y, 0, this.get_dist(next._x, next._y, 0) - 1.0 * this._x_spacing);
                    }
                    _gotcha.setXY(next._x + 1, next._y, true);
                    todo.add(new Voxel(next._x + 1, next._y, 0));
                }
                if (next._x > this._bb_min[0] && !_gotcha.getXY(next._x - 1, next._y)) {
                    if (this.get_dist(next._x - 1, next._y, 0) >= 0.0) {
                        this.set_dist(next._x - 1, next._y, 0, this.get_dist(next._x, next._y, 0) + 1.0 * this._x_spacing);
                    } else {
                        this.set_dist(next._x - 1, next._y, 0, this.get_dist(next._x, next._y, 0) - 1.0 * this._x_spacing);
                    }
                    _gotcha.setXY(next._x - 1, next._y, true);
                    todo.add(new Voxel(next._x - 1, next._y, 0));
                }
                if (next._y < this._bb_max[1] && !_gotcha.getXY(next._x, next._y + 1)) {
                    if (this.get_dist(next._x, next._y + 1, 0) >= 0.0) {
                        this.set_dist(next._x, next._y + 1, 0, this.get_dist(next._x, next._y, 0) + 1.0 * this._y_spacing);
                    } else {
                        this.set_dist(next._x, next._y + 1, 0, this.get_dist(next._x, next._y, 0) - 1.0 * this._y_spacing);
                    }
                    _gotcha.setXY(next._x, next._y + 1, true);
                    todo.add(new Voxel(next._x, next._y + 1, 0));
                }
                if (next._y <= this._bb_min[1] || _gotcha.getXY(next._x, next._y - 1)) continue;
                if (this.get_dist(next._x, next._y - 1, 0) >= 0.0) {
                    this.set_dist(next._x, next._y - 1, 0, this.get_dist(next._x, next._y, 0) + 1.0 * this._y_spacing);
                } else {
                    this.set_dist(next._x, next._y - 1, 0, this.get_dist(next._x, next._y, 0) - 1.0 * this._y_spacing);
                }
                _gotcha.setXY(next._x, next._y - 1, true);
                todo.add(new Voxel(next._x, next._y - 1, 0));
            }
        } else {
            BitMask negative = new BitMask(this._x_size, this._y_size);
            int y = this._bb_min[1];
            while (y <= this._bb_max[1]) {
                int x = this._bb_min[0];
                while (x <= this._bb_max[0]) {
                    if (this.get_dist(x, y, 0) < 0.0) {
                        negative.setXY(x, y, true);
                    }
                    this.set_dist(x, y, 0, 2.147483647E9);
                    ++x;
                }
                ++y;
            }
            Iterator<Voxel> fi = front.iterator();
            double xsxs = this._x_spacing * this._x_spacing;
            while (fi.hasNext()) {
                Voxel fv = fi.next();
                int y2 = this._bb_min[1];
                while (y2 <= this._bb_max[1]) {
                    double yy = (double)((y2 - fv._y) * (y2 - fv._y)) * (this._y_spacing * this._y_spacing);
                    int x = this._bb_min[0];
                    while (x <= this._bb_max[0]) {
                        double dist_sqr = yy + (double)((x - fv._x) * (x - fv._x)) * xsxs;
                        if (dist_sqr < this.get_dist(x, y2, 0)) {
                            this.set_dist(x, y2, 0, dist_sqr);
                        }
                        ++x;
                    }
                    ++y2;
                }
            }
            int y3 = this._bb_min[1];
            while (y3 <= this._bb_max[1]) {
                int x = this._bb_min[0];
                while (x <= this._bb_max[0]) {
                    if (negative.getXY(x, y3)) {
                        this.set_dist(x, y3, 0, -Math.sqrt(this.get_dist(x, y3, 0)));
                    } else {
                        this.set_dist(x, y3, 0, Math.sqrt(this.get_dist(x, y3, 0)));
                    }
                    ++x;
                }
                ++y3;
            }
        }
    }

    public void reinitialize_distances3d(ArrayList<Voxel> front, boolean use_fast_reinit) {
        if (use_fast_reinit) {
            VoxelQueue todo = new VoxelQueue(1024);
            BitCube _gotcha = new BitCube(this._x_size, this._y_size, this._z_size);
            int f = 0;
            while (f < front.size()) {
                Voxel v = front.get(f);
                todo.store(v);
                _gotcha.setXYZ(v._x, v._y, v._z, true);
                this.set_dist(v._x, v._y, v._z, 0.0);
                ++f;
            }
            Voxel next = new Voxel();
            while (todo.size() != 0) {
                todo.fetch(next);
                if (next._x < this._bb_max[0] && !_gotcha.getXYZ(next._x + 1, next._y, next._z)) {
                    if (this.get_dist(next._x + 1, next._y, next._z) >= 0.0) {
                        this.set_dist(next._x + 1, next._y, next._z, this.get_dist(next._x, next._y, next._z) + 1.0 * this._x_spacing);
                    } else {
                        this.set_dist(next._x + 1, next._y, next._z, this.get_dist(next._x, next._y, next._z) - 1.0 * this._x_spacing);
                    }
                    _gotcha.setXYZ(next._x + 1, next._y, next._z, true);
                    todo.store(next._x + 1, next._y, next._z);
                }
                if (next._x > this._bb_min[0] && !_gotcha.getXYZ(next._x - 1, next._y, next._z)) {
                    if (this.get_dist(next._x - 1, next._y, next._z) >= 0.0) {
                        this.set_dist(next._x - 1, next._y, next._z, this.get_dist(next._x, next._y, next._z) + 1.0 * this._x_spacing);
                    } else {
                        this.set_dist(next._x - 1, next._y, next._z, this.get_dist(next._x, next._y, next._z) - 1.0 * this._x_spacing);
                    }
                    _gotcha.setXYZ(next._x - 1, next._y, next._z, true);
                    todo.store(next._x - 1, next._y, next._z);
                }
                if (next._y < this._bb_max[1] && !_gotcha.getXYZ(next._x, next._y + 1, next._z)) {
                    if (this.get_dist(next._x, next._y + 1, next._z) >= 0.0) {
                        this.set_dist(next._x, next._y + 1, next._z, this.get_dist(next._x, next._y, next._z) + 1.0 * this._y_spacing);
                    } else {
                        this.set_dist(next._x, next._y + 1, next._z, this.get_dist(next._x, next._y, next._z) - 1.0 * this._y_spacing);
                    }
                    _gotcha.setXYZ(next._x, next._y + 1, next._z, true);
                    todo.store(next._x, next._y + 1, next._z);
                }
                if (next._y > this._bb_min[1] && !_gotcha.getXYZ(next._x, next._y - 1, next._z)) {
                    if (this.get_dist(next._x, next._y - 1, next._z) >= 0.0) {
                        this.set_dist(next._x, next._y - 1, next._z, this.get_dist(next._x, next._y, next._z) + 1.0 * this._y_spacing);
                    } else {
                        this.set_dist(next._x, next._y - 1, next._z, this.get_dist(next._x, next._y, next._z) - 1.0 * this._y_spacing);
                    }
                    _gotcha.setXYZ(next._x, next._y - 1, next._z, true);
                    todo.store(next._x, next._y - 1, next._z);
                }
                if (next._z < this._bb_max[2] && !_gotcha.getXYZ(next._x, next._y, next._z + 1)) {
                    if (this.get_dist(next._x, next._y, next._z + 1) >= 0.0) {
                        this.set_dist(next._x, next._y, next._z + 1, this.get_dist(next._x, next._y, next._z) + 1.0 * this._z_spacing);
                    } else {
                        this.set_dist(next._x, next._y, next._z + 1, this.get_dist(next._x, next._y, next._z) - 1.0 * this._z_spacing);
                    }
                    _gotcha.setXYZ(next._x, next._y, next._z + 1, true);
                    todo.store(next._x, next._y, next._z + 1);
                }
                if (next._z <= this._bb_min[2] || _gotcha.getXYZ(next._x, next._y, next._z - 1)) continue;
                if (this.get_dist(next._x, next._y, next._z - 1) >= 0.0) {
                    this.set_dist(next._x, next._y, next._z - 1, this.get_dist(next._x, next._y, next._z) + 1.0 * this._z_spacing);
                } else {
                    this.set_dist(next._x, next._y, next._z - 1, this.get_dist(next._x, next._y, next._z) - 1.0 * this._z_spacing);
                }
                _gotcha.setXYZ(next._x, next._y, next._z - 1, true);
                todo.store(next._x, next._y, next._z - 1);
            }
        } else {
            BitCube negative = new BitCube(this._x_size, this._y_size, this._z_size);
            int z = this._bb_min[2];
            while (z <= this._bb_max[2]) {
                int y = this._bb_min[1];
                while (y <= this._bb_max[1]) {
                    int x = this._bb_min[0];
                    while (x <= this._bb_max[0]) {
                        if (this.get_dist(x, y, z) < 0.0) {
                            negative.setXYZ(x, y, z, true);
                        }
                        this.set_dist(x, y, z, 2.147483647E9);
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            double xsxs = this._x_spacing * this._x_spacing;
            for (Voxel fv : front) {
                int z2 = this._bb_min[2];
                while (z2 <= this._bb_max[2]) {
                    double dzdz = (double)((z2 - fv._z) * (z2 - fv._z)) * (this._z_spacing * this._z_spacing);
                    int y = this._bb_min[1];
                    while (y <= this._bb_max[1]) {
                        double dydy = (double)((y - fv._y) * (y - fv._y)) * (this._y_spacing * this._y_spacing);
                        int x = this._bb_min[0];
                        while (x <= this._bb_max[0]) {
                            double dist_sqr = dzdz + dydy + (double)((x - fv._x) * (x - fv._x)) * xsxs;
                            if (dist_sqr < this.get_dist(x, y, z2)) {
                                this.set_dist(x, y, z2, dist_sqr);
                            }
                            ++x;
                        }
                        ++y;
                    }
                    ++z2;
                }
            }
            int z3 = this._bb_min[2];
            while (z3 <= this._bb_max[2]) {
                int y = this._bb_min[1];
                while (y <= this._bb_max[1]) {
                    int x = this._bb_min[0];
                    while (x <= this._bb_max[0]) {
                        if (negative.getXYZ(x, y, z3)) {
                            this.set_dist(x, y, z3, -Math.sqrt(this.get_dist(x, y, z3)));
                        } else {
                            this.set_dist(x, y, z3, Math.sqrt(this.get_dist(x, y, z3)));
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z3;
            }
        }
    }
}

