/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.levelset;

import main.seggen.levelset.EnergyIntegralTerms;
import main.seggen.levelset.Heaviside;

public final class Heaviside0
extends Heaviside {
    public Heaviside0(int value_min, int value_max) {
        super(value_min, value_max);
    }

    @Override
    public double dirac(double z, double eps) {
        return eps / (Math.PI * (eps * eps + z * z));
    }

    @Override
    public void energy_integral_step(double dist, double eps, int val, int voxel_value, EnergyIntegralTerms eit) {
        if (voxel_value >= this._value_min && voxel_value <= this._value_max) {
            double heaviside = 0.5 + Math.atan(dist / eps) / Math.PI;
            eit._c1 += (double)val * (1.0 - heaviside);
            eit._innerpoints += 1.0 - heaviside;
            eit._c2 += (double)val * heaviside;
            eit._outerpoints += heaviside;
        }
    }
}

