/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.levelset;

import main.seggen.levelset.EnergyIntegralTerms;
import main.seggen.levelset.Heaviside;

public final class Heaviside1
extends Heaviside {
    public Heaviside1(int value_min, int value_max) {
        super(value_min, value_max);
    }

    @Override
    public double dirac(double z, double eps) {
        double dirac = z > eps || z < -eps ? 0.0 : (1.0 + Math.cos(Math.PI * z / eps)) / (2.0 * eps);
        return dirac;
    }

    @Override
    public void energy_integral_step(double dist, double eps, int val, int voxel_value, EnergyIntegralTerms eit) {
        if (voxel_value >= this._value_min && voxel_value <= this._value_max) {
            double heaviside = dist > eps ? 1.0 : (dist < -eps ? 0.0 : 0.5 + dist / (2.0 * eps) + Math.sin(Math.PI * dist / eps) / (Math.PI * 2));
            eit._c1 += (double)val * (1.0 - heaviside);
            eit._innerpoints += 1.0 - heaviside;
            eit._c2 += (double)val * heaviside;
            eit._outerpoints += heaviside;
        }
    }
}

