/*
 * Decompiled with CFR 0.152.
 */
package main.seggen.levelset;

import main.seggen.levelset.EnergyIntegralTerms;
import main.seggen.levelset.Heaviside;

public final class Heaviside2
extends Heaviside {
    public Heaviside2(int value_min, int value_max) {
        super(value_min, value_max);
    }

    @Override
    public double dirac(double z, double eps) {
        double tanh = Math.tanh(z / eps);
        return (1.0 - tanh * tanh) / (2.0 * eps);
    }

    @Override
    public void energy_integral_step(double dist, double eps, int val, int voxel_value, EnergyIntegralTerms eit) {
        if (voxel_value >= this._value_min && voxel_value <= this._value_max) {
            double heaviside = (1.0 + Math.tanh(dist / eps)) * 0.5;
            eit._c1 += (double)val * (1.0 - heaviside);
            eit._innerpoints += 1.0 - heaviside;
            eit._c2 += (double)val * heaviside;
            eit._outerpoints += heaviside;
        }
    }
}

