/*
 * Decompiled with CFR 0.152.
 */
package main.tools;

import gui.SegSelector;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.border.Border;
import jgridmaker.GMPanel;
import main.ImageStack;
import main.MasterControl;
import main.Segment;
import main.YDialogs;
import main.YaDiV;
import main.view3d.Viewport3d;
import misc.GeometryExport;
import misc.dicom.DiFile;
import misc.grid.BitCube;
import misc.helper.Helper;
import misc.linkedsurface.LTSConverter;
import misc.linkedsurface.LTSValidator;
import misc.linkedsurface.LTSValidatorWindow;
import misc.linkedsurface.LinkedTriaSurface;
import renderer.SegRenderer3d;
import settings.JDoubleOptionTextfield;
import settings.Settings;
import settings.SettingsOwner;

public class SegExportPanel
extends GMPanel
implements SettingsOwner {
    public static final String OPT_DEF_EXPORT_DIR = Settings.register_str_opt(SegExportPanel.class, "export directory", "Default export directory", System.getProperty("user.home"));
    public static final String OPT_SCALE_FACTOR = Settings.register_double_opt(SegExportPanel.class, "scale factor", "Scales all coordinates by this factor (can be necessary to avoid floating point issues when exporting to an ASCII format)", 100.0);
    private final JButton _jb_dicom_export;
    private final JCheckBox _jcb_dicom_binary;
    private final JCheckBox _jcb_mc_apply_transform;
    private final JCheckBox _jcb_export_mc_closing;
    private final JCheckBox _jb_mc_export_normals;
    private final SegSelector _seg_sel;
    private final JComboBox _jcb_export_type = new JComboBox<String>(GeometryExport.TYPES);
    private final JFileChooser _jfc_mc_export = new JFileChooser(Settings.get_str_option(SegExportPanel.class, OPT_DEF_EXPORT_DIR));
    private final JButton _jb_mc_check;
    private final JButton _jb_mc_export;

    private void export_dicom(Segment seg, String dir_name, boolean binary) {
        ImageStack is = MasterControl.get_is();
        BitCube bc = seg.get_bc();
        boolean ask_user = true;
        int[] pos = new int[3];
        int[] map = is.get_iop_map();
        int[] inc = is.get_iop_inc();
        int[] start = is.get_iop_start();
        pos[map[2]] = start[2];
        int i = 0;
        while (i < is.get_dicom_file_number()) {
            int[] pixels;
            int bytes_pp;
            DiFile df = new DiFile(is.get_dicom_file(i));
            int w = df.get_image_width();
            int h = df.get_image_height();
            if (binary) {
                bytes_pp = 1;
                pixels = new int[w * h];
                pos[map[1]] = start[1];
                int y = 0;
                while (y < h) {
                    pos[map[0]] = start[0];
                    int x = 0;
                    while (x < w) {
                        pixels[y * w + x] = bc.getXYZ(pos[0], pos[1], pos[2]) ? -1 : 0;
                        ++x;
                        int n = map[0];
                        pos[n] = pos[n] + inc[0];
                    }
                    ++y;
                    int n = map[1];
                    pos[n] = pos[n] + inc[1];
                }
                df.set_pixel_data(w, h, pixels, bytes_pp);
            } else {
                DiFile orig = new DiFile();
                try {
                    orig.load_from_file(df.get_file_name());
                }
                catch (Exception e) {
                    YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "The File \"" + df.get_file_name() + "\"does not have a valid " + "original version on the file system");
                    return;
                }
                bytes_pp = orig.get_bytes_per_pixel();
                pixels = orig.get_pixel_data();
                pos[map[1]] = start[1];
                int y = 0;
                while (y < h) {
                    pos[map[0]] = start[0];
                    int x = 0;
                    while (x < w) {
                        if (!bc.getXYZ(pos[0], pos[1], pos[2])) {
                            pixels[y * w + x] = 0;
                        }
                        ++x;
                        int n = map[0];
                        pos[n] = pos[n] + inc[0];
                    }
                    ++y;
                    int n = map[1];
                    pos[n] = pos[n] + inc[1];
                }
                df.set_pixel_data(w, h, pixels, orig.get_min_possible_value(), orig.get_max_possible_value());
            }
            File dummy = new File(df.get_file_name());
            String export_name = new String(String.valueOf(dir_name) + File.separatorChar + dummy.getName());
            try {
                if (ask_user && new File(export_name).exists()) {
                    Object[] options = new Object[]{"Yes", "No"};
                    int answer = JOptionPane.showOptionDialog(MasterControl.get_window(), "The given directory is not empty. Overwrite existing files?", "Overwrite files", 0, 3, null, options, options[1]);
                    if (answer != 0) {
                        return;
                    }
                    ask_user = false;
                }
                df.save_to_file(export_name);
            }
            catch (Exception ex) {
                YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "ToolMisc::export_dicom: could not write file " + export_name + " (" + ex + ")");
            }
            ++i;
            int n = map[2];
            pos[n] = pos[n] + inc[2];
        }
    }

    public SegExportPanel() {
        this._jfc_mc_export.setDialogTitle("Choose file for segment MC surface export");
        this._seg_sel = new SegSelector("Select Segment");
        this._seg_sel.setSelectionMode(2);
        this._seg_sel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String property = propertyChangeEvent.getPropertyName();
                if (SegSelector.SEG_SELECTION_CHANGED.equals(property)) {
                    boolean export_possible = SegExportPanel.this._seg_sel.get_selected_segments().size() != 0;
                    SegExportPanel.this._jb_dicom_export.setEnabled(export_possible);
                    SegExportPanel.this._jb_mc_check.setEnabled(export_possible);
                    SegExportPanel.this._jb_mc_export.setEnabled(export_possible);
                }
            }
        });
        this._jcb_dicom_binary = new JCheckBox("Binary Data", false);
        this._jb_dicom_export = new JButton("Export DICOM");
        this._jb_dicom_export.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setFileSelectionMode(1);
                fc.setDialogTitle("Choose directory for segment DICOM export");
                int ret_val = fc.showSaveDialog(null);
                if (ret_val == 0) {
                    String dir_name = fc.getSelectedFile().getAbsolutePath();
                    SegExportPanel.this.export_dicom(SegExportPanel.this._seg_sel.get_selected_segment(), dir_name, SegExportPanel.this._jcb_dicom_binary.isSelected());
                }
            }
        });
        this._jb_dicom_export.setEnabled(false);
        GMPanel gm_export_dicom = new GMPanel();
        gm_export_dicom.add("_jb_dicom_export", (JComponent)this._jb_dicom_export);
        gm_export_dicom.add("_jcb_dicom_binary", (JComponent)this._jcb_dicom_binary);
        gm_export_dicom.set_layout("<table cellpadding='2' border='0'>  <tr>    <td>::_jcb_dicom_binary::</td>  </tr><tr>    <td>::_jb_dicom_export::</td>  </tr></table>");
        gm_export_dicom.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Export as DICOM", 2, 2));
        this._jb_mc_check = new JButton("Check MC");
        this._jb_mc_check.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Shape3D closing_shp;
                Shape3D mc_shp;
                Segment seg = SegExportPanel.this._seg_sel.get_selected_segment();
                LinkedTriaSurface lts = new LinkedTriaSurface();
                Viewport3d v3d = MasterControl.get_v3d();
                SegRenderer3d sr3d = v3d.get_seg_renderer(seg);
                Transform3D tf_scale = null;
                if (SegExportPanel.this._jcb_mc_apply_transform.isSelected()) {
                    ImageStack is = MasterControl.get_is();
                    double scale = Settings.get_double_option(SegExportPanel.class, OPT_SCALE_FACTOR);
                    double[] mat_scale = new double[]{is.get_x_spacing() * scale, 0.0, 0.0, 0.0, 0.0, is.get_y_spacing() * scale, 0.0, 0.0, 0.0, 0.0, is.get_z_spacing() * scale, 0.0, 0.0, 0.0, 0.0, 1.0};
                    tf_scale = new Transform3D(mat_scale);
                }
                if ((mc_shp = sr3d.get_shp_mc_body()) != null) {
                    if (tf_scale == null) {
                        LTSConverter.ita_to_lts((IndexedTriangleArray)mc_shp.getGeometry(), lts);
                    } else {
                        LTSConverter.ita_to_lts((IndexedTriangleArray)mc_shp.getGeometry(), lts, tf_scale);
                    }
                } else {
                    YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "mc_shp was null!");
                }
                Shape3D shape3D = closing_shp = SegExportPanel.this._jcb_export_mc_closing.isSelected() ? sr3d.get_shp_mc_closing() : null;
                if (closing_shp != null) {
                    if (tf_scale == null) {
                        LTSConverter.ita_to_lts((IndexedTriangleArray)closing_shp.getGeometry(), lts);
                    } else {
                        LTSConverter.ita_to_lts((IndexedTriangleArray)closing_shp.getGeometry(), lts, tf_scale);
                    }
                } else {
                    YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "closing_shp was null!");
                }
                LTSValidatorWindow win = new LTSValidatorWindow("Info on " + seg.get_name());
                win.set_model(lts, null, LTSValidator.validate(lts));
            }
        });
        this._jb_mc_check.setEnabled(false);
        this._jb_mc_export = new JButton("Export MC");
        this._jb_mc_export.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkedList<Segment> seg_list = SegExportPanel.this._seg_sel.get_selected_segments();
                Segment[] segs = new Segment[seg_list.size()];
                String suggested_name = null;
                String format = (String)SegExportPanel.this._jcb_export_type.getSelectedItem();
                if (seg_list.size() != 1 && format.equals(format.equals(GeometryExport.TYPE_STL_BINARY) || format.equals(GeometryExport.TYPE_STL_BINARY))) {
                    JOptionPane.showMessageDialog(MasterControl.get_window(), "STL Format supports only one surface per file. Change segment selection or use other format.", "Inane error", 0);
                    return;
                }
                if (seg_list.size() == 1) {
                    Segment seg = SegExportPanel.this._seg_sel.get_selected_segments().getFirst();
                    suggested_name = String.valueOf(Helper.get_last_dir(MasterControl.get_is().get_dir_name())) + "_" + seg.get_name();
                } else {
                    suggested_name = Helper.get_last_dir(String.valueOf(MasterControl.get_is().get_dir_name()) + "segs");
                }
                if (format.equals(GeometryExport.TYPE_JANUS)) {
                    suggested_name = String.valueOf(suggested_name) + ".dat";
                } else if (format.equals(GeometryExport.TYPE_STL_ASCII) || format.equals(GeometryExport.TYPE_STL_BINARY)) {
                    suggested_name = String.valueOf(suggested_name) + ".stl";
                }
                Iterator it_seg = seg_list.iterator();
                int num = 0;
                while (it_seg.hasNext()) {
                    Segment seg = (Segment)it_seg.next();
                    SegRenderer3d sr = MasterControl.get_v3d().get_seg_renderer(seg);
                    if (!Settings.get_bool_option(sr, SegRenderer3d.OPT_SHOW_MC).booleanValue() || !Settings.get_bool_option(sr, SegRenderer3d.OPT_VISIBLE).booleanValue()) {
                        JOptionPane.showMessageDialog(MasterControl.get_window(), "MC Surface can only be exported when it is shown in the View3d.", "Inane error", 0);
                        return;
                    }
                    segs[num++] = seg;
                }
                SegExportPanel.this._jfc_mc_export.setSelectedFile(new File(suggested_name));
                int ret_val = SegExportPanel.this._jfc_mc_export.showSaveDialog(null);
                if (ret_val == 0) {
                    File file = SegExportPanel.this._jfc_mc_export.getSelectedFile();
                    String file_name = file.getAbsolutePath();
                    if (!file.exists() || YDialogs.overwrite_file_dialog(file_name)) {
                        Transform3D tf_scale = null;
                        if (SegExportPanel.this._jcb_mc_apply_transform.isSelected()) {
                            ImageStack is = MasterControl.get_is();
                            double scale = Settings.get_double_option(SegExportPanel.class, OPT_SCALE_FACTOR);
                            double[] mat_scale = new double[]{is.get_x_spacing() * scale, 0.0, 0.0, 0.0, 0.0, is.get_y_spacing() * scale, 0.0, 0.0, 0.0, 0.0, is.get_z_spacing() * scale, 0.0, 0.0, 0.0, 0.0, 1.0};
                            tf_scale = new Transform3D(mat_scale);
                        }
                        Shape3D[] body_shps = new Shape3D[segs.length];
                        Shape3D[] closing_shps = SegExportPanel.this._jcb_export_mc_closing.isSelected() ? new Shape3D[segs.length] : null;
                        int i = 0;
                        while (i < segs.length) {
                            Viewport3d v3d = MasterControl.get_v3d();
                            SegRenderer3d sr3d = v3d.get_seg_renderer(segs[i]);
                            body_shps[i] = sr3d.get_shp_mc_body();
                            if (closing_shps != null) {
                                closing_shps[i] = sr3d.get_shp_mc_closing();
                            }
                            ++i;
                        }
                        GeometryExport.export_indexed_tria_data(segs, file_name, format, body_shps, closing_shps, tf_scale, SegExportPanel.this._jb_mc_export_normals.isSelected());
                    }
                }
            }
        });
        this._jb_mc_export.setEnabled(false);
        this._jcb_export_mc_closing = new JCheckBox("Closing Surface", true);
        this._jcb_export_mc_closing.setToolTipText("\"Closes\" a segment at the borders of the volume data.");
        this._jb_mc_export_normals = new JCheckBox("Export Normals", false);
        this._jb_mc_export_normals.setToolTipText("If enabled, normals are also exported. Some formats require normals anyway (in this case they are exported automatically).");
        this._jcb_mc_apply_transform = new JCheckBox("Apply Spacing", true);
        this._jcb_mc_apply_transform.setToolTipText("Scales the grid position values by the spacing. If disabled, all vertices will be exproted in grid positions.");
        JDoubleOptionTextfield jdotf_scale_factor = new JDoubleOptionTextfield(SegExportPanel.class, OPT_SCALE_FACTOR, 5);
        GMPanel gm_export_mc = new GMPanel();
        gm_export_mc.add("_jcb_export_mc_closing", (JComponent)this._jcb_export_mc_closing);
        gm_export_mc.add("_jcb_apply_transform", (JComponent)this._jcb_mc_apply_transform);
        gm_export_mc.add("_jcb_export_normals", (JComponent)this._jb_mc_export_normals);
        gm_export_mc.add("jcb_type", (JComponent)this._jcb_export_type);
        gm_export_mc.add("scale_factor", (JComponent)jdotf_scale_factor);
        gm_export_mc.add("_jb_check", (JComponent)this._jb_mc_check);
        gm_export_mc.add("_jb_export", (JComponent)this._jb_mc_export);
        gm_export_mc.set_layout("<table cellpadding='2' border='0'>  <tr>    <td>::_jcb_export_mc_closing::</td>  </tr><tr>    <td>::_jcb_apply_transform::</td>  </tr><tr>    <td>::_jcb_export_normals::</td>  </tr><tr>    <td>::jcb_type::</td>  </tr><tr>    <td>Scaling Factor:</td>  </tr><tr>    <td>::scale_factor::</td>  </tr><tr>    <td>::_jb_check::</td>  </tr><tr>    <td>::_jb_export::</td>  </tr></table>");
        gm_export_mc.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Export MC Surface", 2, 2));
        this.add("_seg_sel", this._seg_sel);
        this.add("gm_export_dicom", (JComponent)gm_export_dicom);
        this.add("gm_export_mc", (JComponent)gm_export_mc);
        this.set_layout("<table cellpadding='2' border='0' height='100%'>  <tr>    <td fill='both'>::_seg_sel::</td>    <td fill='both'>::gm_export_dicom::</td>    <td fill='both'>::gm_export_mc::</td>  </tr></table>");
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
    }

    @Override
    public String get_name() {
        return "SegExport";
    }
}

