/*
 * Decompiled with CFR 0.152.
 */
package main.tools;

import gui.HistoPanel;
import java.awt.Dimension;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JLabel;
import jgridmaker.GMPanel;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.YaDiV;
import misc.dicom.DiDataElement;
import misc.dicom.DiDi;
import misc.dicom.DiFile;
import misc.helper.Helper;
import misc.messages.YObservable;
import misc.messages.YObserverWantsAWTThread;

public final class ToolInfo
extends GMPanel
implements YObserverWantsAWTThread {
    private final JLabel _jl_content_path;
    private final JLabel _jl_images;
    private final JLabel _jl_content_img_depth;
    private final JLabel _jl_sop_media_class;
    private final JLabel _jl_study_uid;
    private final JLabel _jl_series_uid;
    private final JLabel _jl_patient_name;
    private final JLabel _jl_spacing;
    private final JLabel _jl_study_date;
    private final NumberFormat _spacing_formatter = NumberFormat.getNumberInstance();

    public ToolInfo() {
        HistoPanel hp = new HistoPanel(MasterControl.get_is().get_vch(), "HPInfo");
        this._spacing_formatter.setMinimumFractionDigits(0);
        this._spacing_formatter.setMaximumFractionDigits(10);
        this._jl_content_path = new JLabel("---");
        this._jl_sop_media_class = new JLabel("---");
        this._jl_study_uid = new JLabel("---");
        this._jl_series_uid = new JLabel("---");
        this._jl_patient_name = new JLabel("---");
        this._jl_study_date = new JLabel("---");
        this._jl_images = new JLabel("---");
        this._jl_content_img_depth = new JLabel("---");
        this._jl_spacing = new JLabel("---");
        hp.setPreferredSize(new Dimension(400, 100));
        this.add("_jl_images", this._jl_images);
        this.add("_jl_content_img_depth", this._jl_content_img_depth);
        this.add("_jl_spacing", this._jl_spacing);
        this.add("_jl_study_uid", this._jl_study_uid);
        this.add("_jl_series_uid", this._jl_series_uid);
        this.add("_jl_content_path", this._jl_content_path);
        this.add("_jl_patient_name", this._jl_patient_name);
        this.add("_jl_study_date", this._jl_study_date);
        this.add("_jl_sop_media_class", this._jl_sop_media_class);
        this.add("hp", hp);
        this.set_layout("<table cellpadding='2' border='0'>  <tr anchor='north'>    <td>      <table anchor='west'>        <colgroup>          <col width='1%' />          <col width='48%' />        </colgroup>        <tr>          <td>Patient:</td>          <td>::_jl_patient_name::</td>        </tr><tr>          <td>Study Date:</td>          <td>::_jl_study_date::</td>        </tr><tr>          <td>Study UID:</td>          <td>::_jl_study_uid::</td>        </tr><tr>          <td>Series :</td>          <td>::_jl_series_uid::</td>        </tr>      </table>    </td>    <td>      <table anchor='west'>        <colgroup>          <col width='1%' />          <col width='48%' />        </colgroup>        <tr>          <td>Media Class:</td>          <td>::_jl_sop_media_class::</td>        </tr><tr>          <td>Images:</td>          <td>::_jl_images::</td>        </tr><tr>          <td>Depth:</td>          <td>::_jl_content_img_depth::</td>        </tr><tr>          <td>Spacing:</td>          <td>::_jl_spacing::</td>        </tr>      </table>    </td>  </tr><tr>    <td colspan='2'>      <table anchor='west'>        <tr>          <td>Path:</td>          <td>::_jl_content_path::</td>        </tr>      </table>    </td>  </tr><tr>    <td colspan='2' fill='both'>::hp::</td>  </tr></table>");
        MasterControl.get_is().addObserver(this, "ToolInfo()");
    }

    public final void update_content() {
        ImageStack is = MasterControl.get_is();
        DiFile df = is.get_dicom_file(0);
        String patient_name = "---";
        String study_date = "---";
        if (df != null) {
            HashMap<Integer, DiDataElement> data_elements = df.get_data_elements();
            if (data_elements.containsKey(0x100010)) {
                patient_name = data_elements.get(0x100010).get_value_as_string();
            }
            if (data_elements.containsKey(524320)) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                    Date date = sdf.parse(data_elements.get(524320).get_value_as_string());
                    study_date = DateFormat.getDateInstance().format(date);
                }
                catch (Exception ex) {
                    YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "Unhandled Excpetion in ToolInfo::update:content" + ex);
                }
            }
        }
        this._jl_patient_name.setText(patient_name);
        this._jl_study_date.setText(study_date);
        this._jl_content_path.setText(Helper.truncate_file_name(is.get_dir_name(), 30));
        this._jl_study_uid.setText(is.get_study_instance_uid());
        this._jl_series_uid.setText(is.get_series_instance_uid());
        this._jl_images.setText(is.get_dim_z() + " (" + is.get_dim_x() + " x " + is.get_dim_y() + ")");
        this._jl_content_img_depth.setText("" + is.get_voxel_value_range());
        this._jl_spacing.setText("(" + this._spacing_formatter.format(is.get_x_spacing()) + "; " + this._spacing_formatter.format(is.get_y_spacing()) + "; " + this._spacing_formatter.format(is.get_z_spacing()) + ") mm");
        this._jl_sop_media_class.setText(DiDi.get_sop_media_descr(is.get_sop_media_class()));
        this._jl_sop_media_class.setToolTipText("UID " + is.get_sop_media_class());
    }

    @Override
    public void update(YObservable o, Message m) {
        ImageStack is = MasterControl.get_is();
        if (m._type == ImageStack.M_LOADING_FIRST_IMAGE) {
            this.update_content();
        } else if (m._type == ImageStack.M_VC_SET) {
            this._jl_images.setText(is.get_dim_z() + " (" + is.get_dim_x() + " x " + is.get_dim_y() + ")");
        } else if (m._type == ImageStack.M_VC_SPACING_CHANGED) {
            this._jl_spacing.setText("(" + this._spacing_formatter.format(is.get_x_spacing()) + "; " + this._spacing_formatter.format(is.get_y_spacing()) + "; " + this._spacing_formatter.format(is.get_z_spacing()) + ") mm");
        } else if (m._type == ImageStack.M_RESIZE_END) {
            this.update_content();
        }
    }
}

