/*
 * Decompiled with CFR 0.152.
 */
package main.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;
import main.MasterControl;
import main.Message;
import main.view3d.LightEditor;
import main.view3d.LightEditor3D;
import main.view3d.LightModel;
import main.view3d.LightSettings;
import misc.messages.YObservable;
import misc.messages.YObserverWantsAWTThread;

public final class ToolLighting
extends JPanel
implements YObserverWantsAWTThread {
    JTabbedPane _tabs = new JTabbedPane();
    LightEditor3D _ed3d = new LightEditor3D(null);

    public ToolLighting() {
        this.setLayout(new BorderLayout());
        this._ed3d.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Direction settings and preview", 2, 2));
        this.add(this._tabs);
        this.add((Component)this._ed3d, "West");
        this._tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ToolLighting.this.update_ed3d_owner();
            }
        });
        MasterControl.get_lights().addObserver(this, "main.tools.ToolLighting, the global light settings manager");
    }

    public void initialize() {
        LightSettings s = MasterControl.get_lights();
        s.clear();
        LightModel m1 = new LightModel("ambient");
        m1.set_color(new Color3f(0.1f, 0.1f, 0.1f));
        m1.set_enabled(true);
        m1.set_type(LightModel.LightType.ambient);
        s.add_light(m1);
        LightModel m2 = new LightModel("light 1");
        m2.set_color(new Color3f(1.0f, 1.0f, 1.0f));
        m2.set_enabled(true);
        m2.set_type(LightModel.LightType.directional);
        m2.set_direction(new Vector3f(0.0f, 0.2f, 1.0f));
        s.add_light(m2);
    }

    @Override
    public void update(YObservable o, Message obj) {
        Message m = obj;
        if (m._type == LightSettings.M_LIGHT_ADDED) {
            LightModel l = (LightModel)m._obj;
            this._tabs.addTab(l.get_name(), (Component)((Object)new LightEditor(l, this._ed3d)));
            this.validate();
        } else if (m._type == LightSettings.M_LIGHTS_CLEARED) {
            while (this._tabs.getTabCount() > 0) {
                this._tabs.removeTabAt(0);
            }
            this.validate();
        } else if (m._type == LightSettings.M_LIGHT_REMOVED) {
            LightModel l = (LightModel)m._obj;
            int tabin = this._tabs.indexOfTab(l.get_name());
            this._tabs.removeTabAt(tabin);
            this.validate();
        }
        this.update_ed3d_owner();
    }

    private void update_ed3d_owner() {
        if (this._tabs == null || this._tabs.getSelectedComponent() == null || this._ed3d == null) {
            return;
        }
        this._ed3d.set_model(((LightEditor)((Object)this._tabs.getSelectedComponent()))._model);
    }
}

