/*
 * Decompiled with CFR 0.152.
 */
package main.tools;

import gui.LazyInitComponent;
import gui.ROIPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jgridmaker.GMPanel;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.YDialogs;
import main.YaDiV;
import main.tools.SegExportPanel;
import main.tools.ToolBox;
import main.view2d.Viewport2d;
import main.view2d.Viewport2dModel;
import misc.helper.Helper;
import misc.messages.YObservable;
import misc.messages.YObserverWantsAWTThread;
import settings.SettingsOwner;
import threads.YThread;
import yplugins.YModuleType;

public class ToolMisc
extends ToolBox
implements YObserverWantsAWTThread,
LazyInitComponent {
    private ROIPanel _ir_class_panel;
    private VolExportPanel _vol_export_panel;
    private SegExportPanel _seg_export_panel;

    @Override
    public void update(YObservable o, Message m) {
        if (m._type != ImageStack.M_SEG_START && m._type != ImageStack.M_RESIZE_START && m._type != ImageStack.M_FILTER3D_START && m._type != ImageStack.M_SEG_END && m._type != ImageStack.M_RESIZE_END) {
            int cfr_ignored_0 = m._type;
        }
    }

    @Override
    public void create_gui() {
        this._ir_class_panel = new ROIPanel(null, true, "Global Region of Interest");
        this._vol_export_panel = new VolExportPanel();
        this._seg_export_panel = new SegExportPanel();
        this._jtp.addTab("ROI", null, (Component)((Object)this._ir_class_panel), "Select Global Region of Interest");
        this._jtp.addTab("Volume  Export", null, (Component)((Object)this._vol_export_panel), "Export Volume Data");
        this._jtp.addTab("Segment Export", null, (Component)((Object)this._seg_export_panel), "Export Segment Geometry");
        this.add_plugin_tabs(YModuleType.MISC);
        this.setLayout(new BorderLayout());
        this.add(this._jtp, "Center");
        MasterControl.get_is().addObserver(this, "ToolMisc()");
    }

    @Override
    public boolean gui_created() {
        return this._seg_export_panel != null;
    }

    private static class VolExportPanel
    extends GMPanel {
        private final JCheckBox _jcb_volume_data_only;
        private final JCheckBox _jcb_apply_scaling;
        private final JButton _jb_export_single;
        private final JButton _jb_export_all;
        private final JComboBox _jcb_file_format = new JComboBox<String>(ImageIO.getReaderFileSuffixes());

        private void export_images(String dir_name, String suffix, int view_mode, boolean volume_data_only, boolean use_scaling) {
            ExportImagesThread eit = new ExportImagesThread(null, true, true, dir_name, suffix, view_mode, volume_data_only, use_scaling);
            eit.start();
        }

        private void export_image(File file, String suffix, int view_mode, int slice, boolean volume_data_only, boolean use_scaling) {
            double img_y_spacing;
            double img_x_spacing;
            int img_h;
            int img_w;
            ImageStack is = MasterControl.get_is();
            switch (view_mode) {
                case 0: {
                    img_w = is.get_dim_x();
                    img_h = is.get_dim_y();
                    img_x_spacing = is.get_x_spacing();
                    img_y_spacing = is.get_y_spacing();
                    break;
                }
                case 1: {
                    img_w = is.get_dim_y();
                    img_h = is.get_dim_z();
                    img_x_spacing = is.get_y_spacing();
                    img_y_spacing = is.get_z_spacing();
                    break;
                }
                default: {
                    assert (view_mode == 2);
                    img_w = is.get_dim_x();
                    img_h = is.get_dim_z();
                    img_x_spacing = is.get_x_spacing();
                    img_y_spacing = is.get_z_spacing();
                }
            }
            BufferedImage bimg = new BufferedImage(img_w, img_h, 2);
            MasterControl.get_v2d().render_into_image(bimg, view_mode, slice, volume_data_only);
            if (use_scaling && img_x_spacing != img_y_spacing) {
                BufferedImage scaled_image;
                AffineTransform scale = new AffineTransform();
                if (img_x_spacing < img_y_spacing) {
                    double fac_y = img_y_spacing / img_x_spacing;
                    scale.scale(1.0, fac_y);
                    scaled_image = new BufferedImage(img_w, (int)(fac_y * (double)img_h), 2);
                } else {
                    double fac_x = img_x_spacing / img_y_spacing;
                    scale.scale(fac_x, 1.0);
                    scaled_image = new BufferedImage((int)(fac_x * (double)img_w), img_h, 2);
                }
                Graphics2D g2 = (Graphics2D)scaled_image.getGraphics();
                g2.drawImage(bimg, scale, null);
                bimg = scaled_image;
            }
            try {
                ImageIO.write((RenderedImage)bimg, suffix, file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public VolExportPanel() {
            this._jcb_file_format.setSelectedItem("png");
            this._jcb_volume_data_only = new JCheckBox("Volume Data only", false);
            this._jcb_volume_data_only.setToolTipText("If enabled, only the volume data (no segments, no seeds, no special layers) is exported.If disabled, the export images will look exactly as they are currently shown in the View2d.");
            this._jcb_apply_scaling = new JCheckBox("Apply Scaling", true);
            this._jcb_apply_scaling.setToolTipText("If enabled, the spacing in between two pixels will be used to scale the exported images to the correct aspect ratio.");
            this._jb_export_single = new JButton("Export Single Slice");
            this._jb_export_single.setToolTipText("Exports the slice currently shown in the View2d");
            this._jb_export_single.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file;
                    String suffix = (String)VolExportPanel.this._jcb_file_format.getSelectedItem();
                    Viewport2dModel v2d_model = MasterControl.get_v2d().get_model();
                    int view_mode = v2d_model.get_view_mode();
                    int active_image = v2d_model.get_active_image();
                    String suggested_name = String.valueOf(Helper.get_last_dir(MasterControl.get_is().get_dir_name())) + "_" + Viewport2d.VIEWMODE_STR[view_mode].substring(0, 1) + "_" + Helper.add_trailing_zeros(active_image, 5) + "." + suffix;
                    JFileChooser fc = new JFileChooser();
                    fc.setDialogTitle("Single Image Export - Select File Name");
                    fc.setSelectedFile(new File(suggested_name));
                    int ret_val = fc.showSaveDialog(null);
                    if (ret_val == 0 && (!(file = fc.getSelectedFile()).exists() || YDialogs.overwrite_file_dialog(file.getAbsolutePath()))) {
                        VolExportPanel.this.export_image(file, suffix, view_mode, active_image, VolExportPanel.this._jcb_volume_data_only.isSelected(), VolExportPanel.this._jcb_apply_scaling.isSelected());
                    }
                }
            });
            this._jb_export_all = new JButton("Export All Slices");
            this._jb_export_all.setToolTipText("Exports all slices in the view mode (transversal, frontal or sagittal) currently used in the View2d");
            this._jb_export_all.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fc = new JFileChooser();
                    fc.setFileSelectionMode(1);
                    fc.setDialogTitle("Multi Image Export - Select Directory");
                    int ret_val = fc.showSaveDialog(null);
                    if (ret_val == 0) {
                        String dir_name = fc.getSelectedFile().getAbsolutePath();
                        String suffix = (String)VolExportPanel.this._jcb_file_format.getSelectedItem();
                        Viewport2dModel v2d_model = MasterControl.get_v2d().get_model();
                        int view_mode = v2d_model.get_view_mode();
                        VolExportPanel.this.export_images(dir_name, suffix, view_mode, VolExportPanel.this._jcb_volume_data_only.isSelected(), VolExportPanel.this._jcb_apply_scaling.isSelected());
                    }
                }
            });
            this.add("_jcb_volume_data_only", this._jcb_volume_data_only);
            this.add("_jcb_apply_scaling", this._jcb_apply_scaling);
            this.add("_jb_export_single", this._jb_export_single);
            this.add("_jb_export_all", this._jb_export_all);
            this.add("_jcb_file_format", this._jcb_file_format);
            this.set_layout("<table>  <tr>    <td colspan='2'>::_jcb_volume_data_only::</td>  </tr><tr>    <td colspan='2'>::_jcb_apply_scaling::</td>  </tr><tr>    <td anchor='east'>File Format:</td>    <td anchor='west'>::_jcb_file_format::</td>  </tr><tr>    <td>::_jb_export_single::</td>    <td>::_jb_export_all::</td>  </tr></table>");
        }

        private class ExportImagesThread
        extends YThread {
            private final String dir_name;
            private final String suffix;
            private final int view_mode;
            private final boolean volume_data_only;
            private final boolean use_scaling;

            public ExportImagesThread(SettingsOwner parent, boolean monitor, boolean stoppable, String dir_name, String suffix, int view_mode, boolean volume_data_only, boolean use_scaling) {
                super(parent, monitor, stoppable);
                this.dir_name = dir_name;
                this.suffix = suffix;
                this.view_mode = view_mode;
                this.volume_data_only = volume_data_only;
                this.use_scaling = use_scaling;
            }

            @Override
            public void my_run() {
                ImageStack is = MasterControl.get_is();
                int number_of_slices = 0;
                boolean ask_user = true;
                switch (this.view_mode) {
                    case 0: {
                        number_of_slices = is.get_dim_z();
                        break;
                    }
                    case 1: {
                        number_of_slices = is.get_dim_x();
                        break;
                    }
                    default: {
                        assert (this.view_mode == 2);
                        number_of_slices = is.get_dim_y();
                    }
                }
                this.init_progress_measure("exporting images", 0, number_of_slices, 0);
                int i = 0;
                while (i < number_of_slices) {
                    String suggested_name = String.valueOf(this.dir_name) + File.separatorChar + Helper.get_last_dir(MasterControl.get_is().get_dir_name()) + "_" + Viewport2d.VIEWMODE_STR[this.view_mode].substring(0, 1) + "_" + Helper.add_trailing_zeros(i, 5) + "." + this.suffix;
                    File f = new File(suggested_name);
                    try {
                        if (ask_user && f.exists()) {
                            Object[] options = new Object[]{"Yes", "No"};
                            int answer = JOptionPane.showOptionDialog(MasterControl.get_window(), "The given directory is not empty. Overwrite existing files?", "Overwrite files", 0, 3, null, options, options[1]);
                            if (answer != 0) {
                                return;
                            }
                            ask_user = false;
                        }
                        VolExportPanel.this.export_image(f, this.suffix, this.view_mode, i, this.volume_data_only, this.use_scaling);
                    }
                    catch (Exception ex) {
                        YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "ToolMisc::export_images: could not write file " + suggested_name + " (" + ex + ")");
                    }
                    this.inc_progress_value(1);
                    if (this._stop_soon) break;
                    ++i;
                }
                this.set_progress_val(this.get_progress_max());
            }
        }
    }
}

