/*
 * Decompiled with CFR 0.152.
 */
package main.tools;

import gui.LazyInitComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.media.j3d.Transform3D;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import jgridmaker.GMPanel;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.tools.ToolBox;
import main.view3d.Viewport3d;
import misc.StopWatch;
import misc.grid.gradients.GradientCachingMethod;
import misc.messages.YObservable;
import misc.messages.YObserverWantsAWTThread;
import raycaster.RayCastingRenderer;
import raycaster.gui.LightingTab;
import raycaster.gui.RayCasterGuiInitializer;
import raycaster.gui.RenderOptionTab;
import raycaster.gui.RenderResultWindow;
import raycaster.gui.SegmentOptionTab;
import raycaster.gui.SequenceTab;
import raycaster.gui.TransferFunctionTab;
import raycaster.settings.RenderInfoFactory;
import raycaster.settings.RenderSettings;
import raycaster.settings.RenderSettingsIO;
import renderer.BGImageRenderer2d;
import renderer.SegmentColorTableMap;
import settings.JIntegerOptionTextfield;
import settings.Settings;
import settings.SettingsOwner;
import threads.RSThread;
import yplugins.YModuleType;

public final class ToolRayCasting
extends ToolBox
implements YObserverWantsAWTThread,
SettingsOwner,
LazyInitComponent {
    public static final int M_RENDERING_STARTED = Message.register_message("Offline Rendering Started");
    public static final int M_RENDERING_ENDED = Message.register_message("Offline Rendering Ended");
    public static final String OPT_DATE_FORMAT_STRING = Settings.register_str_opt(ToolRayCasting.class, "date format", "date format used in output file naming (see java.text.SimpleDateFormat)", "yyyy_MM_dd_HHmmss");
    public static final String OPT_UPDATE_TR2D = Settings.register_bool_opt(ToolRayCasting.class, "2D Texture Preview", "Use the 2D Texture Renderer as Preview", true);
    public static final String OPT_UPDATE_TR3D = Settings.register_bool_opt(ToolRayCasting.class, "3D Texture Preview", "Use the 3D Texture Renderer as Preview", true);
    public static final String OPT_RESOURCES_DIR = Settings.register_str_opt(ToolRayCasting.class, "resources directory", "path of the directory where resources are stored (Lit Sphere Maps, etc)", "resources");
    public static final String OPT_RESULT_DIR = Settings.register_str_opt(ToolRayCasting.class, "result directory", "path of the directory where the rendered images will be stored", "results");
    public static final String OPT_AUTO_SAVE = Settings.register_bool_opt(ToolRayCasting.class, "auto save", "automatic save of image and settings files after rendering", true);
    public static final String OPT_GRADIENT_CACHING = Settings.register_enum_opt(ToolRayCasting.class, "gradient caching", "Method used to cache the gradients during the calculation", GradientCachingMethod.HASH);
    public static final String OPT_IMG_WIDTH = Settings.register_int_opt(ToolRayCasting.class, "image width", "width of the resulting image in pixels", 512);
    public static final String OPT_IMG_HEIGHT = Settings.register_int_opt(ToolRayCasting.class, "image height", "height of the resulting image in pixels", 512);
    public static final String OPT_SAMPLING_RATE = Settings.register_double_opt(ToolRayCasting.class, "sampling rate", "Rate at which the ray is sampled along its way through the volume. 1 is the voxel spacing.", 1.0);
    public static final String OPT_RAY_TERM = Settings.register_double_opt(ToolRayCasting.class, "ray termination", "epsilon used for early ray termination", 0.005);
    public static final String OPT_THREAD_COUNT = Settings.register_int_opt(ToolRayCasting.class, "thread_count", "Number of render threads to use", 4);
    public static final String OPT_USE_OCTREE = Settings.register_bool_opt(ToolRayCasting.class, "use octree", "If true, uses an binary hierarchy for empty space skipping.", true);
    public static final String OPT_GRADIENT_WEIGHT = Settings.register_bool_opt(ToolRayCasting.class, "x use gradient weight", "weights the alpha value of a sample depending on the gradient length", false);
    public static final String OPT_BISEC_STEPS = Settings.register_int_opt(ToolRayCasting.class, "x bisec steps", "maximum number of steps to find bisec position", 10);
    private final String _name;
    private final ToolRayCasting _tool_instance = this;
    private boolean _gui_created = false;
    private RenderOptionTab _render_tab;
    private TransferFunctionTab _tf_tab;
    private SegmentOptionTab _segment_option_tab;
    private LightingTab _lighting_tab;
    private SequenceTab _sequence_tab;
    private JButton _jb_render;
    private JButton _jb_load_settings;
    private JIntegerOptionTextfield _jiotf_width;
    private JIntegerOptionTextfield _jiotf_height;
    private JIntegerOptionTextfield _jiotfs_threads;

    public ToolRayCasting() {
        this._name = "Offline Render Tool";
    }

    private final void start_rendering() {
        Date date = new Date();
        String path = String.valueOf(Settings.get_str_option(this, OPT_RESULT_DIR)) + "/";
        String file_name_prefix = "image";
        SimpleDateFormat date_format = new SimpleDateFormat(Settings.get_str_option(this, OPT_DATE_FORMAT_STRING));
        String file_name = String.valueOf(path) + "image" + "_" + date_format.format(date);
        OfflineRenderThread render_thread = new OfflineRenderThread(this, true, file_name);
        render_thread.start();
    }

    public final RenderSettings get_render_settings() {
        RenderSettings render_settings = new RenderSettings();
        render_settings.set_render_info(RenderInfoFactory.create_render_info());
        render_settings.set_segment_settings(this._tf_tab.get_segment_settings());
        render_settings.set_lighting_settings(this._lighting_tab.get_lighting_settings());
        Transform3D view_transform = new Transform3D();
        MasterControl.get_v3d().get_view_transform(view_transform);
        render_settings.set_view_transform(view_transform);
        Transform3D world_transform = new Transform3D();
        MasterControl.get_v3d().get_world_transform(world_transform);
        render_settings.set_world_transform(world_transform);
        render_settings.set_filter_settings(this._render_tab.get_filter_settings());
        render_settings.set_light_transform(MasterControl.get_v3d().get_data_to_light_transform(null));
        render_settings.set_width(Settings.get_int_option(this, OPT_IMG_WIDTH));
        render_settings.set_height(Settings.get_int_option(this, OPT_IMG_HEIGHT));
        render_settings.set_sampling_rate(Settings.get_double_option(this, OPT_SAMPLING_RATE).floatValue());
        render_settings.set_ray_termination(Settings.get_double_option(this, OPT_RAY_TERM).floatValue());
        render_settings.set_thread_count(Settings.get_int_option(this, OPT_THREAD_COUNT));
        render_settings.set_use_octree(Settings.get_bool_option(this, OPT_USE_OCTREE));
        render_settings.set_use_transparency(Settings.get_bool_option(TransferFunctionTab.class, TransferFunctionTab.OPT_USE_TRANSPARENCY));
        render_settings.set_background_color(Settings.get_color_option(Viewport3d.class, Viewport3d.OPT_BG_COLOR));
        return render_settings;
    }

    private void load_render_settings() {
        String start_dir = Settings.get_str_option(this, OPT_RESULT_DIR);
        JFileChooser chooser = new JFileChooser(start_dir);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "Render settings file (*.xml)";
            }
        });
        int dialog_return = chooser.showOpenDialog(null);
        if (dialog_return == 0) {
            File file = chooser.getSelectedFile();
            RenderSettings render_settings = null;
            try {
                FileReader fileReader = new FileReader(file);
                render_settings = RenderSettingsIO.read(fileReader);
            }
            catch (Exception e) {
                System.err.println("ToolOfflineRenderer: Problems while parsing '" + file.getAbsolutePath() + "'");
                e.printStackTrace();
                return;
            }
            this.restore_settings(render_settings);
            System.out.println("ToolOfflineRenderer: Settings imported from '" + file.getName() + "'");
        }
    }

    private void restore_settings(RenderSettings render_settings) {
        Settings.set_int_option(this, OPT_IMG_WIDTH, render_settings.get_width());
        Settings.set_int_option(this, OPT_IMG_HEIGHT, render_settings.get_height());
        Settings.set_double_option(this, OPT_SAMPLING_RATE, Double.valueOf(render_settings.get_sampling_rate()));
        Settings.set_double_option(this, OPT_RAY_TERM, Double.valueOf(render_settings.get_ray_termination()));
        Settings.set_bool_option(this, OPT_USE_OCTREE, render_settings.is_use_octree());
        Settings.set_class_color_option(Viewport3d.class, Viewport3d.OPT_BG_COLOR, render_settings.get_background_color());
        Settings.set_class_bool_option(TransferFunctionTab.class, TransferFunctionTab.OPT_USE_TRANSPARENCY, render_settings.is_use_transparency());
        Settings.set_class_enum_option(TransferFunctionTab.class, TransferFunctionTab.OPT_SEGMENT_TF_MERGE_MODE, render_settings.get_segment_settings().get_segment_tf_merge_mode());
        this._render_tab.set_filter_settings(render_settings.get_filter_settings());
        this._lighting_tab.set_lighting_settings(render_settings.get_lighting_settings());
        this._tf_tab.set_segment_settings(render_settings.get_segment_settings());
        MasterControl.get_v3d().set_view_transform(render_settings.get_view_transform());
        MasterControl.get_v3d().set_world_transform(render_settings.get_world_transform());
    }

    public static final void write_image(BufferedImage bimg, String image_file_name) {
        File image_file;
        File parent_dir;
        if (!image_file_name.endsWith(".png")) {
            image_file_name = String.valueOf(image_file_name) + ".png";
        }
        if ((parent_dir = (image_file = new File(image_file_name)).getParentFile()) != null && !parent_dir.isDirectory()) {
            if (parent_dir.mkdirs()) {
                System.out.println("ToolOfflineRenderer: Created directory '" + parent_dir.getPath() + "'.");
            } else {
                System.err.println("ToolOfflineRenderer: Failed to create directory '" + parent_dir.getPath() + "'.\nImage is not saved.");
                return;
            }
        }
        try {
            ImageIO.write((RenderedImage)bimg, "png", image_file);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            System.err.println("ToolOfflineRenderer: Image not written to file '" + image_file_name + "'");
            return;
        }
        System.out.println("ToolOfflineRenderer: Image written to file '" + image_file_name + "'");
    }

    public static final void write_settings(RenderSettings render_settings, long time_ms, String settings_file_name) {
        if (!settings_file_name.endsWith(".xml")) {
            settings_file_name = String.valueOf(settings_file_name) + "_settings.xml";
        }
        try {
            RenderSettingsIO.write(new FileWriter(new File(settings_file_name)), render_settings, time_ms);
            System.out.println("ToolOfflineRenderer: Settings written to file '" + settings_file_name + "'");
        }
        catch (Exception e) {
            System.out.println("ToolOfflineRenderer: Could not write Settings to file " + settings_file_name);
            e.printStackTrace();
        }
    }

    @Override
    public final void update(YObservable o, Message m) {
        if (m._obj instanceof SegmentColorTableMap) {
            BGImageRenderer2d bgir;
            if (Settings.get_bool_option(this, OPT_UPDATE_TR2D).booleanValue()) {
                bgir = MasterControl.get_v3d().get_tex2_renderer().get_image_renderer();
                bgir.set_color_table_map((SegmentColorTableMap)m._obj);
            }
            if (Settings.get_bool_option(this, OPT_UPDATE_TR3D).booleanValue()) {
                bgir = MasterControl.get_v3d().get_tex3_renderer().get_image_renderer();
                bgir.set_color_table_map((SegmentColorTableMap)m._obj);
            }
        }
    }

    @Override
    public final String get_name() {
        return this._name;
    }

    @Override
    public final void settings_changed(Object obj, String opt_name, Object opt) {
    }

    @Override
    public void create_gui() {
        Settings.register_owner(this);
        this._jb_render = new JButton("render :)");
        this._jb_render.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolRayCasting.this.start_rendering();
            }
        });
        this._jb_load_settings = new JButton("load settings");
        this._jb_load_settings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolRayCasting.this.load_render_settings();
            }
        });
        this._jiotf_width = new JIntegerOptionTextfield(this, OPT_IMG_WIDTH, 5);
        this._jiotf_height = new JIntegerOptionTextfield(this, OPT_IMG_HEIGHT, 5);
        this._jiotfs_threads = new JIntegerOptionTextfield(this, OPT_THREAD_COUNT, 2);
        this._lighting_tab = new LightingTab();
        this._sequence_tab = new SequenceTab(this);
        RayCasterGuiInitializer initializer = new RayCasterGuiInitializer(this);
        this._render_tab = initializer.get_render_options_tab();
        this._tf_tab = initializer.get_transfer_function_tab();
        this._tf_tab.add_transfer_function_observer(this);
        this._segment_option_tab = initializer.get_segment_options_tab();
        this._jtp.addTab("Control", null, (Component)((Object)this._render_tab), "Render settings");
        this._jtp.addTab("Transfer Function", null, (Component)((Object)this._tf_tab), "Edit the transfer function");
        this._jtp.addTab("Segment Options", null, (Component)((Object)this._segment_option_tab), "Edit segment options");
        this._jtp.addTab("Lighting", null, (Component)((Object)this._lighting_tab), "Control Lighting Settings");
        this._jtp.addTab("Sequence", null, (Component)((Object)this._sequence_tab), "Record and render a sequence of images");
        this.add_plugin_tabs(YModuleType.RAYCASTING);
        this._jtp.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.gray));
        GMPanel yp_settings = new GMPanel();
        yp_settings.setBorder((Border)BorderFactory.createMatteBorder(1, 1, 1, 1, Color.gray));
        yp_settings.add("_jiotf_width", (JComponent)this._jiotf_width);
        yp_settings.add("_jiotf_height", (JComponent)this._jiotf_height);
        yp_settings.add("_jiotfs_threads", (JComponent)this._jiotfs_threads);
        yp_settings.add("_jb_render", (JComponent)this._jb_render);
        yp_settings.add("_jb_load_settings", (JComponent)this._jb_load_settings);
        yp_settings.set_layout("<table>  <tr>    <td colspan='2' fill='horizontal'>::_jb_render::</td>  </tr><tr>    <td colspan='2' fill='horizontal'>::_jb_load_settings::</td>  </tr><tr>    <td anchor='east'>threads:</td>    <td anchor='west'>::_jiotfs_threads::</td>  </tr><tr>    <td anchor='east'>width:</td>    <td anchor='west'>::_jiotf_width::</td>  </tr><tr>    <td anchor='east'>height:</td>    <td anchor='west'>::_jiotf_height::</td>  </tr></table>");
        this.add("_jtp", this._jtp);
        this.add("yp_settings", (JComponent)yp_settings);
        this.set_layout("<table width='100%' height='100%'>  <tr anchor='north'>    <td width='1%' fill='both'>::yp_settings::</td>    <td width='99%' fill='both'>::_jtp::</td>  </tr></table>");
        this._gui_created = true;
    }

    @Override
    public boolean gui_created() {
        return this._gui_created;
    }

    public final class OfflineRenderThread
    extends RSThread {
        private final String _file_name;
        private final RenderSettings _render_settings;
        private RayCastingRenderer _renderer;

        public OfflineRenderThread(SettingsOwner parent, boolean monitor, String file_name) {
            super(parent, monitor, true);
            this._file_name = file_name;
            this._render_settings = ToolRayCasting.this.get_render_settings();
            this._renderer = null;
        }

        @Override
        public final void my_run() {
            BufferedImage bimg = new BufferedImage(this._render_settings.get_width(), this._render_settings.get_height(), 2);
            MasterControl.get_status_bar().set_stopable(this);
            RenderResultWindow live_view = new RenderResultWindow(ToolRayCasting.this._tool_instance, bimg, this._file_name, this._render_settings);
            ImageStack is = MasterControl.get_is();
            is.send_message(new Message(M_RENDERING_STARTED, null));
            this._renderer = new RayCastingRenderer(this._render_settings, MasterControl.get_is().get_voxel_cube());
            int[] img_data = ((DataBufferInt)bimg.getRaster().getDataBuffer()).getData();
            StopWatch sw = new StopWatch(true);
            this._renderer.render(img_data, live_view, this);
            sw.stop();
            if (!this._stop_soon) {
                System.out.println("ToolOfflineRenderer: Image rendered in " + sw);
                live_view.repaint();
                if (Settings.get_bool_option(ToolRayCasting.this._tool_instance, OPT_AUTO_SAVE).booleanValue()) {
                    ToolRayCasting.write_image(bimg, this._file_name);
                    ToolRayCasting.write_settings(this._render_settings, sw.get_ms(), this._file_name);
                }
            }
            is.send_message(new Message(M_RENDERING_ENDED, null));
        }

        @Override
        public final void stop_soon() {
            if (this._renderer != null) {
                this._renderer.stop_soon();
            }
            super.stop_soon();
        }
    }
}

