/*
 * Decompiled with CFR 0.152.
 */
package main.tools;

import gui.LazyInitComponent;
import gui.MyToolbar;
import gui.SegDialog;
import gui.SegSelector;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import jgridmaker.GMPanel;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.Segment;
import main.YDialogs;
import main.seggen.SegGenActiveContour;
import main.seggen.SegGenAtlas;
import main.seggen.SegGenBitOps;
import main.seggen.SegGenBoundingBox;
import main.seggen.SegGenConnect;
import main.seggen.SegGenEdge;
import main.seggen.SegGenManual;
import main.seggen.SegGenRange;
import main.seggen.SegGenRegionGrow;
import main.seggen.SegGenSimpleGeo;
import main.seggen.SegGenYDM;
import main.tools.ToolBox;
import main.view2d.Viewport2d;
import main.view2d.Viewport2dModel;
import misc.grid.BitCube;
import misc.helper.Helper;
import misc.helper.MeasuringTools;
import misc.messages.YObservable;
import misc.messages.YObserverWantsAWTThread;
import renderer.SegRenderer3d;
import yplugins.YModuleType;

public final class ToolSegGen
extends ToolBox
implements LazyInitComponent {
    public static String TMP_SEG_NAME = "_tmp";
    private Segment _seg_tmp;
    private Segment _seg;
    private SegSelector _seg_sel;
    private boolean _gui_created = false;

    @Override
    public void create_gui() {
        this._seg_sel = new SegSelector("Select Segment");
        ImageStack is = MasterControl.get_is();
        SegTools seg_tools = new SegTools();
        SegCopyToolBar seg_copy = new SegCopyToolBar();
        SegEditModeToolBar seg_clear = new SegEditModeToolBar();
        this._seg_tmp = is.get_segment(TMP_SEG_NAME);
        SegGenRange selgen_range = new SegGenRange(this._seg_tmp);
        SegGenRegionGrow selgen_region = new SegGenRegionGrow(this._seg_tmp);
        SegGenEdge selgen_edge = new SegGenEdge(this._seg_tmp);
        SegGenActiveContour selgen_ac = new SegGenActiveContour(this._seg_tmp);
        SegGenAtlas selgen_atlas = new SegGenAtlas(this._seg_tmp);
        SegGenSimpleGeo selgen_simple_geo = new SegGenSimpleGeo(this._seg_tmp);
        SegGenManual selgen_manual = new SegGenManual(this._seg_tmp);
        SegGenBoundingBox selgen_bb = new SegGenBoundingBox(this._seg_tmp);
        SegGenBitOps selgen_bit_ops = new SegGenBitOps(this._seg_tmp);
        SegGenConnect selgen_connect_ops = new SegGenConnect(this._seg_tmp);
        SegGenYDM selgen_ydm = SegGenYDM.getInstance();
        this._jtp.addTab("range", null, (Component)((Object)selgen_range), "Creates min-max based range selections");
        this._jtp.addTab("region", null, (Component)((Object)selgen_region), "Creates region grow based selections");
        this._jtp.addTab("edge", null, (Component)((Object)selgen_edge), "Contains active contour segmentation methods");
        this._jtp.addTab("levelset", null, (Component)((Object)selgen_ac), "Contains active contour segmentation methods");
        this._jtp.addTab("atlas", null, (Component)((Object)selgen_atlas), "Creates atlas based segmentation");
        this._jtp.addTab("ydmf", null, (Component)((Object)selgen_ydm), "Contains segmentations methods based on the YaDiV Deformable Model Framework");
        this._jtp.addTab("geo", null, (Component)((Object)selgen_simple_geo), "Creates simple geometric selections (circle, box, ...)");
        this._jtp.addTab("manual", null, (Component)((Object)selgen_manual), "Allows free user input");
        this._jtp.addTab("bit ops", null, (Component)((Object)selgen_bit_ops), "Allows different operations like shrink, grow, invert, ...");
        this._jtp.addTab("connect", null, (Component)((Object)selgen_connect_ops), "Connectivity Operations");
        this._jtp.addTab("bbox", null, (Component)((Object)selgen_bb), "Specifies the bounding box used for segmentation");
        this.add_plugin_tabs(YModuleType.SEGMENTING);
        this.add("_seg_tools", (JComponent)((Object)seg_tools));
        this.add("seg_copy", seg_copy);
        this.add("seg_clear", seg_clear);
        this.add("tabbed_pane", this._jtp);
        this.set_layout("<table width='100%' height='100%' cellpadding='0' margin='0' border='0'>  <tr>    <td width='1%' fill='both'>::_seg_tools::</td>    <td width='1%'>::seg_copy::</td>    <td width='97%' fill='both'>::tabbed_pane::</td>    <td width='1%'>::seg_clear::</td>  </tr></table>");
        this._gui_created = true;
    }

    @Override
    public boolean gui_created() {
        return this._gui_created;
    }

    private final class SegCopyToolBar
    extends MyToolbar {
        public SegCopyToolBar() {
            this.setOrientation(1);
            AbstractAction seg_plus = new AbstractAction("Plus", new ImageIcon("resources/gfx/seg_plus.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if ((e.getModifiers() & 2) == 0) {
                        if (ToolSegGen.this._seg != null) {
                            ToolSegGen.this._seg.add_seg(ToolSegGen.this._seg_tmp);
                        } else {
                            YDialogs.notify_user("Select a segment first");
                        }
                    } else {
                        ImageStack is = MasterControl.get_is();
                        int seg_num = is.get_segment_number();
                        if (seg_num < SegDialog.MAX_SEG_NUM) {
                            is.create_segment(Helper.get_unique_key("Seg", is.get_seg_map().keySet()), SegDialog.DEF_COLORS[seg_num - 1]);
                            ToolSegGen.this._seg_sel.setSelectedIndex(seg_num - 1);
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        SwingUtilities.invokeAndWait(new Runnable(){

                                            @Override
                                            public void run() {
                                                Segment new_seg = ToolSegGen.this._seg_sel.get_selected_segment();
                                                new_seg.add_seg(ToolSegGen.this._seg_tmp);
                                                SegRenderer3d renderer = MasterControl.get_v3d().get_seg_renderer(new_seg);
                                                renderer.set_visible(true);
                                            }
                                        });
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                    catch (InvocationTargetException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }).start();
                        }
                    }
                }
            };
            AbstractAction seg_minus = new AbstractAction("Minus", new ImageIcon("resources/gfx/seg_minus.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ToolSegGen.this._seg != null) {
                        ToolSegGen.this._seg.rem_seg(ToolSegGen.this._seg_tmp);
                    } else {
                        YDialogs.notify_user("Select a segment first");
                    }
                }
            };
            AbstractAction copy_left = new AbstractAction("Copy Left", new ImageIcon("resources/gfx/arrow_left.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ToolSegGen.this._seg != null) {
                        ToolSegGen.this._seg.copy_data_from(ToolSegGen.this._seg_tmp);
                    } else {
                        YDialogs.notify_user("Select a segment first");
                    }
                }
            };
            AbstractAction copy_right = new AbstractAction("Copy Right", new ImageIcon("resources/gfx/arrow_right.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ToolSegGen.this._seg != null) {
                        ToolSegGen.this._seg_tmp.copy_data_from(ToolSegGen.this._seg);
                    } else {
                        YDialogs.notify_user("Select a segment first");
                    }
                }
            };
            this.add_button(seg_plus, "Add selection");
            this.add_button(seg_minus, "Remove selection");
            this.add_button(copy_left, "Replace segment");
            this.add_button(copy_right, "Replace Selection");
        }
    }

    private final class SegEditModeToolBar
    extends MyToolbar
    implements YObserverWantsAWTThread {
        private JToggleButton _seed;
        private JToggleButton _draw;
        private JToggleButton _erase;
        private JToggleButton _translate;
        private JToggleButton _bb;

        public SegEditModeToolBar() {
            this.setOrientation(1);
            AbstractAction mode_xyz = new AbstractAction("Mode Select XYZ", new ImageIcon("resources/gfx/mode_xyz.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Viewport2d v2d = MasterControl.get_v2d();
                    v2d.setInteractionListener(v2d.seed_listener);
                }
            };
            AbstractAction mode_draw = new AbstractAction("Mode Draw", new ImageIcon("resources/gfx/mode_draw.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Viewport2d v2d = MasterControl.get_v2d();
                    v2d.setInteractionListener(v2d._draw_seg_listener);
                }
            };
            AbstractAction mode_erase = new AbstractAction("Mode Erase", new ImageIcon("resources/gfx/mode_clear.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Viewport2d v2d = MasterControl.get_v2d();
                    v2d.setInteractionListener(v2d._erase_seg_listener);
                }
            };
            AbstractAction mode_trans = new AbstractAction("Mode Translate", new ImageIcon("resources/gfx/mode_trans.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Viewport2d v2d = MasterControl.get_v2d();
                    v2d.setInteractionListener(v2d._translate_seg_listener);
                }
            };
            AbstractAction seg_clear3d = new AbstractAction("Clear3d", new ImageIcon("resources/gfx/seg_clear3d.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BitCube bc = ToolSegGen.this._seg_tmp.get_bc();
                    bc.clear();
                    ToolSegGen.this._seg_tmp.new_data(false);
                }
            };
            AbstractAction seg_clear2d = new AbstractAction("Clear2d", new ImageIcon("resources/gfx/seg_clear2d.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Viewport2dModel v2d_model = MasterControl.get_v2d().get_model();
                    BitCube bc = ToolSegGen.this._seg_tmp.get_bc();
                    bc.clear_plane(v2d_model.get_view_mode(), v2d_model.get_active_image());
                    ToolSegGen.this._seg_tmp.new_data(true);
                }
            };
            AbstractAction seg_gen_bb = new AbstractAction("BB Selection", new ImageIcon("resources/gfx/mode_bb.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Viewport2d v2d = MasterControl.get_v2d();
                    v2d.setInteractionListener(v2d._bbox_listener);
                }
            };
            Viewport2d v2d = MasterControl.get_v2d();
            this._seed = this.add_toggle_button(mode_xyz, "Select Seed(s)", v2d.get_model().getActiveInteractionListener() == v2d.seed_listener);
            this._draw = this.add_toggle_button(mode_draw, "<html>Draw <p> Hold control key to temporarily switch to erase mode while using the mouse", v2d.get_model().getActiveInteractionListener() == v2d._draw_seg_listener);
            this._erase = this.add_toggle_button(mode_erase, "<html>Erase<p> Hold control key to temporarily switch to draw mode while using the mouse", v2d.get_model().getActiveInteractionListener() == v2d._erase_seg_listener);
            this._translate = this.add_toggle_button(mode_trans, "Translate", v2d.get_model().getActiveInteractionListener() == v2d._translate_seg_listener);
            this._bb = this.add_toggle_button(seg_gen_bb, "Change Bounding Box", v2d.get_model().getActiveInteractionListener() == v2d._bbox_listener);
            this.addSeparator();
            this.add_button(seg_clear2d, "Clear 2d Selection");
            this.add_button(seg_clear3d, "Clear 3d Selection");
            MasterControl.get_v2d().get_model().addObserver(this, "Viewport2dModel.ML_CHANGED");
        }

        @Override
        public void update(YObservable sender, Message m) {
            if (m._type == Viewport2dModel.M_V2D_INTERACTIONLISTENER_CHANGED) {
                Viewport2d v2d = MasterControl.get_v2d();
                this._seed.setSelected(false);
                this._draw.setSelected(false);
                this._erase.setSelected(false);
                this._translate.setSelected(false);
                if (m._obj == v2d.seed_listener) {
                    this._seed.setSelected(true);
                } else if (m._obj == v2d._draw_seg_listener) {
                    this._draw.setSelected(true);
                } else if (m._obj == v2d._erase_seg_listener) {
                    this._erase.setSelected(true);
                } else if (m._obj == v2d._translate_seg_listener) {
                    this._translate.setSelected(true);
                } else if (m._obj == v2d._bbox_listener) {
                    this._bb.setSelected(true);
                }
            }
        }
    }

    private final class SegTools
    extends GMPanel
    implements YObserverWantsAWTThread {
        private final SegTools _instance;
        private final JLabel _jl_volume = new JLabel("Volume: ---");

        public SegTools() {
            this._instance = this;
            MasterControl.get_is().addObserver(this, "SegTools()");
            ToolSegGen.this._seg_sel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String property = propertyChangeEvent.getPropertyName();
                    if (SegSelector.SEG_SELECTION_CHANGED.equals(property)) {
                        if (ToolSegGen.this._seg != null) {
                            ToolSegGen.this._seg.deleteObserver(SegTools.this._instance);
                        }
                        ToolSegGen.this._seg = ToolSegGen.this._seg_sel.get_selected_segment();
                        if (ToolSegGen.this._seg != null) {
                            ToolSegGen.this._seg.addObserver(SegTools.this._instance, "_seg_sel.propertyChange");
                            SegTools.this.update_volume_label();
                        }
                    }
                }
            });
            MyToolbar tool_bar = new MyToolbar();
            tool_bar.setOrientation(0);
            AbstractAction seg_new = new AbstractAction("New", new ImageIcon("resources/gfx/seg_new.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if ((e.getModifiers() & 1) != 0) {
                        ImageStack is = MasterControl.get_is();
                        int seg_num = is.get_segment_number();
                        if (seg_num < SegDialog.MAX_SEG_NUM) {
                            is.create_segment(Helper.get_unique_key("Seg", is.get_seg_map().keySet()), SegDialog.DEF_COLORS[seg_num - 1]);
                            ToolSegGen.this._seg_sel.setSelectedIndex(seg_num - 1);
                        }
                    } else {
                        YDialogs.new_seg_dialog(null);
                    }
                }
            };
            AbstractAction seg_load = new AbstractAction("Load", new ImageIcon("resources/gfx/seg_load.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    YDialogs.load_seg_dialog();
                }
            };
            AbstractAction seg_save = new AbstractAction("Save", new ImageIcon("resources/gfx/seg_save.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ToolSegGen.this._seg != null) {
                        YDialogs.save_seg_dialog(ToolSegGen.this._seg);
                    } else {
                        YDialogs.notify_user("Select a segment first");
                    }
                }
            };
            AbstractAction seg_edit = new AbstractAction("Edit", new ImageIcon("resources/gfx/seg_edit.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ToolSegGen.this._seg != null) {
                        YDialogs.new_seg_dialog(ToolSegGen.this._seg);
                    } else {
                        YDialogs.notify_user("Select a segment first");
                    }
                }
            };
            AbstractAction seg_del = new AbstractAction("Del", new ImageIcon("resources/gfx/seg_delete.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ToolSegGen.this._seg != null) {
                        YDialogs.seg_del_dialog(ToolSegGen.this._seg);
                    } else {
                        YDialogs.notify_user("Select a segment first");
                    }
                }
            };
            tool_bar.add_button(seg_new, "New segment");
            tool_bar.add_button(seg_load, "Load segment");
            tool_bar.add_button(seg_save, "Save selected segment");
            tool_bar.add_button(seg_edit, "Edit selected segment");
            tool_bar.add_button(seg_del, "Delete selected segment");
            this.add("_seg_sel", ToolSegGen.this._seg_sel);
            this.add("tool_bar", tool_bar);
            this.add("_jl_volume", this._jl_volume);
            this.set_layout("<table width='100%' height='100%' cellpadding='2' margin='0' border='0'>  <colgroup>    <col width='1%' />    <col width='1%' />    <col width='98%' />  </colgroup>  <tr height='98%'>    <td fill='both'>::_seg_sel::</td>  </tr><tr height='1%'>    <td>::tool_bar::</td>  </tr><tr height='1%'>    <td>::_jl_volume::</td>  </tr></table>");
        }

        private final void update_volume_label() {
            double volume = MeasuringTools.calc_seg_volume(ToolSegGen.this._seg);
            this._jl_volume.setText("Volume: " + MeasuringTools.get_volume_string(volume));
        }

        private void clear_volume_label() {
            this._jl_volume.setText("Volume: ---");
        }

        @Override
        public void update(YObservable o, Message m) {
            if (m._type == Segment.M_SEG_CHANGED) {
                this.update_volume_label();
            }
            if (m._type == ImageStack.M_LOADING_END) {
                this.clear_volume_label();
            }
        }
    }
}

