/*
 * Decompiled with CFR 0.152.
 */
package main.tools;

import gui.GeoMarkerShowTable;
import gui.LazyInitComponent;
import gui.SegSelector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import jgridmaker.GMPanel;
import main.MasterControl;
import main.Segment;
import main.tools.ToolBox;
import main.tools.ToolLighting;
import main.tools.ToolSegGen;
import main.view3d.Viewport3d;
import renderer.BBoxRenderer3d;
import renderer.BGImageRenderer2d;
import renderer.SegRenderer3d;
import renderer.Tex2Renderer3d;
import renderer.Tex3Renderer3d;
import settings.JBoolOptionCheckbox;
import settings.JColorOption;
import settings.JDoubleOptionTFSlider;
import settings.JEnumOptionComboBox;
import settings.JIntegerOptionSpinner;
import settings.JIntegerOptionTFSlider;
import settings.JIntegerOptionTextfield;
import settings.Settings;
import settings.SettingsListener;
import yplugins.YModuleType;

public final class ToolView3d
extends ToolBox
implements LazyInitComponent {
    private boolean _gui_created;
    private final ToolLighting _tool_lighting = new ToolLighting();

    public ToolView3d() {
        this._tool_lighting.initialize();
        this._gui_created = false;
    }

    @Override
    public void create_gui() {
        this._jtp.addTab("segments", null, (Component)((Object)new SegViewingOptions()), "Segment Rendering");
        this._jtp.addTab("marker", null, (Component)((Object)new MarkerViewingOptions()), "Marker Rendering");
        this._jtp.addTab("volume", null, (Component)((Object)new TexOptions()), "Texture Rendering");
        this._jtp.addTab("slice planes", null, (Component)((Object)new SlicePlaneOptions()), "Slice Plane Rendering");
        this._jtp.addTab("lights", null, this._tool_lighting, "Light Settings");
        this._jtp.addTab("misc", null, (Component)((Object)new MiscOptions()), "Miscellaneous Settings");
        this.add_plugin_tabs(YModuleType.VIEW3D);
        this.setLayout(new BorderLayout());
        this.add(this._jtp, "Center");
        this._gui_created = true;
    }

    @Override
    public boolean gui_created() {
        return this._gui_created;
    }

    private final class MarkerViewingOptions
    extends GMPanel
    implements LazyInitComponent {
        private GeoMarkerShowTable _gm_show_table;

        @Override
        public void create_gui() {
            this._gm_show_table = new GeoMarkerShowTable(MasterControl.get_v3d().get_marker_renderer());
            this.add("_gm_show_table", this._gm_show_table);
            this.set_layout("<table cellpadding='2' border='0' width='100%' height='100%'>  <tr>    <td fill='vertical'>::_gm_show_table::</td>  </tr></table>");
        }

        @Override
        public boolean gui_created() {
            return this._gm_show_table != null;
        }
    }

    private final class MiscOptions
    extends GMPanel {
        private final JBoolOptionCheckbox _jbcb_show_fog;
        private final JDoubleOptionTFSlider _jtf_foginess = new JDoubleOptionTFSlider(Viewport3d.class, Viewport3d.OPT_FOGGINESS, 0.0, 1.0);
        private final JBoolOptionCheckbox _jco_stereo_mode;
        private final JDoubleOptionTFSlider _jtf_stereo_eye_dist;
        private final JColorOption _jco_bg;
        private final JBoolOptionCheckbox _jbcb_bb_show;

        public MiscOptions() {
            this._jbcb_show_fog = new JBoolOptionCheckbox(Viewport3d.class, Viewport3d.OPT_FOG_SHOW);
            this._jco_bg = new JColorOption(Viewport3d.class, Viewport3d.OPT_BG_COLOR);
            this._jco_stereo_mode = new JBoolOptionCheckbox(Viewport3d.class, Viewport3d.OPT_STEREO);
            this._jtf_stereo_eye_dist = new JDoubleOptionTFSlider(Viewport3d.class, Viewport3d.OPT_STEREO_EYE_DIST, -0.2, 0.2);
            this._jbcb_bb_show = new JBoolOptionCheckbox(BBoxRenderer3d.class, BBoxRenderer3d.OPT_VISIBLE);
            GMPanel gm_fog = new GMPanel();
            gm_fog.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Fog", 2, 2));
            gm_fog.add("_jtf_foginess", (JComponent)this._jtf_foginess);
            gm_fog.add("_cb_show_fog", (JComponent)this._jbcb_show_fog);
            gm_fog.set_layout("<table>  <tr>    <td>Fogginess:</td>    <td>::_jtf_foginess::</td>  </tr><tr>    <td colspan='2'>::_cb_show_fog::</td>  </tr></table>");
            GMPanel gm_bg = new GMPanel();
            gm_bg.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Background", 2, 2));
            gm_bg.add("_jco_bg", (JComponent)this._jco_bg);
            gm_bg.set_layout("<table cellpadding='2' border='0'>  <tr>    <td>::_jco_bg::</td>  </tr></table>");
            GMPanel gm_bounding_box = new GMPanel();
            gm_bounding_box.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Volume Box", 2, 2));
            gm_bounding_box.add("_jbcb_bb_show", (JComponent)this._jbcb_bb_show);
            gm_bounding_box.set_layout("<table cellpadding='2' border='0' width='100%'>  <tr>    <td>::_jbcb_bb_show::</td>  </tr></table>");
            GMPanel gm_stereo = new GMPanel();
            gm_stereo.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Stereo View", 2, 2));
            gm_stereo.add("_jco_stereo_mode", (JComponent)this._jco_stereo_mode);
            gm_stereo.add("_jtf_stereo_eye_dist", (JComponent)this._jtf_stereo_eye_dist);
            gm_stereo.set_layout("<table cellpadding='2' border='0' width='100%'>  <tr>    <td width='99%' fill='horizontal'>::_jtf_stereo_eye_dist::</td>    <td width='1%'>::_jco_stereo_mode::</td>  </tr></table>");
            if (!MasterControl.get_v3d().get_stereo_available()) {
                gm_stereo.setEnabled(false);
            }
            this.add("gm_fog", (JComponent)gm_fog);
            this.add("gm_bg", (JComponent)gm_bg);
            this.add("gm_bounding_box", (JComponent)gm_bounding_box);
            this.add("gm_stereo", (JComponent)gm_stereo);
            this.set_layout("<table cellpadding='2' border='0' width='100%' height='100%'>  <tr>    <td fill='both'>::gm_fog::</td>    <td fill='both'>::gm_bg::</td>    <td fill='both'>::gm_bounding_box::</td>  </tr><tr>    <td fill='both' colspan='3'>::gm_stereo::</td>  </tr></table>");
        }
    }

    private final class SegViewingOptions
    extends GMPanel
    implements SettingsListener,
    LazyInitComponent {
        private SegSelector _seg_sel;
        private JBoolOptionCheckbox _jbocb_show_seg;
        private JBoolOptionCheckbox _jbocb_show_points;
        private JIntegerOptionSpinner _jiot_point_dist;
        private JIntegerOptionTFSlider _jiotfs_point_size;
        private JDoubleOptionTFSlider _jdotfs_point_transparency;
        private JBoolOptionCheckbox _jbocb_show_tex2;
        private JBoolOptionCheckbox _jbocb_show_tex3;
        private JBoolOptionCheckbox _jbocb_show_mc;
        private JIntegerOptionTextfield _jiotf_mc_smooth;
        private JBoolOptionCheckbox _jbocb_mc_closing;
        private JBoolOptionCheckbox _jbocbmc_wire;
        private SegRenderer3d _sr3d;
        private GMPanel _gmp_seg_options;
        private GMPanel _gmp_seg_mc_options;
        private GMPanel _gmp_seg_pc_options;
        private GMPanel _gmp_seg_tex_options;
        private GMPanel _gmp_seg_sel;

        public void update() {
            this._gmp_seg_options.setEnabled(this._sr3d != null);
            if (this._sr3d != null) {
                this._jbocb_show_seg.setSelected(Settings.get_bool_option(this._sr3d, SegRenderer3d.OPT_VISIBLE));
                this._jbocb_show_points.setSelected(Settings.get_bool_option(this._sr3d, SegRenderer3d.OPT_SHOW_POINTS));
                this._jbocb_show_mc.setSelected(Settings.get_bool_option(this._sr3d, SegRenderer3d.OPT_SHOW_MC));
                this._jbocb_show_tex2.setSelected(Settings.get_bool_option(this._sr3d, SegRenderer3d.OPT_SHOW_TEX2D));
                this._jbocb_show_tex3.setSelected(Settings.get_bool_option(this._sr3d, SegRenderer3d.OPT_SHOW_TEX3D));
            }
        }

        @Override
        public void settings_changed(Object obj, String opt_name, Object opt) {
            this.update();
        }

        @Override
        public void create_gui() {
            this._sr3d = null;
            this._seg_sel = new SegSelector();
            this._seg_sel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String property = propertyChangeEvent.getPropertyName();
                    if (SegSelector.SEG_SELECTION_CHANGED.equals(property)) {
                        Segment seg = SegViewingOptions.this._seg_sel.get_selected_segment();
                        SegViewingOptions.this._sr3d = MasterControl.get_v3d().get_seg_renderer(seg);
                        if (SegViewingOptions.this._sr3d != null) {
                            SegViewingOptions.this._jbocb_show_seg.set_owner_option(SegViewingOptions.this._sr3d, SegRenderer3d.OPT_VISIBLE);
                            SegViewingOptions.this._jbocb_show_seg.setText("Show " + seg.get_name());
                            SegViewingOptions.this._jbocb_show_mc.set_owner_option(SegViewingOptions.this._sr3d, SegRenderer3d.OPT_SHOW_MC);
                            SegViewingOptions.this._jiotf_mc_smooth.set_owner_option(SegViewingOptions.this._sr3d, SegRenderer3d.OPT_MC_SMOOTH);
                            SegViewingOptions.this._jbocb_mc_closing.set_owner_option(SegViewingOptions.this._sr3d, SegRenderer3d.OPT_MC_CLOSING);
                            SegViewingOptions.this._jbocbmc_wire.set_owner_option(SegViewingOptions.this._sr3d, SegRenderer3d.OPT_MC_WIREFRAME);
                            SegViewingOptions.this._jbocb_show_points.set_owner_option(SegViewingOptions.this._sr3d, SegRenderer3d.OPT_SHOW_POINTS);
                            SegViewingOptions.this._jiot_point_dist.set_owner_option(SegViewingOptions.this._sr3d, SegRenderer3d.OPT_POINT_DIST);
                            SegViewingOptions.this._jiotfs_point_size.set_owner_option(SegViewingOptions.this._sr3d, SegRenderer3d.OPT_POINT_SIZE);
                            SegViewingOptions.this._jdotfs_point_transparency.set_owner_option(SegViewingOptions.this._sr3d, SegRenderer3d.OPT_POINT_TRANS);
                            SegViewingOptions.this._jbocb_show_tex2.set_owner_option(SegViewingOptions.this._sr3d, SegRenderer3d.OPT_SHOW_TEX2D);
                            SegViewingOptions.this._jbocb_show_tex3.set_owner_option(SegViewingOptions.this._sr3d, SegRenderer3d.OPT_SHOW_TEX3D);
                        }
                        SegViewingOptions.this.update();
                    }
                }
            });
            Segment tmp_seg = MasterControl.get_is().get_segment(ToolSegGen.TMP_SEG_NAME);
            this._sr3d = MasterControl.get_v3d().get_seg_renderer(tmp_seg);
            this._jbocb_show_seg = new JBoolOptionCheckbox(this._sr3d, SegRenderer3d.OPT_VISIBLE);
            this._jbocb_show_seg.setText("---");
            this._gmp_seg_sel = new GMPanel();
            this._gmp_seg_sel.add("_seg_sel", (JComponent)this._seg_sel);
            this._gmp_seg_sel.set_layout("<table cellpadding='0' border='0' width='100%' height='100%'>  <tr height='1%'>    <td>Select segment</td>  </tr><tr height='98%'>    <td fill='both'>::_seg_sel::</td>  </tr></table>");
            this._jbocb_show_mc = new JBoolOptionCheckbox(this._sr3d, SegRenderer3d.OPT_SHOW_MC);
            this._jiotf_mc_smooth = new JIntegerOptionTextfield(this._sr3d, SegRenderer3d.OPT_MC_SMOOTH, 3);
            this._jbocb_mc_closing = new JBoolOptionCheckbox(this._sr3d, SegRenderer3d.OPT_MC_CLOSING);
            this._jbocbmc_wire = new JBoolOptionCheckbox(this._sr3d, SegRenderer3d.OPT_MC_WIREFRAME);
            this._gmp_seg_mc_options = new GMPanel();
            this._gmp_seg_mc_options.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Marching Cube", 2, 2));
            this._gmp_seg_mc_options.add("_cb_show_mc", (JComponent)this._jbocb_show_mc);
            this._gmp_seg_mc_options.add("_jbocb_show_mc_closing", (JComponent)this._jbocb_mc_closing);
            this._gmp_seg_mc_options.add("_jiot_mc_smooth", (JComponent)this._jiotf_mc_smooth);
            this._gmp_seg_mc_options.add("_jbocbmc_wire", (JComponent)this._jbocbmc_wire);
            this._gmp_seg_mc_options.set_layout("<table cellpadding='0' border='0' width='100%'>  <tr>    <td colspan='2'>::_cb_show_mc::</td>  </tr><tr>    <td colspan='2'>::_jbocbmc_wire::</td>  </tr><tr>    <td colspan='2'>::_jbocb_show_mc_closing::</td>  </tr><tr>    <td anchor='east'>Smoothing Steps</td>    <td anchor='west'>::_jiot_mc_smooth::</td>  </tr></table>");
            this._jbocb_show_points = new JBoolOptionCheckbox(this._sr3d, SegRenderer3d.OPT_SHOW_POINTS);
            this._jiot_point_dist = new JIntegerOptionSpinner(this._sr3d, SegRenderer3d.OPT_POINT_DIST, 1, 10, 1);
            this._jdotfs_point_transparency = new JDoubleOptionTFSlider(this._sr3d, SegRenderer3d.OPT_POINT_TRANS, 0.0, 1.0);
            this._jiotfs_point_size = new JIntegerOptionTFSlider(this._sr3d, SegRenderer3d.OPT_POINT_SIZE, 1, 10);
            this._gmp_seg_pc_options = new GMPanel();
            this._gmp_seg_pc_options.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Point Cloud", 2, 2));
            this._gmp_seg_pc_options.add("_cb_show_points", (JComponent)this._jbocb_show_points);
            this._gmp_seg_pc_options.add("_jiot_point_dist", (JComponent)this._jiot_point_dist);
            this._gmp_seg_pc_options.add("_jdotfs_point_transparency", (JComponent)this._jdotfs_point_transparency);
            this._gmp_seg_pc_options.add("_jiotfs_point_size", (JComponent)this._jiotfs_point_size);
            this._gmp_seg_pc_options.set_layout("<table cellpadding='0' border='0' width='100%'>  <tr>    <td colspan='2'>::_cb_show_points::</td>  </tr><tr>    <td anchor='east'>Point Distance</td>    <td anchor='west'>::_jiot_point_dist::</td>  </tr><tr>    <td anchor='east'>Point Size</td>    <td anchor='west'>::_jiotfs_point_size::</td>  </tr><tr>    <td anchor='east'>Transparency</td>    <td anchor='west'>::_jdotfs_point_transparency::</td>  </tr></table>");
            this._jbocb_show_tex2 = new JBoolOptionCheckbox(this._sr3d, SegRenderer3d.OPT_SHOW_TEX2D);
            this._jbocb_show_tex3 = new JBoolOptionCheckbox(this._sr3d, SegRenderer3d.OPT_SHOW_TEX3D);
            this._gmp_seg_tex_options = new GMPanel();
            this._gmp_seg_tex_options.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Texture", 2, 2));
            this._gmp_seg_tex_options.add("_cb_show_tex2", (JComponent)this._jbocb_show_tex2);
            this._gmp_seg_tex_options.add("_cb_show_tex3", (JComponent)this._jbocb_show_tex3);
            this._gmp_seg_tex_options.set_layout("<table cellpadding='0' border='0' width='100%'>  <tr>    <td>::_cb_show_tex2::</td>  </tr><tr>    <td>::_cb_show_tex3::</td>  </tr></table>");
            this._gmp_seg_options = new GMPanel();
            this._gmp_seg_options.add("_cb_show_seg", (JComponent)this._jbocb_show_seg);
            this._gmp_seg_options.add("_yseg_mc_options", (JComponent)this._gmp_seg_mc_options);
            this._gmp_seg_options.add("_yseg_pc_options", (JComponent)this._gmp_seg_pc_options);
            this._gmp_seg_options.add("_yseg_tex_options", (JComponent)this._gmp_seg_tex_options);
            this._gmp_seg_options.set_layout("<table cellpadding='0' border='0' width='100%' height='100%'>  <tr>    <td>::_cb_show_seg::</td>    <td fill='both' rowspan='3'>::_yseg_pc_options::</td>  </tr><tr>    <td fill='both' anchor='north'>::_yseg_mc_options::</td>  </tr><tr>    <td fill='both'>::_yseg_tex_options::</td>  </tr></table>");
            this._gmp_seg_options.setEnabled(false);
            this.add("_gm_seg_sel", (JComponent)this._gmp_seg_sel);
            this.add("gm_options", (JComponent)this._gmp_seg_options);
            this.set_layout("<table cellpadding='2' border='0' width='100%' height='100%'>  <tr>    <td width='1%' fill='both'>::_gm_seg_sel::</td>    <td width='99%' fill='both'>::gm_options::</td>  </tr></table>");
        }

        @Override
        public boolean gui_created() {
            return this._seg_sel != null;
        }
    }

    private final class SlicePlaneOptions
    extends GMPanel {
        private final JBoolOptionCheckbox _cb_show_slice_plane = new JBoolOptionCheckbox(Tex2Renderer3d.class, Tex2Renderer3d.OPT_RENDER_PLANE);
        private final JBoolOptionCheckbox _cb_show_ortho_slices = new JBoolOptionCheckbox(Tex2Renderer3d.class, Tex2Renderer3d.OPT_RENDER_ORTHO);
        private final JDoubleOptionTFSlider _jtf_slice_plane_transparency = new JDoubleOptionTFSlider(Tex2Renderer3d.class, Tex2Renderer3d.OPT_PLANE_TRANS, 0.0, 1.0);
        private final JColorOption _jco_trans;
        private final JColorOption _jco_saggi;
        private final JColorOption _jco_front;

        public SlicePlaneOptions() {
            this._jtf_slice_plane_transparency.setValue(Settings.get_double_option(Tex2Renderer3d.class, Tex2Renderer3d.OPT_PLANE_TRANS));
            this._jco_trans = new JColorOption(Tex2Renderer3d.class, Tex2Renderer3d.OPT_PLANE_T_COLOR);
            this._jco_saggi = new JColorOption(Tex2Renderer3d.class, Tex2Renderer3d.OPT_PLANE_S_COLOR);
            this._jco_front = new JColorOption(Tex2Renderer3d.class, Tex2Renderer3d.OPT_PLANE_F_COLOR);
            GMPanel gm_show_options = new GMPanel();
            gm_show_options.add("_cb_show_slice_plane", (JComponent)this._cb_show_slice_plane);
            gm_show_options.add("_cb_show_ortho_slices", (JComponent)this._cb_show_ortho_slices);
            gm_show_options.set_layout("<table width='100%'>  <tr>    <td anchor='east'>::_cb_show_slice_plane::</td>  </tr><tr>    <td anchor='east'>::_cb_show_ortho_slices::</td>  </tr></table>");
            gm_show_options.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Visibility", 2, 2));
            GMPanel gm_plane_colors = new GMPanel();
            gm_plane_colors.add("_jco_trans", (JComponent)this._jco_trans);
            gm_plane_colors.add("_jco_saggi", (JComponent)this._jco_saggi);
            gm_plane_colors.add("_jco_front", (JComponent)this._jco_front);
            gm_plane_colors.add("_jtf_slice_plane_transparency", (JComponent)this._jtf_slice_plane_transparency);
            gm_plane_colors.set_layout("<table width='100%'>  <tr>    <td anchor='east'>Transversal</td>    <td anchor='west'>::_jco_trans::</td>    <td anchor='east'>Sagittal</td>    <td anchor='west'>::_jco_saggi::</td>    <td anchor='east'>Frontal</td>    <td anchor='west'>::_jco_front::</td>  </tr><tr>    <td colspan='6'>      <table width='100%'>        <tr>          <td width='1%'>Transparency</td>          <td width='99%' fill='horizontal'>::_jtf_slice_plane_transparency::</td>        </tr>      </table>    </td>  </tr></table>");
            gm_plane_colors.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Plane Colors", 2, 2));
            this.add("gm_show_options", (JComponent)gm_show_options);
            this.add("gm_plane_colors", (JComponent)gm_plane_colors);
            this.set_layout("<table cellpadding='2' border='0' width='100%' height='100%'>  <tr>    <td width='1%' fill='both'>::gm_show_options::</td>    <td width='99%'  fill='both'>::gm_plane_colors::</td>  </tr></table>");
        }
    }

    private final class Tex2dOptions
    extends GMPanel {
        private final JColorOption _jco_tex2_bg_color;
        private final JBoolOptionCheckbox _jboc_show_bg2d;
        private final JEnumOptionComboBox _jeocb_color_mode_tex2d;
        private final JDoubleOptionTFSlider _jdotfs_tex2_bg_transparency;
        private final JIntegerOptionSpinner _jios_tex2d_steps;

        public Tex2dOptions() {
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Texture2D Volume Rendering", 2, 2));
            Tex2Renderer3d t2r = MasterControl.get_v3d().get_tex2_renderer();
            this._jdotfs_tex2_bg_transparency = new JDoubleOptionTFSlider(Tex2Renderer3d.class, Tex2Renderer3d.OPT_BG_TRANS, 0.0, 1.0);
            this._jco_tex2_bg_color = new JColorOption(Tex2Renderer3d.class, Tex2Renderer3d.OPT_BG_COLOR);
            this._jios_tex2d_steps = new JIntegerOptionSpinner(Tex2Renderer3d.class, Tex2Renderer3d.OPT_TEX_STEPS, 1, 8, 1);
            this._jboc_show_bg2d = new JBoolOptionCheckbox(Tex2Renderer3d.class, Tex2Renderer3d.OPT_RENDER_BG);
            this._jboc_show_bg2d.setText("Enable");
            this._jeocb_color_mode_tex2d = new JEnumOptionComboBox(t2r.get_image_renderer(), BGImageRenderer2d.OPT_COLOR_MODE);
            JPanel title_panel = new JPanel();
            title_panel.add(this._jboc_show_bg2d);
            title_panel.add(new JLabel("Color Mode:"));
            title_panel.add(this._jeocb_color_mode_tex2d);
            this.add("_jtf_tex2_bg_transparency", this._jdotfs_tex2_bg_transparency);
            this.add("_jco_tex2_bg_color", this._jco_tex2_bg_color);
            this.add("_jspin_tex2d_steps", this._jios_tex2d_steps);
            this.add("title_panel", title_panel);
            this.set_layout("<table cellpadding='2' border='0' width='100%'>  <tr>    <td colspan='4'>::title_panel::</td>  </tr><tr>    <td>Alpha:</td>    <td colspan='3' fill='horizontal'>::_jtf_tex2_bg_transparency::</td>  </tr><tr>    <td anchor='east'>Steps:</td>    <td anchor='west'>::_jspin_tex2d_steps::</td>    <td anchor='east'>Color:</td>    <td anchor='west'>::_jco_tex2_bg_color::</td>  </tr></table>");
        }
    }

    private final class Tex3dOptions
    extends GMPanel {
        private final JColorOption _jco_tex3_bg_color;
        private final JBoolOptionCheckbox _jboc_show_bg3d;
        private final JEnumOptionComboBox _jeocb_color_mode_tex3d;
        private final JDoubleOptionTFSlider _jdotfs_bg_tex3_transparency;
        private final JIntegerOptionSpinner _jios_tex3d_steps;
        private final JBoolOptionCheckbox _jboc_use_shading;
        private final JBoolOptionCheckbox _jboc_best_filtering;

        public Tex3dOptions() {
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Texture3D Volume Rendering", 2, 2));
            Tex3Renderer3d t3r = MasterControl.get_v3d().get_tex3_renderer();
            this._jdotfs_bg_tex3_transparency = new JDoubleOptionTFSlider(Tex3Renderer3d.class, Tex3Renderer3d.OPT_BG_TRANS, 0.0, 1.0);
            this._jco_tex3_bg_color = new JColorOption(Tex3Renderer3d.class, Tex3Renderer3d.OPT_BG_COLOR);
            this._jios_tex3d_steps = new JIntegerOptionSpinner(Tex3Renderer3d.class, Tex3Renderer3d.OPT_TEX_STEPS, 1, 8, 1);
            this._jboc_show_bg3d = new JBoolOptionCheckbox(Tex3Renderer3d.class, Tex3Renderer3d.OPT_RENDER_BG);
            this._jboc_show_bg3d.setText("Enable");
            this._jeocb_color_mode_tex3d = new JEnumOptionComboBox(t3r.get_image_renderer(), BGImageRenderer2d.OPT_COLOR_MODE);
            this._jboc_use_shading = new JBoolOptionCheckbox(Tex3Renderer3d.class, Tex3Renderer3d.OPT_RENDER_SHADED);
            this._jboc_best_filtering = new JBoolOptionCheckbox(Tex3Renderer3d.class, Tex3Renderer3d.OPT_NICEST_FILTERING);
            JPanel title_panel = new JPanel();
            title_panel.add(this._jboc_show_bg3d);
            title_panel.add(new JLabel("Color Mode:"));
            title_panel.add(this._jeocb_color_mode_tex3d);
            this.add("_jtf_bg_tex3_transparency", this._jdotfs_bg_tex3_transparency);
            this.add("_jco_tex3_bg_color", this._jco_tex3_bg_color);
            this.add("_jspin_tex3d_steps", this._jios_tex3d_steps);
            this.add("_jboc_use_shading", this._jboc_use_shading);
            this.add("_jboc_best_filtering", this._jboc_best_filtering);
            this.add("title_panel", title_panel);
            this.set_layout("<table cellpadding='2' border='0' width='100%'>  <tr>    <td colspan='4'>::title_panel::</td>  </tr><tr>    <td>Alpha:</td>    <td colspan='3' fill='horizontal'>::_jtf_bg_tex3_transparency::</td>  </tr><tr>    <td anchor='east'>Steps:</td>    <td anchor='west'>::_jspin_tex3d_steps::</td>    <td anchor='east'>Color:</td>    <td anchor='west'>::_jco_tex3_bg_color::</td>  </tr><tr>    <td colspan='2'>::_jboc_use_shading::</td>    <td colspan='2'>::_jboc_best_filtering::</td>  </tr></table>");
        }
    }

    private final class TexOptions
    extends GMPanel {
        private final Tex2dOptions _t2do;
        private final Tex3dOptions _t3do;

        public TexOptions() {
            this._t2do = new Tex2dOptions();
            this._t3do = new Tex3dOptions();
            this.add("_t2do", (JComponent)((Object)this._t2do));
            this.add("_t3do", (JComponent)((Object)this._t3do));
            this.set_layout("<table cellpadding='2' border='0' width='100%' height='100%'>  <tr>    <td width='50%' anchor='west' fill='both'>::_t2do::</td>    <td width='50%' anchor='west' fill='both'>::_t3do::</td>  </tr></table>");
        }
    }
}

