/*
 * Decompiled with CFR 0.152.
 */
package main.tools;

import gui.JTFSliderInt;
import gui.LazyInitComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import jgridmaker.GMPanel;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.YaDiV;
import main.tools.ToolBox;
import misc.StopWatch;
import misc.helper.VolumeOperations;
import misc.messages.YObservable;
import misc.messages.YObserverWantsAWTThread;
import settings.Settings;
import yplugins.YModuleType;

public class ToolVolumeOps
extends ToolBox
implements YObserverWantsAWTThread,
LazyInitComponent {
    private ResizePanel _resize_tab;
    private GaussPanel _gauss_tab;
    private NLDPanel _nld_tab;
    private GeneralPanel _general_tab;
    private boolean _gui_created = false;

    @Override
    public void update(YObservable o, Message m) {
        if (m._type == ImageStack.M_SEG_START || m._type == ImageStack.M_RESIZE_START || m._type == ImageStack.M_FILTER3D_START) {
            this._resize_tab.setEnabled(false);
            this._gauss_tab.setEnabled(false);
            this._nld_tab.setEnabled(false);
            this._general_tab.setEnabled(false);
        } else if (m._type == ImageStack.M_SEG_END || m._type == ImageStack.M_RESIZE_END || m._type == ImageStack.M_FILTER3D_END) {
            this._resize_tab.setEnabled(true);
            this._gauss_tab.setEnabled(true);
            this._nld_tab.setEnabled(true);
            this._general_tab.setEnabled(true);
        }
    }

    @Override
    public void create_gui() {
        this._resize_tab = new ResizePanel();
        this._gauss_tab = new GaussPanel();
        this._nld_tab = new NLDPanel();
        this._general_tab = new GeneralPanel();
        this._jtp.addTab("Resize", null, (Component)((Object)this._resize_tab), "Resize VoxelCube + Semgentations");
        this._jtp.addTab("Gauss", null, (Component)((Object)this._gauss_tab), "Filter Operations");
        this._jtp.addTab("Denoise", null, (Component)((Object)this._nld_tab), "Nonlinear Diffusion denoising filter");
        this._jtp.addTab("General", null, (Component)((Object)this._general_tab), "General Methods (mirror, ...)");
        this.add_plugin_tabs(YModuleType.VOLUME_OP);
        this.setLayout(new BorderLayout());
        this.add(this._jtp, "Center");
        MasterControl.get_is().addObserver(this, "ToolDataOps");
        this._gui_created = true;
    }

    @Override
    public boolean gui_created() {
        return this._gui_created;
    }

    private class GaussPanel
    extends GMPanel {
        private final JTextField _text_sigma;
        private final JTextField _text_n;

        public GaussPanel() {
            JButton but_gauss2D = new JButton("Gauss 2D");
            JButton but_gauss3D = new JButton("Gauss 3D");
            this._text_sigma = new JTextField("1", 3);
            this._text_n = new JTextField("3", 3);
            but_gauss2D.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if ((e.getModifiers() & 1) != 0) {
                        VolumeOperations.compute_clown();
                        return;
                    }
                }
            });
            but_gauss3D.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VolumeOperations.compute_gaussian3D(Integer.parseInt(GaussPanel.this._text_n.getText()), Double.parseDouble(GaussPanel.this._text_sigma.getText()));
                }
            });
            this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.gray));
            this.add("_text_sigma", this._text_sigma);
            this.add("_text_n", this._text_n);
            this.add("but_gauss2D", but_gauss2D);
            this.add("but_gauss3D", but_gauss3D);
            this.set_layout("<table cellpadding='2' border='0'>  <colgroup>    <col width='1%' />    <col width='49%' />    <col width='1%' />    <col width='49%' />  </colgroup>  <tr>    <td colspan='4'>Gaussian Filtering</td>  </tr><tr>    <td>Sigma:</td>    <td>::_text_sigma::</td>    <td>n:</td>    <td>::_text_n::</td>  </tr><tr>    <td colspan='4'>::but_gauss2D::</td>  </tr><tr>    <td colspan='4'>::but_gauss3D::</td>  </tr></table>");
        }
    }

    private class GeneralPanel
    extends GMPanel {
        public GeneralPanel() {
            JButton jb_mirror_x = new JButton("mirror x");
            jb_mirror_x.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StopWatch sw = new StopWatch(true);
                    VolumeOperations.mirror(0);
                    if (Settings.get_bool_option(YaDiV.class, YaDiV.OPT_MEASURE_TIMES).booleanValue()) {
                        YaDiV.report(YaDiV.ReportType.REPORT_TIME, "volume mirror_x = " + sw);
                    }
                }
            });
            JButton jb_mirror_y = new JButton("mirror y");
            jb_mirror_y.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StopWatch sw = new StopWatch(true);
                    VolumeOperations.mirror(1);
                    if (Settings.get_bool_option(YaDiV.class, YaDiV.OPT_MEASURE_TIMES).booleanValue()) {
                        YaDiV.report(YaDiV.ReportType.REPORT_TIME, "volume mirror_y = " + sw);
                    }
                }
            });
            JButton jb_mirror_z = new JButton("mirror z");
            jb_mirror_z.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StopWatch sw = new StopWatch(true);
                    VolumeOperations.mirror(2);
                    if (Settings.get_bool_option(YaDiV.class, YaDiV.OPT_MEASURE_TIMES).booleanValue()) {
                        YaDiV.report(YaDiV.ReportType.REPORT_TIME, "volume mirror_z = " + sw);
                    }
                }
            });
            GMPanel gmp_mirror = new GMPanel();
            gmp_mirror.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Mirror", 2, 2));
            gmp_mirror.add("jb_mirror_x", (JComponent)jb_mirror_x);
            gmp_mirror.add("jb_mirror_y", (JComponent)jb_mirror_y);
            gmp_mirror.add("jb_mirror_z", (JComponent)jb_mirror_z);
            gmp_mirror.set_layout("<table cellpadding='2' border='0'>  <tr>    <td>::jb_mirror_x::</td>    <td>::jb_mirror_y::</td>    <td>::jb_mirror_z::</td>  </tr></table>");
            this.add("gmp_mirror", (JComponent)gmp_mirror);
            this.set_layout("<table cellpadding='2' border='0'>  <tr>    <td>::gmp_mirror::</td>  </tr></table>");
        }
    }

    private class NLDPanel
    extends GMPanel {
        private final JTextField _text_dt;
        private final JTextField _text_n;
        private final JTextField _text_es;
        private final JTextField _text_eds;
        private final JTextField _text_ced;

        public NLDPanel() {
            JButton but_start = new JButton("Start");
            this._text_n = new JTextField("1", 3);
            this._text_dt = new JTextField(".25", 3);
            this._text_es = new JTextField(".0001", 3);
            this._text_eds = new JTextField(".99", 3);
            this._text_ced = new JTextField("0", 3);
            this._text_n.setToolTipText("Number of iterations of the filter");
            this._text_dt.setToolTipText("<html>time step (amount of change per iteration) <p>reduce if algorithm is unstable");
            this._text_es.setToolTipText("sensitivity coeffictient of the edge detector");
            this._text_eds.setToolTipText("strength of filter suppression at a detected edge");
            this._text_ced.setToolTipText("<html>diffusivity along the gradient <p> (relative to diffusivity perpendicular to the gradient)");
            but_start.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VolumeOperations.compute_nonlinear_diffusion(Integer.parseInt(NLDPanel.this._text_n.getText()), Double.parseDouble(NLDPanel.this._text_dt.getText()), Double.parseDouble(NLDPanel.this._text_es.getText()), Double.parseDouble(NLDPanel.this._text_eds.getText()), Double.parseDouble(NLDPanel.this._text_ced.getText()));
                }
            });
            this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.gray));
            this.add("_text_dt", this._text_dt);
            this.add("_text_n", this._text_n);
            this.add("_text_ced", this._text_ced);
            this.add("_text_es", this._text_es);
            this.add("_text_eds", this._text_eds);
            this.add("but_start", but_start);
            this.set_layout("<table cellpadding='2' border='0'>  <colgroup>    <col width='1%' />    <col width='49%' />    <col width='1%' />    <col width='49%' />  </colgroup>  <tr>    <td colspan='2'>Nonlinear anisotropic diffusion filtering</td>  </tr><tr><td colspan='2'></td></tr><tr><td colspan='2'>     Smoothen the data by means of anisotropic diffusion perpendicular to the gradient.</td></tr><tr><td colspan='2'>     Diffusion can be suppressed at edges to retain sharpness.</td>  </tr><tr>    <td>stepsize:</td>    <td>::_text_dt::</td>  </tr><tr>    <td>iterations:</td>    <td>::_text_n::</td>  </tr><tr>    <td>edge sensitivity:</td>    <td>::_text_es::</td>  </tr><tr>    <td>edge preservation:</td>    <td>::_text_eds::</td>  </tr><tr>    <td>edge blurring:</td>    <td>::_text_ced::</td>  </tr><tr>    <td colspan='2'>::but_start::</td>  </tr></table>");
        }
    }

    private class ResizePanel
    extends GMPanel {
        private final JTFSliderInt _jtf_slider_x = new JTFSliderInt(0, 100, 50);
        private final JTFSliderInt _jtf_slider_y;
        private final JTFSliderInt _jtf_slider_z;
        private int _xp = 50;
        private int _yp = 50;
        private int _zp = 50;

        public ResizePanel() {
            this._jtf_slider_x.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String property = propertyChangeEvent.getPropertyName();
                    if (JTFSliderInt.JTF_CHANGE.equals(property)) {
                        ResizePanel.this._xp = (Integer)propertyChangeEvent.getNewValue();
                    }
                }
            });
            this._jtf_slider_y = new JTFSliderInt(0, 100, 50);
            this._jtf_slider_y.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String property = propertyChangeEvent.getPropertyName();
                    if (JTFSliderInt.JTF_CHANGE.equals(property)) {
                        ResizePanel.this._yp = (Integer)propertyChangeEvent.getNewValue();
                    }
                }
            });
            this._jtf_slider_z = new JTFSliderInt(0, 100, 50);
            this._jtf_slider_z.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String property = propertyChangeEvent.getPropertyName();
                    if (JTFSliderInt.JTF_CHANGE.equals(property)) {
                        ResizePanel.this._zp = (Integer)propertyChangeEvent.getNewValue();
                    }
                }
            });
            JButton but_resize = new JButton("Resize");
            but_resize.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MasterControl.get_is().resize((double)ResizePanel.this._xp / 100.0, (double)ResizePanel.this._yp / 100.0, (double)ResizePanel.this._zp / 100.0);
                }
            });
            this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.gray));
            this.add("_jtf_slider_x", this._jtf_slider_x);
            this.add("_jtf_slider_y", this._jtf_slider_y);
            this.add("_jtf_slider_z", this._jtf_slider_z);
            this.add("but_resize", but_resize);
            this.set_layout("<table width='100%' cellpadding='2' border='0'>  <tr>    <td colspan='2'>Resize</td>  </tr><tr>    <td width='1%'>%x: </td>    <td width='99%' fill='horizontal'>::_jtf_slider_x::</td>  </tr><tr>    <td width='1%'>%y: </td>    <td width='99%' fill='horizontal'>::_jtf_slider_y::</td>  </tr><tr>    <td width='1%'>%z: </td>    <td width='99%' fill='horizontal'>::_jtf_slider_z::</td>  </tr><tr>    <td colspan='2'>::but_resize::</td>  </tr></table>");
        }
    }
}

