/*
 * Decompiled with CFR 0.152.
 */
package main.view2d;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.vecmath.Point2i;
import main.ImageStack;
import main.MasterControl;
import main.seggen.SegGen;
import main.view2d.InteractionListener;
import main.view2d.Viewport2d;
import misc.AxisAlignedBoundingBox;
import misc.Voxel;

public class BBoxInteractionListener
extends InteractionListener {
    private IBoundingBoxModificationHelper _bb_modify_helper;
    private int[] _axis_map;
    private Viewport2d _v2d;
    private AxisAlignedBoundingBox _bb;
    final int _max_allowed_distance = 9;
    private Voxel _last_hovered_voxel;

    public BBoxInteractionListener(Viewport2d v2d) {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        this._axis_map = nArray;
        this._max_allowed_distance = 9;
        this._v2d = v2d;
    }

    private List<Voxel> query_for_nearest(int x, int y, int max_distance) {
        LinkedList<Voxel> reachable_neighbours = new LinkedList<Voxel>();
        Point2i[] points = new Point2i[8];
        int i = 0;
        while (i < 8) {
            points[i] = new Point2i();
            ++i;
        }
        i = 1;
        while (i < max_distance) {
            points[0].set(x + i, y + i);
            points[1].set(x + i, y);
            points[2].set(x, y + i);
            points[3].set(x - i, y);
            points[4].set(x, y - i);
            points[5].set(x - i, y - i);
            points[6].set(x - i, y + i);
            points[7].set(x + i, y - i);
            int k = 0;
            while (k < 8) {
                Voxel v = new Voxel();
                this._v2d.convert_panel_pos_to_voxel(points[k].x, points[k].y, v);
                if (!reachable_neighbours.contains(v)) {
                    reachable_neighbours.add(v);
                }
                ++k;
            }
            ++i;
        }
        return reachable_neighbours;
    }

    private SnapResult snap_to_nearest(int x, int y) {
        Voxel v = new Voxel();
        SnapResult _result = new SnapResult();
        this._v2d.convert_panel_pos_to_voxel(x, y, v);
        switch (this._v2d.get_model().get_view_mode()) {
            case 0: {
                if (!this._bb.is_on_z_face(v) || this._bb.is_on_x_face_within_distance(v, 9) || this._bb.is_on_y_face_within_distance(v, 9)) break;
                return _result;
            }
            case 1: {
                if (!this._bb.is_on_x_face(v) || this._bb.is_on_y_face_within_distance(v, 9) || this._bb.is_on_z_face_within_distance(v, 9)) break;
                return _result;
            }
            case 2: {
                if (!this._bb.is_on_y_face(v) || this._bb.is_on_x_face_within_distance(v, 9) || this._bb.is_on_z_face_within_distance(v, 9)) break;
                return _result;
            }
        }
        if (this._bb.is_on_edge(v)) {
            _result.set_voxel(v);
            return _result;
        }
        List<Voxel> snap_to_candidates = this.query_for_nearest(x, y, 9);
        block10: for (Voxel candidate : snap_to_candidates) {
            if (this._bb.is_bb_corner(candidate)) {
                _result.set_voxel(candidate);
                return _result;
            }
            if (_result.is_valid_snap()) continue;
            switch (this._v2d.get_model().get_view_mode()) {
                case 0: {
                    if (!this._bb.is_on_x_face(candidate) && !this._bb.is_on_y_face(candidate)) continue block10;
                    _result.set_voxel(candidate);
                    break;
                }
                case 1: {
                    if (!this._bb.is_on_z_face(candidate) && !this._bb.is_on_y_face(candidate)) continue block10;
                    _result.set_voxel(candidate);
                    break;
                }
                case 2: {
                    if (!this._bb.is_on_x_face(candidate) && !this._bb.is_on_z_face(candidate)) continue block10;
                    _result.set_voxel(candidate);
                }
            }
        }
        return _result;
    }

    private int[] remap(int x, int y, int z) {
        int[] coords = new int[]{x, y, z};
        return new int[]{coords[this._axis_map[0]], coords[this._axis_map[1]], coords[this._axis_map[2]]};
    }

    private DragDirection get_drag_direction(int x, int y, int z) {
        DragDirection dir = null;
        int[] min_array = this._bb.get_min();
        int[] max_array = this._bb.get_max();
        int[] temp = this.remap(x, y, z);
        x = temp[0];
        y = temp[1];
        z = temp[2];
        if (x == max_array[this._axis_map[0]] && y == max_array[this._axis_map[1]]) {
            dir = DragDirection.SE;
        } else if (x == min_array[this._axis_map[0]] && y == max_array[this._axis_map[1]]) {
            dir = DragDirection.SW;
        } else if (x == max_array[this._axis_map[0]] && y == min_array[this._axis_map[1]]) {
            dir = DragDirection.NE;
        } else if (x == min_array[this._axis_map[0]] && y == min_array[this._axis_map[1]]) {
            dir = DragDirection.NW;
        } else if (x == max_array[this._axis_map[0]]) {
            dir = DragDirection.E;
        } else if (y == max_array[this._axis_map[1]]) {
            dir = DragDirection.S;
        } else if (x == min_array[this._axis_map[0]]) {
            dir = DragDirection.W;
        } else if (y == min_array[this._axis_map[1]]) {
            dir = DragDirection.N;
        }
        return dir;
    }

    private Cursor get_cursor_for_drag_direction(DragDirection p) {
        int cursor = 0;
        if (p == DragDirection.NE) {
            cursor = 7;
        } else if (p == DragDirection.SW) {
            cursor = 4;
        } else if (p == DragDirection.E) {
            cursor = 11;
        } else if (p == DragDirection.W) {
            cursor = 10;
        } else if (p == DragDirection.N) {
            cursor = 8;
        } else if (p == DragDirection.S) {
            cursor = 9;
        } else if (p == DragDirection.NW) {
            cursor = 6;
        } else if (p == DragDirection.SE) {
            cursor = 5;
        }
        return Cursor.getPredefinedCursor(cursor);
    }

    private void init() {
        this._bb = SegGen.get_seg_gen_bb();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        Voxel v = new Voxel();
        this._v2d.convert_panel_pos_to_voxel(me.getX(), me.getY(), v);
        this._bb_modify_helper.modify_bb(v._x, v._y, v._z);
    }

    public void set_axis_map_for_viewmode(int viewmode) {
        switch (viewmode) {
            case 0: {
                this._axis_map[0] = 0;
                this._axis_map[1] = 1;
                this._axis_map[2] = 2;
                break;
            }
            case 1: {
                this._axis_map[0] = 1;
                this._axis_map[1] = 2;
                this._axis_map[2] = 0;
                break;
            }
            case 2: {
                this._axis_map[0] = 0;
                this._axis_map[1] = 2;
                this._axis_map[2] = 1;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        SnapResult _result = this.snap_to_nearest(me.getX(), me.getY());
        Cursor cursor = Cursor.getDefaultCursor();
        this.set_axis_map_for_viewmode(this._v2d.get_model().get_view_mode());
        if (_result.is_valid_snap()) {
            Voxel v = _result.get_voxel();
            this._bb_modify_helper = new ResizeHelper(this._bb);
            this._last_hovered_voxel = v;
            cursor = this.get_cursor_for_drag_direction(this.get_drag_direction(v._x, v._y, v._z));
        } else {
            Voxel v = new Voxel();
            this._v2d.convert_panel_pos_to_voxel(me.getX(), me.getY(), v);
            if (this._bb.is_inside(v)) {
                this._bb_modify_helper = new PanHelper(this._bb);
                this._last_hovered_voxel = v;
                cursor = Cursor.getPredefinedCursor(13);
            }
        }
        this.update_cursor(cursor);
    }

    private void update_cursor(Cursor cursor) {
        this._v2d.updateCursor(this, cursor, null, 0, 0);
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (this._last_hovered_voxel == null) {
            return;
        }
        Voxel v = this._last_hovered_voxel;
        this._bb_modify_helper.set_source(v._x, v._y, v._z);
        this._bb_modify_helper.set_is_changing(true);
    }

    private void release_helper() {
        if (this._bb_modify_helper != null) {
            this._bb_modify_helper.own_finalize();
            this._bb_modify_helper = null;
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.release_helper();
    }

    @Override
    public void willBegin() {
        this.init();
        this._v2d.updateCursor(this, Cursor.getPredefinedCursor(1), null, 0, 0);
    }

    @Override
    public void didEnd() {
        this.release_helper();
        this._v2d.updateCursor(this, Cursor.getPredefinedCursor(1), null, 0, 0);
    }

    @Override
    public boolean needsMouse() {
        return true;
    }

    @Override
    public boolean needsMouseMotion() {
        return true;
    }

    private static enum DragDirection {
        N,
        NE,
        E,
        SE,
        S,
        SW,
        W,
        NW;

    }

    private static interface IBoundingBoxModificationHelper {
        public void modify_bb(int var1, int var2, int var3);

        public void own_finalize();

        public void set_source(int var1, int var2, int var3);

        public void set_is_changing(boolean var1);
    }

    private class PanHelper
    implements IBoundingBoxModificationHelper {
        private Point2i _source;
        private AxisAlignedBoundingBox _bb;
        private int[] axis_map = new int[3];

        public PanHelper(AxisAlignedBoundingBox bb) {
            this._bb = bb;
        }

        @Override
        public void modify_bb(int x, int y, int z) {
            int[] temp = BBoxInteractionListener.this.remap(x, y, z);
            x = temp[0];
            y = temp[1];
            z = temp[2];
            if (this._source == null) {
                return;
            }
            this.axis_map = BBoxInteractionListener.this._axis_map;
            int x_diff = x - this._source.x;
            int y_diff = y - this._source.y;
            int[] _bb_max = this._bb.get_max();
            int[] _bb_min = this._bb.get_min();
            int new_x_max = _bb_max[this.axis_map[0]] + x_diff;
            int new_y_max = _bb_max[this.axis_map[1]] + y_diff;
            int new_x_min = _bb_min[this.axis_map[0]] + x_diff;
            int new_y_min = _bb_min[this.axis_map[1]] + y_diff;
            _bb_max[this.axis_map[0]] = new_x_max;
            _bb_max[this.axis_map[1]] = new_y_max;
            _bb_min[this.axis_map[0]] = new_x_min;
            _bb_min[this.axis_map[1]] = new_y_min;
            this._bb.set_changed();
            this._source.x = x;
            this._source.y = y;
        }

        @Override
        public void set_source(int source_x, int source_y, int source_z) {
            int[] temp = BBoxInteractionListener.this.remap(source_x, source_y, source_z);
            source_x = temp[0];
            source_y = temp[1];
            source_z = temp[2];
            this._source = new Point2i(source_x, source_y);
        }

        @Override
        public void set_is_changing(boolean b) {
            this._bb.set_is_changing(true);
        }

        @Override
        public void own_finalize() {
            this._bb.set_is_changing(false);
        }
    }

    private class ResizeHelper
    implements IBoundingBoxModificationHelper {
        private DragDirection _dir;
        private Point2i _source;
        private AxisAlignedBoundingBox _bb;
        private int[] axis_map = new int[3];

        public ResizeHelper(AxisAlignedBoundingBox bb) {
            this._bb = bb;
        }

        @Override
        public void own_finalize() {
            this._bb.set_is_changing(false);
        }

        @Override
        public void set_source(int source_x, int source_y, int source_z) {
            int old_x = source_x;
            int old_y = source_y;
            int old_z = source_z;
            int[] temp = BBoxInteractionListener.this.remap(source_x, source_y, source_z);
            source_x = temp[0];
            source_y = temp[1];
            source_z = temp[2];
            this._source = new Point2i(source_x, source_y);
            this._dir = BBoxInteractionListener.this.get_drag_direction(old_x, old_y, old_z);
        }

        @Override
        public void set_is_changing(boolean b) {
            this._bb.set_is_changing(true);
        }

        private int[] get_is_dims() {
            ImageStack is = MasterControl.get_is();
            return new int[]{is.get_dim_x(), is.get_dim_y(), is.get_dim_z()};
        }

        @Override
        public void modify_bb(int x, int y, int z) {
            if (this._source == null) {
                return;
            }
            int[] temp = BBoxInteractionListener.this.remap(x, y, z);
            x = temp[0];
            y = temp[1];
            z = temp[2];
            this.axis_map = BBoxInteractionListener.this._axis_map;
            int x_increase = x - this._source.x;
            int y_increase = y - this._source.y;
            int[] min_array = this._bb.get_min();
            int[] max_array = this._bb.get_max();
            int[] is_dims = this.get_is_dims();
            switch (this._dir) {
                case N: {
                    min_array[this.axis_map[1]] = Math.max(0, this._source.y + y_increase);
                    break;
                }
                case NE: {
                    min_array[this.axis_map[1]] = Math.max(0, this._source.y + y_increase);
                    max_array[this.axis_map[0]] = Math.min(is_dims[this.axis_map[0]] - 1, this._source.x + x_increase);
                    break;
                }
                case E: {
                    max_array[this.axis_map[0]] = Math.min(is_dims[this.axis_map[0]] - 1, this._source.x + x_increase);
                    break;
                }
                case SE: {
                    max_array[this.axis_map[0]] = Math.min(is_dims[this.axis_map[0]] - 1, this._source.x + x_increase);
                    max_array[this.axis_map[1]] = Math.min(is_dims[this.axis_map[1]] - 1, this._source.y + y_increase);
                    break;
                }
                case S: {
                    max_array[this.axis_map[1]] = Math.min(is_dims[this.axis_map[1]] - 1, this._source.y + y_increase);
                    break;
                }
                case SW: {
                    max_array[this.axis_map[1]] = Math.min(is_dims[this.axis_map[1]] - 1, this._source.y + y_increase);
                    min_array[this.axis_map[0]] = Math.max(0, this._source.x + x_increase);
                    break;
                }
                case W: {
                    min_array[this.axis_map[0]] = Math.max(0, this._source.x + x_increase);
                    break;
                }
                case NW: {
                    min_array[this.axis_map[1]] = Math.max(0, this._source.y + y_increase);
                    min_array[this.axis_map[0]] = Math.max(0, this._source.x + x_increase);
                }
            }
            this._bb.set_changed();
        }
    }

    private class SnapResult {
        private Voxel _snapped_to;

        private SnapResult() {
        }

        public void set_voxel(Voxel v) {
            this._snapped_to = v;
        }

        public Voxel get_voxel() {
            return this._snapped_to;
        }

        public boolean is_valid_snap() {
            return this._snapped_to != null;
        }
    }
}

