/*
 * Decompiled with CFR 0.152.
 */
package main.view2d;

import main.view2d.Filter;

final class BiLinearFilter
implements Filter {
    BiLinearFilter() {
    }

    @Override
    public int sample(float px, float py, int[] data, int lineWidth) {
        float alpha;
        int index_x = (int)px;
        int index_y = (int)py;
        if (index_x <= 0 && px < 0.0f) {
            --index_x;
        }
        if (index_y <= 0 && py < 0.0f) {
            --index_y;
        }
        float factor_x = px - (float)index_x;
        float factor_y = py - (float)index_y;
        int color = BiLinearFilter.get_check(data, index_x, index_y, lineWidth);
        float factor = (1.0f - factor_x) * (1.0f - factor_y);
        float asum = alpha = (float)(color >> 24 & 0xFF) / 255.0f * factor;
        float rsum = (float)(color >> 16 & 0xFF) * alpha;
        float gsum = (float)(color >> 8 & 0xFF) * alpha;
        float bsum = (float)(color & 0xFF) * alpha;
        color = BiLinearFilter.get_check(data, index_x + 1, index_y, lineWidth);
        factor = factor_x * (1.0f - factor_y);
        alpha = (float)(color >> 24 & 0xFF) / 255.0f * factor;
        asum += alpha;
        rsum += (float)(color >> 16 & 0xFF) * alpha;
        gsum += (float)(color >> 8 & 0xFF) * alpha;
        bsum += (float)(color & 0xFF) * alpha;
        color = BiLinearFilter.get_check(data, index_x, index_y + 1, lineWidth);
        factor = (1.0f - factor_x) * factor_y;
        alpha = (float)(color >> 24 & 0xFF) / 255.0f * factor;
        asum += alpha;
        rsum += (float)(color >> 16 & 0xFF) * alpha;
        gsum += (float)(color >> 8 & 0xFF) * alpha;
        bsum += (float)(color & 0xFF) * alpha;
        color = BiLinearFilter.get_check(data, index_x + 1, index_y + 1, lineWidth);
        factor = factor_x * factor_y;
        alpha = (float)(color >> 24 & 0xFF) / 255.0f * factor;
        rsum += (float)(color >> 16 & 0xFF) * alpha;
        gsum += (float)(color >> 8 & 0xFF) * alpha;
        bsum += (float)(color & 0xFF) * alpha;
        if ((asum += alpha) == 0.0f) {
            return 0;
        }
        float iasum = 1.0f / asum;
        int a = (int)(255.0f * asum);
        int r = (int)(rsum * iasum);
        int g = (int)(gsum * iasum);
        int b = (int)(bsum * iasum);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int get_check(int[] a, int x, int y, int line) {
        int def = 0xFFFFFF;
        if (x < 0 || x >= line || y < 0) {
            return 0xFFFFFF;
        }
        int index = y * line + x;
        return index < 0 || index >= a.length ? 0xFFFFFF : a[index];
    }

    @Override
    public int sample_noAlpha(float px, float py, int[] data, int lineWidth) {
        int index_x = (int)px;
        int index_y = (int)py;
        int index = lineWidth * index_y + index_x;
        float factor_x = px - (float)index_x;
        float factor_y = py - (float)index_y;
        int color = data[index];
        float factor = (1.0f - factor_x) * (1.0f - factor_y);
        float rsum = (float)(color >> 16 & 0xFF) * factor;
        float gsum = (float)(color >> 8 & 0xFF) * factor;
        float bsum = (float)(color & 0xFF) * factor;
        color = data[index + 1];
        factor = factor_x * (1.0f - factor_y);
        rsum += (float)(color >> 16 & 0xFF) * factor;
        gsum += (float)(color >> 8 & 0xFF) * factor;
        bsum += (float)(color & 0xFF) * factor;
        color = data[index += lineWidth];
        factor = (1.0f - factor_x) * factor_y;
        rsum += (float)(color >> 16 & 0xFF) * factor;
        gsum += (float)(color >> 8 & 0xFF) * factor;
        bsum += (float)(color & 0xFF) * factor;
        color = data[index + 1];
        factor = factor_x * factor_y;
        int r = (int)(rsum += (float)(color >> 16 & 0xFF) * factor);
        int g = (int)(gsum += (float)(color >> 8 & 0xFF) * factor);
        int b = (int)(bsum += (float)(color & 0xFF) * factor);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    @Override
    public int sample_unsafe(float px, float py, int[] data, int lineWidth) {
        float alpha;
        int index_x = (int)px;
        int index_y = (int)py;
        int index = lineWidth * index_y + index_x;
        float factor_x = px - (float)index_x;
        float factor_y = py - (float)index_y;
        int color = data[index];
        float factor = (1.0f - factor_x) * (1.0f - factor_y);
        float asum = alpha = (float)(color >> 24 & 0xFF) / 255.0f * factor;
        float rsum = (float)(color >> 16 & 0xFF) * alpha;
        float gsum = (float)(color >> 8 & 0xFF) * alpha;
        float bsum = (float)(color & 0xFF) * alpha;
        color = data[index + 1];
        factor = factor_x * (1.0f - factor_y);
        alpha = (float)(color >> 24 & 0xFF) / 255.0f * factor;
        asum += alpha;
        rsum += (float)(color >> 16 & 0xFF) * alpha;
        gsum += (float)(color >> 8 & 0xFF) * alpha;
        bsum += (float)(color & 0xFF) * alpha;
        color = data[index += lineWidth];
        factor = (1.0f - factor_x) * factor_y;
        alpha = (float)(color >> 24 & 0xFF) / 255.0f * factor;
        asum += alpha;
        rsum += (float)(color >> 16 & 0xFF) * alpha;
        gsum += (float)(color >> 8 & 0xFF) * alpha;
        bsum += (float)(color & 0xFF) * alpha;
        color = data[index + 1];
        factor = factor_x * factor_y;
        alpha = (float)(color >> 24 & 0xFF) / 255.0f * factor;
        rsum += (float)(color >> 16 & 0xFF) * alpha;
        gsum += (float)(color >> 8 & 0xFF) * alpha;
        bsum += (float)(color & 0xFF) * alpha;
        if ((asum += alpha) == 0.0f) {
            return 0;
        }
        float iasum = 1.0f / asum;
        int a = (int)(255.0f * asum);
        int r = (int)(rsum * iasum);
        int g = (int)(gsum * iasum);
        int b = (int)(bsum * iasum);
        return a << 24 | r << 16 | g << 8 | b;
    }

    @Override
    public int safe_max_x() {
        return 1;
    }

    @Override
    public int safe_max_y() {
        return 1;
    }

    @Override
    public int safe_min_x() {
        return 0;
    }

    @Override
    public int safe_min_y() {
        return 0;
    }
}

