/*
 * Decompiled with CFR 0.152.
 */
package main.view2d;

import main.view2d.Filter;

public class CubicFilter
implements Filter {
    private static final float NORMALIZATION = 0.16666667f;
    private final float _inner_3;
    private final float _inner_2;
    private final float _inner_0;
    private final float _outer_3;
    private final float _outer_2;
    private final float _outer_1;
    private final float _outer_0;
    private final float[] _hx = new float[4];
    private final float[] _hy = new float[4];

    @Override
    public int safe_max_x() {
        return 2;
    }

    @Override
    public int safe_max_y() {
        return 2;
    }

    @Override
    public int safe_min_x() {
        return -2;
    }

    @Override
    public int safe_min_y() {
        return -2;
    }

    public CubicFilter(float b, float c) {
        this._inner_3 = (12.0f - 9.0f * b - 6.0f * c) * 0.16666667f;
        this._inner_2 = (-18.0f + 12.0f * b + 6.0f * c) * 0.16666667f;
        this._inner_0 = (6.0f - 2.0f * b) * 0.16666667f;
        this._outer_3 = (-b - 6.0f * c) * 0.16666667f;
        this._outer_2 = (6.0f * b + 30.0f * c) * 0.16666667f;
        this._outer_1 = (-12.0f * b - 48.0f * c) * 0.16666667f;
        this._outer_0 = (8.0f * b + 24.0f * c) * 0.16666667f;
    }

    public float h(float x) {
        return x < 1.0f ? this.h_inner(x) : this.h_outer(x);
    }

    public float h_outer(float x) {
        return ((this._outer_3 * x + this._outer_2) * x + this._outer_1) * x + this._outer_0;
    }

    public float h_inner(float x) {
        return (this._inner_3 * x + this._inner_2) * x * x + this._inner_0;
    }

    private void pre_calc(float[] h_store, float p, float i) {
        h_store[0] = this.h_outer(p - i);
        h_store[1] = this.h_inner(p - (i + 1.0f));
        h_store[2] = this.h_inner(i + 2.0f - p);
        h_store[3] = this.h_outer(i + 3.0f - p);
    }

    @Override
    public int sample(float px, float py, int[] data, int lineWidth) {
        int ix = (int)px - 1;
        int iy = (int)py - 1;
        this.pre_calc(this._hx, px, ix);
        this.pre_calc(this._hy, py, iy);
        float asum = 0.0f;
        float rsum = 0.0f;
        float gsum = 0.0f;
        float bsum = 0.0f;
        int cy = 0;
        while (cy < 4) {
            float yfactor = this._hy[cy];
            int cx = 0;
            while (cx < 4) {
                int value = CubicFilter.get_check(data, ix + cx, iy + cy, lineWidth);
                float alpha = value >> 24 & 0xFF;
                if (alpha != 0.0f) {
                    asum += (alpha *= this._hx[cx] * yfactor / 255.0f);
                    rsum += alpha * (float)(value >> 16 & 0xFF);
                    gsum += alpha * (float)(value >> 8 & 0xFF);
                    bsum += alpha * (float)(value & 0xFF);
                }
                ++cx;
            }
            ++cy;
        }
        if (asum == 0.0f) {
            return 0;
        }
        float iasum = 1.0f / asum;
        int a = CubicFilter.clamp(255.0f * asum);
        int r = CubicFilter.clamp(rsum * iasum);
        int g = CubicFilter.clamp(gsum * iasum);
        int b = CubicFilter.clamp(bsum * iasum);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int clamp(float f) {
        int r = (int)f;
        return r < 0 ? 0 : (r > 255 ? 255 : r);
    }

    @Override
    public int sample_noAlpha(float px, float py, int[] data, int lineWidth) {
        int ix = (int)px - 1;
        int iy = (int)py - 1;
        int index_base = ix + iy * lineWidth;
        this.pre_calc(this._hx, px, ix);
        this.pre_calc(this._hy, py, iy);
        float rsum = 0.0f;
        float gsum = 0.0f;
        float bsum = 0.0f;
        int cy = 0;
        int offset = index_base;
        while (cy < 4) {
            float yfactor = this._hy[cy];
            int cx = 0;
            while (cx < 4) {
                int index = offset + cx;
                int value = data[index];
                float factor = this._hx[cx] * yfactor;
                rsum += factor * (float)(value >> 16 & 0xFF);
                gsum += factor * (float)(value >> 8 & 0xFF);
                bsum += factor * (float)(value & 0xFF);
                ++cx;
            }
            ++cy;
            offset += lineWidth;
        }
        int r = CubicFilter.clamp(rsum);
        int g = CubicFilter.clamp(gsum);
        int b = CubicFilter.clamp(bsum);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    @Override
    public int sample_unsafe(float px, float py, int[] data, int lineWidth) {
        int ix = (int)px - 1;
        int iy = (int)py - 1;
        int index_base = ix + iy * lineWidth;
        this.pre_calc(this._hx, px, ix);
        this.pre_calc(this._hy, py, iy);
        float asum = 0.0f;
        float rsum = 0.0f;
        float gsum = 0.0f;
        float bsum = 0.0f;
        int cy = 0;
        int offset = index_base;
        while (cy < 4) {
            float yfactor = this._hy[cy];
            int cx = 0;
            while (cx < 4) {
                int index = offset + cx;
                int value = data[index];
                float alpha = value >> 24 & 0xFF;
                if (alpha != 0.0f) {
                    asum += (alpha *= this._hx[cx] * yfactor / 255.0f);
                    rsum += alpha * (float)(value >> 16 & 0xFF);
                    gsum += alpha * (float)(value >> 8 & 0xFF);
                    bsum += alpha * (float)(value & 0xFF);
                }
                ++cx;
            }
            ++cy;
            offset += lineWidth;
        }
        if (asum == 0.0f) {
            return 0;
        }
        float iasum = 1.0f / asum;
        int a = CubicFilter.clamp(255.0f * asum);
        int r = CubicFilter.clamp(rsum * iasum);
        int g = CubicFilter.clamp(gsum * iasum);
        int b = CubicFilter.clamp(bsum * iasum);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int get_check(int[] a, int x, int y, int line) {
        int def = 0xFFFFFF;
        if (x < 0 || x >= line || y < 0) {
            return 0xFFFFFF;
        }
        int index = y * line + x;
        return index < 0 || index >= a.length ? 0xFFFFFF : a[index];
    }
}

