/*
 * Decompiled with CFR 0.152.
 */
package main.view2d;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import main.view2d.ScaleStrategy;

public class DownScaleStrategy
implements ScaleStrategy {
    private final ScaleStrategy _upscale;

    public DownScaleStrategy(ScaleStrategy upscaleStrategy) {
        this._upscale = upscaleStrategy instanceof DownScaleStrategy ? ((DownScaleStrategy)upscaleStrategy)._upscale : upscaleStrategy;
    }

    @Override
    public void paintScaled(BufferedImage target, BufferedImage source, float scale_x, float scale_y, float shift_x, float shift_y, boolean useAlpha) {
        int scaled_x = (int)(scale_x * (float)source.getWidth());
        int scaled_y = (int)(scale_y * (float)source.getHeight());
        if (scaled_x < source.getWidth() || scaled_y < source.getHeight()) {
            if (scaled_x < source.getWidth()) {
                if (scaled_x > 32) {
                    scaled_x &= 0xFFFFFFF0;
                }
            } else {
                scaled_x = source.getWidth();
            }
            if (scaled_y < source.getHeight()) {
                if (scaled_y > 32) {
                    scaled_y &= 0xFFFFFFF0;
                }
            } else {
                scaled_y = source.getHeight();
            }
            scale_x *= (float)source.getWidth();
            scale_y *= (float)source.getHeight();
            source = this.downscale(source, scaled_x, scaled_y, useAlpha);
            scale_x /= (float)source.getWidth();
            scale_y /= (float)source.getHeight();
        }
        this._upscale.paintScaled(target, source, scale_x, scale_y, shift_x, shift_y, useAlpha);
    }

    private BufferedImage downscale(BufferedImage source, int ret_dim_x, int ret_dim_y, boolean useAlpha) {
        int src_dim_x = source.getWidth();
        int xw = source.getWidth() / ret_dim_x;
        int yw = source.getHeight() / ret_dim_y;
        BufferedImage ret = new BufferedImage(ret_dim_x, ret_dim_y, 2);
        int rem_x = src_dim_x - xw * ret_dim_x;
        int rem_y = source.getHeight() - yw * ret_dim_y;
        int[] rpix = ((DataBufferInt)ret.getRaster().getDataBuffer()).getData();
        int[] spix = ((DataBufferInt)source.getRaster().getDataBuffer()).getData();
        if (useAlpha) {
            int ry = 0;
            int sy = 0;
            int ycounter = 0;
            while (ry < ret_dim_y) {
                int ystep;
                if (ycounter >= ret_dim_y) {
                    ystep = yw + 1;
                    ycounter -= ret_dim_y;
                } else {
                    ystep = yw;
                }
                int rx = 0;
                int sx = 0;
                int xcounter = 0;
                while (rx < ret_dim_x) {
                    int xstep;
                    if (xcounter >= ret_dim_x) {
                        xstep = xw + 1;
                        xcounter -= ret_dim_x;
                    } else {
                        xstep = xw;
                    }
                    float asum = 0.0f;
                    float rsum = 0.0f;
                    float bsum = 0.0f;
                    float gsum = 0.0f;
                    float norm = 1.0f / (float)(255 * ystep * xstep);
                    int i = 0;
                    while (i < ystep) {
                        int j = 0;
                        while (j < xstep) {
                            int value = spix[(sy + i) * src_dim_x + sx + j];
                            float alpha = value >> 24 & 0xFF;
                            if (alpha != 0.0f) {
                                asum += (alpha *= norm);
                                rsum += (float)(value >> 16 & 0xFF) * alpha;
                                gsum += (float)(value >> 8 & 0xFF) * alpha;
                                bsum += (float)(value & 0xFF) * alpha;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    sx += xstep;
                    if (asum != 0.0f) {
                        float iasum = 1.0f / asum;
                        int a = (int)(asum * 255.0f);
                        int r = (int)(rsum * iasum);
                        int g = (int)(gsum * iasum);
                        int b = (int)(bsum * iasum);
                        rpix[rx + ry * ret_dim_x] = a << 24 | r << 16 | g << 8 | b;
                    }
                    ++rx;
                    xcounter += rem_x;
                }
                sy += ystep;
                ++ry;
                ycounter += rem_y;
            }
        } else {
            int ry = 0;
            int sy = 0;
            int ycounter = 0;
            while (ry < ret_dim_y) {
                int ystep;
                if (ycounter >= ret_dim_y) {
                    ystep = yw + 1;
                    ycounter -= ret_dim_y;
                } else {
                    ystep = yw;
                }
                int rx = 0;
                int sx = 0;
                int xcounter = 0;
                while (rx < ret_dim_x) {
                    int xstep;
                    if (xcounter >= ret_dim_x) {
                        xstep = xw + 1;
                        xcounter -= ret_dim_x;
                    } else {
                        xstep = xw;
                    }
                    float rsum = 0.0f;
                    float bsum = 0.0f;
                    float gsum = 0.0f;
                    float norm = 1.0f / (float)(ystep * xstep);
                    int i = 0;
                    while (i < ystep) {
                        int j = 0;
                        while (j < xstep) {
                            int value = spix[(sy + i) * src_dim_x + sx + j];
                            rsum += (float)(value >> 16 & 0xFF);
                            gsum += (float)(value >> 8 & 0xFF);
                            bsum += (float)(value & 0xFF);
                            ++j;
                        }
                        ++i;
                    }
                    sx += xstep;
                    int r = (int)(rsum * norm);
                    int g = (int)(gsum * norm);
                    int b = (int)(bsum * norm);
                    rpix[rx + ry * ret_dim_x] = 0xFF000000 | r << 16 | g << 8 | b;
                    ++rx;
                    xcounter += rem_x;
                }
                sy += ystep;
                ++ry;
                ycounter += rem_y;
            }
        }
        return ret;
    }
}

