/*
 * Decompiled with CFR 0.152.
 */
package main.view2d;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import main.view2d.Filter;
import main.view2d.ScaleStrategy;

public class FilterScaleStrategy
implements ScaleStrategy {
    private final Filter _f;

    public FilterScaleStrategy(Filter f) {
        this._f = f;
    }

    @Override
    public void paintScaled(BufferedImage target, BufferedImage source, float scale_x, float scale_y, float shift_x, float shift_y, boolean useAlpha) {
        int safe_max_y;
        int safe_max_x;
        int safe_min_y;
        int safe_min_x;
        int[] tpix = ((DataBufferInt)target.getRaster().getDataBuffer()).getData();
        int[] spix = ((DataBufferInt)source.getRaster().getDataBuffer()).getData();
        int min_x = (int)shift_x;
        int min_y = (int)shift_y;
        int lineWidth = source.getWidth();
        int max_x = (int)(shift_x + scale_x * (float)lineWidth);
        int max_y = (int)(shift_y + scale_y * (float)source.getHeight());
        if (min_x < 0) {
            min_x = 0;
        }
        if (min_y < 0) {
            min_y = 0;
        }
        if (max_x >= target.getWidth()) {
            max_x = target.getWidth();
        }
        if (max_y >= target.getHeight()) {
            max_y = target.getHeight();
        }
        if ((safe_min_x = (int)(1.0f + shift_x - (float)(this._f.safe_min_x() - 1) * scale_x)) < min_x) {
            safe_min_x = min_x;
        }
        if ((safe_min_y = (int)(1.0f + shift_y - (float)(this._f.safe_min_y() - 1) * scale_y)) < min_y) {
            safe_min_y = min_y;
        }
        if ((safe_max_x = (int)(shift_x - 1.0f + (float)(source.getWidth() - this._f.safe_max_x() + 0) * scale_x)) >= max_x) {
            safe_max_x = max_x;
        }
        if ((safe_max_y = (int)(shift_y - 1.0f + (float)(source.getHeight() - this._f.safe_max_y() + 0) * scale_y)) >= max_y) {
            safe_max_y = max_y;
        }
        boolean unsafe = true;
        float inv_scale_x = 1.0f / scale_x;
        float inv_shift_x = (0.5f - shift_x) * inv_scale_x - 0.5f;
        float inv_scale_y = 1.0f / scale_y;
        float inv_shift_y = (0.5f - shift_y) * inv_scale_y - 0.5f;
        int width = target.getWidth();
        int y = min_y;
        while (y < max_y) {
            int target_index = y * width + min_x;
            float src_y = (float)y * inv_scale_y + inv_shift_y;
            boolean y_unsafe = y < safe_min_y || y >= safe_max_y;
            int x = min_x;
            while (x < max_x) {
                unsafe = y_unsafe || x < safe_min_x || x >= safe_max_x;
                float src_x = (float)x * inv_scale_x + inv_shift_x;
                int erg = unsafe ? this._f.sample(src_x, src_y, spix, lineWidth) : (useAlpha ? this._f.sample_unsafe(src_x, src_y, spix, lineWidth) : this._f.sample_noAlpha(src_x, src_y, spix, lineWidth));
                int alpha_int = erg >> 24 & 0xFF;
                if (alpha_int == 255) {
                    tpix[target_index] = erg;
                } else if (alpha_int != 0) {
                    float alpha = (float)alpha_int / 255.0f;
                    float ialpha = 1.0f - alpha;
                    int old = tpix[target_index];
                    float walpha = alpha;
                    float wialpha = ialpha * (float)(old >> 24 & 0xFF) / 255.0f;
                    int a = (int)((float)(old >> 24 & 0xFF) * wialpha + (float)(erg >> 24 & 0xFF) * walpha);
                    int r = (int)((float)(old >> 16 & 0xFF) * wialpha + (float)(erg >> 16 & 0xFF) * walpha);
                    int g = (int)((float)(old >> 8 & 0xFF) * wialpha + (float)(erg >> 8 & 0xFF) * walpha);
                    int b = (int)((float)(old & 0xFF) * wialpha + (float)(erg & 0xFF) * walpha);
                    tpix[target_index] = a << 24 | r << 16 | g << 8 | b;
                }
                ++x;
                ++target_index;
            }
            ++y;
        }
    }
}

