/*
 * Decompiled with CFR 0.152.
 */
package main.view2d;

import gui.JTFSliderInt;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.view2d.Viewport2dModel;
import misc.messages.YObservable;
import misc.messages.YObserver;

final class ImageSelector
extends JTFSliderInt
implements MouseWheelListener,
YObserver {
    private final Viewport2dModel _v2d_model;

    public ImageSelector(Viewport2dModel v2d_model) {
        super(1, 0, 10, 0);
        this._v2d_model = v2d_model;
        this._v2d_model.addObserver(this, "ImageSelector()");
        MasterControl.get_is().addObserver(this, "ImageSelector()");
        this.get_ftf().setColumns(3);
        this.get_ftf().setHorizontalAlignment(4);
        this.get_slider().addMouseWheelListener(this);
        this.get_slider().setInverted(true);
        this.get_ftf().addMouseWheelListener(this);
    }

    public void update() {
        ImageStack is = MasterControl.get_is();
        int view_mode = this._v2d_model.get_view_mode();
        int max = view_mode == 0 ? is.get_dim_z() - 1 : (view_mode == 1 ? is.get_dim_x() - 1 : is.get_dim_y() - 1);
        this.setMaximum(max);
        this.setValue(this._v2d_model.get_active_image());
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int new_value = this.getValue() - e.getWheelRotation();
        if (new_value >= this._min && new_value <= this._max) {
            this.setValueAndFireEvent(new_value);
        }
    }

    @Override
    public void update(YObservable yo, Message m) {
        if (m._type == Viewport2dModel.M_NEW_VIEW_MODE) {
            this.update();
        } else if (m._type == ImageStack.M_VC_SET) {
            this.update();
        } else if (m._type == Viewport2dModel.M_NEW_ACTIVE_IMAGE) {
            this.update();
        }
    }
}

