/*
 * Decompiled with CFR 0.152.
 */
package main.view2d;

import java.awt.AWTException;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import main.YaDiV;
import main.view2d.ScaleFuncType;
import main.view2d.ScaleStrategy;
import misc.StopWatch;

public class ImageZoomer
extends JPanel {
    public static final Cursor NO_CURSOR;
    public static final String ZOOM_FACTOR_CHANGE = "zoom_factor";
    public static final String ZOOM_CENTER_CHANGE = "zoom_center";
    private int _cursor_hot_x;
    private int _cursor_hot_y;
    private BufferedImage _zoomed_cursor;
    private ScaleFuncType _scale_function = ScaleFuncType.SCALE_FAST;
    private double _img_w_scaling;
    private double _img_h_scaling;
    private BufferedImage _the_image;
    Robot _rob;
    private BufferedImage _output_buffer;
    private BufferedImage _zoomed_background_cache;
    private double _zoom = 1.0;
    private double _center_x;
    private double _center_y;
    private double _transform_x_scale = 1.0;
    private double _transform_y_scale = 1.0;
    private double _transform_x_shift;
    private double _transform_y_shift;
    private boolean _mouse_inside;
    private double _last_mouse_x;
    private double _last_mouse_y;
    private boolean _button_3_down;
    private boolean _mouse_centering = false;
    private double _pan_anchor_x;
    private double _pan_anchor_y;
    private Thread _zoom_overlay_fader;
    private final Object _syncher = new Object();
    private volatile long _zoom_overly_request_time;

    static {
        BufferedImage no_cursor = new BufferedImage(16, 16, 2);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Point hotspot = new Point(0, 0);
        NO_CURSOR = toolkit.createCustomCursor(no_cursor, hotspot, "No Cursor");
    }

    public ImageZoomer() {
        this.setBackground(Color.black);
        ImageZoomerListener listener = new ImageZoomerListener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.addMouseWheelListener(listener);
        this.addComponentListener(listener);
        this.addKeyListener(listener);
        this.setFocusable(true);
        this.setCursor(Cursor.getPredefinedCursor(1));
        try {
            this._rob = new Robot();
        }
        catch (AWTException e) {
            this._rob = null;
            YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "Could not construct robot. Centering of Viewport2D won't work");
        }
    }

    public ScaleFuncType get_scale_function() {
        return this._scale_function;
    }

    public void set_scale_function(ScaleFuncType _scale_function) {
        this._scale_function = _scale_function;
        this._zoomed_background_cache = null;
        this.repaint();
    }

    public double get_mouse_pos_x() {
        return this._last_mouse_x;
    }

    public double get_mouse_pos_y() {
        return this._last_mouse_y;
    }

    void center_mouse() {
        this._pan_anchor_x = this._last_mouse_x;
        this._pan_anchor_y = this._last_mouse_y;
        this.do_pan(this.getWidth() / 2, this.getHeight() / 2);
        this.adjust_view();
        this.move_mouse((int)this.pixel_to_screen_x(this._last_mouse_x), (int)this.pixel_to_screen_y(this._last_mouse_y));
        this.repaint();
    }

    void move_mouse(int x, int y) {
        Point pos = this.getLocationOnScreen();
        this._rob.mouseMove(pos.x + x, pos.y + y);
    }

    public void set_zoomed_cursor(BufferedImage cursor, int hot_x, int hot_y) {
        this._zoomed_cursor = cursor;
        this._cursor_hot_x = hot_x;
        this._cursor_hot_y = hot_y;
        if (this._mouse_inside) {
            this.repaint();
        }
    }

    public double pixel_to_screen_x(double pixel_x) {
        return pixel_x * this._transform_x_scale + this._transform_x_shift;
    }

    public double pixel_to_screen_y(double pixel_y) {
        return pixel_y * this._transform_y_scale + this._transform_y_shift;
    }

    public double screen_to_pixel_x(double screen_x) {
        return (screen_x - this._transform_x_shift) / this._transform_x_scale;
    }

    public double screen_to_pixel_y(double screen_y) {
        return (screen_y - this._transform_y_shift) / this._transform_y_scale;
    }

    public boolean is_mouse_inside() {
        return this._mouse_inside;
    }

    public void set_image(BufferedImage bg, double x_scaling, double y_scaling, double center_x, double center_y, double zoom) {
        this._the_image = bg;
        this._img_w_scaling = x_scaling;
        this._img_h_scaling = y_scaling;
        this.set_zoom_center_no_adjust(center_x, center_y);
        this.set_zoom_factor(this._zoom);
    }

    public void set_scaling(double x_scaling, double y_scaling) {
        this._img_w_scaling = x_scaling;
        this._img_h_scaling = y_scaling;
        this.calc_scaling();
        this.adjust_view();
    }

    public void set_zoom_factor(double zoom) {
        if (zoom < 1.0) {
            zoom = 1.0;
        }
        if (zoom == this._zoom) {
            return;
        }
        double old_zoom = this._zoom;
        double mouse_x = this.pixel_to_screen_x(this._last_mouse_x);
        double mouse_y = this.pixel_to_screen_y(this._last_mouse_y);
        this._zoom = zoom;
        this.calc_scaling();
        this.adjust_view();
        this.rememberMousePosition(mouse_x, mouse_y);
        this.firePropertyChange(ZOOM_FACTOR_CHANGE, new Double(old_zoom), new Double(zoom));
        this.repaint();
    }

    public void set_zoom_center(double center_x_new, double center_y_new) {
        if (center_x_new == this._center_x && center_y_new == this._center_y) {
            return;
        }
        Point2D.Double old = new Point2D.Double(this._center_x, this._center_y);
        double mouse_x = this.pixel_to_screen_x(this._last_mouse_x);
        double mouse_y = this.pixel_to_screen_y(this._last_mouse_y);
        this._center_x = center_x_new;
        this._center_y = center_y_new;
        this.calc_scaling();
        this.adjust_view();
        this.rememberMousePosition(mouse_x, mouse_y);
        Point2D.Double neu = new Point2D.Double(this._center_x, this._center_y);
        this.firePropertyChange(ZOOM_CENTER_CHANGE, old, neu);
        this.repaint();
    }

    private void set_zoom_center_no_adjust(double center_x_new, double center_y_new) {
        if (center_x_new == this._center_x && center_y_new == this._center_y) {
            return;
        }
        Point2D.Double old = new Point2D.Double(this._center_x, this._center_y);
        double mouse_x = this.pixel_to_screen_x(this._last_mouse_x);
        double mouse_y = this.pixel_to_screen_y(this._last_mouse_y);
        this._center_x = center_x_new;
        this._center_y = center_y_new;
        this.calc_scaling();
        this.rememberMousePosition(mouse_x, mouse_y);
        Point2D.Double neu = new Point2D.Double(this._center_x, this._center_y);
        this.firePropertyChange(ZOOM_CENTER_CHANGE, old, neu);
    }

    public Double get_zoom_factor() {
        return this._zoom;
    }

    public double get_zoom_center_x() {
        return this._center_x;
    }

    public double get_zoom_center_y() {
        return this._center_y;
    }

    public void imageChanged() {
        this._zoomed_background_cache = null;
        this.repaint();
    }

    @Override
    public final void paint(Graphics g) {
        BufferedImage buffer = this.paintZoomedParts((Graphics2D)g);
        Graphics2D g2 = buffer == null ? (Graphics2D)g : buffer.createGraphics();
        double zoom_overlay_alpha = (double)(-(System.currentTimeMillis() - this._zoom_overly_request_time)) * 0.003 + 2.0;
        if (this._button_3_down) {
            zoom_overlay_alpha = 1.0;
        }
        if (zoom_overlay_alpha > 1.0) {
            zoom_overlay_alpha = 1.0;
        }
        if (zoom_overlay_alpha > 0.0) {
            zoom_overlay_alpha = 0.5 - 0.5 * Math.cos(zoom_overlay_alpha * Math.PI);
            double img_w = this._the_image.getWidth(null);
            double img_h = this._the_image.getHeight(null);
            double spare = 0.4;
            double r = this._img_h_scaling * img_h / (this._img_w_scaling * img_w);
            double p = -((double)this.getWidth() * r + (double)this.getHeight()) / r;
            double q = (double)(this.getWidth() * this.getHeight()) * 0.6 / r;
            double prev_width = -0.5 * p - Math.sqrt(0.25 * p * p - q);
            double prev_height = prev_width * r;
            g2.setColor(new Color(0.0f, 0.0f, 0.5f, (float)(zoom_overlay_alpha * 0.3)));
            g2.fillRect(0, 0, (int)prev_width, (int)prev_height);
            Composite comp_save2 = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, (float)(zoom_overlay_alpha * 0.7)));
            g2.drawImage(this._the_image, 0, 0, (int)prev_width, (int)prev_height, null);
            g2.setComposite(comp_save2);
            g2.setColor(new Color(0.0f, 0.0f, 1.0f, (float)zoom_overlay_alpha));
            g2.drawRect(0, 0, (int)prev_width, (int)prev_height);
            g2.setColor(new Color(1.0f, 0.0f, 0.0f, (float)zoom_overlay_alpha));
            double cursor_x = this._last_mouse_x * prev_width / img_w;
            double cursor_y = this._last_mouse_y * prev_height / img_h;
            if (0.0 <= cursor_y && cursor_y <= prev_height) {
                g2.drawLine(0, (int)cursor_y, (int)prev_width, (int)cursor_y);
            }
            if (0.0 <= cursor_x && cursor_x <= prev_width) {
                g2.drawLine((int)cursor_x, 0, (int)cursor_x, (int)prev_height);
            }
            double up_y = (0.0 - this._transform_y_shift) / this._transform_y_scale * prev_height / img_h;
            double dim_y = ((double)this.getHeight() - this._transform_y_shift) / this._transform_y_scale * prev_height / img_h - up_y;
            double left_x = (0.0 - this._transform_x_shift) / this._transform_x_scale * prev_width / img_w;
            double dim_x = ((double)this.getWidth() - this._transform_x_shift) / this._transform_x_scale * prev_width / img_w - left_x;
            g2.setColor(new Color(0.0f, 1.0f, 0.0f, (float)(zoom_overlay_alpha * 0.3)));
            g2.fillRect((int)left_x, (int)up_y, (int)dim_x, (int)dim_y);
            g2.setColor(new Color(0.0f, 1.0f, 0.0f, (float)zoom_overlay_alpha));
            g2.drawRect((int)left_x, (int)up_y, (int)dim_x, (int)dim_y);
        }
        if (buffer != null) {
            g.drawImage(buffer, 0, 0, null);
        }
    }

    public final BufferedImage paintZoomedParts(Graphics2D alternative) {
        ScaleStrategy strat;
        block13: {
            ScaleFuncType sft = this._scale_function;
            strat = this._scale_function.createStrategy();
            if (alternative != null) {
                Graphics2D g2 = alternative;
                switch (sft) {
                    case SCALE_FAST: {
                        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                        break;
                    }
                    case SCALE_QUALITY_MEDIUM: {
                        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        break;
                    }
                    case SCALE_QUALITY_BEST: {
                        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                        break;
                    }
                    default: {
                        break block13;
                    }
                }
                g2.setColor(Color.black);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                AffineTransform saved_transform = g2.getTransform();
                g2.translate(this._transform_x_shift, this._transform_y_shift);
                g2.scale(this._transform_x_scale, this._transform_y_scale);
                g2.drawImage((Image)this._the_image, 0, 0, null);
                if (this._mouse_inside && this._zoomed_cursor != null) {
                    BufferedImage brush = this._zoomed_cursor;
                    g2.drawImage((Image)brush, (int)this._last_mouse_x - this._cursor_hot_x, (int)this._last_mouse_y - this._cursor_hot_y, null);
                }
                g2.setTransform(saved_transform);
                return null;
            }
        }
        if (this._zoomed_background_cache != null && this._zoomed_background_cache.getWidth() == this.getWidth() && this._zoomed_background_cache.getHeight() == this.getHeight()) {
            this._output_buffer.getGraphics().drawImage(this._zoomed_background_cache, 0, 0, null);
        } else {
            boolean useCache = this._zoomed_cursor != null && this._scale_function.isExpensive();
            BufferedImage buffer = this._output_buffer;
            if (buffer == null || buffer.getWidth() != this.getWidth() || buffer.getHeight() != this.getHeight()) {
                buffer = this._output_buffer = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            }
            if (useCache) {
                buffer = this._zoomed_background_cache = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            }
            Graphics2D g = buffer.createGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            StopWatch sw = new StopWatch();
            sw.start();
            strat.paintScaled(buffer, this._the_image, (float)this._transform_x_scale, (float)this._transform_y_scale, (float)this._transform_x_shift, (float)this._transform_y_shift, false);
            sw.stop();
            YaDiV.report(YaDiV.ReportType.REPORT_TIME, "ImageZoomer: paintScaled = " + sw);
            if (useCache) {
                this._output_buffer.getGraphics().drawImage(this._zoomed_background_cache, 0, 0, null);
            }
        }
        if (this._mouse_inside && this._zoomed_cursor != null) {
            BufferedImage brush = this._zoomed_cursor;
            double tx = this._transform_x_shift + (double)((int)this._last_mouse_x - this._cursor_hot_x) * this._transform_x_scale;
            double ty = this._transform_y_shift + (double)((int)this._last_mouse_y - this._cursor_hot_y) * this._transform_y_scale;
            strat.paintScaled(this._output_buffer, brush, (float)this._transform_x_scale, (float)this._transform_y_scale, (float)tx, (float)ty, true);
        }
        return this._output_buffer;
    }

    private void calc_scaling() {
        int panel_w = this.getWidth();
        int panel_h = this.getHeight();
        if (panel_w == 0 || panel_h == 0) {
            return;
        }
        double img_w = this._the_image.getWidth(null);
        double img_h = this._the_image.getHeight(null);
        double zoom = this._zoom;
        double center_x = this._center_x;
        double center_y = this._center_y;
        double shape_factor = Math.min((double)panel_w / (this._img_w_scaling * img_w), (double)panel_h / (this._img_h_scaling * img_h));
        this._transform_x_scale = this._img_w_scaling * zoom * shape_factor;
        this._transform_y_scale = this._img_h_scaling * zoom * shape_factor;
        this._transform_x_shift = (double)panel_w * 0.5 - center_x * zoom * shape_factor * this._img_w_scaling;
        this._transform_y_shift = (double)panel_h * 0.5 - center_y * zoom * shape_factor * this._img_h_scaling;
        this._zoomed_background_cache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fade_out_pan_overlay() {
        Object object = this._syncher;
        synchronized (object) {
            this._zoom_overly_request_time = System.currentTimeMillis();
            if (this._zoom_overlay_fader == null) {
                this._zoom_overlay_fader = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = ImageZoomer.this._syncher;
                        synchronized (object) {
                            while (System.currentTimeMillis() - ImageZoomer.this._zoom_overly_request_time < 2000L) {
                                try {
                                    ImageZoomer.this._syncher.wait(30L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                ImageZoomer.this.repaint();
                            }
                            ImageZoomer.this._zoom_overlay_fader = null;
                        }
                    }
                };
                this._zoom_overlay_fader.start();
            }
        }
    }

    private void rememberMousePosition(double x, double y) {
        this._last_mouse_x = (x - this._transform_x_shift) / this._transform_x_scale;
        this._last_mouse_y = (y - this._transform_y_shift) / this._transform_y_scale;
    }

    private void do_pan(int mouse_x, int mouse_y) {
        double move_x = ((double)mouse_x - this._transform_x_shift) / this._transform_x_scale - this._pan_anchor_x;
        double move_y = ((double)mouse_y - this._transform_y_shift) / this._transform_y_scale - this._pan_anchor_y;
        this._transform_x_shift += move_x * this._transform_x_scale;
        this._transform_y_shift += move_y * this._transform_y_scale;
    }

    private void do_zoom(double zoom_change, double fix_x, double fix_y) {
        this._transform_x_shift = fix_x - (fix_x - this._transform_x_shift) * zoom_change;
        this._transform_y_shift = fix_y - (fix_y - this._transform_y_shift) * zoom_change;
        this._transform_y_scale *= zoom_change;
        this._transform_x_scale *= zoom_change;
        double zoom = this._zoom;
        zoom *= zoom_change;
        double panel_w = this.getWidth();
        double panel_h = this.getHeight();
        double center_x_new = (panel_w * 0.5 - this._transform_x_shift) / this._transform_x_scale;
        double center_y_new = (panel_h * 0.5 - this._transform_y_shift) / this._transform_y_scale;
        this.set_zoom_center_no_adjust(center_x_new, center_y_new);
        this.set_zoom_factor(zoom);
    }

    private void adjust_view() {
        double img_w_scaled = this._img_w_scaling * (double)this._the_image.getWidth(null);
        double img_h_scaled = this._img_h_scaling * (double)this._the_image.getHeight(null);
        double shape_factor = Math.min((double)this.getWidth() / img_w_scaled, (double)this.getHeight() / img_h_scaled);
        int panel_h = this.getHeight();
        double up = this._transform_y_shift;
        double down = up + (double)this._the_image.getHeight(null) * this._transform_y_scale;
        double y_shift = 0.0;
        if (down - up > (double)panel_h) {
            if (up > 0.0) {
                y_shift = -up;
            } else if (down < (double)panel_h) {
                y_shift = (double)panel_h - down;
            }
        } else {
            if (up < 0.0) {
                y_shift = -up;
            } else if (down > (double)panel_h) {
                y_shift = (double)panel_h - down;
            }
            up += y_shift;
            down += y_shift;
            double max_up = ((double)panel_h - shape_factor * img_h_scaled) * 0.5;
            double min_down = ((double)panel_h + shape_factor * img_h_scaled) * 0.5;
            if (up > max_up) {
                y_shift += max_up - up;
            } else if (down < min_down) {
                y_shift += min_down - down;
            }
        }
        this._transform_y_shift += y_shift;
        double center_y_new = ((double)panel_h * 0.5 - this._transform_y_shift) / this._transform_y_scale;
        int panel_w = this.getWidth();
        double left = this._transform_x_shift;
        double right = left + (double)this._the_image.getWidth(null) * this._transform_x_scale;
        double x_shift = 0.0;
        if (right - left > (double)panel_w) {
            if (left > 0.0) {
                x_shift = -left;
            } else if (right < (double)panel_w) {
                x_shift = (double)panel_w - right;
            }
        } else {
            if (left < 0.0) {
                x_shift = -left;
            } else if (right > (double)panel_w) {
                x_shift = (double)panel_w - right;
            }
            left += x_shift;
            right += x_shift;
            double max_left = ((double)panel_w - shape_factor * img_w_scaled) * 0.5;
            double min_right = ((double)panel_w + shape_factor * img_w_scaled) * 0.5;
            if (left > max_left) {
                x_shift += max_left - left;
            } else if (right < min_right) {
                x_shift += min_right - right;
            }
        }
        this._transform_x_shift += x_shift;
        double center_x_new = ((double)panel_w * 0.5 - this._transform_x_shift) / this._transform_x_scale;
        this.set_zoom_center_no_adjust(center_x_new, center_y_new);
    }

    class ImageZoomerListener
    implements MouseListener,
    MouseWheelListener,
    ComponentListener,
    MouseMotionListener,
    KeyListener {
        public static final int SHIFT_MAGIC = 40;

        ImageZoomerListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 32 && !ImageZoomer.this._mouse_centering && ImageZoomer.this._rob != null) {
                ImageZoomer.this._mouse_centering = true;
                if (!ImageZoomer.this._button_3_down) {
                    ImageZoomer.this.center_mouse();
                }
            } else if (!ImageZoomer.this._mouse_centering) {
                switch (e.getKeyCode()) {
                    case 37: {
                        this.kb_pan(1, 0);
                        break;
                    }
                    case 39: {
                        this.kb_pan(-1, 0);
                        break;
                    }
                    case 38: {
                        this.kb_pan(0, 1);
                        break;
                    }
                    case 40: {
                        this.kb_pan(0, -1);
                    }
                }
            }
        }

        private void kb_pan(int dx, int dy) {
            double old_transform_x_shift = ImageZoomer.this._transform_x_shift;
            double old_transform_y_shift = ImageZoomer.this._transform_y_shift;
            int x_shift_image_pixels = (int)(40.0 / ImageZoomer.this._transform_x_scale);
            int y_shift_image_pixels = (int)(40.0 / ImageZoomer.this._transform_y_scale);
            if (x_shift_image_pixels == 0) {
                x_shift_image_pixels = 1;
            }
            if (y_shift_image_pixels == 0) {
                y_shift_image_pixels = 1;
            }
            ImageZoomer imageZoomer = ImageZoomer.this;
            imageZoomer._transform_x_shift = imageZoomer._transform_x_shift + (double)x_shift_image_pixels * ImageZoomer.this._transform_x_scale * (double)dx;
            ImageZoomer imageZoomer2 = ImageZoomer.this;
            imageZoomer2._transform_y_shift = imageZoomer2._transform_y_shift + (double)y_shift_image_pixels * ImageZoomer.this._transform_y_scale * (double)dy;
            ImageZoomer.this.adjust_view();
            ImageZoomer imageZoomer3 = ImageZoomer.this;
            imageZoomer3._last_mouse_x = imageZoomer3._last_mouse_x - (ImageZoomer.this._transform_x_shift - old_transform_x_shift) / ImageZoomer.this._transform_x_scale;
            ImageZoomer imageZoomer4 = ImageZoomer.this;
            imageZoomer4._last_mouse_y = imageZoomer4._last_mouse_y - (ImageZoomer.this._transform_y_shift - old_transform_y_shift) / ImageZoomer.this._transform_y_scale;
            ImageZoomer.this.repaint();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 32) {
                ImageZoomer.this._mouse_centering = false;
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            ImageZoomer.this.requestFocusInWindow();
            ImageZoomer.this.rememberMousePosition(me.getX(), me.getY());
            int modifiers = me.getModifiersEx();
            ImageZoomer.this._button_3_down = (modifiers & 0x1000) != 0;
            if ((modifiers & 0x1000) != 0) {
                ImageZoomer.this._pan_anchor_x = ImageZoomer.this._last_mouse_x;
                ImageZoomer.this._pan_anchor_y = ImageZoomer.this._last_mouse_y;
            }
        }

        @Override
        public final void mouseReleased(MouseEvent me) {
            int modifiers = me.getModifiersEx();
            ImageZoomer.this._button_3_down = (modifiers & 0x1000) != 0;
            if (me.getButton() == 3) {
                ImageZoomer.this.fade_out_pan_overlay();
                if (ImageZoomer.this._mouse_centering) {
                    ImageZoomer.this.center_mouse();
                }
            }
        }

        @Override
        public final void mouseEntered(MouseEvent me) {
            ImageZoomer.this.requestFocusInWindow();
            ImageZoomer.this.rememberMousePosition(me.getX(), me.getY());
            ImageZoomer.this._mouse_inside = true;
            if (ImageZoomer.this._zoomed_cursor != null) {
                ImageZoomer.this.repaint();
            }
        }

        @Override
        public final void mouseExited(MouseEvent me) {
            ImageZoomer.this._mouse_inside = false;
            if (ImageZoomer.this._zoomed_cursor != null) {
                ImageZoomer.this.repaint();
            }
        }

        @Override
        public final void mouseDragged(MouseEvent me) {
            ImageZoomer.this.rememberMousePosition(me.getX(), me.getY());
            int modifiers = me.getModifiersEx();
            if (ImageZoomer.this._mouse_centering && (modifiers & 0x1000) == 0) {
                ImageZoomer.this.center_mouse();
                return;
            }
            if ((modifiers & 0x1000) != 0) {
                int mouse_x = me.getX();
                int mouse_y = me.getY();
                ImageZoomer.this.do_pan(mouse_x, mouse_y);
                ImageZoomer.this.adjust_view();
                ImageZoomer.this.rememberMousePosition(me.getX(), me.getY());
                ImageZoomer.this.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            ImageZoomer.this.rememberMousePosition(me.getX(), me.getY());
            if (ImageZoomer.this._mouse_centering) {
                ImageZoomer.this.center_mouse();
                return;
            }
            if (ImageZoomer.this._zoomed_cursor != null) {
                ImageZoomer.this.repaint();
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            ImageZoomer.this.rememberMousePosition(e.getX(), e.getY());
            double zoom_per_rotation = Math.pow(0.5, 0.16666666666666666);
            double zoom_change = Math.pow(zoom_per_rotation, e.getWheelRotation());
            double fix_x = e.getX();
            double fix_y = e.getY();
            double zoom = ImageZoomer.this._zoom;
            if (zoom * zoom_change < 1.0) {
                zoom_change = 1.0 / zoom;
            }
            ImageZoomer.this.do_zoom(zoom_change, fix_x, fix_y);
            int modifiers = e.getModifiersEx();
            if ((modifiers & 0x1000) != 0) {
                ImageZoomer.this.do_pan(e.getX(), e.getY());
            }
            ImageZoomer.this.rememberMousePosition(e.getX(), e.getY());
            ImageZoomer.this.repaint();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            ImageZoomer.this.calc_scaling();
            ImageZoomer.this.adjust_view();
            ImageZoomer.this.repaint();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

