/*
 * Decompiled with CFR 0.152.
 */
package main.view2d;

import java.awt.RenderingHints;
import main.view2d.BiLinearFilter;
import main.view2d.CubicFilter;
import main.view2d.DownScaleStrategy;
import main.view2d.FilterScaleStrategy;
import main.view2d.ScaleStrategy;
import main.view2d.WindowedSincFilter;

public enum ScaleFuncType {
    SCALE_FAST_DOWN{

        @Override
        public ScaleStrategy createStrategy() {
            return new DownScaleStrategy(new ScaleStrategy.Java2DScaleStrategy(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR));
        }
    }
    ,
    SCALE_FAST{

        @Override
        public ScaleStrategy createStrategy() {
            return new ScaleStrategy.Java2DScaleStrategy(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
    }
    ,
    SCALE_QUALITY_MEDIUM{

        @Override
        public ScaleStrategy createStrategy() {
            return new ScaleStrategy.Java2DScaleStrategy(RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
    }
    ,
    SCALE_QUALITY_BEST{

        @Override
        public ScaleStrategy createStrategy() {
            return new ScaleStrategy.Java2DScaleStrategy(RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        }

        @Override
        public boolean isExpensive() {
            return true;
        }
    }
    ,
    SCALE_BILINEAR{

        @Override
        public ScaleStrategy createStrategy() {
            return new DownScaleStrategy(new FilterScaleStrategy(new BiLinearFilter()));
        }
    }
    ,
    SCALE_CUBIC{

        @Override
        public ScaleStrategy createStrategy() {
            return new DownScaleStrategy(new FilterScaleStrategy(new CubicFilter(0.4f, 0.3f)));
        }

        @Override
        public boolean isExpensive() {
            return true;
        }
    }
    ,
    SCALE_SINC{

        @Override
        public ScaleStrategy createStrategy() {
            return new DownScaleStrategy(new FilterScaleStrategy(new WindowedSincFilter(2)));
        }

        @Override
        public boolean isExpensive() {
            return true;
        }
    };


    private ScaleFuncType() {
    }

    public abstract ScaleStrategy createStrategy();

    public boolean isExpensive() {
        return false;
    }

    /* synthetic */ ScaleFuncType(String string, int n, ScaleFuncType scaleFuncType) {
        this();
    }
}

