/*
 * Decompiled with CFR 0.152.
 */
package main.view2d;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public interface ScaleStrategy {
    public void paintScaled(BufferedImage var1, BufferedImage var2, float var3, float var4, float var5, float var6, boolean var7);

    public static class Java2DScaleStrategy
    implements ScaleStrategy {
        public final Object _interpolation_function;

        public Java2DScaleStrategy(Object interpolation) {
            if (interpolation == null || !RenderingHints.KEY_INTERPOLATION.isCompatibleValue(interpolation)) {
                throw new IllegalArgumentException("Not a valid interpolation mode");
            }
            this._interpolation_function = interpolation;
        }

        @Override
        public void paintScaled(BufferedImage target, BufferedImage source, float scale_x, float scale_y, float shift_x, float shift_y, boolean useAlpha) {
            Graphics2D g = target.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this._interpolation_function);
            g.translate(shift_x, shift_y);
            g.scale(scale_x, scale_y);
            g.drawImage((Image)source, 0, 0, null);
        }
    }
}

