/*
 * Decompiled with CFR 0.152.
 */
package main.view2d;

import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import main.ImageStack;
import main.MasterControl;
import main.seggen.SegGenRegionGrow;
import main.view2d.InteractionListener;
import main.view2d.Viewport2d;
import misc.Voxel;

public class SeedInteractionListener
extends InteractionListener {
    private Viewport2d _v2d;

    public SeedInteractionListener(Viewport2d v2d) {
        this._v2d = v2d;
    }

    @Override
    public void mousePressed(MouseEvent me) {
        int modifiers = me.getModifiersEx();
        if ((modifiers & 0x400) != 0) {
            Voxel v = new Voxel();
            this._v2d.convert_panel_pos_to_voxel(me.getX(), me.getY(), v);
            ImageStack is = MasterControl.get_is();
            Voxel seed = new Voxel(v._x, v._y, v._z);
            if (me.isShiftDown()) {
                is.add_or_remove_seed(seed);
            } else {
                is.set_seed(seed);
            }
        }
    }

    @Override
    public void willBegin() {
        this._v2d.updateCursor(this, Cursor.getPredefinedCursor(1), null, 0, 0);
    }

    @Override
    public void didEnd() {
        this._v2d.updateCursor(this, Cursor.getPredefinedCursor(1), null, 0, 0);
    }

    @Override
    public boolean needsMouse() {
        return true;
    }

    @Override
    public boolean needsKeyboard() {
        return true;
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        if (ke.getKeyCode() == 32) {
            SegGenRegionGrow.start_stop();
        }
    }
}

