/*
 * Decompiled with CFR 0.152.
 */
package main.view2d;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import main.ImageStack;
import main.MasterControl;
import main.SegChangeInfo;
import main.Segment;
import main.YaDiV;
import main.seggen.SegGen;
import main.tools.ToolSegGen;
import main.view2d.ImageZoomer;
import main.view2d.InteractionListener;
import main.view2d.Viewport2d;
import misc.Voxel;
import misc.grid.BitCube;
import misc.grid.BitMask;
import misc.grid.RegularGrid3i;

public class SegDrawInteractionListener
extends InteractionListener {
    private BitMask _brush_mask;
    private Image _brush_cursor_img;
    private Viewport2d _v2d;
    private boolean _use_brush_variance = false;
    private double _brush_variance;
    private int _brush_min;
    private int _brush_max;
    private boolean _draw_mode;

    public SegDrawInteractionListener(Viewport2d v2d, boolean draw_mode) {
        this._v2d = v2d;
        this._draw_mode = draw_mode;
    }

    @Override
    public void mousePressed(MouseEvent me) {
        int modifiers = me.getModifiersEx();
        if ((modifiers & 0x400) != 0) {
            Voxel v = new Voxel();
            this._v2d.convert_panel_pos_to_voxel(me.getX(), me.getY(), v);
            ImageStack is = MasterControl.get_is();
            boolean erase_toggled = (modifiers & 0x80) != 0;
            boolean variance_toggled = (modifiers & 0x40) != 0;
            this.seg_draw(v._x, v._y, v._z, variance_toggled, erase_toggled);
            RegularGrid3i vc = is.get_voxel_cube();
            int brush_value = vc.get(v._x, v._y, v._z);
            this._brush_min = brush_value - (int)(this._brush_variance * (double)brush_value);
            this._brush_max = brush_value + (int)(this._brush_variance * (double)brush_value);
        }
        this._v2d.update_magnifier_position();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        int modifiers = me.getModifiersEx();
        if ((modifiers & 0x400) != 0) {
            Voxel v = new Voxel();
            this._v2d.convert_panel_pos_to_voxel(me.getX(), me.getY(), v);
            boolean erase_toggled = (modifiers & 0x80) != 0;
            boolean variance_toggled = (modifiers & 0x40) != 0;
            this.seg_draw(v._x, v._y, v._z, variance_toggled, erase_toggled);
        }
        this._v2d.update_magnifier_position();
        this._v2d.repaint();
    }

    @Override
    public void willBegin() {
        this.update_paint_cursor();
    }

    @Override
    public void didEnd() {
        this._v2d.updateCursor(this, Cursor.getPredefinedCursor(1), null, 0, 0);
    }

    @Override
    public boolean needsMouse() {
        return true;
    }

    @Override
    public boolean needsMouseMotion() {
        return true;
    }

    public final void set_brush_mask_cursor(BitMask bm, Image img) {
        this._brush_mask = bm;
        this._brush_cursor_img = img;
        this.update_paint_cursor();
    }

    private void update_paint_cursor() {
        int h = this._brush_cursor_img.getHeight(null);
        int w = this._brush_cursor_img.getWidth(null);
        BufferedImage _cursor_img = new BufferedImage(w, h, 2);
        Graphics2D g2 = _cursor_img.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(this._brush_cursor_img, 0, 0, w, h, null);
        g2.dispose();
        int[] pixels = ((DataBufferInt)_cursor_img.getRaster().getDataBuffer()).getData();
        int i = 0;
        while (i < pixels.length) {
            if (pixels[i] != 0) {
                pixels[i] = 0x50FF00FF;
            }
            ++i;
        }
        this._v2d.updateCursor(this, ImageZoomer.NO_CURSOR, _cursor_img, _cursor_img.getWidth(null) / 2, _cursor_img.getHeight(null) / 2);
    }

    public final void seg_draw(int x, int y, int z, boolean varianceToggled, boolean eraseToggled) {
        ImageStack is = MasterControl.get_is();
        Segment tmp_seg = is.get_segment(ToolSegGen.TMP_SEG_NAME);
        BitCube bc = tmp_seg.get_bc();
        RegularGrid3i vc = is.get_voxel_cube();
        boolean draw_or_clear = this._draw_mode ^ eraseToggled;
        boolean use_brush_variance = this._use_brush_variance ^ varianceToggled;
        int[] bb_min = SegGen.get_real_bb_min();
        int[] bb_max = SegGen.get_real_bb_max();
        int mode = this._v2d.get_model().get_view_mode();
        switch (mode) {
            case 0: {
                int ciy_min;
                int ix_min = x - (this._brush_mask.get_dim_x() - 1) / 2;
                int iy_min = y - (this._brush_mask.get_dim_y() - 1) / 2;
                int ix_max = x + (this._brush_mask.get_dim_x() + 1) / 2;
                int iy_max = y + (this._brush_mask.get_dim_y() + 1) / 2;
                if (ix_max > bb_max[0] + 1) {
                    ix_max = bb_max[0] + 1;
                }
                if (iy_max > bb_max[1] + 1) {
                    iy_max = bb_max[1] + 1;
                }
                int cix_min = ix_min < bb_min[0] ? bb_min[0] : ix_min;
                int iy = ciy_min = iy_min < bb_min[1] ? bb_min[1] : iy_min;
                while (iy < iy_max) {
                    int ix = cix_min;
                    while (ix < ix_max) {
                        if (this._brush_mask.getXY(ix - ix_min, iy - iy_min)) {
                            if (use_brush_variance) {
                                int value = vc.get(ix, iy, z);
                                if (value >= this._brush_min && value <= this._brush_max) {
                                    bc.setXYZ(ix, iy, z, draw_or_clear);
                                }
                            } else {
                                bc.setXYZ(ix, iy, z, draw_or_clear);
                            }
                        }
                        ++ix;
                    }
                    ++iy;
                }
                int[] bb = new int[]{cix_min, ciy_min, z, ix_max, iy_max, z};
                tmp_seg.new_data(new SegChangeInfo(SegChangeInfo.BOUNDED_CHANGE, bb), true);
                break;
            }
            case 1: {
                int iy_min = y - (this._brush_mask.get_dim_x() - 1) / 2;
                int iz_min = z - (this._brush_mask.get_dim_y() - 1) / 2;
                int iy_max = y + (this._brush_mask.get_dim_x() + 1) / 2;
                int iz_max = z + (this._brush_mask.get_dim_y() + 1) / 2;
                if (iy_max > bb_max[1] + 1) {
                    iy_max = bb_max[1] + 1;
                }
                if (iz_max > bb_max[2] + 1) {
                    iz_max = bb_max[2] + 1;
                }
                int ciy_min = iy_min < bb_min[1] ? bb_min[1] : iy_min;
                int ciz_min = iz_min < bb_min[2] ? bb_min[2] : iz_min;
                int iy = ciy_min;
                while (iy < iy_max) {
                    int iz = ciz_min;
                    while (iz < iz_max) {
                        if (this._brush_mask.getXY(iy - iy_min, iz - iz_min)) {
                            if (use_brush_variance) {
                                int value = vc.get(x, iy, iz);
                                if (value >= this._brush_min && value <= this._brush_max) {
                                    bc.setXYZ(x, iy, iz, draw_or_clear);
                                }
                            } else {
                                bc.setXYZ(x, iy, iz, draw_or_clear);
                            }
                        }
                        ++iz;
                    }
                    ++iy;
                }
                int[] bb = new int[]{x, ciy_min, ciz_min, x, iy_max, iz_max};
                tmp_seg.new_data(new SegChangeInfo(SegChangeInfo.BOUNDED_CHANGE, bb), true);
                break;
            }
            case 2: {
                int ciz_min;
                int ix_min = x - (this._brush_mask.get_dim_x() - 1) / 2;
                int iz_min = z - (this._brush_mask.get_dim_y() - 1) / 2;
                int ix_max = x + (this._brush_mask.get_dim_x() + 1) / 2;
                int iz_max = z + (this._brush_mask.get_dim_y() + 1) / 2;
                if (ix_max > bb_max[0] + 1) {
                    ix_max = bb_max[0] + 1;
                }
                if (iz_max > bb_max[2] + 1) {
                    iz_max = bb_max[2] + 1;
                }
                int cix_min = ix_min < bb_min[0] ? bb_min[0] : ix_min;
                int iz = ciz_min = iz_min < bb_min[2] ? bb_min[2] : iz_min;
                while (iz < iz_max) {
                    int ix = cix_min;
                    while (ix < ix_max) {
                        if (this._brush_mask.getXY(ix - ix_min, iz - iz_min)) {
                            if (use_brush_variance) {
                                int value = vc.get(ix, y, iz);
                                if (value >= this._brush_min && value <= this._brush_max) {
                                    bc.setXYZ(ix, y, iz, draw_or_clear);
                                }
                            } else {
                                bc.setXYZ(ix, y, iz, draw_or_clear);
                            }
                        }
                        ++ix;
                    }
                    ++iz;
                }
                int[] bb = new int[]{cix_min, y, ciz_min, ix_max, y, iz_max};
                tmp_seg.new_data(new SegChangeInfo(SegChangeInfo.BOUNDED_CHANGE, bb), true);
                break;
            }
            default: {
                YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "Error: Unsupported Viewmode: " + mode);
            }
        }
    }

    public final void use_brush_variance(boolean flag) {
        this._use_brush_variance = flag;
    }

    public final void set_brush_variance(double d) {
        this._brush_variance = d;
    }
}

