/*
 * Decompiled with CFR 0.152.
 */
package main.view2d;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import main.MasterControl;
import main.Segment;
import main.tools.ToolSegGen;
import main.view2d.InteractionListener;
import main.view2d.Viewport2d;
import misc.Voxel;

public class TranslateSegInteractionListener
extends InteractionListener {
    private Viewport2d _v2d;
    private int _last_x;
    private int _last_y;
    private int _last_z;
    private long _last_time = 0L;

    public TranslateSegInteractionListener(Viewport2d v2d) {
        this._v2d = v2d;
    }

    @Override
    public void mousePressed(MouseEvent me) {
        int modifiers = me.getModifiersEx();
        if ((modifiers & 0x400) != 0) {
            Voxel v = new Voxel();
            this._v2d.convert_panel_pos_to_voxel(me.getX(), me.getY(), v);
            this._last_x = v._x;
            this._last_y = v._y;
            this._last_z = v._z;
        }
        this._v2d.update_magnifier_position();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        int modifiers = me.getModifiersEx();
        if ((modifiers & 0x400) != 0) {
            Voxel v = new Voxel();
            this._v2d.convert_panel_pos_to_voxel(me.getX(), me.getY(), v);
            if (System.currentTimeMillis() - this._last_time > 10L) {
                this._last_time = System.currentTimeMillis();
                Segment seg = MasterControl.get_is().get_segment(ToolSegGen.TMP_SEG_NAME);
                seg.translate(v._x - this._last_x, v._y - this._last_y, v._z - this._last_z);
                this._last_x = v._x;
                this._last_y = v._y;
                this._last_z = v._z;
            }
        }
        this._v2d.update_magnifier_position();
        this._v2d.repaint();
    }

    @Override
    public void willBegin() {
        this._v2d.updateCursor(this, Cursor.getPredefinedCursor(1), null, 0, 0);
    }

    @Override
    public void didEnd() {
        this._v2d.updateCursor(this, Cursor.getPredefinedCursor(1), null, 0, 0);
    }

    @Override
    public boolean needsMouse() {
        return true;
    }

    @Override
    public boolean needsMouseMotion() {
        return true;
    }
}

