/*
 * Decompiled with CFR 0.152.
 */
package main.view2d;

import gui.JTFSliderInt;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import main.ImageStack;
import main.Magnifier;
import main.MasterControl;
import main.Message;
import main.Segment;
import main.Viewport;
import main.seggen.SegGen;
import main.tools.ToolSegGen;
import main.view2d.BBoxInteractionListener;
import main.view2d.ImageSelector;
import main.view2d.ImageZoomer;
import main.view2d.InteractionListener;
import main.view2d.ScaleFuncType;
import main.view2d.SeedInteractionListener;
import main.view2d.SegDrawInteractionListener;
import main.view2d.TranslateSegInteractionListener;
import main.view2d.Viewport2dModel;
import main.view2d.Viewport2dToolbar;
import misc.Voxel;
import misc.messages.YObservable;
import renderer.BBoxRenderer2d;
import renderer.BGImageRenderer2d;
import renderer.Renderer2d;
import renderer.SegRenderer2d;
import settings.Settings;
import settings.SettingsOwner;

public final class Viewport2d
extends Viewport
implements SettingsOwner {
    public static final String OPT_SCALE_FUNC = Settings.register_enum_opt(Viewport2d.class, "scale function", "Sets the quality of the scaling", ScaleFuncType.SCALE_FAST);
    public static final String OPT_ZOOM = Settings.register_double_opt(Viewport2d.class, "zoom", "Zoom level", 1.0);
    public static final String OPT_NEAR_ALPHA = Settings.register_double_opt(Viewport2d.class, "near slice alpha", "Render intensity of the next and previous slice. Values from 0 to  0.5", 0.0);
    public static final int VIEWMODE_T = 0;
    public static final int VIEWMODE_S = 1;
    public static final int VIEWMODE_F = 2;
    public static final String[] VIEWMODE_STR = new String[]{"Transversal", "Sagittal", "Frontal"};
    public static final int MODE_XYZ = 0;
    public static final int MODE_DRAW = 1;
    public static final int MODE_ERASE = 2;
    public static final int MODE_TRANS = 3;
    private final ImageZoomer _izoom;
    private final ImageSelector _img_sel;
    private final Viewport2dModel _v2d_model;
    private final Viewport2dToolbar _view2d_toolbar;
    private final Hashtable<Renderer2d, Integer> _layer_depths;
    private final Hashtable<Renderer2d, Image> _layer_imgs;
    private final Hashtable<Segment, SegRenderer2d> _seg_renderers;
    private final LinkedList<Renderer2d> _layers;
    private final BBoxRenderer2d _seg_bbox_renderer;
    private final BGImageRenderer2d _bg_img_renderer;
    private final BGImageRenderer2d _below_renderer;
    private final BGImageRenderer2d _above_renderer;
    private final PanelListener _pl;
    private double _zoom_center_x;
    private double _zoom_center_y;
    private double _zoom_center_z;
    private BufferedImage _bimg;
    public SeedInteractionListener seed_listener;
    public TranslateSegInteractionListener _translate_seg_listener;
    public SegDrawInteractionListener _draw_seg_listener;
    public SegDrawInteractionListener _erase_seg_listener;
    public BBoxInteractionListener _bbox_listener;

    public Viewport2d() {
        Settings.register_owner(this);
        this._v2d_model = new Viewport2dModel();
        this._izoom = new ImageZoomer();
        this._izoom.setMinimumSize(new Dimension(this.DEF_WIDTH / 4, this.DEF_HEIGHT / 4));
        this._izoom.setPreferredSize(new Dimension(this.DEF_WIDTH, this.DEF_HEIGHT));
        this._pl = new PanelListener();
        this._izoom.addMouseListener(this._pl);
        this._izoom.addMouseMotionListener(this._pl);
        this._izoom.addPropertyChangeListener(this._pl);
        this._izoom.set_scale_function((ScaleFuncType)Settings.get_enum_option(this, OPT_SCALE_FUNC));
        this.reallocate();
        this.seed_listener = new SeedInteractionListener(this);
        this._translate_seg_listener = new TranslateSegInteractionListener(this);
        this._draw_seg_listener = new SegDrawInteractionListener(this, true);
        this._erase_seg_listener = new SegDrawInteractionListener(this, false);
        this._bbox_listener = new BBoxInteractionListener(this);
        this._v2d_model.default_listener = this.seed_listener;
        this.setInteractionListener(this.seed_listener);
        this._img_sel = new ImageSelector(this._v2d_model);
        this._img_sel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int slice_index;
                String property = evt.getPropertyName();
                if (JTFSliderInt.JTF_CHANGE.equals(property) && (slice_index = Viewport2d.this._img_sel.getValue()) >= 0) {
                    Viewport2d.this._v2d_model.set_active_image(slice_index);
                }
            }
        });
        this._img_sel.setEnabled(false);
        this._layer_depths = new Hashtable();
        this._layer_imgs = new Hashtable();
        this._layers = new LinkedList();
        this._seg_renderers = new Hashtable();
        this.setLayout(new BorderLayout());
        JCheckBox jbc = new JCheckBox("Show Selection", true);
        jbc.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean show = e.getStateChange() == 1;
                Viewport2d.this.show_seg(MasterControl.get_is().get_segment(ToolSegGen.TMP_SEG_NAME), show);
            }
        });
        this._view2d_toolbar = new Viewport2dToolbar(this, this._img_sel.get_ftf());
        JPanel title_panel = new JPanel();
        title_panel.setLayout(new BorderLayout());
        title_panel.add((Component)new JLabel("  View 2d"), "Center");
        title_panel.add((Component)this._view2d_toolbar, "East");
        this.setLayout(new BorderLayout());
        this.add((Component)title_panel, "North");
        this.add((Component)this._izoom, "Center");
        this.add((Component)this._img_sel.get_slider(), "East");
        double alpha = Settings.get_double_option(this, OPT_NEAR_ALPHA);
        this._bg_img_renderer = new BGImageRenderer2d("BGIR View2d");
        this._below_renderer = new BGImageRenderer2d("below", -1, (int)(255.0 * alpha / (1.0 - alpha)));
        this._above_renderer = new BGImageRenderer2d("above", 1, (int)(255.0 * alpha));
        this.add_renderer(this._bg_img_renderer, 0);
        if (alpha != 0.0) {
            this.add_renderer(this._below_renderer, 1);
            this.add_renderer(this._above_renderer, 2);
        }
        this._seg_bbox_renderer = new BBoxRenderer2d(SegGen.get_seg_gen_bb(), "Seg Generator Bounding Box");
        Settings.set_color_option(this._seg_bbox_renderer, BBoxRenderer2d.OPT_COLOR, new Color(255, 128, 128));
        this.add_renderer(this._seg_bbox_renderer, 100);
        this._v2d_model.addObserver(this, "Viewport2d()");
        MasterControl.get_is().addObserver(this, "Viewport2d()");
    }

    public void render_into_image(BufferedImage bimg, int view_mode, int slice, boolean volume_data_only) {
        int[] bimg_alpha_pixels = ((DataBufferInt)bimg.getRaster().getDataBuffer()).getData();
        Arrays.fill(bimg_alpha_pixels, -16777216);
        int w = bimg.getWidth();
        int h = bimg.getHeight();
        Graphics2D g2 = (Graphics2D)bimg.getGraphics();
        BufferedImage layer_image = new BufferedImage(w, h, bimg.getType());
        if (volume_data_only) {
            layer_image = (BufferedImage)this._bg_img_renderer.render_image(view_mode, slice);
            g2.drawImage(layer_image, 0, 0, w, h, null);
        } else {
            for (Renderer2d lr : this._layers) {
                if (!lr.is_visible()) continue;
                layer_image = (BufferedImage)lr.render_image(view_mode, slice);
                g2.drawImage(layer_image, 0, 0, w, h, null);
            }
        }
    }

    public void render_all(boolean update_everything) {
        int[] bimg_alpha_pixels = ((DataBufferInt)this._bimg.getRaster().getDataBuffer()).getData();
        Arrays.fill(bimg_alpha_pixels, -16777216);
        Graphics2D g2 = (Graphics2D)this._bimg.getGraphics();
        int viewmode = this._v2d_model.get_view_mode();
        int active_image_index = this._v2d_model.get_active_image();
        for (Renderer2d lr : this._layers) {
            if (!lr.is_visible()) continue;
            if (update_everything) {
                this._layer_imgs.put(lr, lr.render_image(viewmode, active_image_index));
            }
            g2.drawImage(this._layer_imgs.get(lr), 0, 0, this._bimg.getWidth(), this._bimg.getHeight(), null);
        }
        this._izoom.imageChanged();
        this.repaint();
    }

    private void reallocate() {
        ImageStack is = MasterControl.get_is();
        double x_spacing = is.get_x_spacing();
        double y_spacing = is.get_y_spacing();
        double z_spacing = is.get_z_spacing();
        double zoom = Settings.get_double_option(this, OPT_ZOOM);
        if (is.get_dim_x() == 0) {
            double img_h_scaling = 1.0;
            double img_w_scaling = 1.0;
            this._bimg = new BufferedImage(10, 10, 2);
            this._izoom.set_image(this._bimg, img_w_scaling, img_h_scaling, 5.0, 5.0, zoom);
        } else {
            int view_mode = this._v2d_model.get_view_mode();
            switch (view_mode) {
                case 0: {
                    this._bimg = new BufferedImage(is.get_dim_x(), is.get_dim_y(), 2);
                    double img_w_scaling = x_spacing;
                    double img_h_scaling = y_spacing;
                    this._izoom.set_image(this._bimg, img_w_scaling, img_h_scaling, this._zoom_center_x, this._zoom_center_y, zoom);
                    break;
                }
                case 1: {
                    this._bimg = new BufferedImage(is.get_dim_y(), is.get_dim_z(), 2);
                    double img_w_scaling = y_spacing;
                    double img_h_scaling = z_spacing;
                    this._izoom.set_image(this._bimg, img_w_scaling, img_h_scaling, this._zoom_center_y, this._zoom_center_z, zoom);
                    break;
                }
                default: {
                    assert (view_mode == 2);
                    this._bimg = new BufferedImage(is.get_dim_x(), is.get_dim_z(), 2);
                    double img_w_scaling = x_spacing;
                    double img_h_scaling = z_spacing;
                    this._izoom.set_image(this._bimg, img_w_scaling, img_h_scaling, this._zoom_center_x, this._zoom_center_z, zoom);
                }
            }
            this.update_magnifier_state();
        }
    }

    public void update_magnifier_position() {
        ImageStack is = MasterControl.get_is();
        int x = (int)this._izoom.get_mouse_pos_x();
        int y = (int)this._izoom.get_mouse_pos_y();
        if (is.get_state() == 2) {
            int viewmode = this._v2d_model.get_view_mode();
            int active_image_index = this._v2d_model.get_active_image();
            if (viewmode == 0) {
                Magnifier.magnify(x, y, x, y, active_image_index);
            } else if (viewmode == 1) {
                Magnifier.magnify(x, y, active_image_index, x, y);
            } else {
                Magnifier.magnify(x, y, x, active_image_index, y);
            }
        }
    }

    private void update_magnifier_state() {
        if (this._izoom.is_mouse_inside() && MasterControl.get_is().get_state() == 2) {
            Magnifier.set_image(this._layer_imgs.get(this._bg_img_renderer), this._bimg);
            this.update_magnifier_position();
        } else {
            Magnifier.set_image(null, null);
        }
    }

    public void convert_panel_pos_to_voxel(int x, int y, Voxel v) {
        double tx = this._izoom.screen_to_pixel_x(x);
        double ty = this._izoom.screen_to_pixel_y(y);
        int viewmode = this._v2d_model.get_view_mode();
        int active_image_index = this._v2d_model.get_active_image();
        if (viewmode == 0) {
            v._x = (int)tx;
            v._y = (int)ty;
            v._z = active_image_index;
        } else if (viewmode == 1) {
            v._x = active_image_index;
            v._y = (int)tx;
            v._z = (int)ty;
        } else {
            v._x = (int)tx;
            v._y = active_image_index;
            v._z = (int)ty;
        }
    }

    public boolean add_renderer(Renderer2d lr, int depth) {
        if (this._layer_depths.containsKey(lr)) {
            return false;
        }
        lr.allocate();
        this._layer_depths.put(lr, depth);
        ListIterator<Renderer2d> ilr = this._layers.listIterator();
        while (ilr.hasNext()) {
            Renderer2d l = (Renderer2d)ilr.next();
            if (this._layer_depths.get(l) > depth) break;
        }
        ilr.add(lr);
        this._layer_imgs.put(lr, lr.render_image(this._v2d_model.get_view_mode(), this._v2d_model.get_active_image()));
        lr.addObserver(this, "Viewport2d::add_renderer()");
        this.render_all(false);
        return true;
    }

    public void del_renderer(Renderer2d lr) {
        this._layer_depths.remove(lr);
        this._layers.remove(lr);
        this._layer_imgs.remove(lr);
        lr.deleteObserver(this);
        this.render_all(false);
    }

    private final void add_seg_renderer(Segment seg) {
        SegRenderer2d sr = new SegRenderer2d(seg);
        this.add_renderer(sr, 10 + this._seg_renderers.size());
        this._seg_renderers.put(seg, sr);
        this.show_seg(seg, true);
    }

    private final void del_seg_renderer(Segment seg) {
        SegRenderer2d sr = this._seg_renderers.get(seg);
        this.show_seg(seg, false);
        this._seg_renderers.remove(seg);
        this.del_renderer(sr);
    }

    public final void show_seg(Segment seg, boolean show) {
        Renderer2d lr = this._seg_renderers.get(seg);
        if (show && !lr.is_visible()) {
            lr.addObserver(this, "Viewport2d::show_seg()");
        }
        if (!show && lr.is_visible()) {
            lr.deleteObserver(this);
        }
        this._seg_renderers.get(seg).set_visible(show);
        this._layer_imgs.put(lr, lr.render_image(this._v2d_model.get_view_mode(), this._v2d_model.get_active_image()));
        this.repaint();
        ImageStack is = MasterControl.get_is();
        if (is.get_state() != 1 && is.get_state() != 3) {
            this.render_all(false);
        }
    }

    public SegRenderer2d get_seg_renderer(Segment seg) {
        return this._seg_renderers.get(seg);
    }

    public BBoxRenderer2d get_seg_bbox_renderer() {
        return this._seg_bbox_renderer;
    }

    public BGImageRenderer2d get_bg_image_renderer() {
        return this._bg_img_renderer;
    }

    @Override
    public void update(YObservable o, Message m) {
        ImageStack is = MasterControl.get_is();
        int _viewmode = this._v2d_model.get_view_mode();
        int _active_image_index = this._v2d_model.get_active_image();
        if (m._type == ImageStack.M_CLEAR) {
            this._v2d_model.set_active_image(0, 0);
            this._v2d_model.set_active_image(1, 0);
            this._v2d_model.set_active_image(2, 0);
            this._v2d_model.set_view_mode(0);
            this._img_sel.setEnabled(false);
        } else if (m._type == ImageStack.M_LOADING_START) {
            this._view2d_toolbar.setEnabled(false);
        } else if (m._type == ImageStack.M_LOADING_FIRST_IMAGE) {
            this._img_sel.setEnabled(true);
        } else if (m._type == ImageStack.M_VC_SET) {
            ImageStack.MessageDimChangedInfo info = (ImageStack.MessageDimChangedInfo)m._obj;
            Settings.set_double_option(this, OPT_ZOOM, 1.0);
            this._zoom_center_x = (double)is.get_dim_x() * 0.5;
            this._zoom_center_y = (double)is.get_dim_y() * 0.5;
            this._zoom_center_z = (double)is.get_dim_z() * 0.5;
            this._bg_img_renderer.init_roi_func();
            this._below_renderer.init_roi_func();
            this._above_renderer.init_roi_func();
            this.reallocate();
            double x_fact = (double)info._dim_x_new / (double)info._dim_x_old;
            double y_fact = (double)info._dim_y_new / (double)info._dim_y_old;
            double z_fact = (double)info._dim_z_new / (double)info._dim_z_old;
            int new_active_image_t = (int)((double)this._v2d_model.get_active_image(0) * z_fact + 0.5);
            int new_active_image_s = (int)((double)this._v2d_model.get_active_image(1) * x_fact + 0.5);
            int new_active_image_f = (int)((double)this._v2d_model.get_active_image(2) * y_fact + 0.5);
            if (new_active_image_t > info._dim_z_new - 1) {
                new_active_image_t = info._dim_z_new - 1;
            }
            if (new_active_image_s > info._dim_x_new - 1) {
                new_active_image_s = info._dim_x_new - 1;
            }
            if (new_active_image_f > info._dim_y_new - 1) {
                new_active_image_f = info._dim_y_new - 1;
            }
            this._v2d_model.set_active_image(0, new_active_image_t);
            this._v2d_model.set_active_image(1, new_active_image_s);
            this._v2d_model.set_active_image(2, new_active_image_f);
            this.render_all(true);
        } else if (m._type == ImageStack.M_VC_SPACING_CHANGED) {
            double x_spacing = is.get_x_spacing();
            double y_spacing = is.get_y_spacing();
            double z_spacing = is.get_z_spacing();
            int view_mode = this._v2d_model.get_view_mode();
            switch (view_mode) {
                case 0: {
                    this._izoom.set_scaling(x_spacing, y_spacing);
                    break;
                }
                case 1: {
                    this._izoom.set_scaling(y_spacing, z_spacing);
                    break;
                }
                default: {
                    assert (view_mode == 2);
                    this._izoom.set_scaling(x_spacing, z_spacing);
                }
            }
            this.render_all(true);
        } else if (m._type == ImageStack.M_LOADING_NEW_IMAGE) {
            Settings.set_class_int_option(BGImageRenderer2d.class, BGImageRenderer2d.OPT_W_WIDTH, is.get_grey_window_width());
            Settings.set_class_int_option(BGImageRenderer2d.class, BGImageRenderer2d.OPT_W_CENTER, is.get_grey_window_center());
        } else if (m._type == ImageStack.M_LOADING_END) {
            this._view2d_toolbar.setEnabled(true);
            this.add_seg_renderer(MasterControl.get_is().get_segment(ToolSegGen.TMP_SEG_NAME));
            this._zoom_center_z = (double)is.get_dim_z() * 0.5;
            this.update_magnifier_state();
        } else if (m._type == ImageStack.M_SELECTXYZ) {
            if (is.get_state() == 2) {
                this._layer_imgs.put(this._bg_img_renderer, this._bg_img_renderer.render_image(_viewmode, _active_image_index));
                this._layer_imgs.put(this._below_renderer, this._below_renderer.render_image(_viewmode, _active_image_index));
                this._layer_imgs.put(this._above_renderer, this._above_renderer.render_image(_viewmode, _active_image_index));
                this.render_all(false);
            }
        } else if (m._type == Viewport2dModel.M_NEW_ACTIVE_IMAGE) {
            this.render_all(true);
        } else if (m._type == Viewport2dModel.M_NEW_VIEW_MODE) {
            this.reallocate();
            this.render_all(true);
        } else if (m._type == Renderer2d.M_REQUEST_REDRAW) {
            Renderer2d lr = (Renderer2d)o;
            this._layer_imgs.put(lr, lr.render_image(_viewmode, _active_image_index));
            this.render_all(false);
        } else if (m._type == ImageStack.M_NEW_SEGMENT) {
            Segment seg = (Segment)m._obj;
            this.add_seg_renderer(seg);
        } else if (m._type == ImageStack.M_DEL_SEGMENT) {
            Segment seg = (Segment)m._obj;
            this.del_seg_renderer(seg);
        } else if (m._type == ImageStack.M_RESIZE_END) {
            this.render_all(true);
        }
    }

    @Override
    public final String get_name() {
        return "Viewport 2d";
    }

    @Override
    public final void settings_changed(Object obj, String opt_name, Object opt) {
        if (opt_name == OPT_SCALE_FUNC) {
            this._izoom.set_scale_function((ScaleFuncType)((Object)opt));
        }
        if (opt_name == OPT_ZOOM) {
            this._izoom.set_zoom_factor((Double)opt);
            this._view2d_toolbar._zoom_spinner.setValue(opt);
        }
        if (opt_name == OPT_NEAR_ALPHA) {
            double alpha = Settings.get_double_option(this, OPT_NEAR_ALPHA);
            if (alpha > 0.5) {
                Settings.set_double_option(this, opt_name, 0.5);
                return;
            }
            if (alpha < 0.0) {
                Settings.set_double_option(this, opt_name, 0.0);
                return;
            }
            this._below_renderer.set_default_alpha((int)(255.0 * alpha / (1.0 - alpha)));
            this._above_renderer.set_default_alpha((int)(255.0 * alpha));
            if (alpha == 0.0) {
                this.del_renderer(this._below_renderer);
                this.del_renderer(this._above_renderer);
            } else if (!this.add_renderer(this._below_renderer, 1) & !this.add_renderer(this._above_renderer, 2)) {
                this.render_all(true);
            }
        }
    }

    public Viewport2dModel get_model() {
        return this._v2d_model;
    }

    public void setInteractionListener(InteractionListener ml) {
        if (ml == this._v2d_model.getActiveInteractionListener()) {
            return;
        }
        if (this._v2d_model.getActiveInteractionListener() != null) {
            this._v2d_model.getActiveInteractionListener().didEnd();
            if (this._v2d_model.getActiveInteractionListener().needsMouse()) {
                this._izoom.removeMouseListener(this._v2d_model.getActiveInteractionListener());
            }
            if (this._v2d_model.getActiveInteractionListener().needsMouseMotion()) {
                this._izoom.removeMouseMotionListener(this._v2d_model.getActiveInteractionListener());
            }
            if (this._v2d_model.getActiveInteractionListener().needsMouse()) {
                this._izoom.removeKeyListener(this._v2d_model.getActiveInteractionListener());
            }
            this._v2d_model.previous_listener = this._v2d_model.getActiveInteractionListener() == this.seed_listener || this._v2d_model.getActiveInteractionListener() == this._translate_seg_listener || this._v2d_model.getActiveInteractionListener() == this._draw_seg_listener || this._v2d_model.getActiveInteractionListener() == this._erase_seg_listener ? this._v2d_model.getActiveInteractionListener() : null;
        }
        this._v2d_model.setActiveInteractionListener(ml);
        if (ml == null) {
            return;
        }
        this._v2d_model.getActiveInteractionListener().willBegin();
        if (this._v2d_model.getActiveInteractionListener().needsMouse()) {
            this._izoom.addMouseListener(this._v2d_model.getActiveInteractionListener());
        }
        if (this._v2d_model.getActiveInteractionListener().needsMouseMotion()) {
            this._izoom.addMouseMotionListener(this._v2d_model.getActiveInteractionListener());
        }
        if (this._v2d_model.getActiveInteractionListener().needsKeyboard()) {
            this._izoom.addKeyListener(this._v2d_model.getActiveInteractionListener());
        }
    }

    public void removeInteractionListener(InteractionListener ml) {
        if (ml == this._v2d_model.getActiveInteractionListener()) {
            if (this._v2d_model.previous_listener == null) {
                this.setInteractionListener(this._v2d_model.default_listener);
            } else {
                this.setInteractionListener(this._v2d_model.previous_listener);
            }
        }
    }

    public void updateCursor(InteractionListener ml, Cursor cursor, BufferedImage cursor_img, int hot_x, int hot_y) {
        if (ml == this._v2d_model.getActiveInteractionListener()) {
            this._izoom.setCursor(cursor);
            this._izoom.set_zoomed_cursor(cursor_img, hot_x, hot_y);
        }
    }

    public class PanelListener
    implements MouseListener,
    MouseMotionListener,
    PropertyChangeListener {
        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Viewport2d.this.update_magnifier_state();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            Viewport2d.this.update_magnifier_position();
            Viewport2d.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Viewport2d.this.update_magnifier_position();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Viewport2d.this.update_magnifier_state();
        }

        @Override
        public void mousePressed(MouseEvent me) {
            Viewport2d.this.update_magnifier_position();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Settings.set_double_option(Viewport2d.this, OPT_ZOOM, Viewport2d.this._izoom.get_zoom_factor());
            this.set_zoom_center_2d(Viewport2d.this._izoom.get_zoom_center_x(), Viewport2d.this._izoom.get_zoom_center_y());
            Viewport2d.this.update_magnifier_position();
        }

        private void set_zoom_center_2d(double center_x_new, double center_y_new) {
            int viewmode = Viewport2d.this._v2d_model.get_view_mode();
            if (viewmode == 0) {
                Viewport2d.this._zoom_center_x = center_x_new;
                Viewport2d.this._zoom_center_y = center_y_new;
            } else if (viewmode == 1) {
                Viewport2d.this._zoom_center_y = center_x_new;
                Viewport2d.this._zoom_center_z = center_y_new;
            } else {
                Viewport2d.this._zoom_center_x = center_x_new;
                Viewport2d.this._zoom_center_z = center_y_new;
            }
        }
    }
}

