/*
 * Decompiled with CFR 0.152.
 */
package main.view2d;

import gui.MyToolbar;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import main.MasterControl;
import main.Message;
import main.tools.ToolSegGen;
import main.view2d.Viewport2d;
import main.view2d.Viewport2dModel;
import misc.messages.YObservable;
import misc.messages.YObserver;
import renderer.BGImageRenderer2d;
import settings.Settings;

class Viewport2dToolbar
extends MyToolbar
implements YObserver {
    JToggleButton _jtb_tra;
    JToggleButton _jtb_sag;
    JToggleButton _jtb_fro;
    JToggleButton _jtb_bg;
    JToggleButton _jtb_tmpseg;
    JSpinner _zoom_spinner;
    final Viewport2d _v2d;

    public Viewport2dToolbar(Viewport2d v2d, JFormattedTextField _jtf_selector) {
        this._v2d = v2d;
        this._zoom_spinner = new JSpinner(new SpinnerNumberModel(1.0, 1.0, 10000.0, 0.16666666666666666));
        this._zoom_spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                double new_zoom;
                double zoom = Settings.get_double_option(Viewport2dToolbar.this._v2d, Viewport2d.OPT_ZOOM);
                if (zoom != (new_zoom = ((Number)Viewport2dToolbar.this._zoom_spinner.getValue()).doubleValue())) {
                    Settings.set_double_option(Viewport2dToolbar.this._v2d, Viewport2d.OPT_ZOOM, new_zoom);
                }
            }
        });
        AbstractAction act_tra = new AbstractAction("Transversal", new ImageIcon("resources/gfx/view_trans.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Viewport2dToolbar.this._v2d.get_model().set_view_mode(0);
            }
        };
        AbstractAction act_sag = new AbstractAction("Sagittal", new ImageIcon("resources/gfx/view_sag.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Viewport2dToolbar.this._v2d.get_model().set_view_mode(1);
            }
        };
        AbstractAction act_fro = new AbstractAction("Frontal", new ImageIcon("resources/gfx/view_front.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Viewport2dToolbar.this._v2d.get_model().set_view_mode(2);
            }
        };
        AbstractAction act_bg = new AbstractAction("Show DICOM Data", new ImageIcon("resources/gfx/view_tex2d_bg.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.set_bool_option(Viewport2dToolbar.this._v2d.get_bg_image_renderer(), BGImageRenderer2d.OPT_VISIBLE, Viewport2dToolbar.this._jtb_bg.isSelected());
            }
        };
        AbstractAction act_tmpseg = new AbstractAction("Show Selection", new ImageIcon("resources/gfx/view_tmp_seg.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Viewport2dToolbar.this._v2d.show_seg(MasterControl.get_is().get_segment(ToolSegGen.TMP_SEG_NAME), Viewport2dToolbar.this._jtb_tmpseg.isSelected());
            }
        };
        ButtonGroup bg = new ButtonGroup();
        this.add(new JLabel("Zoom: "));
        this.add(this._zoom_spinner);
        this.add(Box.createHorizontalStrut(20));
        this.addSeparator();
        this._jtb_tra = this.add_toggle_button(act_tra, "Transversal View", true, bg);
        this._jtb_sag = this.add_toggle_button(act_sag, "Sagittal View", false, bg);
        this._jtb_fro = this.add_toggle_button(act_fro, "Frontal View", false, bg);
        this.addSeparator();
        this._jtb_bg = this.add_toggle_button(act_bg, "Show DICOM Data", true);
        this._jtb_tmpseg = this.add_toggle_button(act_tmpseg, "Show Selection", true);
        this.add(_jtf_selector);
        this.setEnabled(false);
        this._v2d.get_model().addObserver(this, "Viewport2dToolbar()");
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this._zoom_spinner.setEnabled(flag);
    }

    @Override
    public void update(YObservable yo, Message m) {
        if (m._type == Viewport2dModel.M_NEW_VIEW_MODE) {
            int view_mode = this._v2d.get_model().get_view_mode();
            if (view_mode == 0) {
                this._jtb_tra.setSelected(true);
            } else if (view_mode == 1) {
                this._jtb_sag.setSelected(true);
            } else {
                assert (view_mode == 2);
                this._jtb_fro.setSelected(true);
            }
        }
    }
}

