/*
 * Decompiled with CFR 0.152.
 */
package main.view2d;

import main.view2d.Filter;

public class WindowedSincFilter
implements Filter {
    private final float _pi_div_xm;
    private final float _four_div_xm;
    private final int _width;
    private final float[] _x_kernel;

    public WindowedSincFilter(int w) {
        this._width = w;
        this._pi_div_xm = (float)(Math.PI / (double)w);
        this._four_div_xm = 4.0f / (float)w;
        this._x_kernel = new float[2 * w + 3];
    }

    private static float sinc(float x) {
        return x == 0.0f ? 1.0f : (float)Math.sin(x) / x;
    }

    private float kernel(float x) {
        return (1.0f + (float)Math.cos(x * this._pi_div_xm)) * WindowedSincFilter.sinc(x * this._four_div_xm);
    }

    @Override
    public int safe_max_x() {
        return 0;
    }

    @Override
    public int safe_max_y() {
        return 0;
    }

    @Override
    public int safe_min_x() {
        return 0;
    }

    @Override
    public int safe_min_y() {
        return 0;
    }

    @Override
    public int sample(float px, float py, int[] data, int lineWidth) {
        return this.sample_unsafe(px, py, data, lineWidth);
    }

    @Override
    public int sample_noAlpha(float px, float py, int[] data, int width) {
        int ix = (int)px;
        int iy = (int)py;
        int height = data.length / width;
        int y_start = iy - this._width + 1 < 0 ? 0 : iy - this._width + 1;
        int y_end = iy + this._width + 1 > height - 1 ? height - 1 : iy + this._width + 1;
        int x_start = ix - this._width + 1 < 0 ? 0 : ix - this._width + 1;
        int x_end = ix + this._width + 1 > width - 1 ? width - 1 : ix + this._width + 1;
        float asum = 0.0f;
        float rsum = 0.0f;
        float gsum = 0.0f;
        float bsum = 0.0f;
        int x = x_start;
        int i = 0;
        while (x < x_end) {
            this._x_kernel[i] = this.kernel(px - (float)x);
            ++x;
            ++i;
        }
        int y = y_start;
        while (y < y_end) {
            int offset = y * width;
            float kernel_y = this.kernel(py - (float)y);
            int x2 = x_start;
            int i2 = 0;
            while (x2 < x_end) {
                int value = data[x2 + offset];
                float kernel_x = this._x_kernel[i2];
                float alpha = kernel_x * kernel_y;
                asum += alpha;
                rsum += (float)(value >> 16 & 0xFF) * alpha;
                gsum += (float)(value >> 8 & 0xFF) * alpha;
                bsum += (float)(value & 0xFF) * alpha;
                ++x2;
                ++i2;
            }
            ++y;
        }
        if (asum == 0.0f) {
            return -11171602;
        }
        float iasum = 1.0f / asum;
        int r = WindowedSincFilter.clamp(rsum * iasum);
        int g = WindowedSincFilter.clamp(gsum * iasum);
        int b = WindowedSincFilter.clamp(bsum * iasum);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    @Override
    public int sample_unsafe(float px, float py, int[] data, int width) {
        int ix = (int)px;
        int iy = (int)py;
        int height = data.length / width;
        int y_start = iy - this._width + 1 < 0 ? 0 : iy - this._width + 1;
        int y_end = iy + this._width + 1 > height - 1 ? height - 1 : iy + this._width + 1;
        int x_start = ix - this._width + 1 < 0 ? 0 : ix - this._width + 1;
        int x_end = ix + this._width + 1 > width - 1 ? width - 1 : ix + this._width + 1;
        float asum = 0.0f;
        float rsum = 0.0f;
        float gsum = 0.0f;
        float bsum = 0.0f;
        float fsum = 0.0f;
        int x = x_start;
        int i = 0;
        while (x < x_end) {
            this._x_kernel[i] = this.kernel(px - (float)x);
            ++x;
            ++i;
        }
        int y = y_start;
        while (y < y_end) {
            int offset = y * width;
            float kernel_y = this.kernel(py - (float)y);
            int x2 = x_start;
            int i2 = 0;
            while (x2 < x_end) {
                int value = data[x2 + offset];
                float alpha = value >> 24 & 0xFF;
                float kernel_x = this._x_kernel[i2];
                float factor = kernel_x * kernel_y;
                fsum += factor;
                if (alpha != 0.0f) {
                    asum += (alpha *= factor / 255.0f);
                    rsum += (float)(value >> 16 & 0xFF) * alpha;
                    gsum += (float)(value >> 8 & 0xFF) * alpha;
                    bsum += (float)(value & 0xFF) * alpha;
                }
                ++x2;
                ++i2;
            }
            ++y;
        }
        if (asum == 0.0f) {
            return 0;
        }
        float iasum = 1.0f / asum;
        int a = WindowedSincFilter.clamp(255.0f * asum / fsum);
        int r = WindowedSincFilter.clamp(rsum * iasum);
        int g = WindowedSincFilter.clamp(gsum * iasum);
        int b = WindowedSincFilter.clamp(bsum * iasum);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int clamp(float f) {
        int r = (int)f;
        return r < 0 ? 0 : (r > 255 ? 255 : r);
    }
}

