/*
 * Decompiled with CFR 0.152.
 */
package main.view3d;

import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import main.view3d.LightMarker;
import main.view3d.LightModel;

public class DirectionalLightMarker
extends LightMarker {
    TransformGroup _dir_transform = new TransformGroup();

    public DirectionalLightMarker() {
        this._root.setCapability(13);
        this._dir_transform.setCapability(18);
        this._root.addChild((Node)this._dir_transform);
        Shape3D s3d = new Shape3D();
        s3d.setGeometry(DirectionalLightMarker.get_arrow_lines());
        s3d.setAppearance(DirectionalLightMarker.make_wire_appearance());
        this._dir_transform.addChild((Node)s3d);
        s3d = new Shape3D();
        s3d.setGeometry(DirectionalLightMarker.get_arrow());
        s3d.setAppearance(DirectionalLightMarker.make_solid_appearance(0.2f, 0.2f, 0.2f));
        this._dir_transform.addChild((Node)s3d);
    }

    @Override
    public void set_light_marker_state(LightModel m, Vector3f d, Point3f foc) {
        if (m.is_tracing()) {
            this.set_direction(d, new Vector3f((Tuple3f)foc));
        } else {
            this.set_direction(d, null);
        }
    }

    public void set_direction(Vector3f d, Vector3f foc) {
        double a1 = Math.atan2(d.y, d.x);
        double a2 = Math.atan2(Math.sqrt(d.x * d.x + d.y * d.y), d.z);
        Transform3D t = new Transform3D();
        t.rotY(a2);
        Transform3D t2 = new Transform3D();
        t2.rotZ(a1);
        t2.mul(t);
        t2.setScale((double)0.2f);
        t.setIdentity();
        d = new Vector3f(d);
        if (foc == null) {
            d.normalize();
            d.scale(-1.0f);
            t.setTranslation(d);
        } else {
            d.scale(-1.0f);
            d.add((Tuple3f)foc);
            t.setTranslation(d);
        }
        t.mul(t2);
        t2.setIdentity();
        t2.setTranslation(new Vector3f(0.0f, 0.0f, -1.0f));
        t.mul(t2);
        this._dir_transform.setTransform(t);
    }
}

