/*
 * Decompiled with CFR 0.152.
 */
package main.view3d;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import javax.media.j3d.Transform3D;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.vecmath.Point3f;
import jgridmaker.GMPanel;
import main.MasterControl;
import main.YDialogs;
import main.view3d.LightEditor3D;
import main.view3d.LightModel;
import misc.Voxel;
import settings.JBoolOptionCheckbox;
import settings.JColorOption;
import settings.JDoubleOptionTFSlider;
import settings.JDoubleOptionTextfield;
import settings.JEnumOptionComboBox;

public class LightEditor
extends GMPanel {
    public final LightModel _model;
    private LightEditor3D _prev;

    public LightEditor(LightModel m, LightEditor3D prev) {
        this._model = m;
        this.setLayout(new BorderLayout());
        Box b = Box.createHorizontalBox();
        b.add((Component)this.build_general_panel());
        b.add(this.build_spot_panel());
        this.add(b, "Center", 0);
        this.add(new JPanel(), "West", 1);
        this.set_editor_3d(prev);
    }

    public void set_editor_3d(LightEditor3D prev) {
        if (this._prev == null && prev == null) {
            return;
        }
        if (this._prev == null) {
            this.remove(1);
            this.invalidate();
        } else {
            this._prev.set_model(null);
        }
        this._prev = prev;
        if (this._prev == null) {
            this.add(this.build_3d(), "West", 1);
            this.invalidate();
        } else {
            this._prev.set_model(this._model);
        }
    }

    public static void setEnabled(Component c, boolean on) {
        if (c instanceof Container) {
            Container c2 = (Container)c;
            int i = 0;
            while (i < c2.getComponentCount()) {
                Component c3 = c2.getComponent(i);
                LightEditor.setEnabled(c3, on);
                ++i;
            }
        } else {
            c.setEnabled(on);
        }
    }

    private JComponent build_3d() {
        LightEditor3D r = new LightEditor3D(this._model);
        r.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Direction settings and preview", 2, 2));
        return r;
    }

    private JComponent build_spot_panel() {
        GMPanel r = new GMPanel();
        r.add("_trace_on", (JComponent)new JBoolOptionCheckbox(this._model, LightModel.OPT_IS_TRACING));
        r.add("_spread", (JComponent)new JDoubleOptionTFSlider(this._model, LightModel.OPT_CONE_SPREAD, 0.0, 1.6));
        r.add("_concentration", (JComponent)new JDoubleOptionTFSlider(this._model, LightModel.OPT_CONE_CONCENTRATION, 0.0, 128.0));
        r.add("_center", (JComponent)new JButton(new AbstractAction("shine at center"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LightEditor.this._model.set_focus(new Point3f(0.0f, 0.0f, 0.0f));
            }
        }));
        r.add("_seed", (JComponent)new JButton(new AbstractAction("shine at seed"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LightEditor.this._model.set_tracing(true);
                LinkedList<Voxel> seeds = MasterControl.get_is().get_seeds();
                if (seeds.size() == 0) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                Voxel seed = (Voxel)seeds.get(0);
                Point3f seed_pos = new Point3f((float)seed._x, (float)seed._y, (float)seed._z);
                Transform3D seedtrans = MasterControl.get_v3d().get_data_transform(null);
                seedtrans.transform(seed_pos);
                LightEditor.this._model.set_focus(seed_pos);
            }
        }));
        r.set_layout("<table cellpadding='0' border='0' anchor='west'>  <tr>    <td>Spread angle</td>    <td>::_spread::</td>  </tr><tr>    <td>Concentration</td>    <td>::_concentration::</td>  </tr><tr>    <td colspan='2' anchor='center'>      <table cellpadding='0' border='0'>        <tr>          <td>::_center::</td>          <td>::_seed::</td>        </tr><tr>          <td>Follow focus</td>          <td>::_trace_on::</td>        </tr>      </table>    </td>  </tr></table>");
        r.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Spot light specific options", 2, 2));
        return r;
    }

    private GMPanel build_general_panel() {
        GMPanel r = new GMPanel();
        r.add("_type_select", (JComponent)new JEnumOptionComboBox(this._model, LightModel.OPT_TYPE));
        r.add("_light_on", (JComponent)new JBoolOptionCheckbox(this._model, LightModel.OPT_IS_ACTIVE));
        r.add("_marker_switch", (JComponent)new JBoolOptionCheckbox(this._model, LightModel.OPT_SHOW_MARKER));
        r.add("_color", (JComponent)new JColorOption(this._model, LightModel.OPT_COLOR));
        r.add("_remove_light", (JComponent)new JButton(new AbstractAction("delete light"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MasterControl.get_lights().size() <= 1) {
                    String text = "<html>Behold, baleful wright of darkness: <br>Thy nefarious scheme to shroud everything in <br>night forever is in vain, for I have long <br> anticipated this disruptive move of thine!</html>";
                    JOptionPane.showMessageDialog((Component)((Object)LightEditor.this), "<html>Behold, baleful wright of darkness: <br>Thy nefarious scheme to shroud everything in <br>night forever is in vain, for I have long <br> anticipated this disruptive move of thine!</html>", "Cannot delete last light", 0);
                    return;
                }
                MasterControl.get_lights().remove_light(LightEditor.this._model);
            }
        }));
        r.add("_clone_light", (JComponent)new JButton(new AbstractAction("clone light"){

            @Override
            public void actionPerformed(ActionEvent e) {
                YDialogs.light_dialog(LightEditor.this._model);
            }
        }));
        r.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "General options", 2, 2));
        r.set_layout("<table cellpadding='0' border='0' anchor='west'>  <tr>    <td>Type</td>    <td>::_type_select::</td>  </tr><tr>    <td>::_light_on::</td>    <td colspan='3'>::_marker_switch::</td>  </tr><tr>    <td>Color</td>    <td>::_color::</td>  </tr><tr>    <td>::_remove_light::</td>    <td>::_clone_light::</td>  </tr></table>");
        return r;
    }

    private JComponent build_pos_panel() {
        GMPanel r = new GMPanel();
        r.add("_x", (JComponent)new JDoubleOptionTextfield(this._model, LightModel.OPT_POS_X, 7));
        r.add("_y", (JComponent)new JDoubleOptionTextfield(this._model, LightModel.OPT_POS_Y, 7));
        r.add("_z", (JComponent)new JDoubleOptionTextfield(this._model, LightModel.OPT_POS_Z, 7));
        r.set_layout("<table cellpadding='0' border='0' anchor='west'>  <tr>    <td>::_x::</td>  </tr><tr>    <td>::_y::</td>  </tr><tr>    <td>::_z::</td>  </tr></table>");
        return r;
    }
}

