/*
 * Decompiled with CFR 0.152.
 */
package main.view3d;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Light;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.JPanel;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import main.MasterControl;
import main.Message;
import main.view3d.LightModel;
import main.view3d.Viewport3d;
import misc.messages.YObservable;
import misc.messages.YObserver;

public class LightEditor3D
extends JPanel
implements YObserver {
    private LightModel _model;
    private Canvas3D _canvas3d;
    private SimpleUniverse _simple_u;
    private TransformGroup _shifted_scene_root;
    private BranchGroup _light;
    private BoundingSphere _bounds;
    private TransformGroup _position_marker;
    private TransformGroup _focus_marker;

    public LightEditor3D(LightModel model) {
        this.set_model(model);
        this.create_scene();
        this.setLayout(new BorderLayout());
        this.add((Component)this._canvas3d);
        MasterControl.get_v3d()._transform_notifier.addObserver(this, "LightEditor3D()");
    }

    public void set_model(LightModel m) {
        if (m == this._model) {
            return;
        }
        if (this._model != null) {
            this._model.deleteObserver(this);
            this._light.detach();
            this._light = null;
        }
        this._model = m;
        if (this._model != null) {
            this._model.addObserver(this, "added in LightEditor3D::set_model");
            this.update_light();
            this.update_markers();
        }
    }

    @Override
    public void update(YObservable o, Message m) {
        if (this._model == null) {
            return;
        }
        if (m._type == LightModel.M_TYPE_CHANGED) {
            this.update_light();
        } else if (o == this._model) {
            this._model.set_light_state((Light)this._light.getChild(0), this.get_focus_transform());
        } else if (m._type == Viewport3d.M_ROTATION_CHANGED) {
            this._model.set_light_state((Light)this._light.getChild(0), this.get_focus_transform());
        }
        this.update_markers();
    }

    private Transform3D get_focus_transform() {
        return this._model.is_tracing() ? MasterControl.get_v3d().get_focus_transform(null) : null;
    }

    private void update_light() {
        if (this._model == null) {
            return;
        }
        Light l = this._model.fiat_lux(this.get_focus_transform());
        LightModel.make_mutable(l);
        l.setInfluencingBounds((Bounds)this._bounds);
        if (this._light != null) {
            this._light.detach();
        }
        this._light = new BranchGroup();
        this._light.setCapability(17);
        this._light.addChild((Node)l);
        this._shifted_scene_root.addChild((Node)this._light);
    }

    private void update_markers() {
        if (this._model == null) {
            return;
        }
        Transform3D t = new Transform3D();
        Vector3f position = new Vector3f((Tuple3f)this._model.get_position(new Point3f()));
        t.setTranslation(position);
        this._position_marker.setTransform(t);
        Vector3f focus = new Vector3f((Tuple3f)this._model.get_focus(new Point3f()));
        if (this._model.is_tracing()) {
            this.get_focus_transform().transform(focus);
        }
        t.setTranslation(focus);
        this._focus_marker.setTransform(t);
    }

    private void create_scene() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        this._canvas3d = new Canvas3D(config);
        this._canvas3d.setMinimumSize(new Dimension(200, 200));
        this._canvas3d.setPreferredSize(new Dimension(200, 200));
        this._simple_u = new SimpleUniverse(this._canvas3d);
        this._simple_u.getViewingPlatform().setNominalViewingTransform();
        this._simple_u.getViewer().getView().setFrontClipDistance(0.001);
        BranchGroup root = new BranchGroup();
        this._light = new BranchGroup();
        this._light.setCapability(17);
        Transform3D shift_trans = new Transform3D();
        shift_trans.setTranslation(new Vector3d(0.0, 0.0, -0.5));
        this._shifted_scene_root = new TransformGroup(shift_trans);
        this._shifted_scene_root.setCapability(13);
        this._shifted_scene_root.setCapability(14);
        this._bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
        Node obj = this.create_central_object();
        this._shifted_scene_root.addChild(obj);
        root.addChild((Node)this._shifted_scene_root);
        Appearance app = new Appearance();
        ColoringAttributes cat = new ColoringAttributes();
        cat.setColor(1.0f, 0.0f, 0.0f);
        app.setColoringAttributes(cat);
        this._position_marker = new TransformGroup();
        this._position_marker.setCapability(18);
        this._position_marker.addChild((Node)new Sphere(0.02f, 0, 5, app));
        root.addChild((Node)this._position_marker);
        app = new Appearance();
        cat = new ColoringAttributes();
        cat.setColor(0.0f, 1.0f, 0.0f);
        app.setColoringAttributes(cat);
        this._focus_marker = new TransformGroup();
        this._focus_marker.setCapability(18);
        this._focus_marker.addChild((Node)new Sphere(0.02f, 0, 5, app));
        root.addChild((Node)this._focus_marker);
        this.update_light();
        this.update_markers();
        this._simple_u.addBranchGraph(root);
        Listener3D l3d = new Listener3D();
        this._canvas3d.addMouseListener((MouseListener)l3d);
        this._canvas3d.addMouseMotionListener((MouseMotionListener)l3d);
        this._canvas3d.addMouseWheelListener((MouseWheelListener)l3d);
    }

    private Node create_central_object() {
        BranchGroup bg = new BranchGroup();
        Appearance app = new Appearance();
        Material mat = new Material();
        mat.setAmbientColor(1.0f, 1.0f, 1.0f);
        mat.setSpecularColor(1.0f, 1.0f, 1.0f);
        mat.setDiffuseColor(0.8f, 0.8f, 0.8f);
        ColoringAttributes rend = new ColoringAttributes();
        PolygonAttributes papp = new PolygonAttributes();
        papp.setBackFaceNormalFlip(true);
        rend.setShadeModel(3);
        app.setColoringAttributes(rend);
        app.setMaterial(mat);
        TransparencyAttributes trap = new TransparencyAttributes();
        trap.setTransparency(0.2f);
        trap.setTransparencyMode(1);
        app.setTransparencyAttributes(trap);
        app.setPolygonAttributes(papp);
        Sphere sph = new Sphere(0.75f, 1, 100);
        sph.setAppearance(app);
        bg.addChild((Node)sph);
        return bg;
    }

    class Listener3D
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        int x;
        int y;

        Listener3D() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Transform3D ftrans = LightEditor3D.this.get_focus_transform();
            Point3f foc = LightEditor3D.this._model.get_focus_transformed(new Point3f(), ftrans);
            if ((e.getModifiersEx() & 0x1000) != 0) {
                Transform3D t3d = new Transform3D();
                t3d.rotX((double)((float)(this.y - e.getY()) * -0.03f));
                t3d.transform(foc);
                t3d.rotY((double)((float)(this.x - e.getX()) * -0.03f));
                t3d.transform(foc);
                if (ftrans != null) {
                    ftrans.invert();
                    ftrans.transform(foc);
                }
                LightEditor3D.this._model.set_focus(foc);
            }
            if ((e.getModifiersEx() & 0x400) != 0) {
                Point3f pos = LightEditor3D.this._model.get_position(new Point3f());
                Transform3D t3d = new Transform3D();
                pos.sub((Tuple3f)foc);
                t3d.rotX((double)((float)(this.y - e.getY()) * -0.03f));
                t3d.transform(pos);
                t3d.rotY((double)((float)(this.x - e.getX()) * -0.03f));
                t3d.transform(pos);
                pos.add((Tuple3f)foc);
                LightEditor3D.this._model.set_position(pos);
            }
            this.x = e.getX();
            this.y = e.getY();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.x = e.getX();
            this.y = e.getY();
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            Transform3D ftrans = LightEditor3D.this.get_focus_transform();
            Point3f foc = LightEditor3D.this._model.get_focus_transformed(new Point3f(), ftrans);
            Point3f pos = LightEditor3D.this._model.get_position(new Point3f());
            Transform3D t3d = new Transform3D();
            pos.sub((Tuple3f)foc);
            t3d.setScale(Math.pow(2.0, -0.1 * (double)e.getWheelRotation()));
            t3d.transform(pos);
            pos.add((Tuple3f)foc);
            LightEditor3D.this._model.set_position(pos);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

