/*
 * Decompiled with CFR 0.152.
 */
package main.view3d;

import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import main.view3d.LightModel;

public abstract class LightMarker {
    static int n = 20;
    static float d1 = 0.1f;
    static float d2 = 0.3f;
    static float h = 0.61f;
    private static IndexedTriangleArray _arrow;
    private static TriangleArray _cone;
    private static LineArray _arrow_lines;
    private static LineArray _cone_lines;
    private static float _epsilon;
    protected final BranchGroup _root = new BranchGroup();

    static {
        _epsilon = 0.0f;
    }

    public static Appearance make_wire_appearance() {
        Appearance r = new Appearance();
        ColoringAttributes catt = new ColoringAttributes();
        catt.setColor(0.0f, 1.0f, 0.0f);
        PolygonAttributes patt = new PolygonAttributes();
        patt.setPolygonMode(1);
        patt.setPolygonOffset(-100.0f);
        patt.setPolygonOffsetFactor(-0.1f);
        r.setPolygonAttributes(patt);
        LineAttributes latt = new LineAttributes();
        r.setLineAttributes(latt);
        r.setPolygonAttributes(patt);
        TransparencyAttributes trap = new TransparencyAttributes();
        trap.setTransparency(0.5f);
        trap.setTransparencyMode(1);
        r.setTransparencyAttributes(trap);
        r.setColoringAttributes(catt);
        return r;
    }

    public static Appearance make_solid_appearance(float r, float g, float b) {
        Appearance ret = new Appearance();
        PolygonAttributes patt = new PolygonAttributes();
        patt.setPolygonOffset(10.0f);
        patt.setPolygonOffsetFactor(1.0f);
        ColoringAttributes catt = new ColoringAttributes();
        catt.setColor(r, g, b);
        ret.setColoringAttributes(catt);
        ret.setPolygonAttributes(patt);
        return ret;
    }

    public static Appearance make_solid_appearance(float r, float g, float b, float a) {
        Appearance ret = new Appearance();
        PolygonAttributes patt = new PolygonAttributes();
        patt.setCullFace(0);
        patt.setPolygonOffset(100.0f);
        patt.setPolygonOffsetFactor(0.1f);
        ColoringAttributes catt = new ColoringAttributes();
        catt.setColor(r, g, b);
        ret.setColoringAttributes(catt);
        TransparencyAttributes tatt = new TransparencyAttributes();
        tatt.setTransparencyMode(1);
        tatt.setTransparency(a);
        ret.setTransparencyAttributes(tatt);
        ret.setPolygonAttributes(patt);
        return ret;
    }

    public static Geometry get_cone_lines() {
        if (_cone_lines == null) {
            int rres = 25;
            int seg = 10;
            _cone_lines = new LineArray(1000, 1);
            Point3f point = new Point3f();
            int i = 0;
            while (i < 25) {
                int j = 0;
                while (j < 10) {
                    int off = (i * 10 + j) * 4;
                    int off2 = ((i + 1) % 25 * 10 + j) * 4;
                    double a = (double)(i * 2) * Math.PI / 25.0;
                    float s = (float)Math.sin(a) * 1.0f;
                    float c = (float)Math.cos(a) * 1.0f;
                    float y = (float)(j + 1) / 10.0f;
                    point.set(c * y, s * y, y);
                    _cone_lines.setCoordinate(off, point);
                    _cone_lines.setCoordinate(off2 + 1, point);
                    _cone_lines.setCoordinate(off + 2, point);
                    y = (float)j / 10.0f;
                    point.set(c * y, s * y, y);
                    _cone_lines.setCoordinate(off + 3, point);
                    ++j;
                }
                ++i;
            }
        }
        return _cone_lines;
    }

    public static Geometry get_cone() {
        if (_cone == null) {
            int rres = 25;
            _cone = new TriangleArray(150, 1);
            Point3f point = new Point3f();
            int i = 0;
            while (i < 25) {
                int off = i;
                int off2 = (i + 1) % 25;
                double a = (double)(i * 2) * Math.PI / 25.0;
                float s = (float)Math.sin(a);
                float c = (float)Math.cos(a);
                point.set(c, s, 1.0f);
                _cone.setCoordinate(3 * off, point);
                _cone.setCoordinate(3 * off2 + 1, point);
                _cone.setCoordinate(75 + 3 * off2, point);
                _cone.setCoordinate(75 + 3 * off + 1, point);
                point.set(0.0f, 0.0f, 0.0f);
                _cone.setCoordinate(3 * off + 2, point);
                point.set(0.0f, 0.0f, 1.0f);
                _cone.setCoordinate(75 + 3 * off + 2, point);
                ++i;
            }
        }
        return _cone;
    }

    public static Geometry get_arrow_lines() {
        if (_arrow_lines == null) {
            _arrow_lines = new LineArray(10 * n, 1);
            Point3f point = new Point3f();
            int i = 0;
            while (i < n) {
                int i2 = (i + 1) % n;
                double a = (double)(i * 2) * Math.PI / (double)n;
                float s = (float)Math.sin(a) * (1.0f + 0.0f * _epsilon);
                float c = (float)Math.cos(a) * (1.0f + 0.0f * _epsilon);
                point.set(c * d1, s * d1, 0.0f * _epsilon);
                _arrow_lines.setCoordinate(0 + 10 * i, point);
                _arrow_lines.setCoordinate(1 + 10 * i2, point);
                _arrow_lines.setCoordinate(6 + 10 * i, point);
                point.set(c * d1, s * d1, h - 0.0f * _epsilon);
                _arrow_lines.setCoordinate(2 + 10 * i, point);
                _arrow_lines.setCoordinate(3 + 10 * i2, point);
                _arrow_lines.setCoordinate(7 + 10 * i, point);
                point.set(c * d2, s * d2, h - 0.0f * _epsilon);
                _arrow_lines.setCoordinate(4 + 10 * i, point);
                _arrow_lines.setCoordinate(5 + 10 * i2, point);
                _arrow_lines.setCoordinate(8 + 10 * i, point);
                point.set(0.0f, 0.0f, 1.0f + 0.0f * _epsilon);
                _arrow_lines.setCoordinate(9 + 10 * i, point);
                ++i;
            }
        }
        return _arrow_lines;
    }

    public static Geometry get_arrow() {
        if (_arrow == null) {
            _arrow = new IndexedTriangleArray(2 + 3 * n, 1, 18 * n);
            Point3f point = new Point3f();
            point.set(0.0f, 0.0f, 0.0f);
            _arrow.setCoordinate(0, point);
            point.set(0.0f, 0.0f, 1.0f);
            _arrow.setCoordinate(1, point);
            int i = 0;
            while (i < n) {
                double a = (double)(i * 2) * Math.PI / (double)n;
                float s = (float)Math.sin(a);
                float c = (float)Math.cos(a);
                int i1 = 2 + 3 * i;
                int i2 = 2 + 3 * ((i + 1) % n);
                point.set(c * d1, s * d1, 0.0f);
                _arrow.setCoordinate(i1, point);
                point.set(c * d1, s * d1, h);
                _arrow.setCoordinate(1 + i1, point);
                point.set(c * d2, s * d2, h);
                _arrow.setCoordinate(2 + i1, point);
                _arrow.setCoordinateIndex(18 * i + 1, 0);
                _arrow.setCoordinateIndex(18 * i + 0, i1);
                _arrow.setCoordinateIndex(18 * i + 2, i2);
                _arrow.setCoordinateIndex(18 * i + 3, i1);
                _arrow.setCoordinateIndex(18 * i + 4, i2);
                _arrow.setCoordinateIndex(18 * i + 5, i2 + 1);
                _arrow.setCoordinateIndex(18 * i + 7, i1);
                _arrow.setCoordinateIndex(18 * i + 6, i1 + 1);
                _arrow.setCoordinateIndex(18 * i + 8, i2 + 1);
                _arrow.setCoordinateIndex(18 * i + 9, i1 + 1);
                _arrow.setCoordinateIndex(18 * i + 10, i2 + 1);
                _arrow.setCoordinateIndex(18 * i + 11, i2 + 2);
                _arrow.setCoordinateIndex(18 * i + 13, i1 + 1);
                _arrow.setCoordinateIndex(18 * i + 12, i1 + 2);
                _arrow.setCoordinateIndex(18 * i + 14, i2 + 2);
                _arrow.setCoordinateIndex(18 * i + 15, i1 + 2);
                _arrow.setCoordinateIndex(18 * i + 16, i2 + 2);
                _arrow.setCoordinateIndex(18 * i + 17, 1);
                ++i;
            }
        }
        return _arrow;
    }

    public BranchGroup get_root() {
        return this._root;
    }

    public abstract void set_light_marker_state(LightModel var1, Vector3f var2, Point3f var3);
}

