/*
 * Decompiled with CFR 0.152.
 */
package main.view3d;

import java.awt.Color;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Light;
import javax.media.j3d.PointLight;
import javax.media.j3d.SpotLight;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import main.Message;
import main.YaDiV;
import main.view3d.Shader;
import misc.messages.YObservable;
import settings.Settings;
import settings.SettingsOwner;

public class LightModel
extends YObservable
implements SettingsOwner {
    public static int M_POS_CHANGED = Message.register_message("light source position changed");
    public static final int M_FOCUS_CHANGED = Message.register_message("light focus position changed");
    public static final int M_COLOR_CHANGED = Message.register_message("light color changed");
    public static final int M_CONE_CHANGED = Message.register_message("light cone settings changed");
    public static final int M_TYPE_CHANGED = Message.register_message("light type changed");
    public static final int M_ACTIVITY_CHANGED = Message.register_message("light switched on/off");
    public static final int M_TRACING_CHANGED = Message.register_message("focus tracing switched on/off");
    public static final int M_ATTENUATION_CHANGED = Message.register_message("light attenuation changed");
    public static final int M_MARKER_VISIBILITY = Message.register_message("light marker visibility changed");
    public static String OPT_IS_ACTIVE = Settings.register_bool_opt(LightModel.class, "light on", "whether this light is shinig", true);
    public static String OPT_IS_TRACING = Settings.register_bool_opt(LightModel.class, "trace focus", "whether the focus coordinates are subject to the scene's rotation", false);
    public static final String OPT_TYPE = Settings.register_enum_opt(LightModel.class, "type", "The type of the light source", LightType.directional);
    public static String OPT_POS_X = Settings.register_double_opt(LightModel.class, "Position X", "The x coordinateof the light position", 0.0);
    public static String OPT_POS_Y = Settings.register_double_opt(LightModel.class, "Position Y", "The y coordinateof the light position", 0.0);
    public static String OPT_POS_Z = Settings.register_double_opt(LightModel.class, "Position Z", "The z coordinateof the light position", 1.0);
    public static String OPT_FOCUS_X = Settings.register_double_opt(LightModel.class, "Focus X", "The x coordinateof the light focus", 0.0);
    public static String OPT_FOCUS_Y = Settings.register_double_opt(LightModel.class, "Focus Y", "The y coordinateof the light focus", 0.0);
    public static String OPT_FOCUS_Z = Settings.register_double_opt(LightModel.class, "Focus Z", "The z coordinateof the light focus", 0.0);
    public static String OPT_CONE_SPREAD = Settings.register_double_opt(LightModel.class, "Cone width", "Spread angle of the spot light's light cone", 1.0);
    public static String OPT_CONE_CONCENTRATION = Settings.register_double_opt(LightModel.class, "Spotlight concentration", "Concentration of the spot light", 1.0);
    public static String OPT_COLOR = Settings.register_color_opt(LightModel.class, "Color", "The color of the light", Color.WHITE);
    public static String OPT_ATT_CONST = Settings.register_double_opt(LightModel.class, "attenuation (constant)", "Constant attenuation factor of the point light", 1.0);
    public static String OPT_ATT_LIN = Settings.register_double_opt(LightModel.class, "attenuation (linear)", "Linear attenuation factor of the point light", 0.0);
    public static String OPT_ATT_QUAD = Settings.register_double_opt(LightModel.class, "attenuation (quadratic)", "Quadratic attenuation factor of the point light", 0.0);
    public static String OPT_SHOW_MARKER = Settings.register_bool_opt(LightModel.class, "Show marker", "Show light position marker", false);
    static final int FLAG_POS_CHANGE = 1;
    static final int FLAG_FOCUS_CHANGE = 2;
    static final int FLAG_COLOR_CHANGE = 4;
    static final int FLAG_TYPE_CHANGE = 8;
    static final int FLAG_ACTIVE_TOGGLE = 16;
    static final int FLAG_CONE_CHANGE = 32;
    static final int FLAG_ATTENUATION_CHANGE = 64;
    static final int FLAG_TRACING_TOGGLE = 128;
    static final int FLAG_MARKER_TOGGLE = 256;
    int _change_flags;
    boolean _ignore_changes;
    Vector3f _pos = new Vector3f();
    Vector3f _focus = new Vector3f();
    boolean _focus_for_tracing;
    private final String _name;

    public LightModel(String name) {
        this._name = name;
        Settings.register_owner(this);
        this._pos.set(Settings.get_double_option(this, OPT_POS_X).floatValue(), Settings.get_double_option(this, OPT_POS_Y).floatValue(), Settings.get_double_option(this, OPT_POS_Z).floatValue());
        this._focus.set(Settings.get_double_option(this, OPT_FOCUS_X).floatValue(), Settings.get_double_option(this, OPT_FOCUS_Y).floatValue(), Settings.get_double_option(this, OPT_FOCUS_Z).floatValue());
        this._focus_for_tracing = this.is_tracing();
    }

    public LightModel(LightModel m, String name) {
        this(name);
        this.set_type(m.get_type());
        this.set_enabled(m.get_enabled());
        this.set_tracing(m.is_tracing());
        this.set_marker_visible(m.is_marker_visible());
        this.set_position(m.get_position(new Point3f()));
        this.set_focus(m.get_focus(new Point3f()));
        this.set_spread(m.get_spread());
        this.set_concentration(m.get_concentration());
        this.set_color(m.get_color_awt());
        this.set_attenuation(m.get_attenuation(new Point3f()));
    }

    public void set_marker_visible(boolean b) {
        Settings.set_bool_option(this, OPT_SHOW_MARKER, b);
    }

    public boolean is_marker_visible() {
        return Settings.get_bool_option(this, OPT_SHOW_MARKER);
    }

    @Override
    public synchronized void settings_changed(Object obj, String opt_name, Object opt) {
        if (opt_name == OPT_POS_X) {
            this._pos.x = ((Double)opt).floatValue();
            this._change_flags |= 1;
        } else if (opt_name == OPT_POS_Y) {
            this._pos.y = ((Double)opt).floatValue();
            this._change_flags |= 1;
        } else if (opt_name == OPT_POS_Z) {
            this._pos.z = ((Double)opt).floatValue();
            this._change_flags |= 1;
        } else if (opt_name == OPT_FOCUS_X) {
            this._focus.x = ((Double)opt).floatValue();
            this._change_flags |= 2;
        } else if (opt_name == OPT_FOCUS_Y) {
            this._focus.y = ((Double)opt).floatValue();
            this._change_flags |= 2;
        } else if (opt_name == OPT_FOCUS_Z) {
            this._focus.z = ((Double)opt).floatValue();
            this._change_flags |= 2;
        } else if (opt_name == OPT_TYPE) {
            this._change_flags |= 8;
        } else if (opt_name == OPT_IS_ACTIVE) {
            this._change_flags |= 0x10;
        } else if (opt_name == OPT_IS_TRACING) {
            this._change_flags |= 0x80;
        } else if (opt_name == OPT_CONE_SPREAD) {
            this._change_flags |= 0x20;
        } else if (opt_name == OPT_CONE_CONCENTRATION) {
            this._change_flags |= 0x20;
        } else if (opt_name == OPT_COLOR) {
            this._change_flags |= 4;
        } else if (opt_name == OPT_ATT_CONST) {
            this._change_flags |= 0x40;
        } else if (opt_name == OPT_ATT_QUAD) {
            this._change_flags |= 0x40;
        } else if (opt_name == OPT_ATT_LIN) {
            this._change_flags |= 0x40;
        } else if (opt_name == OPT_SHOW_MARKER) {
            this._change_flags |= 0x100;
        } else {
            YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "Missing code in settings_changed for option " + opt_name);
        }
        this.setChanged();
        if (!this._ignore_changes) {
            this.notifyObservers_now();
        }
    }

    public void set_attenuation(Point3f attenuation) {
        this._ignore_changes = true;
        Settings.set_double_option(this, OPT_ATT_CONST, Double.valueOf(attenuation.x));
        Settings.set_double_option(this, OPT_ATT_LIN, Double.valueOf(attenuation.y));
        Settings.set_double_option(this, OPT_ATT_QUAD, Double.valueOf(attenuation.z));
        this._ignore_changes = false;
        this.notifyObservers_now();
    }

    public Point3f get_attenuation(Point3f r) {
        r.set((float)(0.0 + Settings.get_double_option(this, OPT_ATT_CONST)), (float)(0.0 + Settings.get_double_option(this, OPT_ATT_LIN)), (float)(0.0 + Settings.get_double_option(this, OPT_ATT_QUAD)));
        return r;
    }

    private synchronized void update_pos() {
        this._ignore_changes = true;
        Settings.set_double_option(this, OPT_POS_X, Double.valueOf(this._pos.x));
        Settings.set_double_option(this, OPT_POS_Y, Double.valueOf(this._pos.y));
        Settings.set_double_option(this, OPT_POS_Z, Double.valueOf(this._pos.z));
        this._ignore_changes = false;
        this.notifyObservers_now();
    }

    private synchronized void update_focus() {
        this._ignore_changes = true;
        Settings.set_double_option(this, OPT_FOCUS_X, Double.valueOf(this._focus.x));
        Settings.set_double_option(this, OPT_FOCUS_Y, Double.valueOf(this._focus.y));
        Settings.set_double_option(this, OPT_FOCUS_Z, Double.valueOf(this._focus.z));
        this._ignore_changes = false;
        this.notifyObservers_now();
    }

    public void set_color(Color color) {
        Settings.set_color_option(this, OPT_COLOR, color);
    }

    public void set_color(Color3f c) {
        Settings.set_color_option(this, OPT_COLOR, c.get());
    }

    public Color3f get_color() {
        return new Color3f(Settings.get_color_option(this, OPT_COLOR));
    }

    public Color get_color_awt() {
        return Settings.get_color_option(this, OPT_COLOR);
    }

    public void set_concentration(double concentration) {
        Settings.set_double_option(this, OPT_CONE_CONCENTRATION, concentration);
    }

    public double get_concentration() {
        return Settings.get_double_option(this, OPT_CONE_CONCENTRATION);
    }

    public void set_spread(double spread) {
        Settings.set_double_option(this, OPT_CONE_SPREAD, spread);
    }

    public double get_spread() {
        return Settings.get_double_option(this, OPT_CONE_SPREAD);
    }

    public boolean is_tracing() {
        return Settings.get_bool_option(this, OPT_IS_TRACING);
    }

    public void set_tracing(boolean tracing) {
        Settings.set_bool_option(this, OPT_IS_TRACING, tracing);
    }

    public void set_enabled(boolean b) {
        Settings.set_bool_option(this, OPT_IS_ACTIVE, b);
    }

    public boolean get_enabled() {
        return Settings.get_bool_option(this, OPT_IS_ACTIVE);
    }

    public void set_type(LightType t) {
        Settings.set_enum_option(this, OPT_TYPE, t);
    }

    public LightType get_type() {
        return (LightType)Settings.get_enum_option(this, OPT_TYPE);
    }

    public void set_focus(Point3f p) {
        this._focus.set((Tuple3f)p);
        this._focus_for_tracing = this.is_tracing();
        this.update_focus();
    }

    public Point3f get_focus_transformed(Point3f r, Transform3D t) {
        r.set((Tuple3f)this._focus);
        if (t != null) {
            t.transform(r);
        }
        return r;
    }

    public Vector3f get_focus_transformed(Vector3f r, Transform3D t) {
        r.set((Tuple3f)this._focus);
        if (t != null) {
            t.transform(r);
        }
        return r;
    }

    public Point3f get_focus(Point3f r) {
        r.set((Tuple3f)this._focus);
        return r;
    }

    public void set_position(Point3f p) {
        this._pos.set((Tuple3f)p);
        this.update_pos();
    }

    public void set_distance(double d) {
        this._pos.scale((float)(d / (double)this._pos.length()));
        this.update_pos();
    }

    public double get_distance() {
        return this._pos.length();
    }

    public void set_direction(Vector3f d) {
        this._pos.sub((Tuple3f)this._focus);
        double dist = this._pos.length();
        this._pos.set((Tuple3f)d);
        this._pos.scale((float)(dist / (double)this._pos.length()));
        this._pos.add((Tuple3f)this._focus);
        this.update_pos();
    }

    public Vector3f get_direction(Vector3f r) {
        r.set((Tuple3f)this._pos);
        r.sub((Tuple3f)this._focus);
        return r;
    }

    public Vector3f get_direction_transformed(Vector3f r, Transform3D t) {
        this.get_focus_transformed(r, t);
        r.sub((Tuple3f)this._pos);
        return r;
    }

    public Point3f get_position(Point3f r) {
        r.set((Tuple3f)this._pos);
        return r;
    }

    @Override
    public String get_name() {
        return this._name;
    }

    public boolean is_focus_valid() {
        return this._focus_for_tracing == this.is_tracing();
    }

    public void set_light_state(Light l, Transform3D t) {
        Point3f att = this.get_attenuation(new Point3f());
        Point3f pos = this.get_position(new Point3f());
        Vector3f dir = this.get_direction_transformed(new Vector3f(), t);
        dir.normalize();
        l.setColor(this.get_color());
        l.setEnable(Settings.get_bool_option(this, OPT_IS_ACTIVE).booleanValue());
        switch ((LightType)Settings.get_enum_option(this, OPT_TYPE)) {
            case spot: {
                float width = (float)(0.0 + Settings.get_double_option(this, OPT_CONE_SPREAD));
                float concentration = (float)(0.0 + Settings.get_double_option(this, OPT_CONE_CONCENTRATION));
                ((SpotLight)l).setSpreadAngle(width);
                ((SpotLight)l).setConcentration(concentration);
                ((SpotLight)l).setDirection(dir);
            }
            case point: {
                ((PointLight)l).setPosition(pos);
                ((PointLight)l).setAttenuation(att);
                return;
            }
            case directional: {
                ((DirectionalLight)l).setDirection(dir);
                return;
            }
            case ambient: {
                return;
            }
        }
    }

    public Light fiat_lux(Transform3D t) {
        Point3f att = this.get_attenuation(new Point3f());
        Point3f pos = this.get_position(new Point3f());
        if (!this.is_tracing()) {
            t = null;
        }
        Vector3f dir = this.get_direction_transformed(new Vector3f(), t);
        dir.normalize();
        boolean enabled = Settings.get_bool_option(this, OPT_IS_ACTIVE);
        switch ((LightType)Settings.get_enum_option(this, OPT_TYPE)) {
            case spot: {
                float width = (float)(0.0 + Settings.get_double_option(this, OPT_CONE_SPREAD));
                float concentration = (float)(0.0 + Settings.get_double_option(this, OPT_CONE_CONCENTRATION));
                return new SpotLight(enabled, this.get_color(), pos, att, dir, width, concentration);
            }
            case point: {
                return new PointLight(enabled, this.get_color(), pos, att);
            }
            case directional: {
                return new DirectionalLight(enabled, this.get_color(), dir);
            }
            case ambient: {
                return new AmbientLight(enabled, this.get_color());
            }
        }
        return null;
    }

    public boolean is_actual_spotlight() {
        return this.get_type() == LightType.spot && this.get_spread() < 1.5707963267948966;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers_now() {
        boolean async = true;
        block17: while (true) {
            int flag;
            LightModel lightModel = this;
            synchronized (lightModel) {
                if (this._change_flags == 0) {
                    break;
                }
                flag = this._change_flags & Integer.lowestOneBit(this._change_flags);
                this._change_flags &= ~flag;
            }
            this.setChanged();
            switch (flag) {
                case 1: {
                    super.notifyObservers(new Message(M_POS_CHANGED, null), true);
                    continue block17;
                }
                case 2: {
                    super.notifyObservers(new Message(M_FOCUS_CHANGED, null), true);
                    continue block17;
                }
                case 4: {
                    super.notifyObservers(new Message(M_COLOR_CHANGED, null), true);
                    continue block17;
                }
                case 64: {
                    super.notifyObservers(new Message(M_ATTENUATION_CHANGED, null), true);
                    continue block17;
                }
                case 32: {
                    super.notifyObservers(new Message(M_CONE_CHANGED, null), true);
                    continue block17;
                }
                case 16: {
                    super.notifyObservers(new Message(M_ACTIVITY_CHANGED, null), true);
                    continue block17;
                }
                case 8: {
                    super.notifyObservers(new Message(M_TYPE_CHANGED, null), true);
                    continue block17;
                }
                case 128: {
                    super.notifyObservers(new Message(M_TRACING_CHANGED, null), true);
                    continue block17;
                }
                case 256: {
                    super.notifyObservers(new Message(M_MARKER_VISIBILITY, null), true);
                    continue block17;
                }
            }
            YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "Missinig dispatcher code for change flag " + Integer.toBinaryString(flag));
        }
        LightModel lightModel = this;
        synchronized (lightModel) {
            if (this._change_flags == 0) {
                this.clearChanged();
            }
        }
    }

    public void dispose() {
    }

    public static void make_mutable(Light light) {
        light.setCapability(15);
        light.setCapability(13);
        if (light instanceof DirectionalLight) {
            light.setCapability(19);
        } else if (light instanceof PointLight) {
            light.setCapability(19);
            light.setCapability(21);
            if (light instanceof SpotLight) {
                light.setCapability(26);
                light.setCapability(24);
                light.setCapability(22);
            }
        }
    }

    public Shader create_shader(Shader next, Transform3D focus_transform, Transform3D rot_transform) {
        boolean white;
        if (!this.get_enabled()) {
            return next;
        }
        Color3f c = this.get_color();
        boolean bl = white = c.x == c.y && c.y == c.z && c.x == c.z;
        if (!this.is_tracing()) {
            focus_transform = null;
        }
        Vector3f dir = this.get_direction_transformed(new Vector3f(), focus_transform);
        switch (this.get_type()) {
            case ambient: {
                return white ? new WhiteAmbientShader(c.x, next) : new AmbientShader(c.x, c.y, c.z, next);
            }
            case directional: {
                return new DirectionalShader(c.x, c.y, c.z, dir, next);
            }
            case spot: {
                if (this.is_actual_spotlight()) {
                    return new SpotShader(c.x, c.y, c.z, dir, this.get_position(new Point3f()), (float)this.get_spread(), (float)this.get_concentration(), this.get_attenuation(new Point3f()), next);
                }
            }
            case point: {
                return new PointShader(c.x, c.y, c.z, this.get_position(new Point3f()), this.get_attenuation(new Point3f()), next);
            }
        }
        throw new IllegalArgumentException("Cannot create shader for light " + this._name);
    }

    static class AmbientShader
    extends Shader {
        private final float _r;
        private final float _g;
        private final float _b;

        public AmbientShader(float r, float g, float b, Shader next) {
            super(next);
            this._r = r;
            this._g = g;
            this._b = b;
        }

        @Override
        public Shader copy(Shader next) {
            return new AmbientShader(this._r, this._g, this._b, next);
        }

        @Override
        public void shade(Vector3f normal, Point3f point, Color4f ambi, Color4f diff, Color4f spec, float spec_exp, boolean flip) {
            ambi.x += this._r;
            ambi.y += this._g;
            ambi.z += this._b;
        }
    }

    static class DirectionalShader
    extends Shader {
        private final float _r;
        private final float _g;
        private final float _b;
        private final Vector3f _dir = new Vector3f();
        private final Vector3f _half_way = new Vector3f();

        public DirectionalShader(float r, float g, float b, Vector3f direction, Shader next) {
            super(next);
            this._r = r;
            this._g = g;
            this._b = b;
            this._dir.set((Tuple3f)direction);
            this._dir.normalize();
        }

        @Override
        public Shader copy(Shader next) {
            return new DirectionalShader(this._r, this._g, this._b, this._dir, next);
        }

        @Override
        public void calculate_halfway(Vector3f dir) {
            this._half_way.add((Tuple3f)this._dir, (Tuple3f)dir);
            this._half_way.normalize();
        }

        @Override
        public void shade(Vector3f normal, Point3f point, Color4f ambi, Color4f diff, Color4f spec, float spec_exp, boolean flip) {
            DirectionalShader.phong(this._r, this._g, this._b, normal, this._dir, this._half_way.x, this._half_way.y, this._half_way.z, spec_exp, diff, spec, flip);
        }
    }

    public static enum LightType {
        point,
        spot,
        directional,
        ambient;

    }

    static class PointShader
    extends Shader {
        private final float _r;
        private final float _g;
        private final float _b;
        private final Point3f _pos = new Point3f();
        private final Point3f _att = new Point3f();
        private final Vector3f _ldir = new Vector3f();
        private final Vector3f _rdir = new Vector3f();

        public PointShader(float r, float g, float b, Point3f pos, Point3f att, Shader next) {
            super(next);
            this._r = r;
            this._g = g;
            this._b = b;
            this._pos.set((Tuple3f)pos);
            this._att.set((Tuple3f)att);
        }

        @Override
        public Shader copy(Shader next) {
            return new PointShader(this._r, this._g, this._b, this._pos, this._att, next);
        }

        @Override
        public void calculate_halfway(Vector3f dir) {
            this._rdir.set((Tuple3f)dir);
        }

        @Override
        public void mark(Color4f _sample_color, Point3f point) {
            this._ldir.set((Tuple3f)point);
            this._ldir.sub((Tuple3f)this._pos);
            float disq = this._ldir.lengthSquared();
            double dist = Math.sqrt(disq);
            if (dist < 0.5) {
                _sample_color.set(1.0f, 1.0f, 1.0f, 1.0f);
                _sample_color.w = (float)((1.0 + Math.cos(10.0 * dist)) * 0.5);
            }
        }

        @Override
        public void shade(Vector3f normal, Point3f point, Color4f ambi, Color4f diff, Color4f spec, float spec_exp, boolean flip) {
            this._ldir.set((Tuple3f)point);
            this._ldir.sub((Tuple3f)this._pos);
            float disq = this._ldir.lengthSquared();
            float att = this._att.x + this._att.y * (float)Math.sqrt(disq) + this._att.z * disq;
            this._ldir.normalize();
            float hw_x = this._ldir.x + this._rdir.x;
            float hw_y = this._ldir.y + this._rdir.y;
            float hw_z = this._ldir.z + this._rdir.z;
            float hwli = 1.0f / (float)Math.sqrt(hw_x * hw_x + hw_y * hw_y + hw_z * hw_z);
            PointShader.phong(this._r * att, this._g * att, this._b * att, normal, this._ldir, hwli * hw_x, hwli * hw_y, hwli * hw_z, spec_exp, diff, spec, flip);
        }
    }

    static class SpotShader
    extends Shader {
        private final float _r;
        private final float _g;
        private final float _b;
        private final Vector3f _dir = new Vector3f();
        private final Point3f _pos = new Point3f();
        private final Point3f _att = new Point3f();
        private final float _spread;
        private final float _scos;
        private final float _conc;
        private final Vector3f _ldir = new Vector3f();

        public SpotShader(float r, float g, float b, Vector3f dir, Point3f pos, float spread, float concentration, Point3f att, Shader next) {
            super(next);
            this._r = r;
            this._g = g;
            this._b = b;
            this._dir.set((Tuple3f)dir);
            this._dir.normalize();
            this._pos.set((Tuple3f)pos);
            this._att.set((Tuple3f)att);
            this._spread = spread;
            this._scos = (float)Math.cos(spread);
            this._conc = concentration;
        }

        @Override
        public Shader copy(Shader next) {
            return new SpotShader(this._r, this._g, this._b, this._dir, this._pos, this._spread, this._conc, this._att, next);
        }

        @Override
        public void shade(Vector3f normal, Point3f point, Color4f ambi, Color4f diff, Color4f spec, float spec_exp, boolean flip) {
            this._ldir.set((Tuple3f)point);
            this._ldir.sub((Tuple3f)this._pos);
            float disq = this._ldir.lengthSquared();
            float att = this._att.x + this._att.y * (float)Math.sqrt(disq) + this._att.z * disq;
            this._ldir.normalize();
            float cos = this._ldir.dot(this._dir);
            if (cos < this._scos) {
                return;
            }
            float hw_x = this._ldir.x + this._dir.x;
            float hw_y = this._ldir.y + this._dir.y;
            float hw_z = this._ldir.z + this._dir.z;
            float hwli = 1.0f / (float)Math.sqrt(hw_x * hw_x + hw_y * hw_y + hw_z * hw_z);
            SpotShader.phong(this._r * (att *= SpotShader.pow_approx(cos, this._conc)), this._g * att, this._b * att, normal, this._ldir, hwli * hw_x, hwli * hw_y, hwli * hw_z, spec_exp, diff, spec, flip);
        }
    }

    static class WhiteAmbientShader
    extends Shader {
        private final float _w;

        public WhiteAmbientShader(float w, Shader next) {
            super(next);
            this._w = w;
        }

        @Override
        public Shader copy(Shader next) {
            return new WhiteAmbientShader(this._w, next);
        }

        @Override
        public void shade(Vector3f normal, Point3f point, Color4f ambi, Color4f diff, Color4f spec, float spec_exp, boolean flip) {
            ambi.w += this._w;
        }
    }
}

