/*
 * Decompiled with CFR 0.152.
 */
package main.view3d;

import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import main.Message;
import main.view3d.LightModel;
import misc.messages.YObservable;

public class LightSettings
extends YObservable
implements Map<String, LightModel> {
    public static final int M_LIGHT_ADDED = Message.register_message("Light added");
    public static final int M_LIGHT_REMOVED = Message.register_message("Light removed");
    public static final int M_LIGHTS_CLEARED = Message.register_message("All lights removed");
    private final Hashtable<String, LightModel> _lights = new Hashtable();

    public LightModel remove_light(Object name) {
        if (name instanceof LightModel) {
            name = ((LightModel)name).get_name();
        }
        if (name == null || !this._lights.containsKey(name)) {
            return null;
        }
        LightModel light = this._lights.get(name);
        this._lights.remove(name);
        this.setChanged();
        this.notifyObservers(new Message(M_LIGHT_REMOVED, light));
        return light;
    }

    public LightModel add_light(LightModel m) {
        String name = m.get_name();
        if (m != null && name != null && !this._lights.containsKey(name)) {
            this._lights.put(name, m);
            this.setChanged();
            this.notifyObservers(new Message(M_LIGHT_ADDED, m));
            return m;
        }
        return null;
    }

    @Override
    public void clear() {
        this._lights.clear();
        this.setChanged();
        this.notifyObservers(new Message(M_LIGHTS_CLEARED, null));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._lights.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._lights.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, LightModel>> entrySet() {
        return Collections.unmodifiableMap(this._lights).entrySet();
    }

    @Override
    public LightModel get(Object key) {
        return this._lights.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this._lights.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableMap(this._lights).keySet();
    }

    @Override
    public LightModel put(String key, LightModel value) {
        if (!value.get_name().equals(key)) {
            throw new IllegalArgumentException("name does not match");
        }
        return this.add_light(value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends LightModel> m) {
        for (Map.Entry<? extends String, ? extends LightModel> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public LightModel remove(Object key) {
        return this.remove_light(key);
    }

    @Override
    public int size() {
        return this._lights.size();
    }

    @Override
    public Collection<LightModel> values() {
        return Collections.unmodifiableMap(this._lights).values();
    }
}

