/*
 * Decompiled with CFR 0.152.
 */
package main.view3d;

import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public abstract class Shader {
    public final Shader _next;

    public Shader(Shader next) {
        this._next = next;
    }

    public abstract Shader copy(Shader var1);

    public static Shader copy_all(Shader s) {
        if (s == null) {
            return null;
        }
        return s.copy(Shader.copy_all(s._next));
    }

    public static void shade_all(Shader s, Vector3f normal, Point3f point, Color4f ambi, Color4f diff, Color4f spec, float spec_exp, boolean flip_normal) {
        while (s != null) {
            s.shade(normal, point, ambi, diff, spec, spec_exp, flip_normal);
            s = s._next;
        }
    }

    public static void mark_all(Shader s, Color4f _sample_color, Point3f point) {
        while (s != null) {
            s.mark(_sample_color, point);
            s = s._next;
        }
    }

    public void mark(Color4f _sample_color, Point3f point) {
    }

    public static String toString_all(Shader s) {
        StringBuilder b = new StringBuilder();
        while (s != null) {
            b.append(s).append('\n');
            s = s._next;
        }
        return b.toString();
    }

    public static void calculate_halfway_all(Shader s, Vector3f dir) {
        while (s != null) {
            s.calculate_halfway(dir);
            s = s._next;
        }
    }

    public abstract void shade(Vector3f var1, Point3f var2, Color4f var3, Color4f var4, Color4f var5, float var6, boolean var7);

    public void calculate_halfway(Vector3f dir) {
    }

    static final void phong(float r, float g, float b, Vector3f normal, Vector3f dir, float hw_x, float hw_y, float hw_z, float spec_exp, Color4f diff, Color4f spec, boolean flip) {
        float i_diff = Math.max(normal.dot(dir), 0.0f);
        float s = normal.x * hw_x + normal.y * hw_y + normal.z * hw_z;
        if (flip && i_diff < 0.0f) {
            s *= -1.0f;
            i_diff *= -1.0f;
        }
        float i_spec = Shader.pow_approx(s, spec_exp);
        diff.x += r * i_diff;
        diff.y += g * i_diff;
        diff.z += b * i_diff;
        i_spec = Math.max(i_spec, 0.0f);
        spec.x += r * i_spec;
        spec.y += g * i_spec;
        spec.z += b * i_spec;
    }

    protected static float pow_approx(float x, float n) {
        return x / (n - n * x + x);
    }
}

