/*
 * Decompiled with CFR 0.152.
 */
package main.view3d;

import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import main.view3d.LightMarker;
import main.view3d.LightModel;

public class SpotMarker
extends LightMarker {
    TransformGroup _dir_transform = new TransformGroup();
    TransformGroup _arrow_transform = new TransformGroup();
    TransformGroup _cone_transform = new TransformGroup();
    Shape3D _arrow = new Shape3D();
    Shape3D _arrow_lines = new Shape3D();
    boolean _is_directed = true;

    public SpotMarker() {
        this._root.setCapability(13);
        this._dir_transform.setCapability(18);
        this._arrow_transform.setCapability(18);
        this._cone_transform.setCapability(18);
        this._root.addChild((Node)this._dir_transform);
        this._dir_transform.addChild((Node)this._arrow_transform);
        this._dir_transform.addChild((Node)this._cone_transform);
        Shape3D s3d = new Shape3D();
        s3d.setGeometry(SpotMarker.get_arrow_lines());
        s3d.setAppearance(SpotMarker.make_wire_appearance());
        this._arrow_transform.addChild((Node)s3d);
        this._arrow = s3d;
        s3d = new Shape3D();
        s3d.setGeometry(SpotMarker.get_arrow());
        s3d.setAppearance(SpotMarker.make_solid_appearance(0.2f, 0.2f, 0.2f));
        this._arrow_lines = s3d;
        this._arrow_transform.addChild((Node)s3d);
        s3d = new Shape3D();
        s3d.setGeometry(SpotMarker.get_cone_lines());
        s3d.setAppearance(SpotMarker.make_wire_appearance());
        this._cone_transform.addChild((Node)s3d);
        s3d = new Shape3D();
        s3d.setGeometry(SpotMarker.get_cone());
        s3d.setAppearance(SpotMarker.make_solid_appearance(1.0f, 1.0f, 1.0f, 0.8f));
        this._cone_transform.addChild((Node)s3d);
    }

    @Override
    public void set_light_marker_state(LightModel m, Vector3f d, Point3f foc) {
        float width;
        double a1 = Math.atan2(d.y, d.x);
        double a2 = Math.atan2(Math.sqrt(d.x * d.x + d.y * d.y), d.z);
        Transform3D t = new Transform3D();
        t.rotY(a2);
        Transform3D t2 = new Transform3D();
        t2.rotZ(a1);
        t2.mul(t);
        Vector3f dist = new Vector3f(d);
        dist.scale(-1.0f);
        dist.add((Tuple3f)foc);
        t2.setTranslation(dist);
        this._dir_transform.setTransform(t2);
        t.setIdentity();
        t.setScale(0.2);
        t2.setIdentity();
        t2.setTranslation(new Vector3f(0.0f, 0.0f, -1.0f));
        t.mul(t2);
        this._arrow_transform.setTransform(t);
        t.setIdentity();
        dist.sub((Tuple3f)foc);
        float height = dist.length();
        float spread = (float)m.get_spread();
        if ((double)(spread * 2.0f) >= Math.PI) {
            width = 1.0E-5f;
            height = -0.001f;
            this._is_directed = false;
        } else {
            width = (float)Math.tan(spread) * height;
            this._is_directed = true;
        }
        t.setScale(new Vector3d((double)width, (double)width, (double)height));
        this._cone_transform.setTransform(t);
    }
}

