/*
 * Decompiled with CFR 0.152.
 */
package main.view3d;

import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseWheelZoom;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.Viewer;
import gui.MyToolbar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Light;
import javax.media.j3d.LinearFog;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SpotLight;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.ToolTipManager;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.Segment;
import main.Viewport;
import main.YaDiV;
import main.seggen.SegGen;
import main.tools.ToolSegGen;
import main.view2d.Viewport2dModel;
import main.view3d.AmbientLightMarker;
import main.view3d.DirectionalLightMarker;
import main.view3d.LightMarker;
import main.view3d.LightModel;
import main.view3d.LightSettings;
import main.view3d.PointLightMarker;
import main.view3d.Shader;
import main.view3d.SpotMarker;
import misc.FPSCounter;
import misc.Voxel;
import misc.messages.YObservable;
import renderer.BBoxRenderer3d;
import renderer.MarkerRenderer3d;
import renderer.Renderer3d;
import renderer.SegRenderer3d;
import renderer.Tex2Renderer3d;
import renderer.Tex3Renderer3d;
import settings.Settings;
import settings.SettingsOwner;

public final class Viewport3d
extends Viewport
implements SettingsOwner {
    public static final String OPT_FOG_SHOW = Settings.register_bool_opt(Viewport3d.class, "Fog Enabled", "Adds an optional fog (sometimes usefull for adding depths to point cloud rendering)", false);
    public static final String OPT_FOGGINESS = Settings.register_double_opt(Viewport3d.class, "Fog Level", "Fog Level", 0.8);
    public static final String OPT_SHOW_FPS = Settings.register_bool_opt(Viewport3d.class, "Show FPS", "Enables or disables FPS measurement. Warning: Measuring FPS causes the gfx card to render the pictureconstantly, even if the scene does not change.", false);
    public static final String OPT_BG_COLOR = Settings.register_color_opt(Viewport3d.class, "Background Color", "Background Color for the Viewport3d", new Color(0, 0, 0));
    public static final String OPT_STEREO = Settings.register_bool_opt(Viewport3d.class, "Stereo Mode", "Use Stereo Display (if available)", true);
    public static final String OPT_STEREO_EYE_DIST = Settings.register_double_opt(Viewport3d.class, "Stereo Eye Dist", "Distance between left and right eye, negative values switch eye position.", 0.01);
    public static final int M_ROTATION_CHANGED = Message.register_message("3D rotation changed");
    public static final int SCENE_1 = 1;
    public static final int SCENE_2 = 2;
    public static final int SCENE_3 = 3;
    private final Hashtable<Renderer3d, BranchGroup> _renderer_map = new Hashtable();
    private final Hashtable<Segment, SegRenderer3d> _seg_renderers = new Hashtable();
    public final ObservableV3D _transform_notifier = new ObservableV3D();
    private final Panel3d _panel3d;
    private Shape3D _shp_selvoxel;
    private final View3dToolBar _view3d_toolbar;
    private final JLabel _v3d_label;
    private final Viewport3d _v3d_instance;
    private final Map<String, BranchGroup> _lights_map = new HashMap<String, BranchGroup>();
    private final Map<String, LightMarker> _light_marker_map = new HashMap<String, LightMarker>();
    private final Tex2Renderer3d _tex2d_renderer;
    private final Tex3Renderer3d _tex3d_renderer;
    private final BBoxRenderer3d _bbox_renderer;
    private final BBoxRenderer3d _seg_bbox_renderer;
    private final MarkerRenderer3d _marker_renderer;

    public void set_full_screen(boolean full_screen) {
        this._view3d_toolbar._jtb_fullscreen.setSelected(full_screen);
    }

    public Viewport3d() {
        Settings.register_owner(this);
        this._v3d_instance = this;
        this._panel3d = new Panel3d();
        this._panel3d.setPreferredSize(new Dimension(this.DEF_WIDTH, this.DEF_HEIGHT));
        Segment tmp_seg = MasterControl.get_is().get_segment(ToolSegGen.TMP_SEG_NAME);
        SegRenderer3d tmp_renderer = new SegRenderer3d(this, 1, tmp_seg);
        Settings.set_bool_option(tmp_renderer, SegRenderer3d.OPT_SHOW_POINTS, true);
        Settings.set_bool_option(tmp_renderer, SegRenderer3d.OPT_SHOW_MC, false);
        this._seg_renderers.put(tmp_seg, tmp_renderer);
        this._view3d_toolbar = new View3dToolBar();
        this._v3d_label = new JLabel("  View 3d");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this._v3d_label, "West");
        panel.add((Component)this._view3d_toolbar, "East");
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "North");
        this.add((Component)this._panel3d, "Center");
        MasterControl.get_lights().addObserver(this, "main.view3d.Viewport3d added itself in it's constructor");
        this._bbox_renderer = new BBoxRenderer3d(this, 1, MasterControl.get_is().get_bb(), "Bounding Box");
        this._seg_bbox_renderer = new BBoxRenderer3d(this, 1, SegGen.get_seg_gen_bb(), "Seg Generator Bounding Box");
        Settings.set_bool_option(this._seg_bbox_renderer, BBoxRenderer3d.OPT_VISIBLE, false);
        Settings.set_bool_option(this._seg_bbox_renderer, BBoxRenderer3d.OPT_AUTO_COLOR, false);
        Settings.set_color_option(this._seg_bbox_renderer, BBoxRenderer3d.OPT_COLOR, new Color(255, 128, 128));
        this._marker_renderer = new MarkerRenderer3d(this, 1, this._panel3d._tg_mouse_rotate);
        this.add_renderer(this._bbox_renderer);
        this.add_renderer(this._seg_bbox_renderer);
        this._tex2d_renderer = new Tex2Renderer3d(this, 1);
        this._tex3d_renderer = new Tex3Renderer3d(this, 2, this._panel3d._tg_mouse_rotate, this._panel3d._canvas3d);
        this.add_renderer(this._tex2d_renderer);
        MasterControl.get_is().addObserver(this, "Viewport3d()");
        MasterControl.get_v2d().get_model().addObserver(this, "Viewport3d()");
        this._transform_notifier.addObserver(this, "Viewport3d()");
    }

    public Canvas3D get_canvas3d() {
        return this._panel3d._canvas3d;
    }

    public SegRenderer3d get_seg_renderer(Segment seg) {
        if (seg == null) {
            return null;
        }
        return this._seg_renderers.get(seg);
    }

    public Tex2Renderer3d get_tex2_renderer() {
        return this._tex2d_renderer;
    }

    public Tex3Renderer3d get_tex3_renderer() {
        return this._tex3d_renderer;
    }

    public BBoxRenderer3d get_bbox_renderer() {
        return this._bbox_renderer;
    }

    public BBoxRenderer3d get_seg_bbox_renderer() {
        return this._seg_bbox_renderer;
    }

    public MarkerRenderer3d get_marker_renderer() {
        return this._marker_renderer;
    }

    public void set_title_string(String str) {
        this._v3d_label.setText("  View 3d" + str);
    }

    public void reset_view() {
        this._panel3d.set_mouse_rotate(this._panel3d._tf_mouse_rotate_orig);
    }

    public void get_view_transform(Transform3D view_transform) {
        TransformGroup view_tg = this._panel3d._simple_u.getViewingPlatform().getViewPlatformTransform();
        view_tg.getTransform(view_transform);
    }

    public void get_world_transform(Transform3D world_transform) {
        this.get_tex2_renderer().get_group().getLocalToVworld(world_transform);
    }

    public Transform3D get_focus_transform(Transform3D t) {
        if (t == null) {
            t = new Transform3D();
        }
        this._panel3d._tg_mouse_rotate.getTransform(t);
        return t;
    }

    public Transform3D get_data_to_light_transform(Transform3D t) {
        if (t == null) {
            t = new Transform3D();
        }
        Transform3D t1 = new Transform3D();
        Transform3D t2 = new Transform3D();
        this._panel3d._tg_mouse_rotate.getTransform(t1);
        this._panel3d._tg_scale_and_move1.getTransform(t2);
        t.mul(t1, t2);
        return t;
    }

    public Transform3D get_data_transform(Transform3D t) {
        if (t == null) {
            t = new Transform3D();
        }
        this._panel3d._tg_scale_and_move1.getTransform(t);
        return t;
    }

    public void set_view_transform(Transform3D t) {
    }

    public void set_world_transform(Transform3D t) {
        Transform3D sam1 = new Transform3D();
        this._panel3d._tg_scale_and_move1.getTransform(sam1);
        t.mulInverse(sam1);
        Matrix3d rot_matrix = new Matrix3d();
        t.get(rot_matrix);
        Transform3D rot = new Transform3D(rot_matrix, new Vector3d(), 1.0);
        t.mulInverse(rot);
        this._panel3d.set_mouse_rotate(rot);
        this._panel3d._tg_mouse_zoom_trans.setTransform(t);
    }

    public Shader get_shader_chain() {
        Shader r = null;
        Transform3D rot = new Transform3D();
        this._panel3d._tg_mouse_rotate.getTransform(rot);
        for (LightModel m : MasterControl.get_lights().values()) {
            r = m.create_shader(r, this.get_light_focus_transform(m), rot);
        }
        return r;
    }

    private Transform3D get_light_focus_transform(LightModel m) {
        if (!m.is_tracing()) {
            return null;
        }
        Transform3D t = new Transform3D();
        this._panel3d._tg_mouse_rotate.getTransform(t);
        return t;
    }

    public TransformGroup get_mouse_rotate() {
        return this._panel3d._tg_mouse_rotate;
    }

    public void add_renderer(Renderer3d renderer) {
        if (!this._renderer_map.containsKey(renderer)) {
            switch (renderer.get_scene_id()) {
                case 1: {
                    this._panel3d._bg_scene1.addChild((Node)renderer.get_group());
                    this._renderer_map.put(renderer, this._panel3d._bg_scene1);
                    break;
                }
                case 2: {
                    this._panel3d._bg_scene2.addChild((Node)renderer.get_group());
                    this._renderer_map.put(renderer, this._panel3d._bg_scene2);
                    break;
                }
                case 3: {
                    this._panel3d._bg_scene3.addChild((Node)renderer.get_group());
                    this._renderer_map.put(renderer, this._panel3d._bg_scene3);
                    break;
                }
            }
        }
    }

    public void rem_renderer(Renderer3d renderer) {
        if (this._renderer_map.containsKey(renderer)) {
            this._renderer_map.get(renderer).removeChild((Node)renderer.get_group());
            this._renderer_map.remove(renderer);
        }
    }

    @Override
    public final void update(YObservable o, Message m) {
        ImageStack is = MasterControl.get_is();
        if (m._type == ImageStack.M_LOADING_START) {
            this._renderer_map.clear();
            this._seg_renderers.clear();
            this._view3d_toolbar.setEnabled(false);
            Settings.set_class_bool_option(Tex3Renderer3d.class, Tex3Renderer3d.OPT_RENDER_BG, false);
        } else if (m._type == ImageStack.M_VC_SPACING_CHANGED || m._type == ImageStack.M_VC_SET) {
            this._panel3d.init();
        } else if (m._type == ImageStack.M_LOADING_END) {
            this._view3d_toolbar.setEnabled(true);
        } else if (m._type == ImageStack.M_RESIZE_END) {
            this._panel3d.init();
            this._tex2d_renderer.resize();
            this._tex3d_renderer.resize();
        } else if (m._type == Viewport2dModel.M_NEW_ACTIVE_IMAGE) {
            boolean render_plane = Settings.get_bool_option(this._tex2d_renderer, Tex2Renderer3d.OPT_RENDER_PLANE);
            boolean render_ortho = Settings.get_bool_option(this._tex2d_renderer, Tex2Renderer3d.OPT_RENDER_ORTHO);
            if (render_plane || render_ortho) {
                this._tex2d_renderer.show_planes();
            }
        } else if (m._type == ImageStack.M_SELECTXYZ) {
            LinkedList<Voxel> seeds = is.get_seeds();
            PointArray points = null;
            if (seeds.size() != 0) {
                points = new PointArray(is.get_seeds().size(), 1);
                Iterator vi = is.get_seeds().iterator();
                int i = 0;
                while (vi.hasNext()) {
                    Voxel v = (Voxel)vi.next();
                    points.setCoordinate(i++, new Point3f((float)v._x, (float)v._y, (float)v._z));
                }
            }
            this._shp_selvoxel.setGeometry(points);
        } else if (m._type == ImageStack.M_NEW_SEGMENT) {
            Segment seg = (Segment)m._obj;
            SegRenderer3d renderer = new SegRenderer3d(this, 1, seg);
            this._seg_renderers.put(seg, renderer);
        } else if (m._type == ImageStack.M_DEL_SEGMENT) {
            Segment seg = (Segment)m._obj;
            this.rem_renderer(this._seg_renderers.get(seg));
            this._seg_renderers.remove(seg);
        } else if (m._type == LightModel.M_TYPE_CHANGED) {
            this._panel3d.update_light((LightModel)o);
        } else if (m._type == LightModel.M_TRACING_CHANGED) {
            boolean need_transform;
            LightModel model = (LightModel)o;
            boolean bl = need_transform = !model.is_focus_valid();
            if (need_transform) {
                Transform3D t = new Transform3D();
                this._panel3d._tg_mouse_rotate.getTransform(t);
                Point3f focus = model.get_focus(new Point3f());
                if (model.is_tracing()) {
                    t.invert();
                }
                t.transform(focus);
                model.set_focus(focus);
            }
        } else if (m._type == LightModel.M_MARKER_VISIBILITY) {
            this._panel3d.update_light_marker((LightModel)o);
        } else if (o instanceof LightModel) {
            LightModel mod = (LightModel)o;
            BranchGroup container = this._lights_map.get(mod.get_name());
            if (container == null) {
                YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "V3d doesnt know light " + mod.get_name());
            }
            ((LightModel)o).set_light_state((Light)container.getChild(0), this.get_light_focus_transform((LightModel)o));
            LightMarker mark = this._light_marker_map.get(mod.get_name());
            if (mark != null) {
                Transform3D t = mod.is_tracing() ? this.get_focus_transform(null) : null;
                Vector3f d = new Vector3f();
                Point3f focus = new Point3f();
                mod.get_direction_transformed(d, t);
                mod.get_focus_transformed(focus, t);
                mark.set_light_marker_state(mod, d, focus);
            }
        } else if (m._type == LightSettings.M_LIGHT_REMOVED) {
            this._panel3d.remove_light((LightModel)m._obj);
        } else if (m._type == LightSettings.M_LIGHTS_CLEARED) {
            this._lights_map.clear();
            this._light_marker_map.clear();
            this._panel3d._light_group.removeAllChildren();
        } else if (m._type == LightSettings.M_LIGHT_ADDED) {
            this._panel3d.update_light((LightModel)m._obj);
        } else if (m._type == M_ROTATION_CHANGED) {
            this._panel3d.update_light_directions();
        }
    }

    @Override
    public final String get_name() {
        return "Viewport 3d";
    }

    @Override
    public final void settings_changed(Object obj, String opt_name, Object opt) {
        if (obj.getClass() == LightModel.class && opt_name != LightModel.OPT_POS_X) {
        }
        if (obj.getClass() == Viewport3d.class) {
            if (opt_name == OPT_SHOW_FPS) {
                this._panel3d._fps_counter.set_reporting(Settings.get_bool_option(this, OPT_SHOW_FPS));
            } else if (opt_name == OPT_FOGGINESS) {
                this._panel3d.update_fog();
            } else if (opt_name == OPT_FOG_SHOW) {
                if (Settings.get_bool_option(this._v3d_instance, OPT_FOG_SHOW).booleanValue()) {
                    this._panel3d._root.addChild((Node)this._panel3d._fog_group);
                } else {
                    this._panel3d._root.removeChild((Node)this._panel3d._fog_group);
                }
            } else if (opt_name == OPT_BG_COLOR) {
                Color bg = Settings.get_color_option(this, OPT_BG_COLOR);
                this._panel3d._bgNode.setColor(new Color3f(bg));
            } else if (opt_name == OPT_STEREO) {
                this._panel3d._canvas3d.setStereoEnable(Settings.get_bool_option(Viewport3d.class, OPT_STEREO).booleanValue());
            } else if (opt_name == OPT_STEREO_EYE_DIST) {
                double eye_dist = Settings.get_double_option(this, OPT_STEREO_EYE_DIST);
                this._panel3d._canvas3d.getView().getPhysicalBody().setLeftEyePosition(new Point3d(-eye_dist / 2.0, 0.0, 0.0));
                this._panel3d._canvas3d.getView().getPhysicalBody().setRightEyePosition(new Point3d(eye_dist / 2.0, 0.0, 0.0));
            }
        }
    }

    public TransformGroup get_sam1() {
        return this._panel3d._tg_scale_and_move1;
    }

    public boolean get_stereo_available() {
        return this._panel3d._canvas3d.getStereoAvailable();
    }

    public static class ObservableV3D
    extends YObservable {
        @Override
        protected void setChanged() {
            super.setChanged();
        }
    }

    private final class Panel3d
    extends JPanel {
        private int _dim_x;
        private int _dim_y;
        private int _dim_z;
        private final Canvas3D _canvas3d;
        private SimpleUniverse _simple_u;
        private BranchGroup _root;
        private BranchGroup _bg_scene1;
        private BranchGroup _bg_scene2;
        private BranchGroup _bg_scene3;
        private BranchGroup _light_group;
        private TransformGroup _tg_mouse_zoom_trans;
        private TransformGroup _tg_mouse_rotate;
        private TransformGroup _tg_scale_and_move1;
        private TransformGroup _tg_scale_and_move2;
        private FPSCounter _fps_counter;
        private BranchGroup _fog_group;
        private LinearFog _fog;
        private Transform3D _tf_mouse_rotate_orig;
        private BranchGroup _bgcolor;
        private Background _bgNode;
        private BoundingSphere _bounds;

        public Panel3d() {
            this.setMinimumSize(new Dimension(Viewport3d.this.DEF_WIDTH / 4, Viewport3d.this.DEF_HEIGHT / 4));
            this.setPreferredSize(new Dimension(Viewport3d.this.DEF_WIDTH, Viewport3d.this.DEF_HEIGHT));
            this.setBackground(Color.BLUE);
            GraphicsConfigTemplate3D template = new GraphicsConfigTemplate3D();
            template.setStereo(2);
            GraphicsConfiguration config = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)template);
            this._canvas3d = new Canvas3D(config);
            this._canvas3d.setMinimumSize(new Dimension(Viewport3d.this.DEF_WIDTH, Viewport3d.this.DEF_HEIGHT));
            this._canvas3d.setPreferredSize(new Dimension(Viewport3d.this.DEF_WIDTH, Viewport3d.this.DEF_HEIGHT));
            this._canvas3d.setBackground(Color.black);
            this._canvas3d.setStereoEnable(Settings.get_bool_option(Viewport3d.class, OPT_STEREO).booleanValue());
            this.setLayout(new BorderLayout());
            this.add((Component)this._canvas3d, "Center");
            this.create_universe();
            this._canvas3d.getView().setTransparencySortingPolicy(1);
            ToolTipManager ttm = ToolTipManager.sharedInstance();
            ttm.setLightWeightPopupEnabled(false);
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        }

        private final void init() {
            ImageStack is = MasterControl.get_is();
            this._dim_x = is.get_dim_x();
            this._dim_y = is.get_dim_y();
            this._dim_z = is.get_dim_z();
            double x_spacing = is.get_x_spacing();
            double y_spacing = is.get_y_spacing();
            double z_spacing = is.get_z_spacing();
            double xmax_scaled = (double)this._dim_x * x_spacing;
            double ymax_scaled = (double)this._dim_y * y_spacing;
            double zmax_scaled = (double)this._dim_z * z_spacing;
            double max_scaled1 = Math.max(Math.max(xmax_scaled, ymax_scaled), zmax_scaled);
            double s1 = 1.5 / max_scaled1;
            double[] mat_scale1 = new double[]{s1 * x_spacing, 0.0, 0.0, 0.0, 0.0, s1 * y_spacing, 0.0, 0.0, 0.0, 0.0, s1 * z_spacing, 0.0, 0.0, 0.0, 0.0, 1.0};
            Transform3D tf_scale_and_move1 = new Transform3D(mat_scale1);
            tf_scale_and_move1.setTranslation(new Vector3d(-(s1 * xmax_scaled) / 2.0, -(s1 * ymax_scaled) / 2.0, -(s1 * zmax_scaled) / 2.0));
            this._tg_scale_and_move1.setTransform(tf_scale_and_move1);
            double dl = Math.max(Math.max(xmax_scaled, ymax_scaled), zmax_scaled);
            double s2 = 1.5 / dl;
            double[] mat_scale2 = new double[]{s2, 0.0, 0.0, 0.0, 0.0, s2, 0.0, 0.0, 0.0, 0.0, s2, 0.0, 0.0, 0.0, 0.0, 1.0};
            Transform3D tf_scale_and_move2 = new Transform3D(mat_scale2);
            double dl2 = Math.sqrt(xmax_scaled * xmax_scaled + ymax_scaled * ymax_scaled + zmax_scaled * zmax_scaled);
            tf_scale_and_move2.setTranslation(new Vector3d(-(s2 * dl2) / 2.0, -(s2 * dl2) / 2.0, -(s2 * dl2) / 2.0));
            this._tg_scale_and_move2.setTransform(tf_scale_and_move2);
            Transform3D tf_rot_init = new Transform3D();
            tf_rot_init.rotX(Math.PI);
            this._tf_mouse_rotate_orig = new Transform3D(tf_rot_init);
            this.set_mouse_rotate(tf_rot_init);
        }

        private final void create_universe() {
            this._simple_u = new SimpleUniverse(this._canvas3d);
            Viewer viewer = this._simple_u.getViewer();
            View view = viewer.getView();
            this._simple_u.getViewingPlatform().setNominalViewingTransform();
            view.setFrontClipDistance(0.001);
            double eye_dist = Settings.get_double_option(Viewport3d.class, OPT_STEREO_EYE_DIST);
            viewer.getPhysicalBody().setLeftEyePosition(new Point3d(-eye_dist / 2.0, 0.0, 0.0));
            viewer.getPhysicalBody().setRightEyePosition(new Point3d(eye_dist / 2.0, 0.0, 0.0));
            if (!(Settings.get_bool_option(Viewport3d.class, OPT_STEREO).booleanValue() && this._canvas3d.getStereoAvailable() && this._canvas3d.getStereoEnable())) {
                this._canvas3d.setMonoscopicViewPolicy(2);
            }
            PointArray points = new PointArray(1, 5);
            Viewport3d.this._shp_selvoxel = new Shape3D((Geometry)points);
            Appearance ap = new Appearance();
            ColoringAttributes ca = new ColoringAttributes();
            ca.setColor(new Color3f(1.0f, 0.0f, 1.0f));
            ap.setColoringAttributes(ca);
            PointAttributes pa = new PointAttributes();
            pa.setPointSize(6.0f);
            pa.setPointAntialiasingEnable(true);
            ap.setPointAttributes(pa);
            Viewport3d.this._shp_selvoxel.setAppearance(ap);
            Viewport3d.this._shp_selvoxel.setCapability(13);
            this._root = new BranchGroup();
            this._root.setCapability(13);
            this._root.setCapability(14);
            this._bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
            this._bgcolor = new BranchGroup();
            this._bgcolor.setCapability(17);
            this._bgcolor.setCapability(13);
            this._bgcolor.setCapability(14);
            Color3f bgColor = new Color3f(Settings.get_color_option(Viewport3d.class, OPT_BG_COLOR));
            this._bgNode = new Background(bgColor);
            this._bgNode.setCapability(17);
            this._bgNode.setCapability(16);
            this._bgNode.setApplicationBounds((Bounds)this._bounds);
            this._bgcolor.addChild((Node)this._bgNode);
            this._root.addChild((Node)this._bgcolor);
            this._fps_counter = new FPSCounter();
            this._fps_counter.set_reporting(false);
            this._fps_counter.setSchedulingBounds((Bounds)this._bounds);
            this._root.addChild((Node)this._fps_counter);
            this._tg_mouse_rotate = new TransformGroup();
            this._tg_mouse_rotate.setCapability(18);
            this._tg_mouse_rotate.setCapability(17);
            this._tg_mouse_zoom_trans = new TransformGroup();
            this._tg_mouse_zoom_trans.setCapability(18);
            this._tg_mouse_zoom_trans.setCapability(17);
            this._tg_scale_and_move1 = new TransformGroup();
            this._tg_scale_and_move1.setCapability(18);
            this._tg_scale_and_move1.setCapability(13);
            this._tg_scale_and_move1.setCapability(14);
            this._tg_scale_and_move2 = new TransformGroup();
            this._tg_scale_and_move2.setCapability(18);
            this._tg_scale_and_move2.setCapability(13);
            this._tg_scale_and_move2.setCapability(14);
            this._bg_scene1 = new BranchGroup();
            this._bg_scene1.setCapability(17);
            this._bg_scene1.setCapability(13);
            this._bg_scene1.setCapability(14);
            this._fog_group = new BranchGroup();
            this._fog_group.setCapability(17);
            this._fog_group.setCapability(13);
            this._fog_group.setCapability(14);
            this._light_group = new BranchGroup();
            this._light_group.setCapability(17);
            this._light_group.setCapability(13);
            this._light_group.setCapability(14);
            this._fog = new LinearFog(0.0f, 0.0f, 0.0f);
            this._fog.setCapability(17);
            this._fog.setInfluencingBounds((Bounds)this._bounds);
            this.create_lights();
            this.update_fog();
            this._fog_group.addChild((Node)this._fog);
            if (Settings.get_bool_option(Viewport3d.this._v3d_instance, OPT_FOG_SHOW).booleanValue()) {
                this._root.addChild((Node)this._fog_group);
            }
            this._bg_scene2 = new BranchGroup();
            this._bg_scene2.setCapability(17);
            this._bg_scene2.setCapability(13);
            this._bg_scene2.setCapability(14);
            MouseRotate _mouse_rotate_behavior = new MouseRotate(this._tg_mouse_rotate){

                public void transformChanged(Transform3D transform) {
                    ((Panel3d)Panel3d.this).Viewport3d.this._transform_notifier.setChanged();
                    ((Panel3d)Panel3d.this).Viewport3d.this._transform_notifier.notifyObservers(new Message(M_ROTATION_CHANGED, null));
                }
            };
            _mouse_rotate_behavior.setSchedulingBounds((Bounds)this._bounds);
            MouseTranslate mt = new MouseTranslate(this._tg_mouse_zoom_trans);
            mt.setSchedulingBounds((Bounds)this._bounds);
            MouseWheelZoom mwz = new MouseWheelZoom(this._tg_mouse_zoom_trans){

                public void transformChanged(Transform3D transform) {
                    Panel3d.this.update_fog();
                }
            };
            mwz.setFactor(-0.1);
            mwz.setSchedulingBounds((Bounds)this._bounds);
            this._bg_scene3 = new BranchGroup();
            this._bg_scene3.setCapability(17);
            this._bg_scene3.setCapability(13);
            this._bg_scene3.setCapability(14);
            this._root.addChild((Node)this._tg_mouse_zoom_trans);
            this._root.addChild((Node)_mouse_rotate_behavior);
            this._root.addChild((Node)mt);
            this._root.addChild((Node)mwz);
            this._tg_mouse_zoom_trans.addChild((Node)this._tg_mouse_rotate);
            this._tg_mouse_zoom_trans.addChild((Node)this._light_group);
            this._tg_mouse_zoom_trans.addChild((Node)this._tg_scale_and_move2);
            this._tg_mouse_rotate.addChild((Node)this._bg_scene3);
            this._tg_mouse_rotate.addChild((Node)this._tg_scale_and_move1);
            this._tg_scale_and_move1.addChild((Node)this._bg_scene1);
            this._tg_scale_and_move2.addChild((Node)this._bg_scene2);
            this._bg_scene1.addChild((Node)Viewport3d.this._shp_selvoxel);
            this._simple_u.addBranchGraph(this._root);
        }

        void update_light_directions() {
            Transform3D t = Viewport3d.this.get_focus_transform(null);
            Vector3f d = new Vector3f();
            Point3f focus = new Point3f();
            for (Map.Entry e : Viewport3d.this._lights_map.entrySet()) {
                LightModel m = MasterControl.get_lights().get(e.getKey());
                if (!m.is_tracing()) continue;
                Light l = (Light)((BranchGroup)e.getValue()).getChild(0);
                LightMarker mark = (LightMarker)Viewport3d.this._light_marker_map.get(m.get_name());
                if (l instanceof DirectionalLight) {
                    m.get_direction_transformed(d, t);
                    m.get_focus_transformed(focus, t);
                    if (mark != null) {
                        mark.set_light_marker_state(m, d, focus);
                    }
                    ((DirectionalLight)l).setDirection(d);
                    continue;
                }
                if (!(l instanceof SpotLight)) continue;
                m.get_direction_transformed(d, t);
                m.get_focus_transformed(focus, t);
                if (mark != null) {
                    mark.set_light_marker_state(m, d, focus);
                }
                ((SpotLight)l).setDirection(d);
            }
        }

        void update_light(LightModel m) {
            String name = m.get_name();
            BranchGroup l = (BranchGroup)Viewport3d.this._lights_map.get(name);
            if (l != null) {
                this._light_group.removeChild((Node)l);
                Viewport3d.this._lights_map.remove(name);
            } else {
                m.addObserver(Viewport3d.this, "added in Viewport3d.Panel3d::update_light");
            }
            Transform3D rotation = Viewport3d.this.get_light_focus_transform(m);
            Light light = m.fiat_lux(rotation);
            LightModel.make_mutable(light);
            light.setInfluencingBounds((Bounds)this._bounds);
            BranchGroup lg = new BranchGroup();
            lg.addChild((Node)light);
            lg.setCapability(17);
            this._light_group.addChild((Node)lg);
            Viewport3d.this._lights_map.put(m.get_name(), lg);
            this.update_light_marker(m);
        }

        private void update_light_marker(LightModel m) {
            String name = m.get_name();
            LightMarker marker = (LightMarker)Viewport3d.this._light_marker_map.get(name);
            if (!m.is_marker_visible()) {
                if (marker != null) {
                    marker.get_root().detach();
                    Viewport3d.this._light_marker_map.remove(name);
                }
                return;
            }
            if (marker != null) {
                marker.get_root().detach();
                marker = null;
            }
            Transform3D t = m.is_tracing() ? Viewport3d.this.get_focus_transform(null) : null;
            Vector3f d = new Vector3f();
            Point3f focus = new Point3f();
            m.get_direction_transformed(d, t);
            m.get_focus_transformed(focus, t);
            switch (m.get_type()) {
                case ambient: {
                    marker = new AmbientLightMarker();
                    break;
                }
                case directional: {
                    marker = new DirectionalLightMarker();
                    break;
                }
                case point: {
                    marker = new PointLightMarker();
                    break;
                }
                case spot: {
                    marker = new SpotMarker();
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            marker.set_light_marker_state(m, d, focus);
            marker.get_root().setCapability(17);
            this._light_group.addChild((Node)marker.get_root());
            Viewport3d.this._light_marker_map.put(m.get_name(), marker);
        }

        private void create_lights() {
            for (LightModel m : MasterControl.get_lights().values()) {
                this.update_light(m);
            }
        }

        private void update_fog() {
            Transform3D zt = new Transform3D();
            this._tg_mouse_zoom_trans.getTransform(zt);
            Vector3d trans = new Vector3d();
            zt.get(trans);
            double center_dist = -trans.z;
            this._simple_u.getViewingPlatform().getViewPlatformTransform().getTransform(zt);
            zt.get(trans);
            center_dist += trans.z;
            double back_fog = Settings.get_double_option(Viewport3d.this._v3d_instance, OPT_FOGGINESS);
            double epsilon = 1.0E-8;
            if (back_fog <= 1.0E-8) {
                back_fog = 1.0E-8;
            } else if (back_fog > 1.0) {
                back_fog = 1.0;
            }
            double front_dist = center_dist - Math.sqrt(2.0);
            this._fog.setFrontDistance(front_dist);
            this._fog.setBackDistance(front_dist + 2.0 * Math.sqrt(2.0) / back_fog);
        }

        public void remove_light(LightModel lightModel) {
            BranchGroup l = (BranchGroup)Viewport3d.this._lights_map.get(lightModel.get_name());
            if (l != null) {
                LightMarker marker = (LightMarker)Viewport3d.this._light_marker_map.get(lightModel.get_name());
                if (marker != null) {
                    this._light_group.removeChild((Node)marker.get_root());
                    Viewport3d.this._light_marker_map.remove(marker);
                }
                this._light_group.removeChild((Node)l);
                Viewport3d.this._lights_map.remove(lightModel.get_name());
                lightModel.deleteObserver(Viewport3d.this);
            }
        }

        public void set_mouse_rotate(Transform3D trans) {
            this._tg_mouse_rotate.setTransform(trans);
            Viewport3d.this._transform_notifier.setChanged();
            Viewport3d.this._transform_notifier.notifyObservers(new Message(M_ROTATION_CHANGED, null));
        }
    }

    private final class View3dToolBar
    extends MyToolbar {
        public JToggleButton _jtb_fullscreen;

        public View3dToolBar() {
            AbstractAction act_fullscreen = new AbstractAction("Show Fullscreen", new ImageIcon("resources/gfx/view_fullscreen3d.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MasterControl.get_window().build_layout(View3dToolBar.this._jtb_fullscreen.isSelected());
                }
            };
            this._jtb_fullscreen = this.add_toggle_button(act_fullscreen, "Show Fullscreen", false);
            this.addSeparator();
            this.add_bool_option_toggle_button(Tex2Renderer3d.class, Tex2Renderer3d.OPT_RENDER_PLANE, (Icon)new ImageIcon("resources/gfx/view_slice.png"));
            this.add_bool_option_toggle_button(Tex2Renderer3d.class, Tex2Renderer3d.OPT_RENDER_ORTHO, (Icon)new ImageIcon("resources/gfx/view_ortho.png"));
            this.addSeparator();
            this.add_bool_option_toggle_button(Tex2Renderer3d.class, Tex2Renderer3d.OPT_RENDER_BG, (Icon)new ImageIcon("resources/gfx/view_tex2d_bg.png"));
            this.add_bool_option_toggle_button(Tex3Renderer3d.class, Tex3Renderer3d.OPT_RENDER_BG, (Icon)new ImageIcon("resources/gfx/view_tex3d_bg.png"));
            ImageStack is = MasterControl.get_is();
            Segment tmp_seg = is.get_segment(ToolSegGen.TMP_SEG_NAME);
            SegRenderer3d tmp_renderer = (SegRenderer3d)Viewport3d.this._seg_renderers.get(tmp_seg);
            this.add_bool_option_toggle_button(tmp_renderer, SegRenderer3d.OPT_VISIBLE, (Icon)new ImageIcon("resources/gfx/view_tmp_seg.png"));
            this.setEnabled(false);
        }
    }
}

