/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.util.Arrays;
import main.Message;
import misc.Voxel;
import misc.messages.YObservable;

public final class AxisAlignedBoundingBox
extends YObservable {
    public static int M_BB_CHANGED = Message.register_message("BB CHANGED");
    private final int[] _bb_min = new int[3];
    private final int[] _bb_max = new int[3];
    public boolean _is_changing = false;

    public AxisAlignedBoundingBox() {
    }

    public AxisAlignedBoundingBox(int min_x, int min_y, int min_z, int max_x, int max_y, int max_z) {
        this._bb_min[0] = min_x;
        this._bb_min[1] = min_y;
        this._bb_min[2] = min_z;
        this._bb_max[0] = max_x;
        this._bb_max[1] = max_y;
        this._bb_max[2] = max_z;
    }

    public void set_box(int min_x, int min_y, int min_z, int max_x, int max_y, int max_z) {
        if (this._is_changing) {
            return;
        }
        if (min_x != this._bb_min[0] || min_y != this._bb_min[1] || min_z != this._bb_min[2] || max_x != this._bb_max[0] || max_y != this._bb_max[1] || max_z != this._bb_max[2]) {
            this._bb_min[0] = min_x;
            this._bb_min[1] = min_y;
            this._bb_min[2] = min_z;
            this._bb_max[0] = max_x;
            this._bb_max[1] = max_y;
            this._bb_max[2] = max_z;
            this.setChanged();
            this.notifyObservers(new Message(M_BB_CHANGED, null));
        }
    }

    public void set_changed() {
        this.setChanged();
        this.notifyObservers(new Message(M_BB_CHANGED, null));
    }

    public void set_min_x(int min_x) {
        this.set_box(min_x, this._bb_min[1], this._bb_min[2], this._bb_max[0], this._bb_max[1], this._bb_max[2]);
    }

    public void set_min_y(int min_y) {
        this.set_box(this._bb_min[0], min_y, this._bb_min[2], this._bb_max[0], this._bb_max[1], this._bb_max[2]);
    }

    public void set_min_z(int min_z) {
        this.set_box(this._bb_min[0], this._bb_min[1], min_z, this._bb_max[0], this._bb_max[1], this._bb_max[2]);
    }

    public void set_max_x(int max_x) {
        this.set_box(this._bb_min[0], this._bb_min[1], this._bb_min[2], max_x, this._bb_max[1], this._bb_max[2]);
    }

    public void set_max_y(int max_y) {
        this.set_box(this._bb_min[0], this._bb_min[1], this._bb_min[2], this._bb_max[0], max_y, this._bb_max[2]);
    }

    public void set_max_z(int max_z) {
        this.set_box(this._bb_min[0], this._bb_min[1], this._bb_min[2], this._bb_max[0], this._bb_max[1], max_z);
    }

    public int[] get_min() {
        return this._bb_min;
    }

    public int[] get_max() {
        return this._bb_max;
    }

    public int get_min_x() {
        return this._bb_min[0];
    }

    public int get_min_y() {
        return this._bb_min[1];
    }

    public int get_min_z() {
        return this._bb_min[2];
    }

    public int get_max_x() {
        return this._bb_max[0];
    }

    public int get_max_y() {
        return this._bb_max[1];
    }

    public int get_max_z() {
        return this._bb_max[2];
    }

    public boolean is_inside(Voxel v) {
        return v._x >= this._bb_min[0] && v._x <= this._bb_max[0] && v._y >= this._bb_min[1] && v._y <= this._bb_max[1] && v._z >= this._bb_min[2] && v._z <= this._bb_max[2];
    }

    public boolean is_bb_corner(Voxel v) {
        int x = v._x;
        int y = v._y;
        int z = v._z;
        return x == this._bb_min[0] && y == this._bb_min[1] && z == this._bb_min[2] || x == this._bb_min[0] && y == this._bb_min[1] && z == this._bb_max[2] || x == this._bb_max[0] && y == this._bb_min[1] && z == this._bb_max[2] || x == this._bb_max[0] && y == this._bb_min[1] && z == this._bb_min[2] || x == this._bb_min[0] && y == this._bb_max[1] && z == this._bb_min[2] || x == this._bb_min[0] && y == this._bb_max[1] && z == this._bb_max[2] || x == this._bb_max[0] && y == this._bb_max[1] && z == this._bb_max[2] || x == this._bb_max[0] && y == this._bb_max[1] && z == this._bb_min[2];
    }

    public boolean is_on_any_side(Voxel v) {
        return this.is_on_x_face(v) || this.is_on_y_face(v) || this.is_on_z_face(v);
    }

    public boolean is_on_edge(Voxel v) {
        return this.is_on_x_edge(v) || this.is_on_y_edge(v) || this.is_on_z_edge(v);
    }

    public boolean is_on_x_edge(Voxel v) {
        int x = v._x;
        int y = v._y;
        int z = v._z;
        boolean b = !(x < this._bb_min[0] || x > this._bb_max[0] || y != this._bb_min[1] && y != this._bb_max[1] || z != this._bb_min[2] && z != this._bb_max[2]);
        return b;
    }

    public boolean is_on_y_edge(Voxel v) {
        int x = v._x;
        int y = v._y;
        int z = v._z;
        boolean b = !(x != this._bb_min[0] && x != this._bb_max[0] || y < this._bb_min[1] || y > this._bb_max[1] || z != this._bb_min[2] && z != this._bb_max[2]);
        return b;
    }

    public boolean is_on_z_edge(Voxel v) {
        int x = v._x;
        int y = v._y;
        int z = v._z;
        boolean b = !(x != this._bb_min[0] && x != this._bb_max[0] || y != this._bb_min[1] && y != this._bb_max[1] || z < this._bb_min[2] && z > this._bb_max[2]);
        return b;
    }

    public boolean is_on_z_face_within_distance(Voxel v, int d) {
        int x = v._x;
        int y = v._y;
        int z = v._z;
        return (this.within_delta(x, this._bb_min[0], d) || this.within_delta(x, this._bb_max[0], d)) && y >= this._bb_min[1] && y <= this._bb_max[1] && z >= this._bb_min[2] && z <= this._bb_max[2];
    }

    public boolean is_on_x_face_within_distance(Voxel v, int d) {
        int x = v._x;
        int y = v._y;
        int z = v._z;
        return (this.within_delta(y, this._bb_min[1], d) || this.within_delta(y, this._bb_max[1], d)) && x >= this._bb_min[0] && x <= this._bb_max[0] && z >= this._bb_min[2] && z <= this._bb_max[2];
    }

    public boolean is_on_y_face_within_distance(Voxel v, int d) {
        int x = v._x;
        int y = v._y;
        int z = v._z;
        return (this.within_delta(z, this._bb_min[2], d) || this.within_delta(z, this._bb_max[2], d)) && x >= this._bb_min[0] && x <= this._bb_max[0] && y >= this._bb_min[1] && y <= this._bb_max[1];
    }

    private boolean within_delta(int value, int center, int delta) {
        return value >= center - delta && value <= center + delta;
    }

    public boolean is_on_x_face(Voxel v) {
        int x = v._x;
        int y = v._y;
        int z = v._z;
        boolean b = !(x != this._bb_min[0] && x != this._bb_max[0] || y < this._bb_min[1] || y > this._bb_max[1] || z < this._bb_min[2] && z > this._bb_max[2]);
        return b;
    }

    public boolean is_on_y_face(Voxel v) {
        int x = v._x;
        int y = v._y;
        int z = v._z;
        boolean b = x >= this._bb_min[0] && x <= this._bb_max[0] && (y == this._bb_min[1] || y == this._bb_max[1]) && z >= this._bb_min[2] && z <= this._bb_max[2];
        return b;
    }

    public boolean is_on_z_face(Voxel v) {
        int x = v._x;
        int y = v._y;
        int z = v._z;
        boolean b = x >= this._bb_min[0] && x <= this._bb_max[0] && y >= this._bb_min[1] && y <= this._bb_max[1] && (z == this._bb_min[2] || z == this._bb_max[2]);
        return b;
    }

    public void set_is_changing(boolean b) {
        this._is_changing = b;
    }

    public String toString() {
        return "AxisAlignedBoundingBox [_bb_min=" + Arrays.toString(this._bb_min) + ", _bb_max=" + Arrays.toString(this._bb_max) + "]";
    }
}

