/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.text.NumberFormat;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import main.MasterControl;
import main.view3d.Viewport3d;

public final class FPSCounter
extends Behavior {
    public static int UPDATE_INTERVAL = 2000;
    WakeupOnElapsedFrames FPSwakeup = new WakeupOnElapsedFrames(0);
    private int _numframes = 0;
    private long _lasttime = 0L;
    private long _deltatime;
    private boolean _report;
    private NumberFormat nf = null;

    public FPSCounter() {
        this.setEnable(false);
        this.nf = NumberFormat.getNumberInstance();
        this.nf.setMinimumFractionDigits(1);
        this.nf.setMaximumFractionDigits(1);
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)this.FPSwakeup);
    }

    public void processStimulus(Enumeration critera) {
        ++this._numframes;
        this._deltatime = System.currentTimeMillis() - this._lasttime;
        if (this._deltatime >= (long)UPDATE_INTERVAL) {
            if (this._report) {
                double fps = (double)this._numframes / ((double)this._deltatime / 1000.0);
                MasterControl.get_v3d().set_title_string(" - " + this.nf.format(fps));
            }
            this._numframes = 0;
            this._lasttime = System.currentTimeMillis();
        }
        this.wakeupOn((WakeupCondition)this.FPSwakeup);
    }

    public final void set_reporting(boolean report) {
        this._report = report;
        Viewport3d v3d = MasterControl.get_v3d();
        if (v3d != null) {
            if (!this._report) {
                v3d.set_title_string("");
            } else {
                v3d.set_title_string(" - 0");
            }
        }
        this.setEnable(report);
    }

    public final boolean is_reporting() {
        return this._report;
    }
}

